#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

from .. import Vulnerability


#------------------------------------------------------------------------------
class OutdatedPlatform(Vulnerability):
    "" # this is intentional, do not remove or change!

    DEFAULTS = Vulnerability.DEFAULTS.copy()
    DEFAULTS["level"] = "high"
    DEFAULTS["cvss_base"] = "9.0"
    DEFAULTS["description"] = \
        "An outdated, potentially vulnerable platform was found."
    DEFAULTS["solution"] = \
"""If possible, apply all missing patches or upgrade to a newer version.
If not, consider adding firewall rules to restrict access to these hosts."""
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Top_10_2013-A5-Security_Misconfiguration",
    )


#------------------------------------------------------------------------------
class OutdatedPlatformMandriva(OutdatedPlatform):
    data_subtype = "mandriva"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Mandriva"


#------------------------------------------------------------------------------
class OutdatedPlatformWindows(OutdatedPlatform):
    data_subtype = "windows"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Windows"


#------------------------------------------------------------------------------
class OutdatedPlatformDebian(OutdatedPlatform):
    data_subtype = "debian"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Debian"


#------------------------------------------------------------------------------
class OutdatedPlatformMacOSX(OutdatedPlatform):
    data_subtype = "mac_os_x"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Mac OS X"


#------------------------------------------------------------------------------
class OutdatedPlatformVMwareESX(OutdatedPlatform):
    data_subtype = "vmware_esx"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: VMware ESX"


#------------------------------------------------------------------------------
class OutdatedPlatformUbuntu(OutdatedPlatform):
    data_subtype = "ubuntu"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Ubuntu"


#------------------------------------------------------------------------------
class OutdatedPlatformHPUX(OutdatedPlatform):
    data_subtype = "hp_ux"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: HP-UX"


#------------------------------------------------------------------------------
class OutdatedPlatformSuSE(OutdatedPlatform):
    data_subtype = "suse"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: SuSE"


#------------------------------------------------------------------------------
class OutdatedPlatformFreeBSD(OutdatedPlatform):
    data_subtype = "freebsd"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: FreeBSD"


#------------------------------------------------------------------------------
class OutdatedPlatformJunos(OutdatedPlatform):
    data_subtype = "junos"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: JunOS"


#------------------------------------------------------------------------------
class OutdatedPlatformScientificLinux(OutdatedPlatform):
    data_subtype = "sci_linux"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Scientific Linux"


#------------------------------------------------------------------------------
class OutdatedPlatformSlackware(OutdatedPlatform):
    data_subtype = "slackware"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Slackware"


#------------------------------------------------------------------------------
class OutdatedPlatformSolaris(OutdatedPlatform):
    data_subtype = "solaris"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Solaris"


#------------------------------------------------------------------------------
class OutdatedPlatformRedHat(OutdatedPlatform):
    data_subtype = "redhat"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Red Hat"


#------------------------------------------------------------------------------
class OutdatedPlatformAmazonLinux(OutdatedPlatform):
    data_subtype = "amazon"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Amazon Linux"


#------------------------------------------------------------------------------
class OutdatedPlatformAIX(OutdatedPlatform):
    data_subtype = "aix"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: AIX"


#------------------------------------------------------------------------------
class OutdatedPlatformGentoo(OutdatedPlatform):
    data_subtype = "gentoo"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Gentoo"


#------------------------------------------------------------------------------
class OutdatedPlatformCentOS(OutdatedPlatform):
    data_subtype = "centos"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: CentOS"


#------------------------------------------------------------------------------
class OutdatedPlatformOracleLinux(OutdatedPlatform):
    data_subtype = "oracle"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Oracle Linux"


#------------------------------------------------------------------------------
class OutdatedPlatformFedora(OutdatedPlatform):
    data_subtype = "fedora"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Fedora"


#------------------------------------------------------------------------------
class OutdatedPlatformNovell(OutdatedPlatform):
    data_subtype = "novell"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Novell"


#------------------------------------------------------------------------------
class OutdatedPlatformCisco(OutdatedPlatform):
    data_subtype = "cisco"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Cisco"


#------------------------------------------------------------------------------
class OutdatedPlatformAndroid(OutdatedPlatform):
    data_subtype = "android"


    #--------------------------------------------------------------------------
    @property
    def display_name(self):
        return "Outdated Platform: Android"


#------------------------------------------------------------------------------
__all__ = [ x for x in dir() if x.startswith("OutdatedPlatform") ]
