#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["UnhandledErrors"]

from .. import Vulnerability, WebVulnerability
from ... import identity


#------------------------------------------------------------------------------
class UnhandledErrors(WebVulnerability):
    """
    Unhandled Errors.

    Unhandled errors in the web application are being returned by the server.
    This may help an adversary to gather information prior to an attack.

    The details on how to suppress error messages is specific to the HTTP
    server and/or the application server being used. Please consult the
    documentation of your software on how to do this.
    """

    DEFAULTS = WebVulnerability.DEFAULTS.copy()
    DEFAULTS["level"]      = "informational"
    DEFAULTS["cwe"]        = "CWE-209"
    DEFAULTS["capec"]      = "CAPEC-54"
    DEFAULTS["cvss_base"]  = "2.4"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Information_Leakage",
    )


    #--------------------------------------------------------------------------
    def __init__(self, target, engine, **kwargs):
        """
        :param target: URL where the vulnerability was found.
        :type target: Url

        :param engine: Web application engine that's returning the errors.
        :type engine: str
        """

        # Web application engine that's returning the errors.
        self.__engine = engine

        # Parent constructor.
        super(UnhandledErrors, self).__init__(target, **kwargs)

    __init__.__doc__ += Vulnerability.__init__.__doc__[
            Vulnerability.__init__.__doc__.find("\n        :keyword"):]


    #--------------------------------------------------------------------------
    @identity
    def engine(self):
        """
        :returns: Web application engine that's returning the errors.
        :rtype: str
        """
        return self.__engine
