/*
 * Decompiled with CFR 0.152.
 */
package com.github.falydoor.limesurveyrc;

import com.github.falydoor.limesurveyrc.dto.LsApiBody;
import com.github.falydoor.limesurveyrc.dto.LsParticipant;
import com.github.falydoor.limesurveyrc.dto.LsQuestion;
import com.github.falydoor.limesurveyrc.dto.LsQuestionAnswer;
import com.github.falydoor.limesurveyrc.dto.LsQuestionGroup;
import com.github.falydoor.limesurveyrc.dto.LsSurvey;
import com.github.falydoor.limesurveyrc.dto.LsSurveyLanguage;
import com.github.falydoor.limesurveyrc.dto.json.LocalDateDeserializer;
import com.github.falydoor.limesurveyrc.dto.json.LsParticipantDeserializer;
import com.github.falydoor.limesurveyrc.dto.json.LsQuestionDeserializer;
import com.github.falydoor.limesurveyrc.dto.json.LsSurveyDeserializer;
import com.github.falydoor.limesurveyrc.exception.LimesurveyRCException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimesurveyRC {
    private final Logger LOGGER = LoggerFactory.getLogger(LimesurveyRC.class);
    private String url;
    private String user;
    private String password;
    private int keyTimeout = 7200;
    private String key = "";
    private ZonedDateTime keyExpiration = ZonedDateTime.now();
    private Gson gson;

    public LimesurveyRC(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.gson = new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer()).registerTypeAdapter(LsSurvey.class, (Object)new LsSurveyDeserializer()).registerTypeAdapter(LsQuestion.class, (Object)new LsQuestionDeserializer()).registerTypeAdapter(LsParticipant.class, (Object)new LsParticipantDeserializer()).create();
    }

    public void setKeyTimeout(int timeout) {
        this.keyTimeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonElement callRC(LsApiBody body) throws LimesurveyRCException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost post = new HttpPost(this.url);
            post.setHeader("Content-type", "application/json");
            String jsonBody = this.gson.toJson((Object)body);
            this.LOGGER.debug("API CALL JSON => " + jsonBody);
            post.setEntity((HttpEntity)new StringEntity(jsonBody));
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                String jsonResult = EntityUtils.toString((HttpEntity)response.getEntity());
                this.LOGGER.debug("API RESPONSE JSON => " + jsonResult);
                JsonElement result = new JsonParser().parse(jsonResult).getAsJsonObject().get("result");
                if (result.isJsonObject() && result.getAsJsonObject().has("status")) {
                    throw new LimesurveyRCException("Error from API : " + result.getAsJsonObject().get("status").getAsString());
                }
                JsonElement jsonElement = result;
                return jsonElement;
            }
            throw new LimesurveyRCException("Expecting status code 200, got " + response.getStatusLine().getStatusCode() + " instead");
        }
        catch (IOException e) {
            throw new LimesurveyRCException("Exception while calling API : " + e.getMessage(), e);
        }
    }

    public int createIncompleteResponse(int surveyId) throws LimesurveyRCException {
        return this.createIncompleteResponse(surveyId, null);
    }

    public int createIncompleteResponse(int surveyId, String token) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("submitdate", "");
        String date = ZonedDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE) + " " + ZonedDateTime.now().format(DateTimeFormatter.ISO_LOCAL_TIME);
        responseData.put("startdate", date);
        responseData.put("datestamp", date);
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            responseData.put("token", token);
        }
        params.setResponseData(responseData);
        return this.callRC(new LsApiBody("add_response", params)).getAsInt();
    }

    public boolean completeResponse(int surveyId, int responseId) throws LimesurveyRCException {
        return this.completeResponse(surveyId, responseId, LocalDateTime.now());
    }

    public boolean completeResponse(int surveyId, int responseId, LocalDateTime date) throws LimesurveyRCException {
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("submitdate", date.format(DateTimeFormatter.ISO_LOCAL_DATE) + " " + date.format(DateTimeFormatter.ISO_LOCAL_TIME));
        JsonElement result = this.updateResponse(surveyId, responseId, responseData);
        if (!result.getAsBoolean()) {
            throw new LimesurveyRCException(result.getAsString());
        }
        return true;
    }

    public JsonElement updateResponse(int surveyId, int responseId, Map<String, String> responseData) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        responseData.put("id", String.valueOf(responseId));
        params.setResponseData(responseData);
        return this.callRC(new LsApiBody("update_response", params));
    }

    public Stream<LsQuestion> getQuestions(int surveyId) throws LimesurveyRCException {
        return this.getGroups(surveyId).flatMap(group -> {
            try {
                return this.getQuestionsFromGroup(surveyId, group.getId());
            }
            catch (LimesurveyRCException e) {
                this.LOGGER.error("Unable to get questions from group " + group.getId(), (Throwable)e);
                return Stream.empty();
            }
        });
    }

    public LsQuestion getQuestion(int surveyId, int questionId) throws LimesurveyRCException {
        return this.getQuestions(surveyId).filter(question -> question.getId() == questionId).findFirst().orElseThrow(() -> new LimesurveyRCException("No question found for id " + questionId + " in survey " + surveyId));
    }

    public Map<String, LsQuestionAnswer> getQuestionAnswers(int questionId) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey();
        params.setQuestionId(questionId);
        ArrayList<String> questionSettings = new ArrayList<String>();
        questionSettings.add("answeroptions");
        params.setQuestionSettings(questionSettings);
        JsonElement result = this.callRC(new LsApiBody("get_question_properties", params)).getAsJsonObject().get("answeroptions");
        return (Map)this.gson.fromJson(result, new TypeToken<Map<String, LsQuestionAnswer>>(){}.getType());
    }

    public Stream<LsQuestionGroup> getGroups(int surveyId) throws LimesurveyRCException {
        JsonElement result = this.callRC(new LsApiBody("list_groups", this.getParamsWithKey(surveyId)));
        List questionGroups = (List)this.gson.fromJson(result, new TypeToken<List<LsQuestionGroup>>(){}.getType());
        return questionGroups.stream().sorted(Comparator.comparing(LsQuestionGroup::getOrder));
    }

    public Stream<LsQuestion> getQuestionsFromGroup(int surveyId, int groupId) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        params.setGroupId(groupId);
        JsonElement result = this.callRC(new LsApiBody("list_questions", params));
        List questions = (List)this.gson.fromJson(result, new TypeToken<List<LsQuestion>>(){}.getType());
        return questions.stream().sorted(Comparator.comparing(LsQuestion::getOrder));
    }

    public boolean isSurveyActive(int surveyId) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        ArrayList<String> surveySettings = new ArrayList<String>();
        surveySettings.add("active");
        params.setSurveySettings(surveySettings);
        return "Y".equals(this.callRC(new LsApiBody("get_survey_properties", params)).getAsJsonObject().get("active").getAsString());
    }

    public boolean isSurveyExists(int surveyId) throws LimesurveyRCException {
        return this.getSurveys().anyMatch(survey -> survey.getId() == surveyId);
    }

    public Stream<LsSurvey> getActiveSurveys() throws LimesurveyRCException {
        return this.getSurveys().filter(LsSurvey::isActive);
    }

    public Stream<LsSurvey> getSurveys() throws LimesurveyRCException {
        JsonElement result = this.callRC(new LsApiBody("list_surveys", this.getParamsWithKey()));
        List surveys = (List)this.gson.fromJson(result, new TypeToken<List<LsSurvey>>(){}.getType());
        return surveys.stream();
    }

    public LsSurveyLanguage getSurveyLanguageProperties(int surveyId) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        ArrayList<String> localeSettings = new ArrayList<String>();
        localeSettings.add("surveyls_welcometext");
        localeSettings.add("surveyls_endtext");
        params.setSurveyLocaleSettings(localeSettings);
        LsSurveyLanguage surveyLanguage = (LsSurveyLanguage)this.gson.fromJson(this.callRC(new LsApiBody("get_language_properties", params)), LsSurveyLanguage.class);
        surveyLanguage.setId(surveyId);
        return surveyLanguage;
    }

    public String getSessionKey() throws LimesurveyRCException {
        if (!this.key.isEmpty() && ZonedDateTime.now().isBefore(this.keyExpiration)) {
            return this.key;
        }
        LsApiBody.LsApiParams params = new LsApiBody.LsApiParams();
        params.setUsername(this.user);
        params.setPassword(this.password);
        JsonElement result = this.callRC(new LsApiBody("get_session_key", params));
        this.key = result.getAsString();
        this.keyExpiration = ZonedDateTime.now().plusSeconds(this.keyTimeout - 60);
        return this.key;
    }

    public Map<String, String> getParticipantProperties(int surveyId, String token, List<String> tokenProperties) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        HashMap<String, String> queryProperties = new HashMap<String, String>();
        queryProperties.put("token", token);
        params.setTokenQueryProperties(queryProperties);
        params.setTokenProperties(tokenProperties);
        return (Map)this.gson.fromJson(this.callRC(new LsApiBody("get_participant_properties", params)), new TypeToken<Map<String, String>>(){}.getType());
    }

    public Stream<LsParticipant> getAllParticipants(int surveyId) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey(surveyId);
        params.setStart(0);
        params.setLimit(-1);
        List participants = (List)this.gson.fromJson(this.callRC(new LsApiBody("list_participants", params)), new TypeToken<List<LsParticipant>>(){}.getType());
        return participants.stream();
    }

    private LsApiBody.LsApiParams getParamsWithKey(int surveyId) throws LimesurveyRCException {
        LsApiBody.LsApiParams params = this.getParamsWithKey();
        params.setSurveyId(surveyId);
        return params;
    }

    private LsApiBody.LsApiParams getParamsWithKey() throws LimesurveyRCException {
        LsApiBody.LsApiParams params = new LsApiBody.LsApiParams();
        params.setSessionKey(this.getSessionKey());
        return params;
    }
}

