/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.google.common.collect.Lists;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.ForLoop;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.ObjectIterator;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Outputs the inner content for each item in the given iterable", params={@JinjavaParam(value="items_to_iterate", desc="Specifies the name of a single item in the sequence or dict.")}, snippets={@JinjavaSnippet(code="{% for item in items %}\n    {{ item }}\n{% endfor %}"), @JinjavaSnippet(desc="Iterating over dictionary values", code="{% for value in dictionary %}\n    {{ value }}\n{% endfor %}"), @JinjavaSnippet(desc="Iterating over dictionary entries", code="{% for key, value in dictionary.items() %}\n    {{ key }}: {{ value }}\n{% endfor %}"), @JinjavaSnippet(desc="Standard blog listing loop", code="{% for content in contents %}\n    Post content variables\n{% endfor %}")})
public class ForTag
implements Tag {
    private static final long serialVersionUID = 6175143875754966497L;
    private static final String LOOP = "loop";
    private static final String TAGNAME = "for";
    private static final String ENDTAGNAME = "endfor";

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        String val;
        int inPos;
        String helpers = tagNode.getHelpers();
        String[] parts = helpers.split("\\s+in\\s+");
        if (parts.length == 2 && !parts[1].contains("'") && !parts[1].contains("\"")) {
            helpers = parts[0] + " in " + parts[1].replace(" ", "");
        }
        List<String> helper = new HelperStringTokenizer(helpers).splitComma(true).allTokens();
        ArrayList loopVars = Lists.newArrayList();
        for (inPos = 0; inPos < helper.size() && !"in".equals(val = helper.get(inPos)); ++inPos) {
            loopVars.add(val);
        }
        if (inPos >= helper.size()) {
            throw new TemplateSyntaxException(tagNode.getHelpers().trim(), "Tag 'for' expects valid 'in' clause, got: " + tagNode.getHelpers(), tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        String loopExpr = StringUtils.join(helper.subList(inPos + 1, helper.size()), (String)",");
        Object collection = interpreter.resolveELExpression(loopExpr, tagNode.getLineNumber());
        ForLoop loop = ObjectIterator.getLoop(collection);
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
            if (loop.getLength() == 0 && interpreter.isValidationMode()) {
                loop = ObjectIterator.getLoop(0);
                interpreter.getContext().setValidationMode(true);
            }
            interpreter.getContext().put(LOOP, loop);
            LengthLimitingStringBuilder buff = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
            while (loop.hasNext()) {
                Object val2 = interpreter.wrap(loop.next());
                if (loopVars.size() == 1) {
                    interpreter.getContext().put(loopVars.get(0), val2);
                } else {
                    block13: for (String loopVar : loopVars) {
                        if (Map.Entry.class.isAssignableFrom(val2.getClass())) {
                            Map.Entry entry = (Map.Entry)val2;
                            Object entryVal = null;
                            if (loopVars.indexOf(loopVar) == 0) {
                                entryVal = entry.getKey();
                            } else if (loopVars.indexOf(loopVar) == 1) {
                                entryVal = entry.getValue();
                            }
                            interpreter.getContext().put(loopVar, entryVal);
                            continue;
                        }
                        try {
                            PropertyDescriptor[] valProps;
                            for (PropertyDescriptor valProp : valProps = Introspector.getBeanInfo(val2.getClass()).getPropertyDescriptors()) {
                                if (!loopVar.equals(valProp.getName())) continue;
                                interpreter.getContext().put(loopVar, valProp.getReadMethod().invoke(val2, new Object[0]));
                                continue block13;
                            }
                        }
                        catch (Exception e) {
                            throw new InterpretException(e.getMessage(), (Throwable)e, tagNode.getLineNumber(), tagNode.getStartPosition());
                        }
                    }
                }
                for (Node node : tagNode.getChildren()) {
                    if (interpreter.getContext().isValidationMode()) {
                        node.render(interpreter);
                        continue;
                    }
                    buff.append(node.render(interpreter));
                }
            }
            String string = buff.toString();
            return string;
        }
    }

    @Override
    public String getEndTagName() {
        return ENDTAGNAME;
    }

    @Override
    public String getName() {
        return TAGNAME;
    }
}

