/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.fn;

import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MacroFunction
extends AbstractCallableMethod {
    private final List<Node> content;
    private final boolean catchKwargs;
    private final boolean catchVarargs;
    private final boolean caller;
    private final Context localContextScope;

    public MacroFunction(List<Node> content, String name, LinkedHashMap<String, Object> argNamesWithDefaults, boolean catchKwargs, boolean catchVarargs, boolean caller, Context localContextScope) {
        super(name, argNamesWithDefaults);
        this.content = content;
        this.catchKwargs = catchKwargs;
        this.catchVarargs = catchVarargs;
        this.caller = caller;
        this.localContextScope = localContextScope;
    }

    @Override
    public Object doEvaluate(Map<String, Object> argMap, Map<String, Object> kwargMap, List<Object> varArgs) {
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
            for (Map.Entry string : this.localContextScope.getScope().entrySet()) {
                if (string.getValue() instanceof MacroFunction) {
                    interpreter.getContext().addGlobalMacro((MacroFunction)string.getValue());
                    continue;
                }
                interpreter.getContext().put(string.getKey(), string.getValue());
            }
            for (Map.Entry<Object, Object> entry : argMap.entrySet()) {
                interpreter.getContext().put(entry.getKey(), entry.getValue());
            }
            interpreter.getContext().put("kwargs", kwargMap);
            interpreter.getContext().put("varargs", varArgs);
            LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
            for (Node node : this.content) {
                result.append(node.render(interpreter));
            }
            String string = result.toString();
            return string;
        }
    }

    public boolean isCatchKwargs() {
        return this.catchKwargs;
    }

    public boolean isCatchVarargs() {
        return this.catchVarargs;
    }

    public boolean isCaller() {
        return this.caller;
    }
}

