/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.hubspot.jinjava.interpret.TagCycleException;
import java.util.Optional;
import java.util.Stack;

public class CallStack {
    private final CallStack parent;
    private final Class<? extends TagCycleException> exceptionClass;
    private final Stack<String> stack = new Stack();

    public CallStack(CallStack parent, Class<? extends TagCycleException> exceptionClass) {
        this.parent = parent;
        this.exceptionClass = exceptionClass;
    }

    public boolean contains(String path) {
        if (this.stack.contains(path)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(path);
        }
        return false;
    }

    public void pushWithoutCycleCheck(String path) {
        this.stack.push(path);
    }

    public void push(String path, int lineNumber, int startPosition) {
        if (this.contains(path)) {
            throw TagCycleException.create(this.exceptionClass, path, Optional.of(lineNumber), Optional.of(startPosition));
        }
        this.stack.push(path);
    }

    public Optional<String> pop() {
        if (this.stack.isEmpty()) {
            if (this.parent != null) {
                return this.parent.pop();
            }
            return Optional.empty();
        }
        return Optional.of(this.stack.pop());
    }
}

