"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Config = _interopRequireDefault(require("../Config"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var fs = require("fs");

function makeid(count) {
  var text = "";
  var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

  for (var i = 0; i < count; i++) {
    text += possible.charAt(Math.floor(Math.random() * possible.length));
  }

  return text;
}

var path_dump_id = makeid(4);
var log_path = console.log;
/**
 * Class to handle logging
 * Structured this way for historical reasons, unneeded 
 * logs are now removed at compile for performance
 */

var Log = /*#__PURE__*/function () {
  function Log() {
    _classCallCheck(this, Log);
  }

  _createClass(Log, [{
    key: "logHigh",
    value: function logHigh(msg) {
      log_path("[?] " + msg);
    }
  }, {
    key: "logMid",
    value: function logMid(msg) {
      log_path("[?] " + msg);
    }
  }, {
    key: "log",
    value: function log(msg) {
      log_path("[!] " + msg);
    }
  }, {
    key: "logQuery",
    value: function logQuery(clause, solver, checkCount, startTime, endTime, model, attempts, hitMax) {
      if (!_Config["default"].outQueriesDir) {
        return;
      }

      var dumpData = {
        clause: clause,
        model: model,
        attempts: attempts,
        startTime: startTime,
        endTime: endTime,
        hitMaxRefinements: hitMax,
        checkCount: checkCount,
        containedRe: (solver + clause).includes("str.in.re")
      };
      var dumpFileName = _Config["default"].outQueriesDir + "/" + path_dump_id;
      fs.appendFileSync(dumpFileName, JSON.stringify(dumpData) + "\nEXPOSE_QUERY_DUMP_SEPERATOR\n");
      this.log("Wrote ".concat(dumpFileName));
    }
  }]);

  return Log;
}();

var _default = new Log();

exports["default"] = _default;