"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNative = isNative;

var _Log = _interopRequireDefault(require("./Log"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/** 
 * Some code is from https://gist.github.com/jdalton/5e34d890105aca44399f by John-David Dalton
 */
var toString = Object.prototype.toString;
var fnToString = Function.prototype.toString;
var reHostCtor = /^\[object .+?Constructor\]$/;
var SECRET_CACHE_STR = "__checked_isNative__before__";
var reNative = RegExp("^" + String(toString).replace(/[.*+?^${}()|[\]\/\\]/g, "\\$&").replace(/toString|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");

function isNativeCore(value) {
  if (value.hasOwnProperty('toString')) {
    _Log["default"].log('WARNING: IsNative will not work on custom toString methods. We assume nobody would overwrite core method toStrings');

    return false;
  }

  if (typeof value === "function") {
    return reNative.test(fnToString.call(value));
  } else if (_typeof(value) === "object") {
    return reHostCtor.test(toString.call(value));
  } else {
    return false;
  }
}

function isNative(v) {
  var type = _typeof(v);

  if (v === null || v === undefined) {
    return false;
  }

  if (typeof v === "function" || _typeof(v) === "object") {
    return isNativeCore(v);
  } else {
    return false;
  }
}