"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _WrappedValue = require("./Values/WrappedValue");

var _SymbolicObject = require("./Values/SymbolicObject");

var _ObjectHelper = _interopRequireDefault(require("./Utilities/ObjectHelper"));

var _SymbolicState = _interopRequireDefault(require("./SymbolicState"));

var _Log = _interopRequireDefault(require("./Utilities/Log"));

var _NotAnErrorException = _interopRequireDefault(require("./NotAnErrorException"));

var _IsNative = require("./Utilities/IsNative");

var _Models = _interopRequireDefault(require("./Models/Models"));

var _External = _interopRequireDefault(require("./External"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var SymbolicExecution = /*#__PURE__*/function () {
  function SymbolicExecution(sandbox, initialInput, exitFn) {
    var _this = this;

    _classCallCheck(this, SymbolicExecution);

    this._sandbox = sandbox;
    this.state = new _SymbolicState["default"](initialInput, this._sandbox);
    this.models = (0, _Models["default"])(this.state);
    this._fileList = new Array();
    this._exitFn = exitFn;

    if (typeof window !== "undefined") {
      window._ExpoSE = this;
      setTimeout(function () {
        console.log("Finish timeout (callback)");

        _this.finished();

        _External["default"].close();
      }, 1000 * 60 * 1);
      var storagePool = {};

      window.localStorage.setItem = function (key, val) {
        storagePool[key] = val;
      };

      window.localStorage.getItem = function (key) {
        return storagePool[key];
      };

      console.log("Browser mode setup finished");
    } else {
      var process = _External["default"].load("process"); //Bind any uncaught exceptions to the uncaught exception handler


      process.on("uncaughtException", this._uncaughtException.bind(this)); //Bind the exit handler to the exit callback supplied

      process.on("exit", this.finished.bind(this));
    }
  }

  _createClass(SymbolicExecution, [{
    key: "finished",
    value: function finished() {
      this._exitFn(this.state, this.state.coverage);
    }
  }, {
    key: "_uncaughtException",
    value: function _uncaughtException(e) {
      //Ignore NotAnErrorException
      if (e instanceof _NotAnErrorException["default"]) {
        return;
      }

      _Log["default"].log("Uncaught exception ".concat(e, " Stack: ").concat(e.stack ? e.stack : ""));

      this.state.errors.push({
        error: "" + e,
        stack: e.stack
      });
    }
  }, {
    key: "report",
    value: function report(sourceString) {
      if (sourceString && !this.state.isSymbolic(sourceString)) {
        if (sourceString.documentURI) {
          sourceString = "" + sourceString.documentURI;
        } else if (sourceString.baseURI) {
          sourceString = "" + sourceString.baseURI;
        } else if (sourceString && sourceString.toString) {
          var tsourceString = sourceString.toString();

          if (tsourceString.includes("Object]")) {
            sourceString = _ObjectHelper["default"].asString(sourceString);
          } else {
            sourceString = tsourceString;
          }
        } else {
          sourceString = _ObjectHelper["default"].asString(sourceString);
        }
      } else {
        sourceString = this.state.asSymbolic(sourceString).simplify();
      }

      console.log("OUTPUT_LOAD_EVENT: !!!".concat(this.state.inlineToSMTLib(), "!!! !!!\"").concat(sourceString, "\"!!!"));
    }
  }, {
    key: "_reportFn",
    value: function _reportFn(f, base, args) {
      if (typeof window !== "undefined") {
        if ((f.name == "appendChild" || f.name == "prependChild" || f.name == "insertBefore" || f.name == "replaceChild") && args[0] && (args[0].src || args[0].innerHTML.includes("src="))) {
          this.report(args[0].src);
          args[0].src = this.state.getConcrete(args[0].src);
        }

        if (f.name == "open" || f.name == "fetch") {
          console.log("REPORTING FN OPEN " + JSON.stringify(args));
          this.report(args[1]);
        }
      }
    }
  }, {
    key: "invokeFunPre",
    value: function invokeFunPre(iid, f, base, args, _isConstructor, _isMethod) {
      this.state.coverage.touch(iid);
      f = this.state.getConcrete(f);

      this._reportFn(f, base, args);

      var functionName = f ? f.name : "undefined";
      var fn_model = this.models.get(f);

      /**
       * Concretize the function if it is native and we do not have a custom model for it
       * TODO: We force concretization on toString functions to avoid recursive call from the lookup into this.models
       * TODO: This is caused by getField(obj) calling obj.toString()
       * TODO: A better solution to this needs to be found
       */
      if (!fn_model && (0, _IsNative.isNative)(f)) {
        var concretized = this.state.concretizeCall(f, base, args);
        base = concretized.base;
        args = concretized.args;

        if (concretized.count > 0) {
          this.state.stats.set("Unmodeled Function Call", functionName);
        }
      } else if (fn_model) {
        this.state.stats.set("Modeled Function Call", functionName);
      } else {
        this.state.stats.seen("General Function Call");
      }
      /**
       * End of conc
       */


      return {
        f: fn_model || f,
        base: base,
        args: args,
        skip: false
      };
    }
    /**
     * Called after a function completes execution
     */

  }, {
    key: "invokeFun",
    value: function invokeFun(iid, f, base, args, result, _isConstructor, _isMethod) {
      this.state.coverage.touch(iid);
      return {
        result: result
      };
    }
  }, {
    key: "literal",
    value: function literal(iid, val, _hasGetterSetter) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "forinObject",
    value: function forinObject(iid, val) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "_location",
    value: function _location(iid) {
      return this._sandbox.iidToLocation(this._sandbox.getGlobalIID(iid));
    }
  }, {
    key: "endExpression",
    value: function endExpression(iid) {
      this.state.coverage.touch(iid);
    }
  }, {
    key: "declare",
    value: function declare(iid, name, val, _isArgument, _argumentIndex, _isCatchParam) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "getFieldPre",
    value: function getFieldPre(iid, base, offset, _isComputed, _isOpAssign, _isMethodCall) {
      this.state.coverage.touch(iid);
      return {
        base: base,
        offset: offset,
        skip: this.state.isWrapped(base) || this.state.isWrapped(offset)
      };
    }
  }, {
    key: "_getFieldSymbolicOffset",
    value: function _getFieldSymbolicOffset(base, offset) {
      offset = this.state.ToString(offset);
      var base_c = this.state.getConcrete(base);

      for (var idx in base_c) {
        var is_this_idx = this.state.binary("==", idx, offset);
        this.state.pushCondition(this.state.asSymbolic(is_this_idx));
      }
    }
    /** 
        * GetField will be skipped if the base or offset is not wrapped (SymbolicObject or isSymbolic)
        */

  }, {
    key: "getField",
    value: function getField(iid, base, offset, _val, _isComputed, _isOpAssign, _isMethodCall) {
      //TODO: This is a horrible hacky way of making certain request attributes symbolic
      //TODO: Fix this!
      if (typeof window != "undefined") {
        if (base == window.navigator) {
          if (offset == "userAgent") {
            return {
              result: Object._expose.makeSymbolic(offset, window.navigator.userAgent)
            };
          }
        }

        if (base == window.document) {
          if (offset == "cookie") {
            return {
              result: Object._expose.makeSymbolic(offset, "")
            };
          }

          if (offset == "lastModified") {
            return {
              result: Object._expose.makeSymbolic(offset, window.document.lastModified)
            };
          }

          if (offset == "referrer") {
            return {
              result: Object._expose.makeSymbolic(offset, window.document.referer)
            };
          }
        }

        if (base == window.location) {
          if (offset == "origin") {
            return {
              result: Object._expose.makeSymbolic(offset, window.location.origin)
            };
          }

          if (offset == "host") {
            return {
              result: Object._expose.makeSymbolic(offset, window.location.host)
            };
          }
        }
      }

      //If dealing with a SymbolicObject then concretize the offset and defer to SymbolicObject.getField
      if (base instanceof _SymbolicObject.SymbolicObject) {
        return {
          result: base.getField(this.state, this.state.getConcrete(offset))
        };
      } //If we are evaluating a symbolic string offset on a concrete base then enumerate all fields
      //Then return the concrete lookup


      if (!this.state.isSymbolic(base) && this.state.isSymbolic(offset) && typeof this.state.getConcrete(offset) == "string") {
        this._getFieldSymbolicOffset(base, offset);

        return {
          result: base[this.state.getConcrete(offset)]
        };
      } //If the array is a symbolic int and the base is a concrete array then enumerate all the indices


      if (!this.state.isSymbolic(base) && this.state.isSymbolic(offset) && this.state.getConcrete(base) instanceof Array && typeof this.state.getConcrete(offset) == "number") {
        for (var i = 0; i < this.state.getConcrete(base).length; i++) {
          this.state.assertEqual(i, offset);
        }

        return {
          result: base[this.state.getConcrete(offset)]
        };
      } //Otherwise defer to symbolicField


      var result_s = this.state.isSymbolic(base) ? this.state.symbolicField(this.state.getConcrete(base), this.state.asSymbolic(base), this.state.getConcrete(offset), this.state.asSymbolic(offset)) : undefined;
      var result_c = this.state.getConcrete(base)[this.state.getConcrete(offset)];
      return {
        result: result_s ? new _WrappedValue.ConcolicValue(result_c, result_s) : result_c
      };
    }
  }, {
    key: "putFieldPre",
    value: function putFieldPre(iid, base, offset, val, _isComputed, _isOpAssign) {
      this.state.coverage.touch(iid);

      if (this.state.getConcrete(offset) === "src" || this.state.getConcrete(offset) === "href") {
        this.report(val);
        val = this.state.getConcrete(val);
      }

      return {
        base: base,
        offset: offset,
        val: val,
        skip: this.state.isWrapped(base) || this.state.isWrapped(offset)
      };
    }
  }, {
    key: "putField",
    value: function putField(iid, base, offset, val, _isComputed, _isOpAssign) {
      if (base instanceof _SymbolicObject.SymbolicObject) {
        return {
          result: base.setField(this.state, this.state.getConcrete(offset), val)
        };
      } //TODO: Enumerate if symbolic offset and concrete input


      if (this.state.isSymbolic(base) && this.state.getConcrete(base) instanceof Array && this.state.arrayType(base) == _typeof(val)) {
        _Log["default"].log("TODO: Check that setField is homogonous"); //SetField produce a new array
        //Therefore the symbolic portion of base needs to be updated


        var base_s = this.state.asSymbolic(base).setField(this.state.asSymbolic(offset), this.state.asSymbolic(val));
        this.state.getConcrete(base)[this.state.getConcrete(offset)] = val;
        this.state.updateSymbolic(base, base_s);

        if (typeof document !== "undefined" && this.state.getConcrete(base) instanceof Element && document.contains(this.state.getConcrete(base)) && offset === "innerHTML") {
          var tv = this.state.getConcrete(val);

          if (typeof tv === "string" && tv.includes("src=")) {
            var sourceString = this.state.asSymbolic(val).toString();
            this.report(sourceString);
          }
        }

        return {
          result: val
        };
      }

      this.state.getConcrete(base)[this.state.getConcrete(offset)] = val;
      return {
        result: val
      };
    }
  }, {
    key: "read",
    value: function read(iid, name, val, _isGlobal, _isScriptLocal) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "write",
    value: function write(iid, name, val, _lhs, _isGlobal, _isScriptLocal) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "_return",
    value: function _return(iid, val) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "_throw",
    value: function _throw(iid, val) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "_with",
    value: function _with(iid, val) {
      this.state.coverage.touch(iid);
      return {
        result: val
      };
    }
  }, {
    key: "functionEnter",
    value: function functionEnter(iid, f, _dis, _args) {
      this.state.coverage.touch(iid);
    }
  }, {
    key: "functionExit",
    value: function functionExit(iid, returnVal, wrappedExceptionVal) {
      this.state.coverage.touch(iid);
      return {
        returnVal: returnVal,
        wrappedExceptionVal: wrappedExceptionVal,
        isBacktrack: false
      };
    }
  }, {
    key: "_scriptDepth",
    value: function _scriptDepth() {
      return this._fileList.length;
    }
  }, {
    key: "_addScript",
    value: function _addScript(fd) {
      this._fileList.push(fd);
    }
  }, {
    key: "_removeScript",
    value: function _removeScript() {
      return this._fileList.pop();
    }
  }, {
    key: "scriptEnter",
    value: function scriptEnter(iid, instrumentedFileName, originalFileName) {
      //this.state.coverage.touch(iid);
      var enterString = "====== ENTERING SCRIPT ".concat(originalFileName, " depth ").concat(this._scriptDepth(), " ======");

      if (this._scriptDepth() == 0) {
        _Log["default"].log(enterString);
      } else {}

      this._addScript(originalFileName);
    }
  }, {
    key: "scriptExit",
    value: function scriptExit(iid, wrappedExceptionVal) {
      //this.state.coverage.touch(iid);
      var originalFileName = this._removeScript();

      var exitString = "====== EXITING SCRIPT ".concat(originalFileName, " depth ").concat(this._scriptDepth(), " ======");

      if (this._scriptDepth() > 0) {} else {
        _Log["default"].log(exitString);
      }

      return {
        wrappedExceptionVal: wrappedExceptionVal,
        isBacktrack: false
      };
    }
  }, {
    key: "binaryPre",
    value: function binaryPre(iid, op, left, right, _isOpAssign, _isSwitchCaseComparison, _isComputed) {
      //Don't do symbolic logic if the symbolic values are diff types
      //Concretise instead
      if (this.state.isWrapped(left) || this.state.isWrapped(right)) {
        var left_c = this.state.getConcrete(left);
        var right_c = this.state.getConcrete(right); //We also consider boxed primitives to be primitive

        var is_primative = _typeof(left_c) != "object" || left_c instanceof Number || left_c instanceof String || left_c instanceof Boolean;
        var is_null = left_c === undefined || right_c === undefined || left_c === null || right_c === null;
        var is_real = typeof left_c == "number" ? Number.isFinite(left_c) && Number.isFinite(right_c) : true; //TODO: Work out how to check that boxed values are the same type

        var is_same_type = _typeof(left_c) === _typeof(right_c) || !is_null && left_c.valueOf() === right_c.valueOf();

        if (!is_same_type || !is_primative || is_null || !is_real) {
          _Log["default"].log("Concretizing binary ".concat(op, " on operands of differing types. Type coercion not yet implemented symbolically. (").concat(_ObjectHelper["default"].asString(left_c), ", ").concat(_ObjectHelper["default"].asString(right_c), ") (").concat(_typeof(left_c), ", ").concat(_typeof(right_c), ")"));

          left = left_c;
          right = right_c;
        } else {}
      } // Don't evaluate natively when args are symbolic


      return {
        op: op,
        left: left,
        right: right,
        skip: this.state.isWrapped(left) || this.state.isWrapped(right)
      };
    }
  }, {
    key: "binary",
    value: function binary(iid, op, left, right, result_c, _isOpAssign, _isSwitchCaseComparison, _isComputed) {
      this.state.coverage.touch(iid);
      var result;

      if (this.state.isSymbolic(left) || this.state.isSymbolic(right)) {
        result = this.state.binary(op, left, right);
      } else {
        result = result_c;
      }

      return {
        result: result
      };
    }
  }, {
    key: "unaryPre",
    value: function unaryPre(iid, op, left) {
      // Don't evaluate natively when args are symbolic
      return {
        op: op,
        left: left,
        skip: this.state.isWrapped(left)
      };
    }
  }, {
    key: "unary",
    value: function unary(iid, op, left, result_c) {
      this.state.coverage.touch(iid);
      return {
        result: this.state.unary(op, left)
      };
    }
  }, {
    key: "conditional",
    value: function conditional(iid, result) {
      this.state.coverage.touch_cnd(iid, this.state.getConcrete(result));

      if (this.state.isSymbolic(result)) {
        this.state.conditional(this.state.toBool(result));
      }

      return {
        result: this.state.getConcrete(result)
      };
    }
  }, {
    key: "instrumentCodePre",
    value: function instrumentCodePre(iid, code) {
      return {
        code: code,
        skip: false
      };
    }
  }, {
    key: "instrumentCode",
    value: function instrumentCode(iid, code, _newAst) {
      return {
        result: code
      };
    }
    /*runInstrumentedFunctionBody(iid) {}*/

  }, {
    key: "onReady",
    value: function onReady(cb) {
      cb();
    }
  }]);

  return SymbolicExecution;
}();

var _default = SymbolicExecution;
exports["default"] = _default;