"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _iidToLocation = _interopRequireDefault(require("./Utilities/iidToLocation"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var LAST_IID = "LAST_IID";
/**
 * Bits for coverage info propagation
 */

var IS_TOUCHED = 0x1;
var CONDITIONAL_TRUE = 0x2;
var CONDITIONAL_FALSE = 0x4;

var Coverage = /*#__PURE__*/function () {
  /**
      * Creates an instance of Coverage.
      * @param {any} sandbox The Jalangi sandbox
      * _branches is an array of coverages for a given sid where the sid is branches[sid+1]
      * @memberOf Coverage
      */
  function Coverage(sandbox) {
    _classCallCheck(this, Coverage);

    this._sandbox = sandbox;
    this._branches = [];
    this._branchFilenameMap = [];
    this._lastIid = 0; //Store the last IID touched for search strategizer
  }

  _createClass(Coverage, [{
    key: "end",
    value: function end() {
      var payload = {};

      for (var i = 0; i < this._branches.length; i++) {
        //SID are indexed from 1 not 0
        var localSid = i + 1;

        if (this._branches[i] !== undefined) {
          //Deep copy the smap
          var map = JSON.parse(JSON.stringify(this._sandbox.smap[localSid])); //Strip away any non SID related entities

          for (var localIid in map) {
            if (isNaN(parseInt(localIid))) {
              delete map[localIid];
            } else {
              map[localIid] = (0, _iidToLocation["default"])(this._sandbox, localSid, localIid);
            }
          }

          payload[this._branchFilenameMap[i]] = {
            smap: map,
            branches: this._branches[i]
          };
        }
      }

      payload[LAST_IID] = this._lastIid;
      return payload;
    }
  }, {
    key: "getBranchInfo",
    value: function getBranchInfo() {
      //-1 from 1-indexed sid to start from 0
      var localIndex = this._sandbox.sid - 1;
      var branchInfo = this._branches[localIndex];

      if (!branchInfo) {
        branchInfo = {};
        this._branches[localIndex] = branchInfo;
        var map = this._sandbox.smap[this._sandbox.sid];
        this._branchFilenameMap[localIndex] = map ? map.originalCodeFileName : "Broken Filename";
      }

      return branchInfo;
    }
  }, {
    key: "touch",
    value: function touch(iid) {
      this.getBranchInfo()[iid] |= IS_TOUCHED;
      this._lastIid = iid;
    }
  }, {
    key: "touch_cnd",
    value: function touch_cnd(iid, result) {
      this.touch(iid);
      this.getBranchInfo()[iid] |= result ? CONDITIONAL_TRUE : CONDITIONAL_FALSE;
    }
  }, {
    key: "last",
    value: function last() {
      return this._lastIid || 0;
    }
  }]);

  return Coverage;
}();

var _default = Coverage;
exports["default"] = _default;