"use strict";

var _SymbolicExecution = _interopRequireDefault(require("./SymbolicExecution"));

var _Config = _interopRequireDefault(require("./Config"));

var _Log = _interopRequireDefault(require("./Utilities/Log"));

var _External = _interopRequireDefault(require("./External"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* Copyright (c) Royal Holloway, University of London | Contact Blake Loring (blake@parsed.uk), Duncan Mitchell (Duncan.Mitchell.2015@rhul.ac.uk), or Johannes Kinder (johannes.kinder@rhul.ac.uk) for details or support | LICENSE.md for license details */

/*global J$*/
// do not remove the following comment
// JALANGI DO NOT INSTRUMENT
//
// Symbolic execution analyser entry point
var fs = _External["default"].load("fs");

var process = _External["default"].load("process");

var input = process.argv[process.argv.length - 1];

_Log["default"].log("Built with BASE logging enabled");

_Log["default"].log("Intial Input " + input);

process.title = "ExpoSE Play " + input;
process.on("disconnect", function () {
  _Log["default"].log("Premature termination - Parent exit");

  process.exit();
});
J$.analysis = new _SymbolicExecution["default"](J$, JSON.parse(input), function (state, coverage) {
  _Log["default"].log("Finished play with PC " + state.pathCondition.map(function (x) {
    return x.ast;
  }));

  if (_Config["default"].outCoveragePath) {
    fs.writeFileSync(_Config["default"].outCoveragePath, JSON.stringify(coverage.end()));

    _Log["default"].log("Wrote final coverage to " + _Config["default"].outCoveragePath);
  } else {
    _Log["default"].log("No final coverage path supplied");
  } //We record the alternatives list as the results develop to make the output tool more resilient to SMT crashes


  state.alternatives(function (current) {
    var finalOut = {
      pc: state.finalPC(),
      input: state.input,
      errors: state.errors,
      alternatives: current,
      stats: state.stats["export"]()
    };

    if (_Config["default"].outFilePath) {
      fs.writeFileSync(_Config["default"].outFilePath, JSON.stringify(finalOut));

      _Log["default"].log("Wrote final output to " + _Config["default"].outFilePath);
    } else {
      _Log["default"].log("No final output path supplied");
    }
  });
});