/*
    Copyright (C) 2014-2019 de4dot@gmail.com

    This file is part of dnSpy

    dnSpy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dnSpy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dnSpy.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.ComponentModel.Composition;
using System.Diagnostics;
using dnSpy.Contracts.Text;
using dnSpy.Contracts.Text.Classification;
using Microsoft.VisualStudio.Text.Classification;

namespace dnSpy.Text.Classification {
	[Export(typeof(IThemeClassificationTypeService))]
	sealed class ThemeClassificationTypeService : IThemeClassificationTypeService {
		readonly IClassificationType[] classificationTypes;

		[ImportingConstructor]
		ThemeClassificationTypeService(IClassificationTypeRegistryService classificationTypeRegistryService) {
			classificationTypes = new IClassificationType[(int)TextColor.Last] {
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Text),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Operator),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Punctuation),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Number),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Comment),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Keyword),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.String),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.VerbatimString),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Char),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Namespace),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Type),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SealedType),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.StaticType),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Delegate),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Enum),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Interface),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ValueType),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Module),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TypeGenericParameter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.MethodGenericParameter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InstanceMethod),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.StaticMethod),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ExtensionMethod),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InstanceField),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.EnumField),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.LiteralField),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.StaticField),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InstanceEvent),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.StaticEvent),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InstanceProperty),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.StaticProperty),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Local),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Parameter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.PreprocessorKeyword),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.PreprocessorText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Label),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.OpCode),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ILDirective),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ILModule),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ExcludedCode),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentAttributeName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentAttributeQuotes),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentAttributeValue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentCDataSection),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentComment),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentDelimiter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentEntityReference),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentProcessingInstruction),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocCommentText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralAttributeName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralAttributeQuotes),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralAttributeValue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralCDataSection),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralComment),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralDelimiter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralEmbeddedExpression),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralEntityReference),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralProcessingInstruction),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlLiteralText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlAttribute),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlAttributeQuotes),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlAttributeValue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlCDataSection),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlComment),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDelimiter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlKeyword),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlProcessingInstruction),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlAttribute),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlAttributeQuotes),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlAttributeValue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlCDataSection),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlComment),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlDelimiter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlKeyword),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlMarkupExtensionClass),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlMarkupExtensionParameterName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlMarkupExtensionParameterValue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlProcessingInstruction),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XamlText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.XmlDocToolTipHeader),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Assembly),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AssemblyExe),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AssemblyModule),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DirectoryPart),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.FileNameNoExtension),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.FileExtension),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Error),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ToStringEval),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplPrompt1),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplPrompt2),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplOutputText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplScriptOutputText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Black),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Blue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Cyan),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkBlue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkCyan),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkGray),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkGreen),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkMagenta),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkRed),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DarkYellow),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Gray),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Green),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Magenta),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Red),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.White),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Yellow),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvBlack),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvBlue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvCyan),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkBlue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkCyan),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkGray),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkGreen),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkMagenta),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkRed),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvDarkYellow),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvGray),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvGreen),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvMagenta),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvRed),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvWhite),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InvYellow),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogExceptionHandled),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogExceptionUnhandled),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogStepFiltering),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogLoadModule),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogUnloadModule),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogExitProcess),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogExitThread),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogProgramOutput),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogMDA),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogTimestamp),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.LineNumber),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplLineNumberInput1),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplLineNumberInput2),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ReplLineNumberOutput),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.VisibleWhitespace),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.InactiveSelectedText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HighlightedReference),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HighlightedWrittenReference),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HighlightedDefinition),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CurrentStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CurrentStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CallReturn),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CallReturnMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ActiveStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BreakpointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedBreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledBreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CurrentLine),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CurrentLineNoFocus),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexOffset),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexByte0),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexByte1),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexByteError),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexAscii),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexCaret),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexInactiveCaret),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexSelection),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.GlyphMargin),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BraceMatching),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.LineSeparator),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.FindMatchHighlightMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureNamespace),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureType),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureModule),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureValueType),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureInterface),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureMethod),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureAccessor),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureAnonymousMethod),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureConstructor),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureDestructor),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureOperator),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureConditional),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureLoop),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureProperty),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureEvent),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureTry),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureCatch),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureFilter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureFinally),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureFault),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureLock),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureUsing),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureFixed),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureSwitch),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureCase),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureLocalFunction),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureOther),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureXml),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BlockStructureXaml),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CompletionMatchHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.CompletionSuffix),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SignatureHelpDocumentation),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SignatureHelpCurrentParameter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SignatureHelpParameter),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SignatureHelpParameterDocumentation),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.Url),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexPeDosHeader),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexPeFileHeader),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexPeOptionalHeader32),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexPeOptionalHeader64),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexPeSection),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexPeSectionName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexCor20Header),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexStorageSignature),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexStorageHeader),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexStorageStream),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexStorageStreamName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexStorageStreamNameInvalid),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexTablesStream),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexTableName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DocumentListMatchHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.GacMatchHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AppSettingsTreeViewNodeMatchHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AppSettingsTextMatchHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexCurrentLine),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexCurrentLineNoFocus),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexInactiveSelectedText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexColumnLine0),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexColumnLine1),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexColumnLineGroup0),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexColumnLineGroup1),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexHighlightedValuesColumn),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexHighlightedAsciiColumn),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexGlyphMargin),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexCurrentValueCell),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexCurrentAsciiCell),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.OutputWindowText),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexFindMatchHighlightMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexToolTipServiceField0),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexToolTipServiceField1),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.HexToolTipServiceCurrentField),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ListFindMatchHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedBreakpointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedBreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedAdvancedBreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledAdvancedBreakpointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledAdvancedBreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedDisabledAdvancedBreakpointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BreakpointWarningStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BreakpointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedBreakpointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BreakpointErrorStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BreakpointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedBreakpointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedBreakpointWarningStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedBreakpointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedAdvancedBreakpointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedBreakpointErrorStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedBreakpointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedAdvancedBreakpointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TracepointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledTracepointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedDisabledTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedTracepointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedAdvancedTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledAdvancedTracepointStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DisabledAdvancedTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedDisabledAdvancedTracepointStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TracepointWarningStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TracepointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedTracepointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TracepointErrorStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.TracepointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedTracepointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedTracepointWarningStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedTracepointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedAdvancedTracepointWarningStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedTracepointErrorStatement),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AdvancedTracepointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.SelectedAdvancedTracepointErrorStatementMarker),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.BookmarkName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.ActiveBookmarkName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogTrace),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugLogExtensionMessage),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebuggerValueChangedHighlight),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugExceptionName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugStowedExceptionName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugReturnValueName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugVariableName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugObjectIdName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebuggerDisplayAttributeEval),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebuggerNoStringQuotesEval),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.DebugViewPropertyName),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmComment),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmDirective),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmPrefix),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmMnemonic),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmKeyword),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmOperator),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmPunctuation),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmNumber),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmRegister),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmSelectorValue),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmLabelAddress),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmFunctionAddress),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmLabel),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmFunction),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmData),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmAddress),
				classificationTypeRegistryService.GetClassificationType(ThemeClassificationTypeNames.AsmHexBytes),
			};
			foreach (var ct in classificationTypes) {
				Debug2.Assert(ct is not null);
				if (ct is null)
					throw new InvalidOperationException();
			}
		}

		public IClassificationType GetClassificationType(TextColor color) {
			if (!(0 <= color && color < TextColor.Last))
				color = TextColor.Text;
			return classificationTypes[(int)color];
		}
	}
}
