/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

public class NetworkSimulator {
    private static Timer _timer = new Timer(true);
    private static int HZ = 10;
    private boolean _shared = false;
    private Object _readLock = null;
    private Object _writeLock = null;
    private Object _sharedLock = null;
    private String _name;
    private int _readBandwidth = 0;
    private int _writeBandwidth = 0;
    private int _sharedBandwidth = 0;
    private int _readAvailable = 0;
    private int _writeAvailable = 0;
    private int _sharedAvailable = 0;
    private int _latency;

    public NetworkSimulator(String name, int latency, int readBandwidth, int writeBandwidth) {
        this._readLock = new Object();
        this._writeLock = new Object();
        this._name = name;
        this._shared = false;
        this._latency = latency;
        this._readBandwidth = readBandwidth;
        this._writeBandwidth = writeBandwidth;
        _timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                NetworkSimulator.this.refreshBandwidth();
            }
        }, 0L, (long)(1000 / HZ));
    }

    public NetworkSimulator(String name, int latency, int sharedBandwidth) {
        this._sharedLock = new Object();
        this._name = name;
        this._shared = true;
        this._latency = latency;
        this._sharedBandwidth = sharedBandwidth;
        _timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                NetworkSimulator.this.refreshBandwidth();
            }
        }, 0L, (long)(1000 / HZ));
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBandwidth() {
        if (this._shared) {
            Object object = this._sharedLock;
            synchronized (object) {
                this._sharedAvailable = this._sharedBandwidth / HZ;
                this._sharedLock.notifyAll();
            }
        }
        Object object = this._readLock;
        synchronized (object) {
            this._readAvailable = this._readBandwidth / HZ;
            this._readLock.notifyAll();
        }
        object = this._writeLock;
        synchronized (object) {
            this._writeAvailable = this._writeBandwidth / HZ;
            this._writeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int reserveShared(int requested) {
        var2_2 = this._sharedLock;
        synchronized (var2_2) {
            if (requested == 0) {
                try {
                    this._sharedLock.wait();
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
                return 0;
            }
            if (true) ** GOTO lbl20
            do {
                try {
                    this._sharedLock.wait();
                }
                catch (InterruptedException var3_4) {
                    // empty catch block
                }
lbl20:
                // 3 sources

            } while (this._sharedAvailable == 0);
            allocation = Math.min(requested, this._sharedAvailable);
            this._sharedAvailable -= allocation;
            return allocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int reserveRead(int requested) {
        if (this._shared) {
            return this.reserveShared(requested);
        }
        var2_2 = this._readLock;
        synchronized (var2_2) {
            if (requested == 0) {
                try {
                    this._readLock.wait();
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
                return 0;
            }
            if (true) ** GOTO lbl22
            do {
                try {
                    this._readLock.wait();
                }
                catch (InterruptedException var3_4) {
                    // empty catch block
                }
lbl22:
                // 3 sources

            } while (this._readAvailable == 0);
            allocation = Math.min(requested, this._readAvailable);
            this._readAvailable -= allocation;
            return allocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int reserveWrite(int requested) {
        if (this._shared) {
            return this.reserveShared(requested);
        }
        var2_2 = this._writeLock;
        synchronized (var2_2) {
            if (requested == 0) {
                try {
                    this._writeLock.wait();
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
                return 0;
            }
            if (true) ** GOTO lbl22
            do {
                try {
                    this._writeLock.wait();
                }
                catch (InterruptedException var3_4) {
                    // empty catch block
                }
lbl22:
                // 3 sources

            } while (this._writeAvailable == 0);
            allocation = Math.min(requested, this._writeAvailable);
            this._writeAvailable -= allocation;
            return allocation;
        }
    }

    public InputStream wrapInputStream(InputStream in) {
        return new ThrottledInputStream(in);
    }

    public OutputStream wrapOutputStream(OutputStream out) {
        return new ThrottledOutputStream(out);
    }

    private class ThrottledInputStream
    extends FilterInputStream {
        public ThrottledInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int got = this.in.read();
            if (got < 0) {
                return got;
            }
            while (NetworkSimulator.this.reserveRead(1) == 0) {
            }
            return got;
        }

        @Override
        public int read(byte[] buff, int off, int len) throws IOException {
            int allocation = 0;
            int got = this.in.read(buff, off, len);
            while (allocation < got) {
                allocation += NetworkSimulator.this.reserveRead(got - allocation);
            }
            return got;
        }
    }

    private class ThrottledOutputStream
    extends FilterOutputStream {
        public ThrottledOutputStream(OutputStream out) {
            super(out);
        }

        private void sleep(long period) {
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void write(int b) throws IOException {
            long finish = System.currentTimeMillis() + (long)NetworkSimulator.this._latency;
            while (NetworkSimulator.this.reserveWrite(1) == 0) {
            }
            this.out.write(b);
            long now = System.currentTimeMillis();
            if (now < finish) {
                this.sleep(finish - now);
            }
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            long finish = System.currentTimeMillis() + (long)NetworkSimulator.this._latency + (long)(len / (NetworkSimulator.this._shared ? NetworkSimulator.this._sharedBandwidth : NetworkSimulator.this._writeBandwidth));
            while (len > 0) {
                int allocation = NetworkSimulator.this.reserveWrite(len);
                if (allocation <= 0) continue;
                this.out.write(buff, off, allocation);
                off += allocation;
                len -= allocation;
            }
            long now = System.currentTimeMillis();
            if (now < finish) {
                this.sleep(finish - now);
            }
        }
    }
}

