/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.NetworkSimulator;
import org.owasp.webscarab.plugin.proxy.Proxy;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;
import org.owasp.webscarab.util.HtmlEncoder;

public class ConnectionHandler
implements Runnable {
    private static SSLSocketFactory _factory = null;
    private static String _keystore = "resources/server.p12";
    private static char[] _keystorepass = "password".toCharArray();
    private static char[] _keypassword = "password".toCharArray();
    private ProxyPlugin[] _plugins = null;
    private Proxy _proxy;
    private Socket _sock = null;
    private HttpUrl _base;
    private NetworkSimulator _simulator;
    private HTTPClient _httpClient = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private InputStream _clientIn = null;
    private OutputStream _clientOut = null;
    private InputStream _serverIn = null;
    private OutputStream _serverOut = null;
    private static int count = 0;

    public ConnectionHandler(Proxy proxy, Socket sock, HttpUrl base, NetworkSimulator simulator, boolean usePlugins) {
        this._proxy = proxy;
        this._sock = sock;
        this._base = base;
        this._simulator = simulator;
        if (usePlugins) {
            this._plugins = this._proxy.getPlugins();
        }
        try {
            this._sock.setTcpNoDelay(true);
            this._sock.setSoTimeout(30000);
        }
        catch (SocketException se) {
            this._logger.warning("Error setting socket parameters");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [49[DOLOOP]], but top level block is 15[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initSSL() {
        this._logger.info("initSSL()");
        KeyStore ks = null;
        KeyManagerFactory kmf = null;
        SSLContext sslcontext = null;
        try {
            ks = KeyStore.getInstance("PKCS12");
            Enumeration<URL> e = this.getClass().getClassLoader().getResources("resources");
            System.out.println("RESOURCES:");
            while (e.hasMoreElements()) {
                System.out.println(" -: " + e.nextElement());
            }
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(_keystore);
            if (is == null) {
                throw new NullPointerException("No keystore found!!");
            }
            ks.load(is, _keystorepass);
            kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, _keypassword);
            sslcontext = SSLContext.getInstance("SSLv3");
            sslcontext.init(kmf.getKeyManagers(), null, null);
            _factory = sslcontext.getSocketFactory();
            this._logger.info("Initialised SSL handler OK");
        }
        catch (Exception e) {
            this._logger.severe("Exception accessing keystore: " + e);
            _factory = null;
        }
    }

    private Socket negotiateSSL(Socket sock) throws Exception {
        if (_factory == null) {
            this.initSSL();
        }
        try {
            SSLSocket sslsock = (SSLSocket)_factory.createSocket(sock, sock.getInetAddress().getHostName(), sock.getPort(), true);
            sslsock.setUseClientMode(false);
            this._logger.fine("Finished negotiating SSL - algorithm is " + sslsock.getSession().getCipherSuite());
            return sslsock;
        }
        catch (Exception e) {
            this._logger.severe("Error layering SSL over the socket: " + e);
            throw e;
        }
    }

    private Response errorResponse(Request request, String message) {
        Response response = new Response();
        response.setRequest(request);
        response.setVersion("HTTP/1.0");
        response.setStatus("500");
        response.setMessage("WebScarab error");
        response.setHeader("Content-Type", "text/html");
        response.setHeader("Connection", "Close");
        String template = "<HTML><HEAD><TITLE>WebScarab Error</TITLE></HEAD>";
        template = String.valueOf(template) + "<BODY>CSRFTester couldn't retrieve<P><pre>" + HtmlEncoder.encode(request.toString()) + "</pre><P>";
        template = String.valueOf(template) + "The error was : <P><pre>" + HtmlEncoder.encode(message) + "</pre><P></HTML>";
        response.setContent(template.getBytes());
        return response;
    }
}

