/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import org.owasp.webscarab.model.Message;
import org.owasp.webscarab.model.Request;

public class Response
extends Message {
    private String version = null;
    private String status = null;
    private String message = null;
    private Request _request = null;

    public Response() {
        this.setVersion("HTTP/1.0");
    }

    public Response(Response resp) {
        this.version = resp.getVersion();
        this.status = resp.getStatus();
        this.message = resp.getMessage();
        this.setHeaders(resp.getHeaders());
        this.setContent(resp.getContent());
    }

    @Override
    public void read(InputStream is) throws IOException {
        String line = this.readLine(is);
        if (line == null) {
            throw new IOException("No data received from the server");
        }
        String[] parts = line.split(" ", 3);
        if (parts.length < 2) {
            throw new IOException("Invalid response line read from the server: \"" + line + "\"");
        }
        this.setVersion(parts[0]);
        this.setStatus(parts[1]);
        if (parts.length == 3) {
            this.setMessage(parts[2]);
        } else {
            this.setMessage("");
        }
        super.read(is);
        if (this.status.equals("304") || this.status.equals("204")) {
            this.setNoBody();
        }
    }

    public void parse(String string) throws ParseException {
        this.parse(new StringBuffer(string));
    }

    @Override
    public void parse(StringBuffer buff) throws ParseException {
        String line = this.getLine(buff);
        String[] parts = line.split(" ", 3);
        if (parts.length >= 2) {
            this.setVersion(parts[0]);
            this.setStatus(parts[1]);
        }
        if (parts.length == 3) {
            this.setMessage(parts[2]);
        } else {
            this.setMessage("");
        }
        super.parse(buff);
        if (this.status.equals("304") || this.status.equals("204")) {
            this.setNoBody();
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.write(os, "\r\n");
    }

    @Override
    public void write(OutputStream os, String crlf) throws IOException {
        os = new BufferedOutputStream(os);
        os.write(new String(String.valueOf(this.version) + " " + this.getStatusLine() + crlf).getBytes());
        super.write(os, crlf);
        os.flush();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatusLine() {
        return String.valueOf(this.status) + " " + this.message;
    }

    @Override
    public String toString() {
        return this.toString("\r\n");
    }

    @Override
    public String toString(String crlf) {
        StringBuffer buff = new StringBuffer();
        buff.append(String.valueOf(this.version) + " " + this.getStatusLine() + crlf);
        buff.append(super.toString(crlf));
        return buff.toString();
    }

    public void setRequest(Request request) {
        this._request = request;
    }

    public Request getRequest() {
        return this._request;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Response)) {
            return false;
        }
        Response resp = (Response)obj;
        if (!this.getVersion().equals(resp.getVersion())) {
            return false;
        }
        if (!this.getStatusLine().equals(resp.getStatusLine())) {
            return false;
        }
        return super.equals(obj);
    }
}

