/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class Preferences {
    static Properties _props = new Properties();
    private static Logger _logger = Logger.getLogger("org.owasp.webscarab.model.Preferences");
    private static String _location = null;

    private Preferences() {
    }

    public static Properties getPreferences() {
        return _props;
    }

    public static void loadPreferences(String file) throws IOException {
        if (file == null) {
            String sep = System.getProperty("file.separator");
            String home = System.getProperty("user.home");
            _location = String.valueOf(home) + sep + "WebScarab.properties";
        } else {
            _location = file;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(_location);
            props.load(is);
            _props = props;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void savePreferences() throws IOException {
        FileOutputStream fos = new FileOutputStream(_location);
        _props.store(fos, "WebScarab Properties");
        fos.close();
    }

    public static void setPreference(String key, String value) {
        _props.setProperty(key, value);
    }

    public static String getPreference(String key) {
        return _props.getProperty(key);
    }

    public static String getPreference(String key, String defaultValue) {
        return _props.getProperty(key, defaultValue);
    }

    public static String remove(String key) {
        return (String)_props.remove(key);
    }
}

