/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FixedLengthInputStream
extends FilterInputStream {
    private int max;
    private int read = 0;
    private int mark = 0;
    private boolean closed = false;

    public FixedLengthInputStream(InputStream is, int max) {
        super(is);
        this.max = max;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("available called on closed stream");
        }
        int canread = this.max - this.read;
        int available = super.available();
        if (canread > available) {
            available = canread;
        }
        return available;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("read called on closed stream");
        }
        int canread = this.max - this.read;
        if (canread < 1) {
            canread = 0;
        }
        if (canread > 0) {
            int b = super.read();
            if (b > -1) {
                ++this.read;
            }
            return b;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("read called on closed stream");
        }
        int canread = Math.min(len, this.max - this.read);
        if (canread > 0) {
            int bytesRead = super.read(b, off, canread);
            if (bytesRead > -1) {
                this.read += bytesRead;
            }
            return bytesRead;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("skip called on closed stream");
        }
        int canread = this.max - this.read;
        if (n > (long)canread) {
            n = canread;
        }
        if (n > 0L) {
            n = super.skip(n);
            this.read += (int)n;
        }
        return n;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on a " + this.in.getClass().getName() + " (" + this.read + " of " + this.max + ")";
    }
}

