/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester.report;

import java.io.File;
import java.io.IOException;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.report.ReportAdapter;

public final class XHRReport
extends ReportAdapter {
    protected XHRReport() {
    }

    @Override
    public String generateHtml(CSRFTesterModel model, File dir) throws IOException {
        this.generateMasterHtml(model, dir);
        return "file://" + dir.getPath() + "/index.html";
    }

    private void generateMasterHtml(CSRFTesterModel model, File dir) throws IOException {
        String template = this.getContent("/resources/XHRTemplate.html");
        StringBuffer pauses = new StringBuffer();
        StringBuffer methods = new StringBuffer();
        StringBuffer urls = new StringBuffer();
        StringBuffer params = new StringBuffer();
        int count = model.getRowCount();
        int i = 0;
        while (i < count) {
            pauses.append("\"" + model.getPause(i) + "\"");
            methods.append("\"" + model.getMethod(i) + "\"");
            urls.append("\"" + model.getURL(i) + "\"");
            params.append("\"" + model.getParameters(i) + "\"");
            if (i != count - 1) {
                pauses.append(",");
                methods.append(",");
                urls.append(",");
                params.append(",");
            }
            ++i;
        }
        String html = template;
        html = html.replace("<%COUNT%>", String.valueOf(count));
        html = html.replace("<%PAUSES%>", pauses);
        html = html.replace("<%METHODS%>", methods);
        html = html.replace("<%URLS%>", urls);
        html = html.replace("<%PARAMS%>", params);
        this.writeFile(dir, "index.html", html);
    }
}

