/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester.report;

import java.util.HashMap;
import java.util.Map;
import org.owasp.csrftester.report.Report;

public final class ReportFactory {
    public static final int FORMS = 0;
    public static final int XHR = 1;
    public static final int FRAME = 2;
    public static final int IMG = 3;
    public static final int LINK = 4;
    private static ReportFactory instance = new ReportFactory();
    private Map<Integer, String> reports = null;

    private ReportFactory() {
        String pg = "org.owasp.csrftester.report.";
        this.reports = new HashMap<Integer, String>();
        this.reports.put(0, "org.owasp.csrftester.report.FormsReport");
        this.reports.put(1, "org.owasp.csrftester.report.XHRReport");
        this.reports.put(2, "org.owasp.csrftester.report.FrameReport");
        this.reports.put(3, "org.owasp.csrftester.report.IMGReport");
        this.reports.put(4, "org.owasp.csrftester.report.LinkReport");
    }

    public static ReportFactory getInstance() {
        return instance;
    }

    public Report getReport(int id) {
        Report report = null;
        String s = this.reports.get(id);
        if (s != null) {
            report = this.getReport(s);
        }
        return report;
    }

    private Report getReport(String s) {
        Report report = null;
        try {
            Class<?> c = Class.forName(s);
            Object o = c.newInstance();
            if (o instanceof Report) {
                report = (Report)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return report;
    }
}

