/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.report.Report;

public abstract class ReportAdapter
implements Report {
    private static String sep = System.getProperty("line.separator");

    protected String getContent(String resourceName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer sb = new StringBuffer();
        String line = "";
        while ((line = reader.readLine()) != null) {
            sb.append(String.valueOf(line) + sep);
        }
        return sb.toString();
    }

    protected void writeFile(File dir, String name, String content) throws IOException {
        if (dir == null) {
            throw new IOException("No file specified");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, name);
        FileWriter writer = new FileWriter(file);
        writer.write(content);
        writer.close();
    }

    protected String getParametersAsHtmlInput(CSRFTesterModel model, int row) {
        return this.getParametersAsHtmlInput(model, row, false);
    }

    protected String getParametersAsHtmlInput(CSRFTesterModel model, int row, boolean isString) {
        String s = model.getParameters(row);
        String[] parts = s.split("&");
        StringBuffer sb = new StringBuffer();
        if (s == null || s.length() == 0) {
            if (isString) {
                sb.append("'<input type=\"hidden\" name=\"name\" value=\"value\"/>' \r\n");
            } else {
                sb.append("<input type=\"hidden\" name=\"name\" value=\"value\"/> \r\n");
            }
        } else if (parts.length == 1) {
            String[] pair = parts[0].split("=");
            if (isString) {
                sb.append("'<input type=\"hidden\" name=\"" + pair[0] + "\" value=\"" + pair[1] + "\"/>' \r\n");
            } else {
                sb.append("<input type=\"hidden\" name=\"" + pair[0] + "\" value=\"" + pair[1] + "\"/> \r\n");
            }
        } else {
            int i = 0;
            while (i < parts.length) {
                String value;
                String name = parts[i].split("=")[0];
                String string = value = parts[i].split("=").length == 1 ? "" : parts[i].split("=")[1];
                if (isString) {
                    sb.append("'<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>'");
                } else {
                    sb.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
                }
                if (i + 1 < parts.length && isString) {
                    sb.append(" + \r\n");
                } else {
                    sb.append("\r\n");
                }
                ++i;
            }
        }
        return sb.toString();
    }
}

