/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.util.Encoding;

public class CSRFTesterModel
extends DefaultTableModel {
    public static String DEFAULT_INCLUDE_PATTERN = ".*";
    public static String DEFAULT_EXCLUDE_PATTERN = ".*\\.(gif|jpg|png|css|ico|js|axd\\?.*|ico)$";
    public static String SEPARATOR = "\t";
    private boolean dirty = false;
    private Pattern include = Pattern.compile(DEFAULT_INCLUDE_PATTERN);
    private Pattern exclude = Pattern.compile(DEFAULT_EXCLUDE_PATTERN);
    private String linkText = null;

    public CSRFTesterModel() {
        super(new Object[0][], new String[]{"Step", "Method", "URL", "Parameters", "Pause"});
    }

    public void setIncludePattern(String pattern) throws PatternSyntaxException {
        this.include = Pattern.compile(pattern);
    }

    public void setExcludePattern(String pattern) throws PatternSyntaxException {
        this.exclude = Pattern.compile(pattern);
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public boolean saveNeeded() {
        return this.dirty;
    }

    public String getStepName(int row) {
        return this.getValueAt(row, 0).toString();
    }

    public void setStepName(int row, String value) {
        this.dirty = true;
        this.setValueAt(value, row, 0);
    }

    public String getMethod(int row) {
        return this.getValueAt(row, 1).toString();
    }

    public void setMethod(int row, String value) {
        this.dirty = true;
        this.setValueAt(value, row, 1);
    }

    public String getURL(int row) {
        return this.getValueAt(row, 2).toString();
    }

    public void setURL(int row, String value) {
        this.dirty = true;
        this.setValueAt(value, row, 2);
    }

    public String getParameters(int row) {
        return this.getValueAt(row, 3).toString();
    }

    public void setParameters(int row, String value) {
        this.dirty = true;
        this.setValueAt(value, row, 3);
    }

    public int getPause(int row) {
        String str = this.getValueAt(row, 4).toString();
        int pause = Integer.parseInt(str);
        return pause;
    }

    public void setPause(int row, String value) {
        this.dirty = true;
        this.setValueAt(value, row, 4);
        this.fireTableDataChanged();
    }

    public void addHttpRequest(String stepName, String method, String url, String params, int pause) {
        if (this.include.matcher(url).matches() && !this.exclude.matcher(url).matches()) {
            this.dirty = true;
            Object[] data = new String[]{stepName, method, Encoding.urlDecode(url).replace('\"', '\''), Encoding.urlDecode(params).replace('\"', '\''), "" + pause};
            this.addRow(data);
        }
    }

    public void clear() {
        this.dirty = true;
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public void load(File f) throws IOException {
        this.clear();
        BufferedReader r = new BufferedReader(new FileReader(f));
        String line = "";
        while ((line = r.readLine()) != null) {
            this.addRow(this.parse(line));
        }
        r.close();
        this.dirty = false;
    }

    private String[] parse(String line) {
        String[] data = new String[5];
        String[] parts = line.split(SEPARATOR);
        data[0] = parts[0];
        data[1] = parts[1];
        data[2] = parts[2];
        data[3] = parts[3];
        data[4] = parts[4];
        return data;
    }

    public void save(File f) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getRowCount()) {
            sb.delete(0, sb.length());
            sb.append(this.getValueAt(i, 0) + SEPARATOR);
            sb.append(this.getValueAt(i, 1) + SEPARATOR);
            sb.append(this.getValueAt(i, 2) + SEPARATOR);
            sb.append(this.getValueAt(i, 3) + SEPARATOR);
            sb.append(this.getValueAt(i, 4));
            w.write(sb.toString());
            w.newLine();
            ++i;
        }
        w.close();
        this.dirty = false;
    }

    private void setValueAt(String value, int row, int column) {
        int rowCount = this.getRowCount();
        if (rowCount >= row) {
            super.setValueAt(value, row, column);
        }
    }
}

