/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester;

import java.awt.EventQueue;
import java.io.IOException;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.CSRFTesterUI;
import org.owasp.csrftester.Proxy;

public class CSRFTester {
    private CSRFTesterModel model = new CSRFTesterModel();
    private CSRFTesterUI ui = new CSRFTesterUI(this.model);
    private static CSRFTester instance = new CSRFTester();

    public CSRFTester() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int x = 100;
                int y = 100;
                CSRFTester.this.ui.setLocation(x, y);
                CSRFTester.this.ui.setVisible(true);
            }
        });
    }

    public boolean isRecording() {
        return this.ui.isRecording();
    }

    public void addHttpRequest(String stepName, String method, String url, String params, int pause) {
        if (this.ui.isRecording()) {
            this.model.addHttpRequest(stepName, method, url, params, pause);
        }
    }

    public static void main(String[] args) {
        CSRFTester csrfTester = CSRFTester.getInstance();
        try {
            Proxy proxy = new Proxy();
            csrfTester.ui.setStatus(false, "Proxy started on port 8008");
        }
        catch (IOException e) {
            csrfTester.ui.setStatus(true, e.getMessage());
            System.exit(-1);
        }
    }

    public static CSRFTester getInstance() {
        return instance;
    }
}

