define(
['jquery','lodash','backbone','semantic','utils/tpl',
'models/scanstatus-collection',
'models/pentest-model',
'models/pentest-result-collection',
'views/pentest-scantable-empty',
'views/pentest-scantable',
'views/pentest-option',
'views/pentest-result'],

function($,_,Backbone,$,tpl,ScanStatuses, 
	Pentest, PentestResults, 
	PentestEmptyView, PentestScanTableView, PentestOptionView, PentestResultView) {

	var PentestView = Backbone.View.extend({

		initialize: function(){
			this.template = _.template(tpl.get('pentest'));
			
		},

		render: function(){
			this.setElement(this.template());
			return this.el;
		},

		events: {
			"click .to-go-scan.button" : "backToScan",
			"click .to-step-one.button" : "stepOne",
			"click .to-step-two.button" : "stepTwo",
			"click .to-step-start.button" : "pentestStart"
		},

		afterRender: function(){
			var scannedAP = this.getScannedAP();
			
			if ( scannedAP ) {
				if( this.apList==undefined ) {
					this.apList = new ScanStatuses(scannedAP);
				}
				this.apTableView = new PentestScanTableView({
					model : this.apList
				});
				this.$el.find('.ap-table').html(this.apTableView.render().el);
				
				this.optionView = new PentestOptionView();
				this.$el.find('.option').html(this.optionView.render().el);

				this.stepOne();
			
			} else {
				this.pentestEmptyView = new PentestEmptyView();
				this.$el.find('.ap-empty').html(this.pentestEmptyView.render().el);

				this.stepEmpty();
			}

			
		},

		getScannedAP: function(){
			var data = localStorage.getItem('scannedAP');
			if( data == null || data=='') {
				console.log('a')
				return false;
			} else {
				var json_data = JSON.parse(data);
				var filtered_data = _.filter(json_data,function(d){
					return d.type != "ad-hoc" && d.type != "station";
				});
				return filtered_data;
			}
		},

		stepEmpty: function() {
			this.$el.find('.steps .active').removeClass('active');
			this.$el.find('.steps .step.one').addClass('active');
			if( this.$el.find('.pentest-step.active').length>0 ) {
				this.$el.find('.pentest-step.active').removeClass('active').transition({
					animation: 'fade right',
					onHide: function(){
						$('.pentest-step.empty').addClass('active').transition('fade left');
					}
				});
			} else {
				$('.pentest-step.empty').addClass('active').transition('fade left');
			}
		},

		backToScan: function() {
			app.navigate("status",{trigger:true});
		},

		stepOne: function() {
			this.$el.find('.steps .active').removeClass('active');
			this.$el.find('.steps .step.one').addClass('active');
			if( this.$el.find('.pentest-step.active').length>0 ) {
				this.$el.find('.pentest-step.active').removeClass('active').transition({
					animation: 'fade right',
					onHide: function(){
						$('.pentest-step.one').addClass('active').transition('fade left');
					}
				});
			} else {
				$('.pentest-step.one').addClass('active').transition('fade left');
			}
			
		},

		stepTwo: function() {
			this.$el.find('.steps .active').removeClass('active');
			this.$el.find('.steps .step.two').addClass('active');
			this.$el.find('.pentest-step.active').removeClass('active').transition({
				animation: 'fade right',
				onHide: function(){
					$('.pentest-step.two').addClass('active').transition('fade left');
				}
			});
		},

		stepThree: function() {
			this.$el.find('.steps .active').removeClass('active');
			this.$el.find('.steps .step.three').addClass('active');
			this.$el.find('.pentest-step.active').removeClass('active').transition({
				animation: 'fade right',
				onHide: function(){
					$('.pentest-step.three').addClass('active').transition('fade left');
				}
			})
		},

		setPentestOption: function() {
			this.pentest = new Pentest();
			this.pentest.set(this.apTableView.getValue());
			this.pentest.set(this.optionView.getValue());

			this.pentest.save();
		},

		loadingModal: function() {
			var self = this;
			$('.pentest-loading.modal').modal({
				closable:false,
				onDeny:function(){
					clearTimeout(self.pentestTimer)
				}
			}).modal('show');

			$('.ui.progress').progress({
				total: this.count
			});
		},

		resultRender: function() {
			if(this.pentestResults==undefined){
				this.pentestResults = new PentestResults();
			}
			this.pentestResultView = new PentestResultView({
				model : this.pentestResults
			});
			this.$el.find('.pentest-result').html(this.pentestResultView.render().el);
		},

		pentestStart: function() {
			this.setPentestOption();

			this.count = this.pentest.get("timeout")*12;

			this.loadingModal();
	
			this.stepThree();

			this.resultRender();

			
			this.pentestLoop(this.count);
		},

		pentestLoop: function(count){
			var self = this;
			if( count>0 ) {
				this.pentestTimer = setTimeout( function() {
					$('.ui.progress').progress('increment');
					self.pentestResults.fetch({
						update:true,
						remove:false,
						success: function(){
							self.pentestLoop(count-1);
						},
						error: function(){
							console.log('pentest error');
						}
					});
				}, 5000);
			} else {
				$('.pentest-loading.modal').modal('hide');
			}
		}
	});
	
	return PentestView;

});