define(
['jquery','lodash','backbone','semantic','utils/tpl'],

function($, _, Backbone, $, tpl) {
	var PentestTypeTableView = Backbone.View.extend({

		tagName: 'div',

		initialize: function(){
			this.template = _.template(tpl.get('pentest-typetable'));
		},

		render: function(){
			this.$el.html(this.template());

			return this;
		},

		getValue: function(){
			var return_obj = {};
			this.$el.find('input:checkbox[name="check_type"]:checked').each(function(){
				var value = $(this).val();
				return_obj[value] = true;
			});
			return return_obj;
		}
	});
	
	return PentestTypeTableView;
});