define(
['jquery','lodash','backbone','semantic','utils/tpl','libs/jquery.tablesort'],

function($, _, Backbone, $, tpl) {
	var PentestScanTableView = Backbone.View.extend({

		tagName: 'div',


		initialize: function(){
			this.template = _.template(tpl.get('pentest-scantable'));
			this.model.bind("reset",this.render,this);
		},

		render: function(){
			this.$el.html(this.template());

			_.each(this.model.models,function(scanStatus){
				this.appendList(scanStatus);
			},this);

			this.sortTable();
			return this;
		},

		sortTable: function(){
			this.$el.find('table').tablesort();
		},

		appendList: function(scanStatus){
			this.$el.find('tbody').append(new PentestScanTableListView({
				model: scanStatus
			}).render().el);
		},

		getValue: function(){
			var return_obj = {};
			var return_arr = [];
			this.$el.find('input:checkbox[name="check_ap"]:checked').each(function(){
				var tmp_obj = {};
				var target_row = $(this).closest('tr');
				tmp_obj['bssid'] = target_row.find('.bssid').text();
				tmp_obj['essid'] = target_row.find('.essid').text();
				tmp_obj['channel'] = target_row.find('.channel').text();
				tmp_obj['enc_type'] = target_row.find('.enc_type').text();
				return_arr.push(tmp_obj);
			});
			return_obj['aplist'] = return_arr;
			return return_obj;
		}
	});
	
	var PentestScanTableListView = Backbone.View.extend({

		tagName: "tr",

		initialize: function(){
			this.template = _.template(tpl.get('pentest-scantable-list'));
			this.model.bind("change", this.render,this);
			this.model.bind("destroy",this.close,this);
		},

		render: function(){
			this.$el.html(this.template(this.model.toJSON()));
			return this;
		}
	})
	return PentestScanTableView;
});