define(
['jquery','lodash','backbone','semantic','utils/tpl','libs/jquery.tablesort'],

function($, _, Backbone, $, tpl) {
	var PentestResultView = Backbone.View.extend({

		tagName: 'div',

		className: 'ui raised segment',

		initialize: function(){
			this.template = _.template(tpl.get('pentest-result'));
			this.model.bind("reset",this.render,this);
			this.model.bind("add",this.appendList,this);
		},

		render: function(){
			this.$el.html(this.template());
			_.each(this.model.models,function(result_value){
				this.appendList(result_value);
			},this);

			this.sortTable();
			return this;
		},

		sortTable: function(){
			this.$el.find('table').tablesort();
		},

		appendList: function(result_value){
			this.$el.find('tbody').append(new PentestResultListView({
				model: result_value
			}).render().el);
		}
	});
	
	var PentestResultListView = Backbone.View.extend({

		tagName: "tr",

		initialize: function(){
			this.template = _.template(tpl.get('pentest-result-list'));
			this.model.bind("change", this.render,this);
			this.model.bind("destroy",this.close,this);
		},

		render: function(){
			this.$el.html(this.template(this.model.toJSON()));
			return this;
		}
	});

	return PentestResultView;
});