define(
['jquery','lodash','backbone','semantic','utils/tpl'],

function($, _, Backbone, $, tpl) {
	var PentestOptionView = Backbone.View.extend({

		tagName: 'div',

		initialize: function(){
			this.template = _.template(tpl.get('pentest-option'));
		},

		render: function(){
			this.$el.html(this.template());
			this.$el.find('.ui.checkbox').checkbox();

			return this;
		},

		events: {
			'change input.range': 'change_range',
			'mousemove input.range': 'change_range',
			'click .bruteforce.radio' : 'setBruteforce',
			'click .dictionary.radio' : 'setDictionary'
		},

		setBruteforce: function(){
			var bruteforce_field = this.$el.find('.bruteforce.segment');
			var dictionary_field = this.$el.find('.dictionary.segment');
			bruteforce_field.removeClass('disabled');
			dictionary_field.addClass('disabled');
			bruteforce_field.find('input').removeAttr("disabled");
			dictionary_field.find('input').attr("disabled",true);
			dictionary_field.find('input:checked').attr("checked",false);
		},

		setDictionary: function(){
			var bruteforce_field = this.$el.find('.bruteforce.segment');
			var dictionary_field = this.$el.find('.dictionary.segment');
			dictionary_field.removeClass('disabled');
			bruteforce_field.addClass('disabled');
			dictionary_field.find('input').removeAttr("disabled");
			bruteforce_field.find('input').attr("disabled",true);
			bruteforce_field.find('input:checked').attr("checked",false);
			bruteforce_field.find('input[type="text"]').val('');
		},

		change_range: function(){
			$(event.target).closest('div.field').find('.time_val').html(event.target.value);
		},

		getValue: function(){
			var return_obj = {};
			this.$el.find('input:checkbox[name="pentest_option"]:checked').each(function(){
				var value = $(this).val();
				return_obj[value] = true;
			});

			var minlength = this.$el.find('input:text[name="pentest_option_minlength"]').val();
			var maxlength = this.$el.find('input:text[name="pentest_option_maxlength"]').val();
			var timeout = this.$el.find('input.range[name="pentest_timeout"]').val();

			return_obj['bruteforce_minlength'] = minlength;
			return_obj['bruteforce_maxlength'] = maxlength;
			return_obj['timeout'] = timeout;


			return return_obj

		}
	});
	
	return PentestOptionView;
});