/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import msf.RpcConnection;

public class UploadFile
implements Runnable {
    protected FileInputStream in = null;
    protected byte[] buffer = new byte[262144];
    protected File file = null;
    protected RpcConnection client = null;
    protected UploadNotify listener = null;
    protected Thread thread = null;
    protected String rfile = null;

    public UploadFile(RpcConnection client, File file, UploadNotify listener) {
        this.file = file;
        this.client = client;
        this.listener = listener;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public String getRemoteFile() {
        if (SwingUtilities.isEventDispatchThread()) {
            System.err.println("DiSS! upload of " + this.file + " is happening in EDT (unsafe)");
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.rfile == null) {
            throw new RuntimeException("user canceled upload of file");
        }
        return this.rfile;
    }

    protected Object[] argz(byte[] data, long length) {
        byte[] me = new byte[(int)length];
        int x = 0;
        while ((long)x < length) {
            me[x] = data[x];
            ++x;
        }
        Object[] args = new Object[]{this.file.getName(), me};
        return args;
    }

    @Override
    public void run() {
        try {
            long total = this.file.length();
            long start = System.currentTimeMillis();
            long read2 = 0L;
            long ret = 0L;
            long sofar = 0L;
            double time = 0.0;
            ProgressMonitor progress = new ProgressMonitor(null, "Upload " + this.file.getName(), "Starting upload", 0, (int)total);
            this.in = new FileInputStream(this.file);
            read2 = this.in.read(this.buffer);
            sofar += read2;
            Map result = (Map)this.client.execute("armitage.upload", this.argz(this.buffer, read2));
            while (sofar < total) {
                time = (double)(System.currentTimeMillis() - start) / 1000.0;
                progress.setProgress((int)sofar);
                progress.setNote("Speed: " + Math.round((double)(sofar / 1024L) / time) + " KB/s");
                if (progress.isCanceled()) {
                    progress.close();
                    this.in.close();
                    return;
                }
                read2 = this.in.read(this.buffer);
                sofar += read2;
                this.client.execute("armitage.append", this.argz(this.buffer, read2));
                Thread.yield();
            }
            time = (double)(System.currentTimeMillis() - start) / 1000.0;
            progress.setProgress((int)sofar);
            progress.setNote("Speed: " + Math.round((double)(sofar / 1024L) / time) + " KB/s");
            progress.close();
            this.in.close();
            if (this.listener != null) {
                this.listener.complete(result.get("file") + "");
            }
            this.rfile = result.get("file") + "";
        }
        catch (Exception ioex) {
            JOptionPane.showMessageDialog(null, "Aborted upload of: " + this.file.getName() + "\n" + ioex.getMessage(), "Error", 0);
            System.err.println("Aborted upload of: " + this.file);
            ioex.printStackTrace();
        }
    }

    public static interface UploadNotify {
        public void complete(String var1);
    }
}

