/*
 * Decompiled with CFR 0.152.
 */
package ui;

import armitage.ArmitageApplication;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import msf.Async;
import msf.RpcConnection;

public class MultiFrame
extends JFrame
implements KeyEventDispatcher {
    protected JToolBar toolbar;
    protected JPanel content;
    protected CardLayout cards;
    protected LinkedList buttons;
    protected Properties prefs;
    protected Set idle = new HashSet();
    protected ArmitageApplication active;

    public void actOnDisconnect(final ArmitageInstance i) {
        if (i.serviced) {
            return;
        }
        i.serviced = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                i.button.setForeground(Color.RED);
                i.app.disconnected();
            }
        });
    }

    public void actOnIdle(final ArmitageInstance i) {
        if (this.idle.contains(i)) {
            return;
        }
        this.idle.add(i);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                i.button.setForeground(Color.MAGENTA);
            }
        });
    }

    public void actOnNotIdle(final ArmitageInstance i) {
        this.idle.remove(i);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                i.button.setForeground(Color.BLACK);
            }
        });
    }

    public void watchDog() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    LinkedList linkedList = MultiFrame.this.buttons;
                    synchronized (linkedList) {
                        for (ArmitageInstance temp : MultiFrame.this.buttons) {
                            if (!((Async)((Object)temp.client)).isConnected()) {
                                MultiFrame.this.actOnDisconnect(temp);
                                continue;
                            }
                            if (!((Async)((Object)temp.client)).isResponsive()) {
                                MultiFrame.this.actOnIdle(temp);
                                continue;
                            }
                            if (!MultiFrame.this.idle.contains(temp)) continue;
                            MultiFrame.this.actOnNotIdle(temp);
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }).start();
    }

    public void setPreferences(Properties prefs) {
        this.prefs = prefs;
    }

    public Properties getPreferences() {
        return this.prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getClients() {
        LinkedList linkedList = this.buttons;
        synchronized (linkedList) {
            HashMap<String, RpcConnection> r = new HashMap<String, RpcConnection>();
            for (ArmitageInstance temp : this.buttons) {
                if (!((Async)((Object)temp.client)).isConnected() || !((Async)((Object)temp.client)).isResponsive()) continue;
                r.put(temp.button.getText(), temp.client);
            }
            return r;
        }
    }

    public void setTitle(ArmitageApplication app, String title) {
        if (this.active == app) {
            this.setTitle(title);
        }
    }

    public boolean checkLocal() {
        return this.checkCollision("localhost");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCollision(String name) {
        LinkedList linkedList = this.buttons;
        synchronized (linkedList) {
            for (ArmitageInstance temp : this.buttons) {
                if (!name.equals(temp.button.getText())) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ev) {
        if (this.active != null) {
            return this.active.getBindings().dispatchKeyEvent(ev);
        }
        return false;
    }

    public static final void setupLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnect() {
        LinkedList linkedList = this.buttons;
        synchronized (linkedList) {
            if (this.buttons.size() == 0) {
                System.exit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        LinkedList linkedList = this.buttons;
        synchronized (linkedList) {
            ArmitageInstance temp = null;
            this.content.remove(this.active);
            Iterator i = this.buttons.iterator();
            while (i.hasNext()) {
                temp = (ArmitageInstance)i.next();
                if (temp.app != this.active) continue;
                this.toolbar.remove(temp.button);
                i.remove();
                this.toolbar.validate();
                this.toolbar.repaint();
                break;
            }
            if (this.buttons.size() == 0) {
                System.exit(0);
            } else if (this.buttons.size() == 1) {
                this.remove(this.toolbar);
                this.validate();
            }
            temp = i.hasNext() ? (ArmitageInstance)i.next() : (ArmitageInstance)this.buttons.getFirst();
            this.set(temp.button);
        }
    }

    public MultiFrame() {
        super("");
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.content = new JPanel();
        this.cards = new CardLayout();
        this.content.setLayout(this.cards);
        this.add((Component)this.content, "Center");
        this.buttons = new LinkedList();
        this.setDefaultCloseOperation(3);
        this.setSize(800, 600);
        this.setExtendedState(6);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.watchDog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(JToggleButton button) {
        LinkedList linkedList = this.buttons;
        synchronized (linkedList) {
            for (ArmitageInstance temp : this.buttons) {
                if (temp.button.getText().equals(button.getText())) {
                    temp.button.setSelected(true);
                    this.active = temp.app;
                    this.setTitle(this.active.getTitle());
                    continue;
                }
                temp.button.setSelected(false);
            }
            this.cards.show(this.content, button.getText());
            this.active.touch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addButton(String title, final ArmitageApplication component, RpcConnection conn) {
        if (this.checkCollision(title)) {
            this.addButton(title + " (2)", component, conn);
            return;
        }
        LinkedList linkedList = this.buttons;
        synchronized (linkedList) {
            final ArmitageInstance a = new ArmitageInstance();
            a.button = new JToggleButton(title);
            a.button.setToolTipText(title);
            a.app = component;
            a.client = conn;
            a.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MultiFrame.this.set((JToggleButton)ev.getSource());
                }
            });
            a.button.addMouseListener(new MouseAdapter(){

                public void check(MouseEvent ev) {
                    if (ev.isPopupTrigger()) {
                        final JToggleButton source = a.button;
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem rename = new JMenuItem("Rename");
                        rename.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                String name = JOptionPane.showInputDialog("Rename to?", (Object)source.getText());
                                if (name != null) {
                                    MultiFrame.this.content.remove(component);
                                    MultiFrame.this.content.add((Component)component, name);
                                    source.setText(name);
                                    MultiFrame.this.set(source);
                                }
                            }
                        });
                        popup.add(rename);
                        popup.show((JComponent)ev.getSource(), ev.getX(), ev.getY());
                        ev.consume();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent ev) {
                    this.check(ev);
                }

                @Override
                public void mousePressed(MouseEvent ev) {
                    this.check(ev);
                }

                @Override
                public void mouseReleased(MouseEvent ev) {
                    this.check(ev);
                }
            });
            this.toolbar.add(a.button);
            this.content.add((Component)component, title);
            this.buttons.add(a);
            this.set(a.button);
            if (this.buttons.size() == 1) {
                this.show();
            } else if (this.buttons.size() == 2) {
                this.add((Component)this.toolbar, "South");
            }
            this.validate();
        }
    }

    private static class ArmitageInstance {
        public ArmitageApplication app;
        public JToggleButton button;
        public RpcConnection client;
        public boolean serviced = false;

        private ArmitageInstance() {
        }
    }
}

