/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import sleep.engine.types.ObjectValue;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScalarType;
import sleep.runtime.SleepUtils;

public class Scalar
implements Serializable {
    protected ScalarType value = null;
    protected ScalarArray array = null;
    protected ScalarHash hash = null;

    public ScalarType getActualValue() {
        return this.value;
    }

    public ScalarType getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.array != null) {
            return SleepUtils.getScalar(SleepUtils.describe(this)).getValue();
        }
        if (this.hash != null) {
            return SleepUtils.getScalar(SleepUtils.describe(this)).getValue();
        }
        return null;
    }

    public String stringValue() {
        return ((Object)this.getValue()).toString();
    }

    public int intValue() {
        return this.getValue().intValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public long longValue() {
        return this.getValue().longValue();
    }

    public Object objectValue() {
        if (this.array != null) {
            return this.array;
        }
        if (this.hash != null) {
            return this.hash;
        }
        return this.value.objectValue();
    }

    public ScalarArray getArray() {
        return this.array;
    }

    public ScalarHash getHash() {
        return this.hash;
    }

    public void setValue(ScalarType scalarType) {
        this.value = scalarType.copyValue();
        this.array = null;
        this.hash = null;
    }

    public void setValue(ScalarArray scalarArray) {
        this.value = null;
        this.array = scalarArray;
        this.hash = null;
    }

    public void setValue(ScalarHash scalarHash) {
        this.value = null;
        this.array = null;
        this.hash = scalarHash;
    }

    public Object identity() {
        if (this.getArray() != null) {
            return this.array;
        }
        if (this.getHash() != null) {
            return this.hash;
        }
        if (this.value.getType() == ObjectValue.class) {
            return this.objectValue();
        }
        return this.toString();
    }

    public boolean sameAs(Scalar scalar) {
        if (this.getArray() != null && scalar.getArray() != null && this.getArray() == scalar.getArray()) {
            return true;
        }
        if (this.getHash() != null && scalar.getHash() != null && this.getHash() == scalar.getHash()) {
            return true;
        }
        if (this.getActualValue() != null && scalar.getActualValue() != null) {
            if (this.getActualValue().getType() == ObjectValue.class || scalar.getActualValue().getType() == ObjectValue.class) {
                return this.objectValue() == scalar.objectValue();
            }
            return this.identity().equals(scalar.identity());
        }
        return false;
    }

    public String toString() {
        return this.stringValue();
    }

    public void setValue(Scalar scalar) {
        if (scalar == null) {
            return;
        }
        if (scalar.getArray() != null) {
            this.setValue(scalar.getArray());
            return;
        }
        if (scalar.getHash() != null) {
            this.setValue(scalar.getHash());
            return;
        }
        if (scalar.getValue() != null) {
            this.setValue(scalar.getValue());
            return;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (SleepUtils.isEmptyScalar(this)) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(this.value);
        }
        objectOutputStream.writeObject(this.array);
        objectOutputStream.writeObject(this.hash);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.value = (ScalarType)objectInputStream.readObject();
        this.array = (ScalarArray)objectInputStream.readObject();
        this.hash = (ScalarHash)objectInputStream.readObject();
        if (this.value == null && this.array == null && this.hash == null) {
            this.setValue(SleepUtils.getEmptyScalar());
        }
    }
}

