/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.ProxyInterface;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.IntValue;
import sleep.engine.types.LongValue;
import sleep.engine.types.ObjectValue;
import sleep.engine.types.StringValue;
import sleep.interfaces.Function;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScalarHash;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import sleep.runtime.WatchScalar;

public class ObjectUtilities {
    private static Class STRING_SCALAR = StringValue.class;
    private static Class INT_SCALAR = IntValue.class;
    private static Class DOUBLE_SCALAR = DoubleValue.class;
    private static Class LONG_SCALAR = LongValue.class;
    private static Class OBJECT_SCALAR = ObjectValue.class;
    public static final int ARG_MATCH_YES = 3;
    public static final int ARG_MATCH_NO = 0;
    public static final int ARG_MATCH_MAYBE = 1;

    public static int isArgMatch(Class[] classArray, Stack stack) {
        int n = 3;
        for (int i = 0; i < classArray.length; ++i) {
            Scalar scalar = (Scalar)stack.get(classArray.length - i - 1);
            if ((n &= ObjectUtilities.isArgMatch(classArray[i], scalar)) != 0) continue;
            return 0;
        }
        return n;
    }

    private static Class normalizePrimitive(Class clazz) {
        if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        }
        return clazz;
    }

    public static int isArgMatch(Class clazz, Scalar scalar) {
        if (SleepUtils.isEmptyScalar(scalar)) {
            return 3;
        }
        if (scalar.getArray() != null) {
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                while (clazz2.isArray()) {
                    clazz2 = clazz2.getComponentType();
                }
                Class clazz3 = ObjectUtilities.getArrayType(scalar, null);
                if (clazz3 != null && clazz2.isAssignableFrom(clazz3)) {
                    return 3;
                }
                return 0;
            }
            if (clazz == List.class || clazz == Collection.class) {
                return 3;
            }
            if (clazz == ScalarArray.class) {
                return 3;
            }
            if (clazz == Object.class) {
                return 1;
            }
            return 0;
        }
        if (scalar.getHash() != null) {
            if (clazz == Map.class) {
                return 3;
            }
            if (clazz == ScalarHash.class) {
                return 3;
            }
            if (clazz == Object.class) {
                return 1;
            }
            return 0;
        }
        if (clazz.isPrimitive()) {
            Class clazz4 = scalar.getActualValue().getType();
            if (clazz4 == INT_SCALAR && clazz == Integer.TYPE) {
                return 3;
            }
            if (clazz4 == DOUBLE_SCALAR && clazz == Double.TYPE) {
                return 3;
            }
            if (clazz4 == LONG_SCALAR && clazz == Long.TYPE) {
                return 3;
            }
            if (clazz == Character.TYPE && clazz4 == STRING_SCALAR && ((Object)scalar.getActualValue()).toString().length() == 1) {
                return 3;
            }
            if (clazz4 == OBJECT_SCALAR) {
                clazz = ObjectUtilities.normalizePrimitive(clazz);
                return scalar.objectValue().getClass() == clazz ? 3 : 0;
            }
            return clazz4 == STRING_SCALAR ? 0 : 1;
        }
        if (clazz.isInterface()) {
            if (SleepUtils.isFunctionScalar(scalar) || clazz.isInstance(scalar.objectValue())) {
                return 3;
            }
            return 0;
        }
        if (clazz == String.class) {
            Class clazz5 = scalar.getActualValue().getType();
            return clazz5 == STRING_SCALAR ? 3 : 1;
        }
        if (clazz == Object.class) {
            return 1;
        }
        if (clazz.isInstance(scalar.objectValue())) {
            Class clazz6 = scalar.getActualValue().getType();
            return clazz6 == OBJECT_SCALAR ? 3 : 1;
        }
        if (clazz.isArray()) {
            Class clazz7 = scalar.getActualValue().getType();
            if (clazz7 == STRING_SCALAR && (clazz.getComponentType() == Character.TYPE || clazz.getComponentType() == Byte.TYPE)) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static Method findMethod(Class clazz, String string, Stack stack) {
        int n = stack.size();
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || methodArray[i].getParameterTypes().length != n) continue;
            if (n == 0) {
                return methodArray[i];
            }
            int n2 = ObjectUtilities.isArgMatch(methodArray[i].getParameterTypes(), stack);
            if (n2 == 3) {
                return methodArray[i];
            }
            if (n2 != 1) continue;
            method = methodArray[i];
        }
        return method;
    }

    public static Constructor findConstructor(Class clazz, Stack stack) {
        int n = stack.size();
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != n) continue;
            if (n == 0) {
                return constructorArray[i];
            }
            int n2 = ObjectUtilities.isArgMatch(constructorArray[i].getParameterTypes(), stack);
            if (n2 == 3) {
                return constructorArray[i];
            }
            if (n2 != 1) continue;
            constructor = constructorArray[i];
        }
        return constructor;
    }

    public static Class convertScalarDescriptionToClass(Scalar scalar) {
        if (scalar.objectValue() instanceof Class) {
            return (Class)scalar.objectValue();
        }
        return ObjectUtilities.convertDescriptionToClass(scalar.toString());
    }

    public static Class convertDescriptionToClass(String string) {
        if (string.length() != 1) {
            return null;
        }
        Class clazz = null;
        switch (string.charAt(0)) {
            case 'z': {
                clazz = Boolean.TYPE;
                break;
            }
            case 'c': {
                clazz = Character.TYPE;
                break;
            }
            case 'b': {
                clazz = Byte.TYPE;
                break;
            }
            case 'h': {
                clazz = Short.TYPE;
                break;
            }
            case 'i': {
                clazz = Integer.TYPE;
                break;
            }
            case 'l': {
                clazz = Long.TYPE;
                break;
            }
            case 'f': {
                clazz = Float.TYPE;
                break;
            }
            case 'd': {
                clazz = Double.TYPE;
                break;
            }
            case 'o': {
                clazz = Object.class;
                break;
            }
            case '*': {
                clazz = null;
            }
        }
        return clazz;
    }

    public static Object buildArgument(Class clazz, Scalar scalar, ScriptInstance scriptInstance) {
        if (clazz == String.class) {
            return SleepUtils.isEmptyScalar(scalar) ? null : scalar.toString();
        }
        if (scalar.getArray() != null) {
            if (clazz.isArray()) {
                Class clazz2 = ObjectUtilities.getArrayType(scalar, clazz.getComponentType());
                Object object = Array.newInstance(clazz2, scalar.getArray().size());
                Iterator iterator = scalar.getArray().scalarIterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Scalar scalar2 = (Scalar)iterator.next();
                    Object object2 = ObjectUtilities.buildArgument(clazz2, scalar2, scriptInstance);
                    if (!(object2 == null && !clazz2.isPrimitive() || clazz2.isInstance(object2) || clazz2.isPrimitive())) {
                        if (clazz2.isArray()) {
                            throw new RuntimeException("incorrect dimensions for conversion to " + clazz);
                        }
                        throw new RuntimeException(SleepUtils.describe(scalar2) + " at " + n + " is not compatible with " + clazz2.getName());
                    }
                    Array.set(object, n, object2);
                    ++n;
                }
                return object;
            }
            if (clazz == ScalarArray.class) {
                return scalar.objectValue();
            }
            return SleepUtils.getListFromArray(scalar);
        }
        if (scalar.getHash() != null) {
            if (clazz == ScalarHash.class) {
                return scalar.objectValue();
            }
            return SleepUtils.getMapFromHash(scalar);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return scalar.intValue() != 0;
            }
            if (clazz == Byte.TYPE) {
                return new Byte((byte)scalar.intValue());
            }
            if (clazz == Character.TYPE) {
                return new Character(scalar.toString().charAt(0));
            }
            if (clazz == Double.TYPE) {
                return new Double(scalar.doubleValue());
            }
            if (clazz == Float.TYPE) {
                return new Float((float)scalar.doubleValue());
            }
            if (clazz == Integer.TYPE) {
                return new Integer(scalar.intValue());
            }
            if (clazz == Short.TYPE) {
                return new Short((short)scalar.intValue());
            }
            if (clazz == Long.TYPE) {
                return new Long(scalar.longValue());
            }
        } else {
            if (SleepUtils.isEmptyScalar(scalar)) {
                return null;
            }
            if (clazz.isArray() && scalar.getActualValue().getType() == StringValue.class) {
                if (clazz.getComponentType() == Byte.TYPE || clazz.getComponentType() == Byte.class) {
                    return BridgeUtilities.toByteArrayNoConversion(scalar.toString());
                }
                if (clazz.getComponentType() == Character.TYPE || clazz.getComponentType() == Character.class) {
                    return scalar.toString().toCharArray();
                }
            } else if (clazz.isInterface() && SleepUtils.isFunctionScalar(scalar)) {
                return ProxyInterface.BuildInterface(clazz, (Function)SleepUtils.getFunctionFromScalar(scalar, scriptInstance), scriptInstance);
            }
        }
        return scalar.objectValue();
    }

    public static String buildArgumentErrorMessage(Class clazz, String string, Class[] classArray, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(string + "(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i + 1 >= classArray.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("(");
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                stringBuffer2.append(objectArray[i].getClass().getName());
            } else {
                stringBuffer2.append("null");
            }
            if (i + 1 >= objectArray.length) continue;
            stringBuffer2.append(", ");
        }
        stringBuffer2.append(")");
        return "bad arguments " + stringBuffer2.toString() + " for " + stringBuffer.toString() + " in " + clazz;
    }

    public static Object[] buildArgumentArray(Class[] classArray, Stack stack, ScriptInstance scriptInstance) {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Scalar scalar = (Scalar)stack.pop();
            objectArray[i] = ObjectUtilities.buildArgument(classArray[i], scalar, scriptInstance);
        }
        return objectArray;
    }

    public static Scalar BuildScalar(boolean bl, Object object) {
        if (object == null) {
            return SleepUtils.getEmptyScalar();
        }
        Class clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType() == Byte.TYPE || clazz.getComponentType() == Byte.class) {
                return SleepUtils.getScalar((byte[])object);
            }
            if (clazz.getComponentType() == Character.TYPE || clazz.getComponentType() == Character.class) {
                return SleepUtils.getScalar(new String((char[])object));
            }
            Scalar scalar = SleepUtils.getArrayScalar();
            for (int i = 0; i < Array.getLength(object); ++i) {
                scalar.getArray().push(ObjectUtilities.BuildScalar(true, Array.get(object, i)));
            }
            return scalar;
        }
        if (bl) {
            if (clazz.isPrimitive()) {
                clazz = ObjectUtilities.normalizePrimitive(clazz);
            }
            if (clazz == Boolean.class) {
                return SleepUtils.getScalar((Boolean)object != false ? 1 : 0);
            }
            if (clazz == Byte.class) {
                return SleepUtils.getScalar((int)((Byte)object).byteValue());
            }
            if (clazz == Character.class) {
                return SleepUtils.getScalar(object.toString());
            }
            if (clazz == Double.class) {
                return SleepUtils.getScalar((Double)object);
            }
            if (clazz == Float.class) {
                return SleepUtils.getScalar((double)((Float)object).floatValue());
            }
            if (clazz == Integer.class) {
                return SleepUtils.getScalar((Integer)object);
            }
            if (clazz == Long.class) {
                return SleepUtils.getScalar((Long)object);
            }
        }
        if (clazz == String.class) {
            return SleepUtils.getScalar(object.toString());
        }
        if (clazz == Scalar.class || clazz == WatchScalar.class) {
            return (Scalar)object;
        }
        return SleepUtils.getScalar(object);
    }

    public static Class getArrayType(Scalar scalar, Class clazz) {
        if (scalar.getArray() != null && scalar.getArray().size() > 0 && (clazz == null || clazz == Object.class)) {
            for (int i = 0; i < scalar.getArray().size(); ++i) {
                if (scalar.getArray().getAt(i).getArray() != null) {
                    return ObjectUtilities.getArrayType(scalar.getArray().getAt(i), clazz);
                }
                Class<?> clazz2 = scalar.getArray().getAt(i).getValue().getClass();
                Object object = scalar.getArray().getAt(i).objectValue();
                if (clazz2 == DOUBLE_SCALAR) {
                    return Double.TYPE;
                }
                if (clazz2 == INT_SCALAR) {
                    return Integer.TYPE;
                }
                if (clazz2 == LONG_SCALAR) {
                    return Long.TYPE;
                }
                if (object == null) continue;
                return object.getClass();
            }
        }
        return clazz;
    }

    public static void handleExceptionFromJava(Throwable throwable, ScriptEnvironment scriptEnvironment, String string, int n) {
        if (throwable != null) {
            scriptEnvironment.flagError(throwable);
            if (scriptEnvironment.isThrownValue() && string != null && string.length() > 0) {
                scriptEnvironment.getScriptInstance().recordStackFrame(string, n);
            }
        }
    }
}

