/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.IOObject;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class SocketObject
extends IOObject {
    protected Socket socket;
    private static Map servers;
    public static final int LISTEN_FUNCTION = 1;
    public static final int CONNECT_FUNCTION = 2;

    public Object getSource() {
        return this.socket;
    }

    public void open(SocketHandler socketHandler, ScriptEnvironment scriptEnvironment) {
        try {
            this.socket = new Socket();
            if (socketHandler.laddr != null) {
                this.socket.bind(new InetSocketAddress(socketHandler.laddr, socketHandler.lport));
            }
            this.socket.connect(new InetSocketAddress(socketHandler.host, socketHandler.port), socketHandler.timeout);
            this.socket.setSoLinger(true, socketHandler.linger);
            this.openRead(this.socket.getInputStream());
            this.openWrite(this.socket.getOutputStream());
        }
        catch (Exception exception) {
            scriptEnvironment.flagError(exception);
        }
    }

    public static void release(int n) {
        String string = n + "";
        ServerSocket serverSocket = null;
        if (servers != null && servers.containsKey(string)) {
            serverSocket = (ServerSocket)servers.get(string);
            servers.remove(string);
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static ServerSocket getServerSocket(int n, SocketHandler socketHandler) throws Exception {
        String string = n + "";
        if (servers == null) {
            servers = Collections.synchronizedMap(new HashMap());
        }
        ServerSocket serverSocket = null;
        if (servers.containsKey(string)) {
            serverSocket = (ServerSocket)servers.get(string);
        } else {
            serverSocket = new ServerSocket(n, socketHandler.backlog, socketHandler.laddr != null ? InetAddress.getByName(socketHandler.laddr) : null);
            servers.put(string, serverSocket);
        }
        return serverSocket;
    }

    public void listen(SocketHandler socketHandler, ScriptEnvironment scriptEnvironment) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = SocketObject.getServerSocket(socketHandler.port, socketHandler);
            serverSocket.setSoTimeout(socketHandler.timeout);
            this.socket = serverSocket.accept();
            this.socket.setSoLinger(true, socketHandler.linger);
            socketHandler.callback.setValue(SleepUtils.getScalar(this.socket.getInetAddress().getHostAddress()));
            this.openRead(this.socket.getInputStream());
            this.openWrite(this.socket.getOutputStream());
            return;
        }
        catch (Exception exception) {
            scriptEnvironment.flagError(exception);
            return;
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    public static class SocketHandler
    implements Runnable {
        public ScriptInstance script;
        public SleepClosure function;
        public SocketObject socket;
        public int port;
        public int timeout;
        public String host;
        public Scalar callback;
        public int type;
        public String laddr;
        public int lport;
        public int linger;
        public int backlog;

        public void start() {
            if (this.function != null) {
                this.socket.setThread(new Thread(this));
                this.socket.getThread().start();
            } else {
                this.run();
            }
        }

        public void run() {
            if (this.type == 1) {
                this.socket.listen(this, this.script.getScriptEnvironment());
            } else {
                this.socket.open(this, this.script.getScriptEnvironment());
            }
            if (this.function != null) {
                Stack<Scalar> stack = new Stack<Scalar>();
                stack.push(SleepUtils.getScalar(this.socket));
                this.function.callClosure("&callback", this.script, stack);
            }
        }
    }
}

