/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.io.IOException;
import java.util.ListIterator;
import org.msgpack.packer.Packer;
import org.msgpack.type.AbstractArrayValue;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.Value;

class ArrayValueImpl
extends AbstractArrayValue {
    private static ArrayValueImpl emptyInstance = new ArrayValueImpl(new Value[0], true);
    private Value[] array;

    public static ArrayValue getEmptyInstance() {
        return emptyInstance;
    }

    @Override
    public Value[] getElementArray() {
        return this.array;
    }

    ArrayValueImpl(Value[] array2, boolean gift) {
        if (gift) {
            this.array = array2;
        } else {
            this.array = new Value[array2.length];
            System.arraycopy(array2, 0, this.array, 0, array2.length);
        }
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public Value get(int index) {
        if (index < 0 || this.array.length <= index) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (!this.array[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.writeArrayBegin(this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i].writeTo(pk);
        }
        pk.writeArrayEnd();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isArrayValue()) {
            return false;
        }
        if (v.getClass() == ArrayValueImpl.class) {
            return this.equals((ArrayValueImpl)v);
        }
        ListIterator oi = v.asArrayValue().listIterator();
        for (int i = 0; i < this.array.length; ++i) {
            if (oi.hasNext() && this.array[i].equals(oi.next())) continue;
            return false;
        }
        return !oi.hasNext();
    }

    private boolean equals(ArrayValueImpl o) {
        if (this.array.length != o.array.length) {
            return false;
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i].equals(o.array[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 1;
        for (int i = 0; i < this.array.length; ++i) {
            Value obj = this.array[i];
            h = 31 * h + obj.hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (this.array.length == 0) {
            return sb.append("[]");
        }
        sb.append("[");
        sb.append(this.array[0]);
        for (int i = 1; i < this.array.length; ++i) {
            sb.append(",");
            this.array[i].toString(sb);
        }
        sb.append("]");
        return sb;
    }
}

