/*
 * Decompiled with CFR 0.152.
 */
package msf;

import armitage.ArmitageMain;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import msf.RpcConnection;

public class MeterpreterSession
implements Runnable {
    protected RpcConnection connection;
    protected LinkedList listeners = new LinkedList();
    protected LinkedList commands = new LinkedList();
    protected String session;
    protected boolean teammode;
    public static long DEFAULT_WAIT = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MeterpreterCallback l) {
        MeterpreterSession meterpreterSession = this;
        synchronized (meterpreterSession) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Command command, Map response, boolean timeout) {
        Iterator i;
        MeterpreterSession meterpreterSession = this;
        synchronized (meterpreterSession) {
            i = new LinkedList(this.listeners).iterator();
        }
        while (i.hasNext()) {
            if (timeout) {
                ((MeterpreterCallback)i.next()).commandTimeout(this.session, command != null ? command.token : null, response);
                continue;
            }
            ((MeterpreterCallback)i.next()).commandComplete(this.session, command != null ? command.token : null, response);
        }
    }

    public MeterpreterSession(RpcConnection connection, String session, boolean teammode) {
        this.connection = connection;
        this.session = session;
        this.teammode = teammode;
        new Thread(this).start();
    }

    protected void emptyRead() {
        if (this.teammode) {
            return;
        }
        try {
            Map read2 = this.readResponse();
            while (!"".equals(read2.get("data"))) {
                this.fireEvent(null, read2, false);
                read2 = this.readResponse();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void processCommand(Command c) {
        Map response = null;
        Map read2 = null;
        int expectedReads = 1;
        try {
            this.emptyRead();
            response = (Map)this.connection.execute("session.meterpreter_write", new Object[]{this.session, c.text});
            if (c.text.startsWith("cd ")) {
                return;
            }
            if (c.text.startsWith("rm ")) {
                return;
            }
            if (c.text.equals("shell\n") || c.text.equals("exit\n") || c.text.equals("rev2self\n")) {
                return;
            }
            if (!c.text.startsWith("webcam_snap -h")) {
                if (c.text.startsWith("webcam_snap ")) {
                    expectedReads = 3;
                } else {
                    if (c.text.startsWith("webcam_list") && !this.teammode) {
                        this.connection.execute("session.meterpreter_write", new Object[]{this.session, "getdesktop\n"});
                        this.readUntilSuccessful(c, false);
                        return;
                    }
                    if (c.text.startsWith("download ")) {
                        expectedReads = 2;
                    } else if (c.text.startsWith("upload ")) {
                        expectedReads = 2;
                    } else if (c.text.startsWith("keyscan_dump")) {
                        expectedReads = 2;
                    } else if (c.text.startsWith("migrate")) {
                        expectedReads = 2;
                    } else {
                        if (c.text.startsWith("hashdump")) {
                            this.readUntilSuccessful(c, true);
                            return;
                        }
                        if (c.text.startsWith("ps") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("execute") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("route") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("sniffer_interfaces") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("sniffer_dump") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("use ") && !this.teammode) {
                            this.readUntilSuccessful(c, false, "\n", 60000L);
                            return;
                        }
                        if (c.text.startsWith("load ") && !this.teammode) {
                            this.readUntilSuccessful(c, false, "\n", 60000L);
                            return;
                        }
                        if (c.text.startsWith("run ") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("timestomp ") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("sysinfo") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("ipconfig") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("list_tokens") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("impersonate_token") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("add_user") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("add_localgroup_user") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("add_group_user") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                        if (c.text.startsWith("kerberos")) {
                            this.readUntilSuccessful(c, true, "\n\n", 10000L);
                            return;
                        }
                        if (c.text.startsWith("livessp")) {
                            this.readUntilSuccessful(c, true, "\n\n", 10000L);
                            return;
                        }
                        if (c.text.startsWith("mimikatz_command")) {
                            this.readUntilSuccessful(c, true);
                            return;
                        }
                        if (c.text.startsWith("msv")) {
                            this.readUntilSuccessful(c, true, "\n\n", 10000L);
                            return;
                        }
                        if (c.text.startsWith("ssp")) {
                            this.readUntilSuccessful(c, true, "\n\n", 10000L);
                            return;
                        }
                        if (c.text.startsWith("tspkg")) {
                            this.readUntilSuccessful(c, true, "\n\n", 10000L);
                            return;
                        }
                        if (c.text.startsWith("wdigest")) {
                            this.readUntilSuccessful(c, true, "\n\n", 10000L);
                            return;
                        }
                        if (c.text.startsWith("enumdesktops") && !this.teammode) {
                            this.readUntilSuccessful(c, false);
                            return;
                        }
                    }
                }
            }
            for (int x = 0; x < expectedReads; ++x) {
                read2 = this.readResponse();
                long start = System.currentTimeMillis();
                while ("".equals(read2.get("data")) || read2.get("data").toString().startsWith("[-] Error running command read")) {
                    if (System.currentTimeMillis() - start > DEFAULT_WAIT) {
                        this.fireEvent(c, read2, true);
                        ArmitageMain.print_error("command timed out (session " + this.session + ") - '" + c.text + "'");
                        return;
                    }
                    read2 = this.readResponse();
                }
                this.fireEvent(c, read2, false);
            }
            read2 = this.readResponse();
            while (!"".equals(read2.get("data"))) {
                this.fireEvent(c, read2, false);
                read2 = this.readResponse();
            }
        }
        catch (Exception ex) {
            ArmitageMain.print_error("Meterpreter " + this.session + " error while executing '" + (c.text + "").trim() + "': " + ex.getMessage() + "\n\tlast response: " + response);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Object token, String text) {
        MeterpreterSession meterpreterSession = this;
        synchronized (meterpreterSession) {
            if (text.trim().equals("")) {
                return;
            }
            Command temp = new Command();
            temp.token = token;
            temp.text = text;
            this.commands.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command grabCommand() {
        MeterpreterSession meterpreterSession = this;
        synchronized (meterpreterSession) {
            return (Command)this.commands.pollFirst();
        }
    }

    @Override
    public void run() {
        long lastRead = System.currentTimeMillis();
        try {
            while (true) {
                Command next;
                if ((next = this.grabCommand()) == null && System.currentTimeMillis() - lastRead > 500L) {
                    lastRead = System.currentTimeMillis();
                    this.emptyRead();
                    continue;
                }
                if (next == null) {
                    Thread.sleep(25L);
                    continue;
                }
                lastRead = System.currentTimeMillis();
                this.processCommand(next);
            }
        }
        catch (Exception ex) {
            ArmitageMain.print_error("Meterpreter session " + this.session + " is dead: " + ex.getMessage());
            ex.printStackTrace();
            return;
        }
    }

    private void readUntilSuccessful(Command c, boolean pieces) throws Exception {
        long timeout = pieces ? 3000L : 500L;
        this.readUntilSuccessful(c, pieces, timeout);
    }

    private void readUntilSuccessful(Command c, boolean pieces, long timeout) throws Exception {
        this.readUntilSuccessful(c, pieces, null, timeout);
    }

    private void readUntilSuccessful(Command c, boolean pieces, String theend, long timeout) throws Exception {
        long start = System.currentTimeMillis() + DEFAULT_WAIT;
        StringBuffer buffer = new StringBuffer();
        Map read2 = null;
        while (System.currentTimeMillis() - start < timeout) {
            read2 = this.readResponse();
            String data = read2.get("data") + "";
            if (data.length() <= 0) continue;
            if (pieces) {
                this.fireEvent(c, read2, false);
            } else {
                buffer.append(data);
            }
            start = System.currentTimeMillis();
            if (theend == null || !data.toString().endsWith(theend) && !data.startsWith("[-] Unknown command:")) continue;
            break;
        }
        if (!pieces) {
            read2.put("data", buffer.toString());
            this.fireEvent(c, read2, false);
        }
    }

    private Map readResponse() throws Exception {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Map)this.connection.execute("session.meterpreter_read", new Object[]{this.session});
    }

    public static interface MeterpreterCallback {
        public void commandComplete(String var1, Object var2, Map var3);

        public void commandTimeout(String var1, Object var2, Map var3);
    }

    private static class Command {
        public Object token;
        public String text;
        public long start = System.currentTimeMillis();

        private Command() {
        }
    }
}

