/*
 * Decompiled with CFR 0.152.
 */
package cortana.metasploit;

import cortana.Safety;
import cortana.core.EventManager;
import cortana.core.FilterManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import msf.MeterpreterSession;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class MeterpreterBridge
implements Loadable,
Function,
MeterpreterSession.MeterpreterCallback {
    protected EventManager events;
    protected FilterManager filters;
    protected RpcConnection client;
    protected RpcConnection dserver;
    protected Map sessions;

    @Override
    public void commandComplete(String session, Object token, Map response) {
        if (!(token instanceof MeterpreterToken)) {
            return;
        }
        ScriptInstance script = ((MeterpreterToken)token).script;
        String command = ((MeterpreterToken)token).command;
        SleepClosure function2 = ((MeterpreterToken)token).function;
        String[] first = command.split("\\s+");
        if (first.length == 0) {
            return;
        }
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(response.get("data")));
        args.push(SleepUtils.getScalar(command));
        args.push(SleepUtils.getScalar(session));
        if (function2 == null) {
            this.events.fireEvent("meterpreter_" + first[0].toLowerCase(), args, script);
            this.events.fireEvent("meterpreter", args, script);
        } else {
            SleepUtils.runCode(function2, "complete", script, args);
        }
    }

    @Override
    public void commandTimeout(String session, Object token, Map response) {
        if (!(token instanceof MeterpreterToken)) {
            return;
        }
        ScriptInstance script = ((MeterpreterToken)token).script;
        String command = ((MeterpreterToken)token).command;
        SleepClosure function2 = ((MeterpreterToken)token).function;
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(SleepUtils.getScalar(command));
        args.push(SleepUtils.getScalar(session));
        if (function2 == null) {
            this.events.fireEvent("meterpreter_timeout", args, script);
        } else {
            SleepUtils.runCode(function2, "timeout", script, args);
        }
    }

    public MeterpreterSession getSession(String sid) {
        if (this.sessions.containsKey(sid)) {
            return (MeterpreterSession)this.sessions.get(sid);
        }
        MeterpreterSession m = new MeterpreterSession(this.client, sid, this.client != this.dserver);
        m.addListener(this);
        this.sessions.put(sid, m);
        return m;
    }

    public MeterpreterBridge(RpcConnection client, RpcConnection dserver, EventManager events, FilterManager filters) {
        this.client = client;
        this.dserver = dserver;
        this.events = events;
        this.filters = filters;
        this.sessions = new HashMap();
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        SleepClosure f;
        String sid = BridgeUtilities.getString(args, "");
        String command = BridgeUtilities.getString(args, "");
        MeterpreterSession session = this.getSession(sid);
        MeterpreterToken token = new MeterpreterToken();
        token.script = script;
        token.command = command;
        token.function = args.isEmpty() ? null : (f = BridgeUtilities.getFunction(args, script));
        if (Safety.shouldAsk(script)) {
            StringBuffer description = new StringBuffer();
            description.append("<html><body><b>");
            description.append(new File(script.getName()).getName());
            description.append("</b> wants to control meterpreter <b>");
            description.append(sid);
            description.append("</b>:</html></body>\n\n<html><body><b>");
            description.append(command);
            description.append("</b></body></html>\n\nWould you like to allow this?");
            if (!Safety.ask(script, description.toString(), "meterpreter " + sid + " - '" + command + "'")) {
                return SleepUtils.getEmptyScalar();
            }
        }
        if (Safety.shouldLog(script)) {
            Safety.log(script, "meterpreter " + sid + ": '" + command + "'");
        }
        session.addCommand(token, command);
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance si) {
        si.getScriptEnvironment().getEnvironment().put("&m_cmd", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }

    private static class MeterpreterToken {
        public ScriptInstance script;
        public String command;
        public SleepClosure function;

        private MeterpreterToken() {
        }
    }
}

