/*
 * Decompiled with CFR 0.152.
 */
package cortana.core;

import cortana.core.Filters;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.engine.ObjectUtilities;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class FilterManager {
    protected Map filters = new HashMap();

    protected List getFilters(String name) {
        if (this.filters.containsKey(name)) {
            return (List)this.filters.get(name);
        }
        this.filters.put(name, new LinkedList());
        return (List)this.filters.get(name);
    }

    public Loadable getBridge() {
        return new Filters(this);
    }

    public void addFilter(String filter, SleepClosure c) {
        this.getFilters(filter).add(new Filter(c));
    }

    public static Scalar convertAll(Object data) {
        if (data instanceof Collection) {
            Scalar temp = SleepUtils.getArrayScalar();
            Iterator i = ((Collection)data).iterator();
            while (i.hasNext()) {
                temp.getArray().push(FilterManager.convertAll(i.next()));
            }
            return temp;
        }
        if (data instanceof Map) {
            Scalar temp = SleepUtils.getHashScalar();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                Scalar key = SleepUtils.getScalar(entry.getKey() + "");
                Scalar value = temp.getHash().getAt(key);
                value.setValue(FilterManager.convertAll(entry.getValue()));
            }
            return temp;
        }
        return ObjectUtilities.BuildScalar(true, data);
    }

    public Stack filterScalarData(String eventName, Stack args) {
        List filters = this.getFilters(eventName);
        if (filters.size() == 0) {
            return args;
        }
        Iterator i = filters.iterator();
        ScriptInstance script = null;
        while (i.hasNext()) {
            Filter f = (Filter)i.next();
            if (!f.getClosure().getOwner().isLoaded()) {
                i.remove();
                continue;
            }
            Scalar temp = SleepUtils.runCode(f.getClosure(), eventName, null, args);
            script = f.getClosure().getOwner();
            args.clear();
            if (temp.getArray() != null) {
                ScalarArray ar = temp.getArray();
                while (ar.size() > 0) {
                    Scalar tempz = ar.pop();
                    args.push(tempz);
                }
                continue;
            }
            throw new RuntimeException("filter " + f.getClosure() + " did not return an array");
        }
        return args;
    }

    public Object[] filterData(String eventName, Object[] data) {
        if (this.getFilters(eventName).size() == 0) {
            return data;
        }
        Stack<Scalar> args = new Stack<Scalar>();
        int offset = data.length - 1;
        for (int x = 0; x < data.length; ++x) {
            args.push(FilterManager.convertAll(data[offset - x]));
        }
        Stack res = this.filterScalarData(eventName, args);
        Object[] rv = new Object[res.size()];
        for (int x = 0; x < rv.length; ++x) {
            rv[x] = ObjectUtilities.buildArgument(Object.class, (Scalar)res.pop(), null);
        }
        return rv;
    }

    private static class Filter {
        protected SleepClosure filter;

        public Filter(SleepClosure filter) {
            this.filter = filter;
        }

        public SleepClosure getClosure() {
            return this.filter;
        }
    }
}

