/*
 * Decompiled with CFR 0.152.
 */
package sleep.error;

import java.io.File;
import sleep.runtime.ScriptInstance;

public class ScriptWarning {
    protected ScriptInstance script;
    protected String message;
    protected int line;
    protected boolean trace;
    protected String source;

    public ScriptWarning(ScriptInstance scriptInstance, String string, int n) {
        this(scriptInstance, string, n, false);
    }

    public ScriptWarning(ScriptInstance scriptInstance, String string, int n, boolean bl) {
        this.script = scriptInstance;
        this.message = string;
        this.line = n;
        this.trace = bl;
        this.source = this.script.getScriptEnvironment().getCurrentSource();
    }

    public boolean isDebugTrace() {
        return this.trace;
    }

    public ScriptInstance getSource() {
        return this.script;
    }

    public String toString() {
        if (this.isDebugTrace()) {
            return "Trace: " + this.getMessage() + " at " + this.getNameShort() + ":" + this.getLineNumber();
        }
        return "Warning: " + this.getMessage() + " at " + this.getNameShort() + ":" + this.getLineNumber();
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getScriptName() {
        return this.source;
    }

    public String getNameShort() {
        return new File(this.getScriptName()).getName();
    }
}

