/*
 * Decompiled with CFR 0.152.
 */
package msf;

import armitage.ArmitageMain;
import graph.Route;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import msf.Base64;
import msf.RpcConnection;
import org.postgresql.util.PGobject;

public class DatabaseImpl
implements RpcConnection {
    protected Connection db;
    protected Map queries;
    protected String workspaceid = "0";
    protected String hFilter = null;
    protected String sFilter = null;
    protected String[] lFilter = null;
    protected Route[] rFilter = null;
    protected String[] oFilter = null;
    protected int hindex = 0;
    protected int sindex = 0;
    protected Map labels = new HashMap();
    protected int maxhosts = 512;
    protected int maxservices = 12288;
    private static long tzfix = 0L;
    protected boolean newdatamodel = false;

    public void resetHostsIndex() {
        this.hindex = 0;
        this.queries = this.build();
    }

    public void resetServicesIndex() {
        this.sindex = 0;
        this.queries = this.build();
    }

    public void nextHostsIndex() {
        ++this.hindex;
        this.queries = this.build();
    }

    public void nextServicesIndex() {
        ++this.sindex;
        this.queries = this.build();
    }

    private static String join(List items, String delim) {
        StringBuffer result = new StringBuffer();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            result.append(i.next());
            if (!i.hasNext()) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public void setWorkspace(String name) {
        try {
            List spaces = this.executeQuery("SELECT DISTINCT * FROM workspaces");
            for (Map temp : spaces) {
                if (!name.equals(temp.get("name"))) continue;
                this.workspaceid = temp.get("id") + "";
                this.queries = this.build();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setDebug(boolean d) {
    }

    public DatabaseImpl() {
        this.queries = this.build();
    }

    protected Object fixResult(Object o) {
        if (o instanceof Timestamp) {
            return new Long(((Timestamp)o).getTime() + tzfix);
        }
        if (o instanceof PGobject) {
            return o.toString();
        }
        return o;
    }

    protected int executeUpdate(String query) throws Exception {
        Statement s = this.db.createStatement();
        return s.executeUpdate(query);
    }

    protected List executeQuery(String query) throws Exception {
        LinkedList results = new LinkedList();
        Statement s = this.db.createStatement();
        ResultSet r = s.executeQuery(query);
        while (r.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            ResultSetMetaData m = r.getMetaData();
            int c = m.getColumnCount();
            for (int i = 1; i <= c; ++i) {
                row.put(m.getColumnLabel(i), this.fixResult(r.getObject(i)));
            }
            results.add(row);
        }
        return results;
    }

    private boolean checkRoute(String address) {
        for (int x = 0; x < this.rFilter.length; ++x) {
            if (!this.rFilter[x].shouldRoute(address)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLabel(String host) {
        if (!this.labels.containsKey(host)) {
            return false;
        }
        String label_l = (this.labels.get(host) + "").toLowerCase();
        for (int x = 0; x < this.lFilter.length; ++x) {
            if (label_l.indexOf(this.lFilter[x]) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean checkOS(String os) {
        String os_l = os.toLowerCase();
        for (int x = 0; x < this.oFilter.length; ++x) {
            if (os_l.indexOf(this.oFilter[x]) == -1) continue;
            return true;
        }
        return false;
    }

    protected void loadLabels() {
        try {
            List rows = this.executeQuery("SELECT DISTINCT data FROM notes WHERE ntype = 'armitage.labels'");
            if (rows.size() == 0) {
                return;
            }
            String data = ((Map)rows.get(0)).get("data") + "";
            byte[] raw = Base64.decode(data);
            ByteArrayInputStream store = new ByteArrayInputStream(raw);
            ObjectInputStream handle = new ObjectInputStream(store);
            Map temp = (Map)handle.readObject();
            handle.close();
            store.close();
            this.labels.putAll(temp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void mergeLabels(Map l) {
        for (Map.Entry entry : l.entrySet()) {
            if ("".equals(entry.getValue())) {
                this.labels.remove(entry.getKey() + "");
                continue;
            }
            this.labels.put(entry.getKey() + "", entry.getValue() + "");
        }
    }

    public List addLabels(List rows) {
        if (this.labels.size() == 0) {
            return rows;
        }
        for (Map entry : rows) {
            String address = (entry.containsKey("address") ? entry.get("address") : entry.get("host")) + "";
            if (this.labels.containsKey(address)) {
                entry.put("label", this.labels.get(address) + "");
                continue;
            }
            entry.put("label", "");
        }
        return rows;
    }

    public List filterByRoute(List rows, int max) {
        if (this.rFilter != null || this.oFilter != null || this.lFilter != null) {
            Iterator i = rows.iterator();
            while (i.hasNext()) {
                Map entry = (Map)i.next();
                if (this.rFilter != null && entry.containsKey("address")) {
                    if (!this.checkRoute(entry.get("address") + "")) {
                        i.remove();
                        continue;
                    }
                } else if (this.rFilter != null && entry.containsKey("host") && !this.checkRoute(entry.get("host") + "")) {
                    i.remove();
                    continue;
                }
                if (this.oFilter != null && entry.containsKey("os_name") && !this.checkOS(entry.get("os_name") + "")) {
                    i.remove();
                    continue;
                }
                if (this.lFilter != null && entry.containsKey("address")) {
                    if (this.checkLabel(entry.get("address") + "")) continue;
                    i.remove();
                    continue;
                }
                if (this.lFilter == null || !entry.containsKey("host") || this.checkLabel(entry.get("host") + "")) continue;
                i.remove();
            }
            if (rows.size() > max) {
                rows.subList(max, rows.size()).clear();
            }
        }
        return rows;
    }

    public boolean isNewDataModel() {
        return this.newdatamodel;
    }

    public void connect(String dbstring, String user, String password, int version) throws Exception {
        this.db = DriverManager.getConnection(dbstring, user, password);
        this.newdatamodel = version >= 41000;
        this.setWorkspace("default");
        this.loadLabels();
    }

    @Override
    public Object execute(String methodName) throws IOException {
        return this.execute(methodName, new Object[0]);
    }

    protected Map build() {
        int limit2;
        HashMap<String, String> temp = new HashMap<String, String>();
        int limit1 = this.rFilter == null && this.oFilter == null && this.lFilter == null ? this.maxhosts : 30000;
        int n = limit2 = this.rFilter == null && this.oFilter == null && this.lFilter == null ? this.maxservices : 100000;
        if (this.newdatamodel) {
            String nastyquery = "SELECT metasploit_credential_cores.id AS id, metasploit_credential_cores.realm_id AS realm_id, metasploit_credential_publics.username AS user, metasploit_credential_privates.type AS ptype, metasploit_credential_privates.data AS pass, 0 AS port, '' AS host, '' AS sname, '' AS proto FROM metasploit_credential_publics, metasploit_credential_privates, metasploit_credential_cores, metasploit_credential_origin_imports WHERE metasploit_credential_cores.origin_id = metasploit_credential_origin_imports.id AND metasploit_credential_cores.origin_type = 'Metasploit::Credential::Origin::Import' AND metasploit_credential_cores.public_id = metasploit_credential_publics.id AND metasploit_credential_cores.private_id = metasploit_credential_privates.id UNION SELECT metasploit_credential_cores.id AS id, metasploit_credential_cores.realm_id AS realm_id, metasploit_credential_publics.username AS user, metasploit_credential_privates.type AS ptype, metasploit_credential_privates.data AS pass, 0 AS port, '' AS host, '' AS sname, '' AS proto FROM metasploit_credential_publics, metasploit_credential_privates, metasploit_credential_cores, metasploit_credential_origin_cracked_passwords WHERE metasploit_credential_cores.origin_id = metasploit_credential_origin_cracked_passwords.id AND metasploit_credential_cores.origin_type = 'Metasploit::Credential::Origin::Cracked_Password' AND metasploit_credential_cores.public_id = metasploit_credential_publics.id AND metasploit_credential_cores.private_id = metasploit_credential_privates.id UNION SELECT metasploit_credential_cores.id AS id, metasploit_credential_cores.realm_id AS realm_id, metasploit_credential_publics.username AS user, metasploit_credential_privates.type AS ptype, metasploit_credential_privates.data AS pass, services.port AS port, host(hosts.address) AS host, services.name AS sname, services.proto AS proto FROM metasploit_credential_publics, metasploit_credential_privates, metasploit_credential_cores, hosts, services, metasploit_credential_origin_services WHERE metasploit_credential_cores.origin_id = metasploit_credential_origin_services.id AND metasploit_credential_cores.origin_type = 'Metasploit::Credential::Origin::Service' AND metasploit_credential_cores.public_id = metasploit_credential_publics.id AND metasploit_credential_cores.private_id = metasploit_credential_privates.id AND metasploit_credential_origin_services.service_id = services.id AND services.host_id = hosts.id AND hosts.workspace_id = " + this.workspaceid + " UNION SELECT metasploit_credential_cores.id AS id, metasploit_credential_cores.realm_id AS realm_id, metasploit_credential_publics.username AS user, metasploit_credential_privates.type AS ptype, metasploit_credential_privates.data AS pass, sessions.port AS port, host(hosts.address) AS host, '' AS sname, '' AS proto FROM metasploit_credential_publics, metasploit_credential_privates, metasploit_credential_cores, hosts, sessions, metasploit_credential_origin_sessions WHERE metasploit_credential_cores.origin_id = metasploit_credential_origin_sessions.id AND metasploit_credential_cores.origin_type = 'Metasploit::Credential::Origin::Session' AND metasploit_credential_cores.public_id = metasploit_credential_publics.id AND metasploit_credential_cores.private_id = metasploit_credential_privates.id AND metasploit_credential_origin_sessions.session_id = sessions.id AND sessions.host_id = hosts.id AND hosts.workspace_id = " + this.workspaceid + " UNION SELECT metasploit_credential_cores.id AS id, metasploit_credential_cores.realm_id AS realm_id, metasploit_credential_publics.username AS user, metasploit_credential_privates.type AS ptype, metasploit_credential_privates.data AS pass, 0 AS port, '' AS host, '' AS sname, '' AS proto FROM metasploit_credential_publics, metasploit_credential_privates, metasploit_credential_cores, metasploit_credential_origin_manuals WHERE metasploit_credential_cores.origin_id = metasploit_credential_origin_manuals.id AND metasploit_credential_cores.origin_type = 'Metasploit::Credential::Origin::Manual' AND metasploit_credential_cores.public_id = metasploit_credential_publics.id AND metasploit_credential_cores.private_id = metasploit_credential_privates.id";
            temp.put("db.creds", nastyquery);
            temp.put("db.creds2", nastyquery);
        } else {
            temp.put("db.creds", "SELECT DISTINCT creds.*, hosts.address as host, services.name as sname, services.port as port, services.proto as proto FROM creds, services, hosts WHERE services.id = creds.service_id AND hosts.id = services.host_id AND hosts.workspace_id = " + this.workspaceid);
            temp.put("db.creds2", "SELECT DISTINCT creds.user, creds.pass, hosts.address as host, services.name as sname, services.port as port, services.proto as proto, creds.ptype FROM creds, services, hosts WHERE services.id = creds.service_id AND hosts.id = services.host_id AND hosts.workspace_id = " + this.workspaceid);
        }
        if (this.hFilter != null) {
            LinkedList<String> tables = new LinkedList<String>();
            tables.add("hosts");
            if (this.hFilter.indexOf("services.") >= 0) {
                tables.add("services");
            }
            if (this.hFilter.indexOf("sessions.") >= 0) {
                tables.add("sessions");
            }
            temp.put("db.hosts", "SELECT DISTINCT hosts.id, hosts.updated_at, hosts.state, hosts.mac, hosts.purpose, hosts.os_flavor, hosts.os_name, hosts.address, hosts.os_sp, hosts.name FROM " + DatabaseImpl.join(tables, ", ") + " WHERE hosts.workspace_id = " + this.workspaceid + " AND " + this.hFilter + " ORDER BY hosts.id ASC LIMIT " + limit1 + " OFFSET " + limit1 * this.hindex);
        } else {
            temp.put("db.hosts", "SELECT DISTINCT hosts.id, hosts.updated_at, hosts.state, hosts.mac, hosts.purpose, hosts.os_flavor, hosts.os_name, hosts.address, hosts.os_sp, hosts.name FROM hosts WHERE hosts.workspace_id = " + this.workspaceid + " ORDER BY hosts.id ASC LIMIT " + limit1 + " OFFSET " + this.hindex * limit1);
        }
        temp.put("db.services", "SELECT DISTINCT services.id, services.name, services.port, services.proto, services.info, services.updated_at, hosts.address as host FROM services, (" + temp.get("db.hosts") + ") as hosts WHERE hosts.id = services.host_id AND services.state = 'open' ORDER BY services.id ASC LIMIT " + limit2 + " OFFSET " + limit2 * this.sindex);
        temp.put("db.loots", "SELECT DISTINCT loots.*, hosts.address as host FROM loots, hosts WHERE hosts.id = loots.host_id AND hosts.workspace_id = " + this.workspaceid);
        temp.put("db.workspaces", "SELECT DISTINCT * FROM workspaces");
        temp.put("db.notes", "SELECT DISTINCT notes.*, hosts.address as host FROM notes, hosts WHERE hosts.id = notes.host_id AND hosts.workspace_id = " + this.workspaceid);
        temp.put("db.clients", "SELECT DISTINCT clients.*, hosts.address as host FROM clients, hosts WHERE hosts.id = clients.host_id AND hosts.workspace_id = " + this.workspaceid);
        temp.put("db.sessions", "SELECT DISTINCT sessions.*, hosts.address as host FROM sessions, hosts WHERE hosts.id = sessions.host_id AND hosts.workspace_id = " + this.workspaceid);
        temp.put("db.events", "SELECT DISTINCT id, username, info, created_at FROM events WHERE events.name = 'armitage.event' ORDER BY id ASC");
        return temp;
    }

    @Override
    public Object execute(String methodName, Object[] params) throws IOException {
        try {
            if (this.queries.containsKey(methodName)) {
                String query = this.queries.get(methodName) + "";
                HashMap<String, List> result = new HashMap<String, List>();
                if (methodName.equals("db.services")) {
                    result.put(methodName.substring(3), this.filterByRoute(this.executeQuery(query), this.maxservices));
                } else if (methodName.equals("db.hosts")) {
                    result.put(methodName.substring(3), this.addLabels(this.filterByRoute(this.executeQuery(query), this.maxhosts)));
                } else {
                    result.put(methodName.substring(3), this.executeQuery(query));
                }
                return result;
            }
            if (methodName.equals("db.vulns")) {
                List a = this.executeQuery("SELECT DISTINCT vulns.*, vulns.id as vid, hosts.address as host, services.port as port, services.proto as proto, refs.name as refs FROM vulns, hosts, services, vulns_refs, refs WHERE hosts.id = vulns.host_id AND services.id = vulns.service_id AND vulns_refs.vuln_id = vulns.id AND vulns_refs.ref_id = refs.id AND hosts.workspace_id = " + this.workspaceid);
                List b = this.executeQuery("SELECT DISTINCT vulns.*, vulns.id as vid, hosts.address as host, refs.name as refs FROM vulns, hosts, refs, vulns_refs WHERE hosts.id = vulns.host_id AND vulns.service_id IS NULL AND vulns_refs.vuln_id = vulns.id AND vulns_refs.ref_id = refs.id AND hosts.workspace_id = " + this.workspaceid);
                a.addAll(b);
                HashMap<String, List> result = new HashMap<String, List>();
                result.put("vulns", a);
                return result;
            }
            if (methodName.equals("db.log_event")) {
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("INSERT INTO events (name, username, info, created_at) VALUES ('armitage.event', ?, ?, now() AT TIME ZONE 'GMT')");
                stmt.setString(1, params[0] + "");
                stmt.setString(2, params[1] + "");
                stmt.executeUpdate();
                return new HashMap();
            }
            if (methodName.equals("db.key_add")) {
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("INSERT INTO notes (ntype, data) VALUES (?, ?)");
                stmt.setString(1, params[0] + "");
                stmt.setString(2, params[1] + "");
                stmt.executeUpdate();
                return new HashMap();
            }
            if (methodName.equals("db.key_delete")) {
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("DELETE FROM notes WHERE id = ?");
                stmt.setString(1, params[0] + "");
                stmt.executeUpdate();
                return new HashMap();
            }
            if (methodName.equals("db.key_clear")) {
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("DELETE FROM notes WHERE ntype = ?");
                stmt.setString(1, params[0] + "");
                stmt.executeUpdate();
                return new HashMap();
            }
            if (methodName.equals("db.key_values")) {
                HashMap<String, List> results = new HashMap<String, List>();
                String key = params[0] + "";
                if (!key.matches("[0-9a-zA-Z\\._]+")) {
                    ArmitageMain.print_error("DatabaseImpl.java - Key '" + key + "' did not validate!");
                    return new HashMap();
                }
                results.put("values", this.executeQuery("SELECT DISTINCT * FROM notes WHERE ntype = '" + key + "' ORDER BY id ASC"));
                return results;
            }
            if (methodName.equals("db.clear_cache")) {
                this.executeUpdate("BEGIN;DELETE FROM module_details;DELETE FROM module_details;DELETE FROM module_targets;DELETE FROM module_authors;DELETE FROM module_actions;DELETE FROM module_mixins;DELETE FROM module_platforms;DELETE FROM module_archs;DELETE FROM module_refs;COMMIT");
                return new HashMap();
            }
            if (methodName.equals("db.clear")) {
                this.labels = new HashMap();
                if (this.isNewDataModel()) {
                    this.executeUpdate("BEGIN;DELETE FROM hosts;DELETE FROM services;DELETE FROM events;DELETE FROM notes;DELETE FROM creds;DELETE FROM loots;DELETE FROM vulns;DELETE FROM sessions;DELETE FROM clients;DELETE FROM metasploit_credential_origin_manuals;DELETE FROM metasploit_credential_origin_imports;DELETE FROM metasploit_credential_origin_sessions;DELETE FROM metasploit_credential_origin_services;DELETE FROM metasploit_credential_origin_cracked_passwords;DELETE FROM metasploit_credential_publics;DELETE FROM metasploit_credential_privates;DELETE FROM metasploit_credential_cores;DELETE FROM metasploit_credential_realms;COMMIT");
                } else {
                    this.executeUpdate("BEGIN;DELETE FROM hosts;DELETE FROM services;DELETE FROM events;DELETE FROM notes;DELETE FROM creds;DELETE FROM loots;DELETE FROM vulns;DELETE FROM sessions;DELETE FROM clients;COMMIT");
                }
                return new HashMap();
            }
            if (methodName.equals("db.filter")) {
                Map values = (Map)params[0];
                this.rFilter = null;
                this.oFilter = null;
                this.lFilter = null;
                LinkedList<String> hosts = new LinkedList<String>();
                LinkedList srvcs = new LinkedList();
                if ((values.get("session") + "").equals("1")) {
                    hosts.add("sessions.host_id = hosts.id AND sessions.closed_at IS NULL AND sessions.close_reason IS NULL");
                }
                if (values.containsKey("size")) {
                    try {
                        this.maxhosts = Integer.parseInt(values.get("size") + "");
                        this.maxservices = this.maxhosts * 24;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (values.containsKey("hosts") && (values.get("hosts") + "").length() > 0) {
                    String h = values.get("hosts") + "";
                    if (!h.matches("[0-9a-fA-F\\.:\\%\\_/, ]+")) {
                        ArmitageMain.print_error("DatabaseImpl.java - Host value '" + h + "' did not validate!");
                        return new HashMap();
                    }
                    String[] routes = h.split(",\\s*");
                    this.rFilter = new Route[routes.length];
                    for (int x = 0; x < routes.length; ++x) {
                        this.rFilter[x] = new Route(routes[x]);
                    }
                }
                if (values.containsKey("ports") && (values.get("ports") + "").length() > 0) {
                    LinkedList<String> ports = new LinkedList<String>();
                    LinkedList ports2 = new LinkedList();
                    String[] p = (values.get("ports") + "").split(",\\s*");
                    for (int x = 0; x < p.length; ++x) {
                        if (!p[x].matches("[0-9]+")) {
                            return new HashMap();
                        }
                        ports.add("services.port = " + p[x]);
                    }
                    hosts.add("services.host_id = hosts.id");
                    hosts.add("services.state = 'open'");
                    hosts.add("(" + DatabaseImpl.join(ports, " OR ") + ")");
                }
                if (values.containsKey("os") && (values.get("os") + "").length() > 0) {
                    this.oFilter = (values.get("os") + "").toLowerCase().split(",\\s*");
                }
                if (values.containsKey("labels") && (values.get("labels") + "").length() > 0) {
                    this.lFilter = (values.get("labels") + "").toLowerCase().split(",\\s*");
                }
                this.hFilter = hosts.size() == 0 ? null : DatabaseImpl.join(hosts, " AND ");
                this.queries = this.build();
                return new HashMap();
            }
            if (methodName.equals("db.fix_creds")) {
                Map values = (Map)params[0];
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("UPDATE creds SET ptype = 'smb_hash' WHERE creds.user = ? AND creds.pass = ?");
                stmt.setString(1, values.get("user") + "");
                stmt.setString(2, values.get("pass") + "");
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                result.put("rows", new Integer(stmt.executeUpdate()));
                return result;
            }
            if (methodName.equals("db.report_labels")) {
                Map values = (Map)params[0];
                this.mergeLabels(values);
                this.executeUpdate("DELETE FROM notes WHERE notes.ntype = 'armitage.labels'");
                ByteArrayOutputStream store = new ByteArrayOutputStream(this.labels.size() * 128);
                ObjectOutputStream handle = new ObjectOutputStream(store);
                handle.writeObject(this.labels);
                handle.close();
                store.close();
                String data = Base64.encode(store.toByteArray());
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("INSERT INTO notes (ntype, data) VALUES ('armitage.labels', ?)");
                stmt.setString(1, data);
                stmt.executeUpdate();
                return new HashMap();
            }
            if (methodName.equals("db.report_host")) {
                Map values = (Map)params[0];
                String host = values.get("host") + "";
                PreparedStatement stmt = null;
                this.executeUpdate("DELETE FROM notes WHERE EXISTS (SELECT id, address FROM hosts WHERE notes.host_id = id AND address = '" + host + "'::text::inet AND workspace_id = " + this.workspaceid + ")");
                if (values.containsKey("os_name") && values.containsKey("os_flavor")) {
                    stmt = this.db.prepareStatement("UPDATE hosts SET os_name = ?, os_flavor = ?, os_sp = '' WHERE hosts.address = ?::text::inet AND hosts.workspace_id = " + this.workspaceid);
                    stmt.setString(1, values.get("os_name") + "");
                    stmt.setString(2, values.get("os_flavor") + "");
                    stmt.setString(3, host);
                    stmt.executeUpdate();
                } else if (values.containsKey("os_name")) {
                    stmt = this.db.prepareStatement("UPDATE hosts SET os_name = ?, os_flavor = '', os_sp = '' WHERE hosts.address = ?::text::inet AND hosts.workspace_id = " + this.workspaceid);
                    stmt.setString(1, values.get("os_name") + "");
                    stmt.setString(2, host);
                    stmt.executeUpdate();
                }
                if (values.containsKey("purpose")) {
                    stmt = this.db.prepareStatement("UPDATE hosts SET purpose = ? WHERE hosts.address = ?::text::inet AND hosts.workspace_id = " + this.workspaceid);
                    stmt.setString(1, values.get("purpose") + "");
                    stmt.setString(2, host);
                    stmt.executeUpdate();
                }
                return new HashMap();
            }
            if (methodName.equals("db.remove_service")) {
                Map values = (Map)params[0];
                PreparedStatement stmt = null;
                stmt = this.db.prepareStatement("DELETE FROM services WHERE id = ?");
                stmt.setInt(1, Integer.parseInt(values.get("id") + ""));
                stmt.executeUpdate();
                return new HashMap();
            }
            if (methodName.equals("db.report_service")) {
                Map values = (Map)params[0];
                PreparedStatement stmt = null;
                if (values.containsKey("info")) {
                    stmt = this.db.prepareStatement("UPDATE services SET info = ? WHERE services.id = ?");
                    stmt.setString(1, values.get("info") + "");
                    stmt.setInt(2, Integer.parseInt(values.get("id") + ""));
                    stmt.executeUpdate();
                }
                return new HashMap();
            }
            if (methodName.equals("db.raw")) {
                return this.executeQuery("" + params[0]);
            }
            ArmitageMain.print_error("DatabaseImpl.java - need to implement: " + methodName);
        }
        catch (Exception ex) {
            ArmitageMain.print_error("DatabaseImpl.java - exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        return new HashMap();
    }

    static {
        Calendar now = Calendar.getInstance();
        tzfix = now.get(15) + now.get(16);
    }
}

