/*
 * Decompiled with CFR 0.152.
 */
package cortana.metasploit;

import armitage.ConsoleCallback;
import armitage.ConsoleClient;
import console.Console;
import cortana.core.EventManager;
import cortana.core.FilterManager;
import java.io.IOException;
import java.util.Stack;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class EventLogBridge
implements Loadable,
Function,
ConsoleCallback {
    protected EventManager events;
    protected FilterManager filters;
    protected RpcConnection client;
    protected RpcConnection dserver;
    protected ConsoleClient console;

    @Override
    public void sessionRead(String sessionid, String text) {
        String[] lines = text.trim().split("\n");
        for (int x = 0; x < lines.length; ++x) {
            Stack<Scalar> args = new Stack<Scalar>();
            args.push(SleepUtils.getScalar(lines[x]));
            this.events.fireEvent("event_read", args);
        }
    }

    @Override
    public void sessionWrote(String sessionid, String text) {
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(SleepUtils.getScalar(sessionid));
        args.push(SleepUtils.getScalar(text.trim()));
        this.events.fireEvent("event_write", args);
    }

    public ConsoleClient start(Console window) {
        if (this.dserver != this.client) {
            this.console = new ConsoleClient(window, this.dserver, "armitage.poll", "armitage.push", null, "", false);
            this.console.addSessionListener(this);
            return this.console;
        }
        return null;
    }

    public EventLogBridge(RpcConnection client, RpcConnection dserver, EventManager events, FilterManager filters) {
        this.client = client;
        this.dserver = dserver;
        this.events = events;
        this.filters = filters;
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        if (this.dserver == this.client) {
            return SleepUtils.getEmptyScalar();
        }
        String text = BridgeUtilities.getString(args, "");
        try {
            if (name.equals("&elog")) {
                Object[] arg = new Object[]{text};
                this.dserver.execute("armitage.log", arg);
                this.sessionWrote("log", text + "\n");
            } else if (name.equals("&say")) {
                this.console.sendString(text + "\n");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance si) {
        si.getScriptEnvironment().getEnvironment().put("&elog", this);
        si.getScriptEnvironment().getEnvironment().put("&say", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }
}

