/*
 * Decompiled with CFR 0.152.
 */
package cortana.metasploit;

import armitage.ConsoleQueue;
import cortana.Safety;
import cortana.core.EventManager;
import cortana.core.FilterManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ConsoleBridge
implements Loadable,
Function,
ConsoleQueue.ConsoleCallback {
    protected EventManager events;
    protected FilterManager filters;
    protected RpcConnection client;
    protected Map sessions;

    @Override
    public void commandComplete(ConsoleQueue session, Object token, String output) {
        if (!(token instanceof ConsoleToken)) {
            Stack<Scalar> args = new Stack<Scalar>();
            args.push(FilterManager.convertAll(output));
            args.push(SleepUtils.getEmptyScalar());
            args.push(SleepUtils.getScalar(session));
            this.events.fireEvent("console", args, null);
            return;
        }
        ScriptInstance script = ((ConsoleToken)token).script;
        String command = ((ConsoleToken)token).command;
        SleepClosure function2 = ((ConsoleToken)token).function;
        String[] first = command.split("\\s+");
        if (first.length == 0) {
            return;
        }
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(output));
        args.push(SleepUtils.getScalar(command));
        args.push(SleepUtils.getScalar(session));
        if (function2 == null) {
            this.events.fireEvent("console_" + first[0].toLowerCase(), args, script);
            this.events.fireEvent("console", args, script);
        } else {
            SleepUtils.runCode(function2, "complete", script, args);
        }
    }

    private ConsoleQueue getQueue(ScriptInstance script) {
        ConsoleQueue session;
        if (script.getMetadata().containsKey("%msfconsole%")) {
            session = (ConsoleQueue)script.getMetadata().get("%msfconsole%");
        } else {
            session = this.newQueue(script);
            script.getMetadata().put("%msfconsole%", session);
        }
        return session;
    }

    private ConsoleQueue newQueue(ScriptInstance script) {
        ConsoleQueue session = new ConsoleQueue(this.client);
        session.addListener(this);
        session.start();
        return session;
    }

    public ConsoleBridge(RpcConnection client, EventManager events, FilterManager filters) {
        this.client = client;
        this.events = events;
        this.filters = filters;
        this.sessions = new HashMap();
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        if (name.equals("&console")) {
            ConsoleQueue session = this.newQueue(script);
            session.addSessionListener(this);
            return SleepUtils.getScalar(session);
        }
        if (name.equals("&cmd_set")) {
            ConsoleQueue session = (ConsoleQueue)BridgeUtilities.getObject(args);
            Scalar topitem = (Scalar)args.pop();
            session.setOptions(SleepUtils.getMapFromHash(topitem));
        } else if (name.equals("&cmd_echo")) {
            ConsoleQueue session = (ConsoleQueue)BridgeUtilities.getObject(args);
            session.append(BridgeUtilities.getString(args, ""));
        } else if (name.equals("&cmd_stop")) {
            ConsoleQueue session = (ConsoleQueue)BridgeUtilities.getObject(args);
            session.stop();
        } else {
            SleepClosure f;
            ConsoleQueue session = null;
            if (name.equals("&cmd")) {
                session = (ConsoleQueue)BridgeUtilities.getObject(args);
            } else if (name.equals("&cmd_async")) {
                session = this.newQueue(script);
            } else if (name.equals("&cmd_safe")) {
                session = this.getQueue(script);
            }
            String command = BridgeUtilities.getString(args, "");
            ConsoleToken token = new ConsoleToken();
            token.script = script;
            token.command = command;
            token.function = args.isEmpty() ? null : (f = BridgeUtilities.getFunction(args, script));
            if (Safety.shouldAsk(script)) {
                StringBuffer description = new StringBuffer();
                description.append("<html><body><b>");
                description.append(new File(script.getName()).getName());
                description.append("</b> wants to write to a console");
                description.append("</b>:</html></body>\n\n<html><body><b>");
                description.append(command);
                description.append("</b></body></html>\n\nWould you like to allow this?");
                if (!Safety.ask(script, description.toString(), "console - '" + command + "'")) {
                    return SleepUtils.getEmptyScalar();
                }
            }
            if (Safety.shouldLog(script)) {
                Safety.log(script, "console - '" + command + "'");
            }
            session.addCommand(token, command);
            if (name.equals("&cmd_async")) {
                session.stop();
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance si) {
        si.getScriptEnvironment().getEnvironment().put("&cmd_async", this);
        si.getScriptEnvironment().getEnvironment().put("&cmd_safe", this);
        si.getScriptEnvironment().getEnvironment().put("&cmd", this);
        si.getScriptEnvironment().getEnvironment().put("&cmd_echo", this);
        si.getScriptEnvironment().getEnvironment().put("&cmd_set", this);
        si.getScriptEnvironment().getEnvironment().put("&console", this);
        si.getScriptEnvironment().getEnvironment().put("&cmd_stop", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }

    private static class ConsoleToken {
        public ScriptInstance script;
        public String command;
        public SleepClosure function;

        private ConsoleToken() {
        }
    }
}

