/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.DataUtils;
import cortana.data.Host;
import cortana.data.Hosts;
import cortana.data.ManagedData;
import cortana.data.Service;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import msf.RpcConnection;
import sleep.runtime.Scalar;

public class Services
extends ManagedData {
    protected RpcConnection client;
    protected EventManager manager;
    protected Hosts hosts;
    protected List services = new LinkedList();

    public Services(Hosts hosts, RpcConnection client, EventManager manager) {
        this.client = client;
        this.manager = manager;
        this.hosts = hosts;
    }

    public List getServices() {
        return this.services;
    }

    @Override
    public Scalar getScalar() {
        if (this.cache == null) {
            this.cache = FilterManager.convertAll(this.getServices());
        }
        return this.cache;
    }

    protected void fireServiceEvent(String event, Iterator services) {
        while (services.hasNext()) {
            Service t = (Service)services.next();
            if (event.equals("service_add")) {
                this.manager.fireEventAsync("service_add_" + t.getPort(), t.arguments());
                this.manager.fireEventAsync("service_add", t.arguments());
                continue;
            }
            this.manager.fireEventAsync(event, t.arguments());
        }
    }

    public void processServices(Map results) {
        if (this.hosts.isInitial()) {
            return;
        }
        if (!results.containsKey("services")) {
            return;
        }
        this.cache = null;
        this.hosts.cache = null;
        HashSet oldServices = new HashSet();
        HashSet<Service> newServices = new HashSet<Service>();
        for (Host host : this.hosts.getHosts().values()) {
            oldServices.addAll(host.serviceSet());
            host.getServices().clear();
        }
        this.services = (List)results.get("services");
        for (Map data : this.services) {
            String host = data.get("host") + "";
            String port = data.get("port") + "";
            Host temp = (Host)this.hosts.getHosts().get(host);
            if (temp == null) continue;
            Map srvc = temp.getServices();
            srvc.put(port, data);
            newServices.add(new Service(host, port));
        }
        if (!this.initial) {
            Set newStuff = DataUtils.difference(newServices, oldServices);
            this.fireServiceEvent("service_add", newStuff.iterator());
            Set deletedStuff = DataUtils.difference(oldServices, newServices);
            this.fireServiceEvent("service_delete", deletedStuff.iterator());
        }
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(this.services));
        this.manager.fireEventAsync("services", args);
        this.initial = false;
    }
}

