/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.DataUtils;
import cortana.data.Host;
import cortana.data.ManagedData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import msf.RpcConnection;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class Hosts
extends ManagedData {
    protected RpcConnection client;
    protected EventManager manager;
    protected Map hosts = new HashMap();

    public Map getHostsData() {
        HashMap r = new HashMap();
        for (Map.Entry temp : this.hosts.entrySet()) {
            r.put(temp.getKey(), ((Host)temp.getValue()).getData());
        }
        return r;
    }

    @Override
    public Scalar getScalar() {
        if (this.cache == null) {
            this.cache = FilterManager.convertAll(this.getHostsData());
        }
        return this.cache;
    }

    public Map getHosts() {
        return this.hosts;
    }

    public Hosts(RpcConnection client, EventManager manager) {
        this.client = client;
        this.manager = manager;
    }

    protected void fireHostEvent(String event, Iterator changes) {
        while (changes.hasNext()) {
            String addr = (String)changes.next();
            Stack<Scalar> argz = new Stack<Scalar>();
            argz.push(SleepUtils.getScalar(addr));
            this.manager.fireEventAsync(event, argz);
        }
    }

    public void processHosts(Map results) {
        if (!results.containsKey("hosts")) {
            return;
        }
        this.cache = null;
        HashSet currentHosts = new HashSet();
        currentHosts.addAll(this.hosts.keySet());
        HashMap<String, Host> newHosts = new HashMap<String, Host>();
        List hostl = (List)results.get("hosts");
        for (Map data : hostl) {
            Host temp;
            String address = data.get("address") + "";
            if (this.hosts.containsKey(address)) {
                temp = (Host)this.hosts.get(address);
                temp.update(data);
            } else {
                temp = new Host(address, data);
            }
            newHosts.put(address, temp);
        }
        this.hosts = newHosts;
        if (!this.initial) {
            Set oldHosts = DataUtils.difference(currentHosts, newHosts.keySet());
            this.fireHostEvent("host_delete", oldHosts.iterator());
            Set newStuff = DataUtils.difference(newHosts.keySet(), currentHosts);
            this.fireHostEvent("host_add", newStuff.iterator());
        }
        Stack<Scalar> arg = new Stack<Scalar>();
        arg.push(FilterManager.convertAll(hostl));
        this.manager.fireEventAsync("hosts", arg);
        this.initial = false;
    }
}

