/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import armitage.ArmitageTimerClient;
import cortana.core.EventManager;
import cortana.data.CortanaTimer;
import cortana.data.Credentials;
import cortana.data.Host;
import cortana.data.Hosts;
import cortana.data.Loots;
import cortana.data.Routes;
import cortana.data.Services;
import cortana.data.Sessions;
import graph.Route;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class DataManager
implements ArmitageTimerClient,
Loadable,
Function,
Predicate {
    protected RpcConnection client;
    protected EventManager manager;
    protected Hosts hosts;
    protected Routes routes;
    protected Sessions sessions;
    protected Services services;
    protected Credentials creds;
    protected Loots loots;
    protected boolean synced = false;
    protected boolean reset = false;
    protected boolean dserver = true;

    public DataManager(RpcConnection client, EventManager manager, boolean hasTeamServer) {
        this.client = client;
        this.manager = manager;
        this.hosts = new Hosts(client, manager);
        this.routes = new Routes(client, manager);
        this.services = new Services(this.hosts, client, manager);
        this.sessions = new Sessions(this.hosts, client, manager);
        this.creds = new Credentials(client, manager);
        this.loots = new Loots(client, manager);
        this.dserver = hasTeamServer;
    }

    public void start() {
        Object[] arguments = new Object[]{new HashMap()};
        new CortanaTimer(this.client, "db.hosts", 2500L, this, this.dserver);
        new CortanaTimer(this.client, "db.services", 10000L, this, this.dserver);
        new CortanaTimer(this.client, "db.creds", 30000L, this, this.dserver);
        new CortanaTimer(this.client, "db.loots", 30000L, this, this.dserver);
        new CortanaTimer(this.client, "session.list", 2000L, this, this.dserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        DataManager dataManager = this;
        synchronized (dataManager) {
            return this.synced && !this.hosts.isInitial() && !this.services.isInitial() && !this.routes.isInitial() && !this.sessions.isInitial() && !this.creds.isInitial() && !this.loots.isInitial();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean result(String command, Object[] arguments, Map results) {
        DataManager dataManager = this;
        synchronized (dataManager) {
            if (command.equals("session.list")) {
                this.sessions.processSessions(results);
                this.routes.processRoutes(results);
            } else if (command.equals("db.services")) {
                this.services.processServices(results);
            } else if (command.equals("db.hosts")) {
                this.hosts.processHosts(results);
            } else if (command.equals("db.creds")) {
                this.creds.processCreds(results);
            } else if (command.equals("db.loots")) {
                this.loots.processLoots(results);
            }
            if (!(this.synced || this.hosts.isInitial() || this.services.isInitial() || this.routes.isInitial() || this.sessions.isInitial() || this.creds.isInitial() || this.loots.isInitial())) {
                boolean r = this.reset;
                this.synced = true;
                this.reset = false;
                if (!r) {
                    this.manager.fireEventAsync("ready", new Stack());
                } else {
                    this.manager.fireEventAsync("workspace_change", new Stack());
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        DataManager dataManager = this;
        synchronized (dataManager) {
            if (name.equals("&sessions")) {
                return this.sessions.getScalar();
            }
            if (name.equals("&hosts")) {
                return this.hosts.getScalar();
            }
            if (name.equals("&credentials")) {
                return this.creds.getScalar();
            }
            if (name.equals("&loots")) {
                return this.loots.getScalar();
            }
            if (name.equals("&services")) {
                return this.services.getScalar();
            }
            if (name.equals("&db_sync")) {
                Object[] arguments = new Object[]{new HashMap()};
                new CortanaTimer(this.client, "db.hosts", 0L, this, false);
                new CortanaTimer(this.client, "db.services", 0L, this, false);
                new CortanaTimer(this.client, "db.creds", 0L, this, false);
                return SleepUtils.getEmptyScalar();
            }
            if (name.equals("&routes")) {
                return this.routes.getScalar();
            }
            if (name.equals("&db_workspace")) {
                try {
                    HashMap<String, String> workspace = new HashMap<String, String>();
                    Object[] argz = new Object[1];
                    if (args.size() >= 4) {
                        String hosts = BridgeUtilities.getString(args, "");
                        String ports = BridgeUtilities.getString(args, "");
                        String os = BridgeUtilities.getString(args, "");
                        String session = BridgeUtilities.getString(args, "");
                        if (!args.isEmpty()) {
                            String size = BridgeUtilities.getString(args, "512");
                            workspace.put("size", size);
                        }
                        if (!hosts.equals("")) {
                            workspace.put("hosts", hosts);
                        }
                        if (!ports.equals("")) {
                            workspace.put("ports", ports);
                        }
                        if (!os.equals("")) {
                            workspace.put("os", os);
                        }
                        if (!session.equals("")) {
                            workspace.put("session", "1");
                        }
                        argz[0] = workspace;
                    } else if (args.size() == 1) {
                        argz[0] = SleepUtils.getMapFromHash((Scalar)args.pop());
                        if (!(argz[0] instanceof Map)) {
                            throw new IllegalArgumentException("&db_workspace requires a hash");
                        }
                    } else {
                        argz[0] = new HashMap();
                    }
                    this.client.execute("db.filter", argz);
                    this.reset = true;
                    this.synced = false;
                    this.hosts.reset();
                    this.sessions.reset();
                    this.routes.reset();
                    this.services.reset();
                    this.creds.reset();
                }
                catch (IOException ioex) {
                    throw new RuntimeException(ioex);
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decide(String predicate, ScriptInstance script, Stack terms) {
        DataManager dataManager = this;
        synchronized (dataManager) {
            if (predicate.equals("hasservice")) {
                String port = BridgeUtilities.getString(terms, "");
                String addr = BridgeUtilities.getString(terms, "");
                Host host = (Host)this.hosts.getHosts().get(addr);
                if (host != null) {
                    return host.hasService(port);
                }
            } else if (predicate.equals("ispivot")) {
                String addr = BridgeUtilities.getString(terms, "");
                String sid = BridgeUtilities.getString(terms, "");
                for (Route r : this.routes.getRoutes()) {
                    if (!sid.equals(r.getGateway()) || !r.shouldRoute(addr)) continue;
                    return true;
                }
            } else {
                if (predicate.equals("isroute")) {
                    String addr = BridgeUtilities.getString(terms, "");
                    Route route = (Route)BridgeUtilities.getObject(terms);
                    return route.shouldRoute(addr);
                }
                if (predicate.equals("-isready")) {
                    String sid = BridgeUtilities.getString(terms, "");
                    Map session = this.sessions.getSession(sid);
                    if (session == null) {
                        return false;
                    }
                    return !"meterpreter".equals(session.get("type")) || !"".equals(session.get("info"));
                }
                if (predicate.equals("-ismeterpreter")) {
                    String sid = BridgeUtilities.getString(terms, "");
                    Map session = this.sessions.getSession(sid);
                    if (session == null) {
                        return false;
                    }
                    return "meterpreter".equals(session.get("type"));
                }
                if (predicate.equals("-isshell")) {
                    String sid = BridgeUtilities.getString(terms, "");
                    Map session = this.sessions.getSession(sid);
                    if (session == null) {
                        return false;
                    }
                    return "shell".equals(session.get("type"));
                }
                if (predicate.equals("-iswinmeterpreter")) {
                    String sid = BridgeUtilities.getString(terms, "");
                    Map session = this.sessions.getSession(sid);
                    if (session == null) {
                        return false;
                    }
                    return "meterpreter".equals(session.get("type")) && ("x86/win32".equals(session.get("platform")) || "x86/win64".equals(session.get("platform")));
                }
            }
        }
        return false;
    }

    @Override
    public void scriptLoaded(ScriptInstance script) {
        Hashtable env = script.getScriptEnvironment().getEnvironment();
        env.put("&credentials", this);
        env.put("&loots", this);
        env.put("&sessions", this);
        env.put("&hosts", this);
        env.put("&services", this);
        env.put("&db_sync", this);
        env.put("&routes", this);
        env.put("&db_workspace", this);
        env.put("hasservice", this);
        env.put("ispivot", this);
        env.put("isroute", this);
        env.put("-isshell", this);
        env.put("-ismeterpreter", this);
        env.put("-iswinmeterpreter", this);
        env.put("-isready", this);
        env.put("ispivot", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance script) {
    }
}

