/*
 * Decompiled with CFR 0.152.
 */
package armitage;

import armitage.ConsoleCallback;
import armitage.TabCompletion;
import console.Console;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import msf.RpcAsync;
import msf.RpcConnection;

public class ConsoleClient
implements Runnable,
ActionListener {
    protected RpcConnection connection;
    protected Console window;
    protected String readCommand;
    protected String writeCommand;
    protected String destroyCommand;
    protected String session;
    protected LinkedList listeners = new LinkedList();
    protected boolean echo = true;
    protected boolean go_read = true;
    protected boolean swallow = false;
    protected ActionListener sessionListener = null;
    private static final Pattern interact = Pattern.compile("sessions -i (\\d+)\n");
    private long lastRead = 0L;
    protected LinkedList commands = new LinkedList();

    public void setSessionListener(ActionListener l) {
        this.sessionListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.go_read = false;
        }
    }

    public Console getWindow() {
        return this.window;
    }

    public void setEcho(boolean b) {
        this.echo = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindow(Console console) {
        ConsoleClient consoleClient = this;
        synchronized (consoleClient) {
            this.window = console;
            this.setupListener();
        }
    }

    public void addSessionListener(ConsoleCallback l) {
        this.listeners.add(l);
    }

    public void fireSessionReadEvent(String text) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ConsoleCallback)i.next()).sessionRead(this.session, text);
        }
    }

    public void fireSessionWroteEvent(String text) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ConsoleCallback)i.next()).sessionWrote(this.session, text);
        }
    }

    public ConsoleClient(Console window, RpcConnection connection, String readCommand, String writeCommand, String destroyCommand, String session, boolean swallow) {
        this.window = window;
        this.connection = connection;
        this.readCommand = readCommand;
        this.writeCommand = writeCommand;
        this.destroyCommand = destroyCommand;
        this.session = session;
        this.swallow = swallow;
        this.setupListener();
        new Thread(this).start();
    }

    public void setMetasploitConsole() {
        this.window.addActionForKey("ctrl pressed Z", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConsoleClient.this.sendString("background\n");
            }
        });
        new TabCompletion(this.window, this.connection, this.session, "console.tabs");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.destroyCommand != null) {
            ((RpcAsync)this.connection).execute_async(this.destroyCommand, new Object[]{this.session});
        }
        this.kill();
    }

    protected void finalize() {
        this.actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _sendString(String text) {
        Matcher m;
        if (this.writeCommand == null) {
            return;
        }
        if (this.sessionListener != null && (m = interact.matcher(text)).matches()) {
            this.sessionListener.actionPerformed(new ActionEvent(this, 0, m.group(1)));
            return;
        }
        Map read2 = null;
        try {
            ConsoleClient consoleClient = this;
            synchronized (consoleClient) {
                if (this.window != null && this.echo) {
                    this.window.append(this.window.getPromptText() + text);
                }
            }
            if ("armitage.push".equals(this.writeCommand)) {
                read2 = (Map)this.connection.execute(this.writeCommand, new Object[]{this.session, text});
            } else {
                this.connection.execute(this.writeCommand, new Object[]{this.session, text});
                read2 = this.readResponse();
            }
            this.processRead(read2);
            this.fireSessionWroteEvent(text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupListener() {
        ConsoleClient consoleClient = this;
        synchronized (consoleClient) {
            if (this.window != null) {
                this.window.getInput().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String text = ConsoleClient.this.window.getInput().getText() + "\n";
                        ConsoleClient.this.window.getInput().setText("");
                        ConsoleClient.this.sendString(text);
                    }
                });
            }
        }
    }

    public static String cleanText(String text) {
        StringBuffer string = new StringBuffer(text.length());
        char[] chars = text.toCharArray();
        for (int x = 0; x < chars.length; ++x) {
            if (chars[x] == '\u0001' || chars[x] == '\u0002') continue;
            string.append(chars[x]);
        }
        return string.toString();
    }

    private Map readResponse() throws Exception {
        try {
            return (Map)this.connection.execute(this.readCommand, new Object[]{this.session});
        }
        catch (SocketException sex) {
            return null;
        }
        catch (NullPointerException nex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRead(Map read2) throws Exception {
        if (!"".equals(read2.get("data"))) {
            String text = read2.get("data") + "";
            ConsoleClient consoleClient = this;
            synchronized (consoleClient) {
                if (this.window != null) {
                    this.window.append(text);
                }
            }
            this.fireSessionReadEvent(text);
            this.lastRead = System.currentTimeMillis();
        }
        ConsoleClient consoleClient = this;
        synchronized (consoleClient) {
            if (!"".equals(read2.get("prompt")) && this.window != null) {
                this.window.updatePrompt(ConsoleClient.cleanText(read2.get("prompt") + ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendString(String text) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.commands.add(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean shouldRead = this.go_read;
        String command = null;
        long last = 0L;
        try {
            if (this.swallow) {
                this.readResponse();
            }
            while (shouldRead) {
                LinkedList linkedList = this.listeners;
                // MONITORENTER : linkedList
                if (this.commands.size() > 0) {
                    command = (String)this.commands.removeFirst();
                }
                // MONITOREXIT : linkedList
                if (command != null) {
                    this._sendString(command);
                    command = null;
                    this.lastRead = System.currentTimeMillis();
                }
                long now = System.currentTimeMillis();
                if (this.window == null || this.window.isShowing() || now - last >= 1500L) {
                    Map read2 = this.readResponse();
                    if (read2 == null) return;
                    if ("failure".equals(read2.get("result") + "")) {
                        return;
                    }
                    this.processRead(read2);
                    last = System.currentTimeMillis();
                }
                Thread.sleep(100L);
                LinkedList linkedList2 = this.listeners;
                // MONITORENTER : linkedList2
                shouldRead = this.go_read;
                // MONITOREXIT : linkedList2
            }
            return;
        }
        catch (Exception javaSucksBecauseItMakesMeCatchEverythingFuckingThing) {
            javaSucksBecauseItMakesMeCatchEverythingFuckingThing.printStackTrace();
        }
    }
}

