/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.IOUtils;

public abstract class Jar {
    private static final Set<String> mLoaded = new HashSet<String>();
    private static final Map<String, File> mExtracted = new HashMap<String, File>();

    public static File getResourceAsFile(String name, Class clazz) throws BrutException {
        File file = mExtracted.get(name);
        if (file == null) {
            file = Jar.extractToTmp(name, clazz);
            mExtracted.put(name, file);
        }
        return file;
    }

    public static File extractToTmp(String resourcePath, Class clazz) throws BrutException {
        return Jar.extractToTmp(resourcePath, "brut_util_Jar_", clazz);
    }

    public static File extractToTmp(String resourcePath, String tmpPrefix, Class clazz) throws BrutException {
        try {
            InputStream in = clazz.getResourceAsStream(resourcePath);
            if (in == null) {
                throw new FileNotFoundException(resourcePath);
            }
            long suffix = ThreadLocalRandom.current().nextLong();
            suffix = suffix == Long.MIN_VALUE ? 0L : Math.abs(suffix);
            File fileOut = File.createTempFile(tmpPrefix, suffix + ".tmp");
            fileOut.deleteOnExit();
            FileOutputStream out = new FileOutputStream(fileOut);
            IOUtils.copy(in, out);
            in.close();
            ((OutputStream)out).close();
            return fileOut;
        }
        catch (IOException ex) {
            throw new BrutException("Could not extract resource: " + resourcePath, ex);
        }
    }
}

