#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 21 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/GLTextureTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ims/internal/IImsEcbmListener;-exitedECBM-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-access$3900-(Lcom/android/server/pm/PackageManagerService; Ljava/lang/String; I I)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getConnectionStatistics-()Landroid/net/wifi/WifiConnectionStatistics;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/SearchView$SearchAutoComplete;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/VpnService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopPackageLocked-(Ljava/lang/String; I Z Z Z Z Z I Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/connectivity/PacManager;-get-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/net/wifi/WifiManager$WifiLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/VoicemailContract$Status;-buildSourceUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/wm/WindowManagerService;-addWindow-(Lcom/android/server/wm/Session; Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getUidTagPersistBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getGlobalAlertBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-enableSystemApp-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$SoftApStartedState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/view/IWindowManager;-inputMethodClientHasFocus-(Lcom/android/internal/view/IInputMethodClient;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/ims/internal/IImsCallSessionListener$Stub$Proxy;-callSessionHoldFailed-(Lcom/android/ims/internal/IImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/RestrictionsPinActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-moveStackWindowsLocked-(Lcom/android/server/wm/DisplayContent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CropFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/display/AutomaticBrightnessController;-<init>-(Lcom/android/server/display/AutomaticBrightnessController$Callbacks; Landroid/os/Looper; Landroid/hardware/SensorManager; Landroid/util/Spline; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/WifiController$FullHighPerfLockHeldState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/UiccCard;-iccCloseLogicalChannel-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl$2;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindow;-openPanelsAfterRestore-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub;-switchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/SmsMessage;-calculateLength-(Ljava/lang/CharSequence; Z)Lcom/android/internal/telephony/GsmAlphabet$TextEncodingDetails;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/FrameSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/SupplicantStateTracker;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-enableScreenIfNeeded-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmCellBroadcastHandler;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConsumerIrService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.TRANSMIT_IR'],
	'Lcom/android/internal/policy/impl/PolicyControl;-reloadFromSetting-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-setLockTaskModeLocked-(Lcom/android/server/am/TaskRecord; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-addAppWidget-(I I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/SimpleMonthView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Landroid/preference/SeekBarVolumizer;-onStartSample-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/GLTextureSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/hdmi/HdmiCecFeatureAction$ActionTimerHandler;-sendTimerMessage-(I J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setScreenCaptureDisabled-(Landroid/content/ComponentName; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processPlayTone-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/print/IPrintManager;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/Session;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/RampAnimator;-animateTo-(I I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/TextClock;-access$000-(Landroid/widget/TextClock;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/UsimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/MmsServiceBroker$BinderService;-deleteStoredConversation-(Ljava/lang/String; J)Z' : ['android.permission.WRITE_SMS'],
	'Landroid/content/MutableContextWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/print/IPrintManager$Stub;-getPrintJobInfos-(I I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/gsm/SmsMessage;-getSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Landroid/telephony/gsm/SmsMessage$SubmitPdu;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/LocationManagerService$4;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-doVisibilityChanged-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-doNotifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/NfcAdapter;-removeNfcUnlockHandler-(Landroid/nfc/NfcAdapter$NfcUnlockHandler;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ExpandableListActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/RecentApplicationsBackground;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/UiModeManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountAuthenticatorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IActivityManager;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ActionBarContainer;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getApplicationRestrictions-(Landroid/content/ComponentName; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/print/UserState;-enableSystemPrintServicesLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardware;-pauseGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/videosrc/MediaSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/Vibrator;-vibrate-(J Landroid/media/AudioAttributes;)V' : ['android.permission.VIBRATE'],
	'Landroid/widget/TextClock;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/PhoneNumberUtils;-isEmergencyNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-proceedAfterWildChar-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine$SupplicantStartedState;-enter-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-reportGeofenceResumeStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/RotationPolicy;-isRotationLockToggleVisible-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/MifareClassic;-decrement-(I I)V' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/widget/TextClock;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiNotificationController$NotificationEnabledSettingObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/accessibilityservice/IAccessibilityServiceConnection$Stub;-getWindows-()Ljava/util/List;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/ShutdownActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/RttService$RttServiceImpl$RttStateMachine$DefaultState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/print/IPrintManager$Stub;-startPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Chronometer;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/dreams/DreamManagerService;-chooseDreamForUser-(Z I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-importTextMessage-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; J Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/UiccPhoneBookController;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/ISub;-getDefaultSmsSubId-()J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/UsimDataDownloadHandler;-sendSmsAckForEnvelopeResponse-(Lcom/android/internal/telephony/uicc/IccIoResult; I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendTouchExplorationGestureStartAndHoverEnterIfNeeded-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setInternalDataEnabled-(Z Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-enableGsmBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/wifi/SupplicantStateTracker$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/backup/BackupManagerService$PerformBackupTask;-finalizeBackup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ZoomButtonsController$Container;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Landroid/service/dreams/Sandman;-startDreamWhenDockedIfAppropriate-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiManager;-isDeviceToApRttSupported-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/app/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RadioButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-setColor-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/dreams/DreamManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LocationManagerService;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/VibratorService;-onInputDeviceRemoved-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/RadioGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine;-handleNetworkDisconnect-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-updatePhoneObject-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-getInstalledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcCardEmulation$Stub;-registerAidGroupForService-(I Landroid/content/ComponentName; Landroid/nfc/cardemulation/AidGroup;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-getAllowScansWithTraffic-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/INfcAdapter;-setReaderMode-(Landroid/os/IBinder; Landroid/nfc/IAppCallback; I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DatePicker$DatePickerSpinnerDelegate;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-handleOnRotationChanged-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/service/wallpaper/WallpaperService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-getVerboseLoggingLevel-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/INetworkPolicyManager$Stub;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getCellLocation-()Landroid/telephony/CellLocation;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SubscriptionManager;-getSubInfoUsingIccId-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/AudioService;-checkZen-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager;-createPrinterDiscoverySession-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/StatusBarManager;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/nfc/NfcAdapter;-setBeamPushUrisCallback-(Landroid/nfc/NfcAdapter$CreateBeamUrisCallback; Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/NativeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/location/GpsLocationProvider;-updateLowPowerMode-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AsyncPlayer;-stop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/LocalePicker;-constructAdapter-(Landroid/content/Context; I I)Landroid/widget/ArrayAdapter;' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/NfcAdapter;-enableForegroundDispatch-(Landroid/app/Activity; Landroid/app/PendingIntent; [Landroid/content/IntentFilter; [[Ljava/lang/String;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/SMSDispatcher$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/MediaSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/NotificationManagerService$5;-setAutomaticZenModeConditions-([Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeechService$SynthesisToFileOutputStreamSpeechItemV1;-setRequestParams-(Landroid/speech/tts/SynthesisRequest;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DigitalClock;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayPowerController;-handleProximitySensorEvent-(J Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateDataConnectionTracker-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-enforceCanManageCaCerts-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/backup/LocalTransportService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/DowntimeConditionProvider;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/voiceinteraction/SoundTriggerHelper;-stopRecognition-(I Landroid/hardware/soundtrigger/IRecognitionStatusCallback;)I' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/DigitalClock;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-requestShutdown-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/RingtoneManager;-getActualDefaultRingtoneUri-(Landroid/content/Context; I)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccSmsController;-disableCellBroadcastRangeForSubscriber-(J I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/input/InputManagerService;-start-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/tts/ITextToSpeechService$Stub;-speak-(Landroid/os/IBinder; Ljava/lang/CharSequence; I Landroid/os/Bundle; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService;-access$200-(Lcom/android/server/VibratorService;)V' : ['android.permission.VIBRATE'],
	'Landroid/widget/CheckedTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$WindowManagerCallbacks;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/VpnService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDisconnectionErrorCreatingConnection;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-nvReadItem-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/UiccPhoneBookController;-getAdnRecordsInEfForSubscriber-(J I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/app/NetInitiatedActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextClock$1;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothAdapter;-createNewRfcommSocketAndRecord-(Ljava/lang/String; Ljava/util/UUID; Z Z)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEfForSubscriber-(J Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/videosrc/MediaSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/uiautomator/testrunner/UiAutomatorTestRunner;-start-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/handover/BluetoothPeripheralHandover$Callback;-onBluetoothPeripheralHandoverComplete-(Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/uicc/UiccCard;-iccTransmitApduBasicChannel-(I I I I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/View$AttachInfo$Callbacks;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-shutdownRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/content/SyncStorageEngine;-setSyncableStateForEndPoint-(Lcom/android/server/content/SyncStorageEngine$EndPoint; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-createPrinterDiscoverySession-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/lights/LightsService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/CompatModeDialog$1;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/INetworkPolicyManager;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/PersistentDataBlockService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/media/ClosedCaptionWidget;-onAttachedToWindow-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BootReceiver;-removeOldUpdatePackages-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Landroid/media/IAudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/speech/RecognitionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$MyWakeGestureListener;-onWakeUp-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationBlacklist;-getStringArrayLocked-(Ljava/lang/String;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/TechListChooserActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Service;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setInitialAttachApn-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/AccessibilityController$DisplayMagnifier$MagnifiedViewport;-<init>-(Lcom/android/server/wm/AccessibilityController$DisplayMagnifier;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/hdmi/HdmiControlService;-initializeLocalDevices-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/WakeLockStateMachine;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DockObserver;-access$100-(Lcom/android/server/DockObserver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ISub$Stub;-setColor-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPermittedAccessibilityServices-(Landroid/content/ComponentName; Ljava/util/List;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneFactory;-getGsmPhone-(I)Lcom/android/internal/telephony/Phone;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$AppDeathRecipient;-binderDied-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISub$Stub;-getActiveSubInfoList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getLine1NumberForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-keyguardGoingAway-(Z Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-setUniverseTransformLocked-(Lcom/android/server/wm/WindowState; F F F F F F F)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/DigitalClock;-access$300-(Landroid/widget/DigitalClock;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/ChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/FilterGraphEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothDevice;-createInsecureRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/dreams/DreamManagerService;-testDreamInternal-(Landroid/content/ComponentName; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub;-close-(I)I' : ['android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/LockPatternUtils;-getWidgetsEnabled-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/AlertActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accounts/AccountManagerService$6;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/NfcService;-isAirplaneModeOn-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/EditText;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/RotationPolicy;-registerRotationPolicyListener-(Landroid/content/Context; Lcom/android/internal/view/RotationPolicy$RotationPolicyListener; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SubscriptionController;-getActiveSubInfoList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-setPermittedInputMethods-(Landroid/content/ComponentName; Ljava/util/List;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/WebVttRenderingWidget;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NdefFormatable;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/Tag;-rediscover-()Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getActiveSubInfoList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/tv/TvInputInfo$TvInputSettings;-getHiddenTvInputIds-(Landroid/content/Context; I)Ljava/util/Set;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine;-setFrequencyBand-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindow;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getAggressiveHandover-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/AudioService$AudioServiceInternal;-setStreamVolumeForUid-(I I I Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/backup/BackupManagerService;-deviceIsProvisioned-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;-writeSentMessage-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/MmsServiceBroker;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/PreferenceFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/content/ContentService;-getCurrentSyncsAsUser-(I)Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/UiAutomation;-getWindows-()Ljava/util/List;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateFormat;-getTimeFormat-(Landroid/content/Context;)Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Connection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/inputmethodservice/KeyboardView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/AppChooserActivity;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getTimeCacheMaxAge-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/EventStreamTransformation;-clear-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordExpirationTimeout-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofencePauseStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateFormat;-getDateFormatString-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcCardEmulation$Stub$Proxy;-setPreferredService-(Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-getInstallLocation-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentialsAsUser-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler; Landroid/os/UserHandle;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/hardware/location/GeofenceHardware;-addGeofence-(I I Landroid/hardware/location/GeofenceHardwareRequest; Landroid/hardware/location/GeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/TextView;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayManagerService$DisplayAdapterListener;-onDisplayDeviceEvent-(Lcom/android/server/display/DisplayDevice; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService$Stub;-sync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SubscriptionController;-getSubInfoUsingIccId-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-doFinish-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$WakeLock;-binderDied-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/PhoneNumberUtils;-isVoiceMailNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/Phone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/WakeGestureListener$2;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService$9;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISub$Stub;-getSubInfoForSubscriber-(J)Landroid/telephony/SubInfoRecord;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/inputmethodservice/ExtractEditText;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/TintFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-clearBackupData-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Global;-getStringForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getAccountTypesWithManagementDisabledAsUser-(I)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker$4;-onCallProgressing-(Lcom/android/ims/ImsCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Chronometer;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/notification/NotificationListenerService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SizeAdaptiveLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Ljava/net/ServerSocket;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-renameAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setInitialAttachApn-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/le/BluetoothLeAdvertiser;-startAdvertising-(Landroid/bluetooth/le/AdvertiseSettings; Landroid/bluetooth/le/AdvertiseData; Landroid/bluetooth/le/AdvertiseCallback;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/backup/BackupManagerService$PerformUnifiedRestoreTask$EngineThread;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager$2;-startTask-()V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/IAudioService$Stub;-reloadAudioSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/effect/effects/TintEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/SepiaEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-execute-(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;' : ['android.permission.INTERNET'],
	'Lcom/android/server/accounts/AccountManagerService;-checkManageAccountsOrUseCredentialsPermissions-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/ims/internal/ImsCallSession$Listener;-callSessionStartFailed-(Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/SystemGesturesPointerEventListener$Callbacks;-onSwipeFromBottom-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/ims/ImsEcbm$ImsEcbmListenerProxy;-enteredECBM-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/service/voice/VoiceInteractionService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-sendMessage-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/ISms$Stub;-disableCellBroadcastForSubscriber-(J I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/AlertActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onKey-(I [I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-clearPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter;-addNfcUnlockHandler-(Landroid/nfc/INfcUnlockHandler; [I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncPendingAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/speech/tts/TextToSpeech;-getDefaultEngine-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/Filter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-getTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/app/admin/IDevicePolicyManager;-clearCrossProfileIntentFilters-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/DragState;-getTouchedWinAtPointLw-(F F)Lcom/android/server/wm/WindowState;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/hardware/location/GeofenceHardwareService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setAndBroadcastNetworkSetTime-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/dreams/DreamManagerService;-access$2400-(Lcom/android/server/dreams/DreamManagerService;)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/NullFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/tv/TvInputManagerService$1;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/nfc/P2pEventManager;-onP2pReceiveComplete-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/tv/TvInputService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setPropertiesByCarrier-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPermittedInputMethodsForCurrentUser-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CellBroadcastHandler;-handleSmsMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-injectSmsPdu-([B Ljava/lang/String; Landroid/app/PendingIntent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-usingBiometricWeak-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState$ActingState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/content/SyncManager;-scheduleLocalSync-(Landroid/accounts/Account; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/printservice/PrintService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-addTestProvider-(Ljava/lang/String; Lcom/android/internal/location/ProviderProperties;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService;-main-(Landroid/content/Context; Lcom/android/server/pm/Installer; Z Z)Lcom/android/server/pm/PackageManagerService;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Contacts$Settings;-getSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Landroid/view/TextureView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine$ConnectedState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getIsimChallengeResponse-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub;-setDisplayNumber-(Ljava/lang/String; J)I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getAllowScansWithTraffic-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/ContextImpl;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiController$StaEnabledState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/widget/AnalogClock;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdatesLocked-(Landroid/location/LocationRequest; Lcom/android/server/LocationManagerService$Receiver; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/WiredAccessoryManager;-notifyWiredAccessoryChanged-(J I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractButton;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/media/MediaSessionService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationFudger$1;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-make-(Lcom/android/internal/telephony/cat/BerTlv;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncManager;-scheduleSync-(Landroid/content/ComponentName; I I Landroid/os/Bundle; J J)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/media/TtmlRenderingWidget;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getGroupIdLevel1ForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/widget/SearchView$SearchAutoComplete;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DropBoxManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/NotificationManagerService$NotificationListeners;-<init>-(Landroid/content/Context; Landroid/os/Handler; Ljava/lang/Object; Lcom/android/server/notification/ManagedServices$UserProfiles;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TtsEngines;-getDefaultEngine-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setApplicationRestrictions-(Landroid/content/ComponentName; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService;-checkReadAccountsPermission-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wm/WindowManagerService;-computeScreenConfigurationLocked-(Landroid/content/res/Configuration;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/Context;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowStateAnimator;-setSurfaceBoundariesLocked-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Settings$System;-getInt-(Landroid/content/ContentResolver; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/handover/HandoverTransfer;-onScanCompleted-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLockWithUid-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-clearCache-()V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/server/notification/ZenModeHelper$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/location/LocationFudger;-loadCoarseAccuracy-()F' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/wifi/WifiController$StaDisabledWithScanState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-disable-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/notification/ValidateNotificationPeople;-access$600-(Lcom/android/server/notification/ValidateNotificationPeople; Landroid/content/Context; Ljava/lang/String;)Lcom/android/server/notification/ValidateNotificationPeople$LookupResult;' : ['android.permission.READ_CONTACTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setProfileEnabled-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$Secure;-getStringForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/usage/UsageStatsService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub;-setAllowScansWithTraffic-(I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISms;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/connectivity/Tethering;-updateConfiguration-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-getInstallLocation-()I' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CompoundButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcController;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$BinderService;-acquireWakeLockWithUid-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordQuality-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/media/WebVttRenderingWidget$SpanLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/tts/TextToSpeech;-setVoice-(Landroid/speech/tts/Voice;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothInputDevice;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/AlertActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/inputmethod/InputMethodSubtypeSwitchingController$InputMethodAndSubtypeList;-getSortedInputMethodAndSubtypeList-(Z Z Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/service/voice/VoiceInteractionService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService;-access$2600-(Lcom/android/server/power/PowerManagerService; Lcom/android/server/power/PowerManagerService$WakeLock;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-playEarcon-(Ljava/lang/String; I Landroid/os/Bundle; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-injectSmsPdu-([B Ljava/lang/String; Landroid/app/PendingIntent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/cardemulation/RegisteredAidCache;-onPreferredPaymentServiceChanged-(Landroid/content/ComponentName;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/notification/ZenModeHelper;-isDefaultMessagingApp-(Lcom/android/server/notification/NotificationRecord;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-invokeBeam-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/notification/ConditionProviders;-setAutomaticZenModeConditions-([Landroid/net/Uri; Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/printservice/PrintService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/cardemulation/HostApduService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothPbap;-close-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IEthernetManager$Stub;-setConfiguration-(Landroid/net/IpConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/app/AliasActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/print/IPrintManager$Stub;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/tv/TvInputService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/admin/IDevicePolicyManager;-getGlobalProxyAdmin-(I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/input/InputManager$InputDeviceVibrator;-vibrate-([J I Landroid/media/AudioAttributes;)V' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accessibilityservice/IAccessibilityServiceConnection$Stub;-getWindow-(I)Landroid/view/accessibility/AccessibilityWindowInfo;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-access$9800-(Landroid/media/AudioService; I I I Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/TtmlRenderingWidget;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-setCdmaBroadcastActivation-(Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getAllSubInfoCount-()I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine;-<init>-(Lcom/android/server/NsdService; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/util/IState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/BarController;-adjustSystemUiVisibilityLw-(I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/DevicePolicyManagerInternal;-getCrossProfileWidgetProviders-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/backup/FullBackupJob;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/IPrintManager;-cancelPrintJob-(Landroid/print/PrintJobId; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/InboundSmsHandler$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumNumeric-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleShift-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/app/ActivityThread$DropBoxReporter;-addText-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub$Stub;-getDefaultDataSubId-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-nvWriteCdmaPrl-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter$Stub;-enable-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-wipeDataLocked-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewOverlay$OverlayViewGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcCardEmulation;-isDefaultServiceForAid-(I Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/BitmapSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DateTimeView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/tv/TvInputManagerService$1;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/service/voice/VoiceInteractionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/notification/ZenModeHelper$SettingsObserver;-update-(Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/UiModeManagerService;-access$100-(Lcom/android/server/UiModeManagerService; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-onSystemReady-()V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-access$3400-(Lcom/android/internal/telephony/dataconnection/DataConnection; Lcom/android/internal/telephony/dataconnection/DataConnection$ConnectionParams;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine$ObtainingIpState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SubtitleView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SubscriptionController;-setDefaultSubId-(J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnectionForSubscriber-(J I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ILockSettings;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/voiceinteraction/SoundTriggerHelper;-onRecognition-(Landroid/hardware/soundtrigger/SoundTrigger$RecognitionEvent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handleCdmaSubscriptionSource-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-requestShutdown-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/widget/LinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/accounts/ChooseAccountTypeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcCardEmulation$Stub;-setPreferredService-(Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/server/connectivity/Tethering;-checkDunRequired-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/ActivityGroup;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/TouchExplorer;-clear-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-getApplicationRestrictions-(Landroid/content/ComponentName; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/VideoView$7;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RelativeLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/backup/LocalTransportService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler$StartupState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/view/menu/ListMenuItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISub$Stub;-getAllSubInfoCount-()I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/NfcActivityManager;-setNdefPushContentUri-(Landroid/app/Activity; [Landroid/net/Uri;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getUidConfig-()Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings$Config;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/WakeLockStateMachine$DefaultState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/nfc/handover/ConfirmConnectActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/pm/PackageManagerService;-unloadMediaPackages-(Landroid/util/ArrayMap; [I Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiController$FullHighPerfLockHeldState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/wifi/WifiStateMachine$L2ConnectedState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-enableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setUserRestriction-(Landroid/content/ComponentName; Ljava/lang/String; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/filterfw/core/FilterGraph;-tearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/DhcpStateMachine$RunningState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/SRTRenderer;-createTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/BackgroundDexOptService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setProfileOwner-(Landroid/content/ComponentName; Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/MifareClassic;-restore-(I)V' : ['android.permission.NFC'],
	'Lcom/android/server/DockObserver;-init-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-setDefaultForNextTap-(Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/server/hdmi/SystemAudioAutoInitiationAction;-processCommand-(Lcom/android/server/hdmi/HdmiCecMessage;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$AudioServiceInternal;-adjustStreamVolumeForUid-(I I I Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/CallbackFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/SeekBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/cardemulation/OffHostApduService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TextToSpeechService;-access$400-(Landroid/speech/tts/TextToSpeechService;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/CallManager;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SubscriptionController;-setDefaultDataSubId-(J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getEnabledInputMethodList-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/NetworkScoreManager;-disableScoring-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/cardemulation/CardEmulation;-categoryAllowsForegroundPreference-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-setKeyguardDisabledFeatures-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/TechListChooserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NsdService$NsdStateMachine$DisabledState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Landroid/telephony/SmsMessage;-fragmentText-(Ljava/lang/String;)Ljava/util/ArrayList;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-startProfilesLocked-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/CompoundButton;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/ActivityThread$DropBoxReporter;-addData-(Ljava/lang/String; [B I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-access$000-(Lcom/android/internal/telephony/imsphone/ImsPhone;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BatteryService;-logBatteryStatsLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/DialogTitle;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/trust/TrustManagerService;-access$1600-(Lcom/android/server/trust/TrustManagerService; Lcom/android/internal/widget/LockPatternUtils; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncsAsUser-(I)Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/telephony/TelephonyManager;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/print/IPrintManager;-startPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BroadcastQueue$AppNotResponding;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/ServiceWatcher$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopUserLocked-(I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/nfc/INfcTag;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Landroid/view/accessibility/CaptioningManager;-access$100-(Landroid/view/accessibility/CaptioningManager;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onRecordsLoaded-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/widget/SimpleMonthView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/wifi/WifiManager;-requestBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/WapPushOverSms;-dispatchWapPdu-([B Landroid/content/BroadcastReceiver; Lcom/android/internal/telephony/InboundSmsHandler;)I' : ['android.permission.RECEIVE_MMS', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager$CellBroadcastRangeManager;-updateRanges-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/AlarmManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/CantAddAccountActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/SystemServer;-startOtherServices-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/view/IInputMethodManager$Stub$Proxy;-getEnabledInputMethodSubtypeList-(Ljava/lang/String; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyLocationChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DigitalClock;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Landroid/location/Criteria; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/LocationBasedCountryDetector$1;-onLocationChanged-(Landroid/location/Location;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-addNfcUnlockHandler-(Landroid/nfc/INfcUnlockHandler; [I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$ConnectModeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/ObjectSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/ActionBarContextView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$4;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/notification/DowntimeConditionProvider;-createCondition-(Landroid/service/notification/ZenModeConfig$DowntimeInfo; I)Landroid/service/notification/Condition;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Presentation$1;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiSettingsStore;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcAdapter$Stub;-removeNfcUnlockHandler-(Landroid/nfc/INfcUnlockHandler;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$BinderService;-setStayOnSetting-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/InputStreamSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/NetInitiatedActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LockSettingsService$DatabaseHelper;-onUpgrade-(Landroid/database/sqlite/SQLiteDatabase; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/BackgroundDexOptService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/UsimFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-cancelNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/FillLightEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditText;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastForSubscriber-(J I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncActivityTooManyDeletes;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/CropFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActiveServices;-bringDownServiceLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService;-startBluetoothScoInt-(Landroid/os/IBinder; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getChannelList-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-handleRuimRefresh-(Lcom/android/internal/telephony/uicc/IccRefreshResponse;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler;-handleServiceCategoryProgramData-(Lcom/android/internal/telephony/cdma/SmsMessage;)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/widget/RemoteViews$2;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipAudioCall;-releaseWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/GraphRunner;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ActivityManagerNative;-setPackageScreenCompatMode-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/nsd/INsdManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.INTERNET'],
	'Landroid/widget/SeekBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine;-handleSupplicantConnectionLoss-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/RotateFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/AsyncService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkTimeUpdateService;-isAutomaticTimeRequested-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/WifiDisplayController$1;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcApplication;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/ISipService$Stub;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/widget/TextViewWithCircularIndicator;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/media/MediaBrowserService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPukForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setRecommendedGlobalProxy-(Landroid/content/ComponentName; Landroid/net/ProxyInfo;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-addGpsNavigationMessageListener-(Landroid/location/GpsNavigationMessageEvent$Listener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/StackView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession$Stub$Proxy;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/widget/CompoundButton;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-startServiceLocked-(Landroid/app/IApplicationThread; Landroid/content/Intent; Ljava/lang/String; I I I)Landroid/content/ComponentName;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-performTransitions-(Lcom/android/internal/util/State; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/commands/settings/SettingsCmd;-deleteForUser-(Landroid/content/IContentProvider; I Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getIccSerialNumberForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/IAudioService$Stub;-adjustStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$System;-getConfiguration-(Landroid/content/ContentResolver; Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/AccessibilityController$WindowsForAccessibilityObserver;-scheduleComputeChangedWindowsLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordMinimumNumeric-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcTag;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Landroid/widget/AbsSpinner;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-enforceReceiveAndSend-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub$1;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/backup/IBackupManager;-opComplete-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-getSubscriptionInfoAndStartPollingThreads-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/appwidget/AppWidgetServiceImpl;-bindAppWidgetId-(Ljava/lang/String; I I Landroid/content/ComponentName; Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/monkey/Monkey;-main-([Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/job/JobSchedulerService$JobSchedulerStub;-schedule-(Landroid/app/job/JobInfo;)I' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/effect/effects/SharpenEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodAndSubtypeHashCodeListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-pollCallsWhenSafe-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getCrossProfileWidgetProviders-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-disableCdmaBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/widget/CompoundButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/RedEyeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/widget/SwipeDismissLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-getAnyDataEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getGlobalProxyAdmin-(I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService$TagService;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/server/wm/WindowManagerService;-moveInputMethodWindowsIfNeededLocked-(Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getOutgoingCallerIdDisplay-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/WebVttRenderingWidget;-manageChangeListener-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/view/View;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService;-startVibrationLocked-(Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri; I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/dreams/DreamManagerService;-startDozingInternal-(Landroid/os/IBinder; I I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/DateTimeView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/pm/LauncherAppsService$LauncherAppsImpl$MyPackageMonitor;-onSomePackagesChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/SystemServer;-main-([Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$UserState$1;-binderDied-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/AlarmManagerService;-onStart-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordMinimumLowerCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcA;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiStateMachine;-sendConnectedState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-calculateLength-(Ljava/lang/CharSequence; Z)Lcom/android/internal/telephony/GsmAlphabet$TextEncodingDetails;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityStack;-resetAffinityTaskIfNeededLocked-(Lcom/android/server/am/TaskRecord; Lcom/android/server/am/TaskRecord; Z Z I)I' : ['android.permission.SEND_SMS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/telecom/InCallService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowManager;-setAppVisibility-(Landroid/os/IBinder; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/AbsActionBarView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService$HandlerParams;-handleStartCopy-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/FullBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/FilterPort;-setFrame-(Landroid/filterfw/core/Frame;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ContextThemeWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-setSyncAutomaticallyAsUser-(Landroid/accounts/Account; Ljava/lang/String; Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-onRecordLoaded-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-getDataConnectionState-()Lcom/android/internal/telephony/PhoneConstants$DataState;' : ['android.permission.READ_PROFILE'],
	'Landroid/print/PrintJob;-restart-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/TapAgainDialog;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-getOrientationFromAppTokensLocked-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/cardemulation/TapAgainDialog;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getSubInfoUsingIccId-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/DockObserver;-onBootPhase-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiStateMachine$VerifyingLinkState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TimePicker;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/notification/ZenModeHelper$Callback;-onZenModeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendSmsByPstn-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getCurrentCalls-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Bookmarks;-add-(Landroid/content/ContentResolver; Landroid/content/Intent; Ljava/lang/String; Ljava/lang/String; C I)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FinalPort;-pushFrame-(Landroid/filterfw/core/Frame;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceAdded-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/ViewSwitcher;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager$CellBroadcastRangeManager;-tryAddRanges-(I I Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService$8;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-setMicrophoneMute-(Z Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/MountServiceIdler;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-updateCredentials-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/IccProvider;-updateIccRecordInEf-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/notification/ConditionProviders$ZenModeHelperCallback;-onZenModeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$AccessibilityContentObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/GLTextureTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterfw/core/InputPort;-setFrame-(Landroid/filterfw/core/Frame;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-handleSetRequest-(Lcom/android/internal/location/ProviderRequest; Landroid/os/WorkSource;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerInternal;-setWindowsForAccessibilityCallback-(Landroid/view/WindowManagerInternal$WindowsForAccessibilityCallback;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/performance/ThroughputFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/DhcpStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/IInputMethodManager;-getEnabledInputMethodList-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-endFile-(Landroid/media/MediaScanner$FileEntry; Z Z Z Z Z)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-resetSelectedInputMethodAndSubtypeLocked-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-setDataAllowed-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/widget/NumberPicker$CustomEditText;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/ContextThemeWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-acceptCall-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/NotificationManagerService;-loadPolicyFile-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/MultiAutoCompleteTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/Filter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiServiceImpl;-enableAggressiveHandover-(I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/Chronometer;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GeofenceManager;-scheduleUpdateFencesLocked-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/NfcActivityManager;-requestNfcServiceCallback-()V' : ['android.permission.NFC'],
	'Landroid/app/ActivityView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-isSpellCheckerEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getPollInterval-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-setCdmaBroadcastConfig-([Lcom/android/internal/telephony/cdma/CdmaSmsBroadcastConfigInfo;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-requestBatchedScan-(Landroid/net/wifi/BatchedScanSettings; Landroid/os/IBinder; Landroid/os/WorkSource;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-restartRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/content/SyncActivityTooManyDeletes;-startSyncReallyDelete-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioManager;-startBluetoothScoVirtualCall-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/backup/SystemBackupAgent;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/notification/DowntimeConditionProvider;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/PacManager;-longSchedule-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-addSubtypeToHistory-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getAccountTypesWithManagementDisabledAsUser-(I)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptFallback-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiConfigStore;-handleSSIDStateChange-(I Z Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getIsSyncableAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/tv/TvInputInfo$TvInputSettings;-getCustomLabels-(Landroid/content/Context; I)Ljava/util/Map;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Browser;-deleteFromHistory-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS'],
	'Landroid/content/IContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/Application;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/commands/uiautomator/Launcher$Command;-run-([Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/tts/TextToSpeech$2;-run-(Landroid/speech/tts/ITextToSpeechService;)Ljava/lang/Integer;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Landroid/provider/Settings$Global;-getString-(Landroid/content/ContentResolver; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcAdapter$Stub;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-<init>-(Ljava/lang/String; Landroid/content/Context; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/CellBroadcastHandler;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/hdmi/HdmiControlService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/notification/NotificationManagerService$NotificationListeners;-<init>-(Lcom/android/server/notification/NotificationManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-inputDispatchingTimedOut-(I Z Ljava/lang/String;)J' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/ims/ImsCall;-notifyConferenceSessionTerminated-(Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/SpeechRecognizer;-access$000-(Landroid/speech/SpeechRecognizer; Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/provider/ContactsContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-isApplicationHidden-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/app/ExpandableListActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/IContentService;-setMasterSyncAutomaticallyAsUser-(Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-packageHasActiveAdmins-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TtsEngines;-updateLocalePrefForEngine-(Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/ObjectSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/PreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/P2pEventListener;-onP2pNfcTapRequested-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/ActionBarView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LockSettingsService;-setLockPassword-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextClock;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ActivityManagerNative;-showBootMessage-(Ljava/lang/CharSequence; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/power/PowerManagerService;-handleBatteryStateChangedLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$7600-(Lcom/android/server/wifi/WifiStateMachine;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-switchUser-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/ViewAnimator;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/base/ObjectSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-startNavigating-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-<init>-(Landroid/content/Context; Lcom/android/nfc/cardemulation/RegisteredServicesCache; Lcom/android/nfc/cardemulation/RegisteredAidCache; Lcom/android/nfc/cardemulation/PreferredServices$Callback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiSettingsStore;-getPersistedWifiState-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-getDataEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-notifyLockTaskModeChanged-(Z Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameFetch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-rebuildAppWindowListLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/GhostView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/backup/IBackupManager$Stub;-opComplete-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SubscriptionManager;-setDisplayName-(Ljava/lang/String; J J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService$Lifecycle;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-clearUserRestrictions-(Landroid/os/UserHandle;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/connectivity/NetworkMonitor$DefaultState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-disable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/ITextToSpeechService$Stub;-synthesizeToFileDescriptor-(Landroid/os/IBinder; Ljava/lang/CharSequence; Landroid/os/ParcelFileDescriptor; Landroid/os/Bundle; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ImageSwitcher;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/media/effect/EffectContext;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccProvider;-loadAllSimContacts-(I)Landroid/database/Cursor;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getXtPersistBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ISyncAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getDataEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-bringDownServiceIfNeededLocked-(Lcom/android/server/am/ServiceRecord; Z Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/preference/PreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/DuotoneEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/sip/ISipService;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Landroid/widget/CheckedTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.GET_PACKAGE_SIZE'],
	'Landroid/nfc/tech/MifareUltralight;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/server/BluetoothManagerService;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ContextImpl;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TextToSpeech;-runAction-(Landroid/speech/tts/TextToSpeech$Action; Ljava/lang/Object; Ljava/lang/String; Z Z)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IApplicationToken;-windowsVisible-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/PersistentDataBlockService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-updatePhoneObject-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-applyNewState-(Lcom/android/internal/telephony/dataconnection/ApnContext; Z Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-getAllMessagesFromIccEfForSubscriber-(J Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ISub;-setDisplayNumberFormat-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-initializeP2pSettings-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/hardware/IConsumerIrService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.TRANSMIT_IR'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/trust/TrustManagerService;-resetAgent-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcRootActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getPrivilegedConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/backup/BackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcTag$Stub;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Landroid/widget/TextClock;-chooseFormat-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SmsApplication;-getApplication-(Landroid/content/Context; Z I)Lcom/android/internal/telephony/SmsApplication$SmsApplicationData;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/NumberPicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-displayReady-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService;-scheduleTraversalLocked-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/GhostView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub;-setStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setCdmaBroadcastConfig-([Lcom/android/internal/telephony/cdma/CdmaSmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-invokeBeam-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/test/mock/MockContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getDevPersistBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-fetchDunApn-()Lcom/android/internal/telephony/dataconnection/ApnSetting;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/SupplicantStateTracker$UninitializedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Landroid/nfc/INfcTag$Stub;-reconnect-(I)I' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaRecorder;-setAudioSource-(I)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/filterfw/core/FilterSurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/ILocationManager;-addGpsNavigationMessageListener-(Landroid/location/IGpsNavigationMessageListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/LockToAppRequestDialog;-getLockString-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-scheduleSleepTimeout-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-setRequest-(Lcom/android/internal/location/ProviderRequest; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager$CdmaBroadcastRangeManager;-updateRanges-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentials-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/accounts/AccountManagerService;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getImei-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/provider/CallLog$Calls;-addCall-(Lcom/android/internal/telephony/CallerInfo; Landroid/content/Context; Ljava/lang/String; I I I Landroid/telecom/PhoneAccountHandle; J I Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/INfcAdapter;-setAppCallback-(Landroid/nfc/IAppCallback;)V' : ['android.permission.NFC'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/NfcAdapter;-setNdefPushMessageCallback-(Landroid/nfc/NfcAdapter$CreateNdefMessageCallback; Landroid/app/Activity; I)V' : ['android.permission.NFC'],
	'Landroid/content/IContentService$Stub;-getSyncStatusAsUser-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName; I)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/media/effect/effects/SepiaEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/UiccPhoneBookController;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-access$1800-(Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService$8;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/TintFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.REORDER_TASKS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.GET_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/DuotoneEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IPowerManager;-updateWakeLockUids-(Landroid/os/IBinder; [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/BarController;-checkHiddenLw-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/IntentService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/NetworkScorerAppManager;-setActiveScorer-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeech;-synthesizeToFile-(Ljava/lang/CharSequence; Landroid/os/Bundle; Ljava/io/File; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcA;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$MagnificationController;-setMagnifiedRegionCenter-(F F Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService;-setStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-removeAccountAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/InputMethodManagerService;-resetStateIfCurrentLocaleChangedLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine;-fetchRssiLinkSpeedAndFrequencyNative-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/ActivityManagerNative;-getTaskThumbnail-(I)Landroid/app/ActivityManager$TaskThumbnail;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/speech/RecognitionService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService;-access$1400-(Lcom/android/server/display/DisplayManagerService; Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onDataSetupCompleteError-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager;-doDatabaseCleanup-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-setPostDialState-(Lcom/android/internal/telephony/Connection$PostDialState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISms$Stub;-updateMessageOnIccEfForSubscriber-(J Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/GrainFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$P2pEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-onStart-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CLEAR_APP_CACHE', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/MifareClassic;-authenticateSectorWithKeyA-(I [B)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/CertBlacklister$BlacklistObserver;-getValue-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Application;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getDefaultVoiceSubId-()J' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$2;-doWork-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/view/accessibility/IAccessibilityManager$Stub;-registerUiTestAutomationService-(Landroid/os/IBinder; Landroid/accessibilityservice/IAccessibilityServiceClient; Landroid/accessibilityservice/AccessibilityServiceInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/DefaultRemovedActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/SubscriptionManager;-getDefaultDataPhoneId-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-sendStoredText-(Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyServiceStateForPhoneId-(I J Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService;-isAllowedByCurrentUserSettingsLocked-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-dialInternal-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/LockPatternUtils;-setOwnerInfoEnabled-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/trust/TrustAgentService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowStateAnimator;-finishExit-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/power/PowerManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcB;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/SmsMessage;-getSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Lcom/android/internal/telephony/gsm/SmsMessage$SubmitPdu;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/commands/am/Am;-runStartUserInBackground-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/BlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Application;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/RttService$RttServiceImpl$RttStateMachine$EnabledState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-statusBarVisibilityChanged-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setActivePasswordState-(I I I I I I I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-access$600-(Lcom/android/server/LocationManagerService; I I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/BaseCommands;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-setAllowScansWithTraffic-(I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/telephony/gsm/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-writeInboxMessage-(Landroid/content/Intent;)Landroid/net/Uri;' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SMS'],
	'Lcom/android/internal/telephony/TelephonyDevController;-registerRIL-(Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/LauncherAppsService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-updateSmsSendStatusHelper-(I Ljava/util/List; Lcom/android/internal/telephony/SMSDispatcher; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/RecognitionService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/MediaSource;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-createAndInitializeUser-(Landroid/content/ComponentName; Ljava/lang/String; Ljava/lang/String; Landroid/content/ComponentName; Landroid/os/Bundle;)Landroid/os/UserHandle;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-handleCallDeflectionIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-lockNow-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/SyncRunner;-performStep-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/restrictions/RestrictionsManagerService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewFactory;-onWebViewUpdateInstalled-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/WindowManagerPolicy;-adjustSystemUiVisibilityLw-(I)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/effect/effects/CropEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/speech/RecognitionService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/WallpaperManager;-setStream-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/test/ModelInterpreter;-<init>-(Ljava/net/InetSocketAddress;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-loadFromEF-(I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService$InstallParams;-startCopy-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/UserState;-readConfigurationLocked-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-hasUserSetupCompleted-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/ITextToSpeechService$Stub$Proxy;-getClientDefaultLanguage-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub$Proxy;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/filterpacks/base/CallbackFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler$DefaultState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/content/IIntentReceiver;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-isApnTypeAvailable-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-startBluetoothScoVirtualCall-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/widget/Editor;-performLongClick-(Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/SystemService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/CameraSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/nfc/cardemulation/RegisteredAidCache;-updateRoutingLocked-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/location/LocationBlacklist;-reloadBlacklistLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-installSystemProviders-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$9;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/WindowManagerPolicy;-applyPostLayoutPolicyLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManager$LayoutParams;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/backup/BackupManagerService;-handleTimeout-(I Ljava/lang/Object;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/SyncActivityTooManyDeletes;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/dreams/DreamController$3;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-runActionNoReconnect-(Landroid/speech/tts/TextToSpeech$Action; Ljava/lang/Object; Ljava/lang/String; Z)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/DialogTitle;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFinished-(I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-access$900-(Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker; Lcom/android/ims/ImsCall; Lcom/android/internal/telephony/Call$State; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService$DragInputEventReceiver;-onInputEvent-(Landroid/view/InputEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/net/INetworkStatsService$Stub;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ActivityManagerNative;-killApplicationWithAppId-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/ime/Ime;-run-([Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/NfcAdapter;-invokeBeam-(Landroid/app/Activity;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/UiModeManagerService;-updateLocked-(I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$L2ConnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncStorageEngine$OnSyncRequestListener;-onSyncRequest-(Lcom/android/server/content/SyncStorageEngine$EndPoint; I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendNewSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/SmsHeader; I Landroid/app/PendingIntent; Landroid/app/PendingIntent; Z Ljava/util/concurrent/atomic/AtomicInteger; Ljava/util/concurrent/atomic/AtomicBoolean; Landroid/net/Uri;)V' : ['android.permission.RECEIVE_SMS'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ActivityManager;-getRecentTasksForUser-(I I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/accessibility/AccessibilityInputFilter;-access$100-(Lcom/android/server/accessibility/AccessibilityInputFilter; J)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/MediaPlayer;-addTimedTextSource-(Ljava/io/FileDescriptor; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LockSettingsService;-checkPassword-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/widget/LockPatternUtils;-isBiometricWeakLivelinessEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/SupplicantStateTracker$HandshakeState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/ClosedCaptionWidget;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothAdapter;-closeProfileProxy-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-getIccSimChallengeResponse-(I Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/performance/ThroughputFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStackSupervisor$VirtualActivityContainer;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readPbrFileAndWait-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/display/DisplayManagerService;-createVirtualDisplayInternal-(Landroid/hardware/display/IVirtualDisplayCallback; Landroid/media/projection/IMediaProjection; I Ljava/lang/String; Ljava/lang/String; I I I Landroid/view/Surface; I)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/KeyguardManager;-exitKeyguardSecurely-(Landroid/app/KeyguardManager$OnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setActiveAdmin-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/RIL;-changeIccPin-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getCurrentFailedPasswordAttempts-(I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppDiedLocked-(Lcom/android/server/am/ProcessRecord; Z Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/RemoteViewsAdapter$RemoteViewsFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-setNetworkTemplateEnabled-(Landroid/net/NetworkTemplate; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ActivityGroup;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/notification/CountdownConditionProvider;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/WaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getSubInfoUsingSlotId-(I)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ReceiverRestrictedContext;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getKeyguardDisabledFeatures-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-markMessagesAsRead-(Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ims/ImsCall$Listener;-onCallStarted-(Lcom/android/ims/ImsCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/media/MediaSessionService$SessionManagerImpl$KeyEventWakeLockReceiver;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl$1;-onChange-(Z Landroid/net/Uri; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/WindowManagerPolicy;-focusChangedLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManagerPolicy$WindowState;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-getMute-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/CalendarView$LegacyCalendarViewDelegate$WeekView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountAuthenticatorActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/WallpaperManager;-setResource-(I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowStateAnimator;-destroySurfaceLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-showGlobalActionsInternal-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/telephony/SubscriptionManager;-allDefaultsSelected-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-registerPointerSpeedSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/notification/ConditionProviderService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordExpirationTimeout-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextViewWithCircularIndicator;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityStack;-updateTransitLocked-(I Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-removeUser-(Landroid/content/ComponentName; Landroid/os/UserHandle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-addAccount-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterfw/core/FinalPort;-setFrame-(Landroid/filterfw/core/Frame;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-isActivePasswordSufficient-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordExpirationLocked-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-connect-(I I)I' : ['android.permission.NFC'],
	'Landroid/nfc/tech/BasicTagTechnology;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/server/wifi/WifiStateMachine;-stopBatchedScan-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiServiceImpl;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/service/notification/NotificationListenerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/INetworkPolicyManager$Stub;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-getAllMessagesFromIcc-()Ljava/util/ArrayList;' : ['android.permission.RECEIVE_SMS'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/Session;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/commands/monkey/MonkeySourceNetwork;-startServer-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/SimpleMonthView;-getMonthAndYearString-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$SoftApStartedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wifi/RttService$RttServiceImpl$RttStateMachine$RequestPendingState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/BlendFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/display/WifiDisplayController;-<init>-(Landroid/content/Context; Landroid/os/Handler; Lcom/android/server/display/WifiDisplayController$Listener;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setP2pModes-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-sendFullNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/Ringtone;-setUri-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub$Proxy;-sync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-nvWriteCdmaPrl-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-pollBatchedScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-performLayoutLockedInner-(Lcom/android/server/wm/DisplayContent; Z Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/Filter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ToggleButton;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/printservice/PrintService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-clearPackagePersistentPreferredActivities-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-getAdnRecordsSizeForSubscriber-(J I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Ljava/net/Socket;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/server/am/ActivityStack;-checkReadyForSleepLocked-()Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/ShutdownActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/notification/ConditionProviderService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/AccessibleDateAnimator;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/DowntimeConditionProvider;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/handover/HandoverManager;-createBluetoothOobDataRecord-()Landroid/nfc/NdefRecord;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/RetargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/nsd/INsdManager$Stub;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-access$300-(Lcom/android/internal/widget/multiwaveview/GlowPadView; I F F)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/NsdService$NsdStateMachine;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/CalendarContract$Instances;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; J J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/ListActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/TextureView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub$Proxy;-getInitialDisplaySize-(I Landroid/graphics/Point;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getDisabledSystemInputMethods-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$SettingsObserver;-<init>-(Landroid/media/AudioService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/widget/Switch;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-beginLayoutLw-(Z I I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/CalendarView$LegacyCalendarViewDelegate;-goTo-(Ljava/util/Calendar; Z Z Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-isDataConnectivityPossible-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IntRangeManager;-enableRange-(I I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothPan;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/LockPatternUtilsCache;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/backup/PackageManagerBackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/Button;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getSubscriberIdForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getMute-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-flashAndSetGenericTrue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/backup/PackageManagerBackupAgent;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/appwidget/AppWidgetService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccSmsController;-getPreferredSmsSubscription-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-setupDataOnConnectableApns-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-removeActiveAdmin-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-checkForCompatibleConnectedApnContext-(Lcom/android/internal/telephony/dataconnection/ApnContext;)Lcom/android/internal/telephony/dataconnection/DcAsyncChannel;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-addPersistentPreferredActivity-(Landroid/content/ComponentName; Landroid/content/IntentFilter; Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService$LocalService;-setMagnificationCallbacks-(Landroid/view/WindowManagerInternal$MagnificationCallbacks;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-privatizeCellInfoList-(Ljava/util/List;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService$Vibration;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/widget/RemoteViewsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-getInitialMaxRetry-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager$8;-onServiceChanged-(Landroid/content/SyncAdapterType; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/ScreenMagnifier$MagnificationController;-offsetMagnifiedRegionCenter-(F F)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine$ConnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/usb/UsbDeviceManager$AdbSettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/nfc/cardemulation/TapAgainDialog;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/input/InputManager$InputDeviceVibrator;-vibrate-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/appwidget/AppWidgetService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/dreams/DreamManagerService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/CountdownConditionProvider;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-onConnectedInOrOut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-restartRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/SystemGesturesPointerEventListener;-onPointerEvent-(Landroid/view/MotionEvent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/P2pLinkManager$3;-doGet-(I Landroid/nfc/NdefMessage;)Lcom/android/nfc/snep/SnepMessage;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityStackSupervisor$ActivityStackSupervisorHandler;-activityIdleInternal-(Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/SyncActivityTooManyDeletes;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/ClosedCaptionWidget$CCLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-clearLock-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/ManagedServices$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-setDataAllowed-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-access$3700-(Lcom/android/server/power/PowerManagerService; J I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/backup/IBackupManager;-clearBackupData-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/EditText;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-checkPasswordHistory-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ApplicationErrorReport;-getErrorReportReceiver-(Landroid/content/Context; Ljava/lang/String; I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-systemRunning-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/Button;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BroadcastQueue;-broadcastTimeoutLocked-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaPlayer;-selectOrDeselectTrack-(I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/power/PowerManagerService;-napInternal-(J I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/media/MediaHTTPConnection;-getSize-()J' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/PhoneWindow;-onMenuModeChange-(Lcom/android/internal/view/menu/MenuBuilder;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-hasGrantedPolicy-(Landroid/content/ComponentName; I I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/ForegroundUtils;-handleUidToBackground-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getActiveAdmins-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Settings$System;-getIntForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms;-sendMessage-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getVoiceMailAlphaTagForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/speech/tts/TextToSpeech;-speak-(Ljava/lang/CharSequence; I Landroid/os/Bundle; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/widget/YearPickerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager;-access$1300-(Lcom/android/server/content/SyncManager; Lcom/android/server/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager;-addCrossProfileWidgetProvider-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringLogger;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getIccSimChallengeResponse-(J I Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ims/ImsEcbmStateListener;-onECBMExited-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setAccountManagementDisabled-(Landroid/content/ComponentName; Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService;-setRingerMode-(I Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-getVerboseLoggingLevel-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/util/AsyncService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameStore;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendStoredMultipartText-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/uicc/IsimUiccRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/BeamShareActivity$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/WifiManager;-isWifiScannerSupported-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-register-(Landroid/net/sip/SipProfile; I Landroid/net/sip/SipRegistrationListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsMessage;-getSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Landroid/telephony/SmsMessage$SubmitPdu;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/effect/effects/NegativeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$7;-onSwipeFromRight-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/StateMachine$SmHandler$HaltingState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-addGpsMeasurementsListener-(Landroid/location/IGpsMeasurementsListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowSession;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/WifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/view/SurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$10000-(Lcom/android/server/wifi/WifiStateMachine; Landroid/net/NetworkInfo$DetailedState;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/BrowserContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS'],
	'Lcom/android/server/am/ActivityManagerService;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/app/ChooserActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceRemoved-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/NfcService;-onLlcpFirstPacketReceived-(Lcom/android/nfc/DeviceHost$NfcDepEndpoint;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/backup/BackupManagerService$PerformBackupTask;-beginBackup-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/WifiManager$MulticastLock;-release-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/server/power/PowerManagerService$2;-onStateChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/ContextThemeWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/widget/YearPickerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/usb/UsbService$Lifecycle;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordHistoryLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-nvReadItem-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/TouchExplorer$SendHoverExitDelayed;-forceSendAndRemove-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/commands/media/Media;-run-([Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-handleSrvccStateChanged-([I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/GLTextureSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telecom/InCallService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/IntentForwarderActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipService;-restartPortMappingLifetimeMeasurement-(Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-finishInstrumentationLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiController;-readWifiSleepPolicy-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService$TagService;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/dataconnection/DcController;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setDataProfile-([Lcom/android/internal/telephony/dataconnection/DataProfile; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-setHoldScreenLocked-(Lcom/android/server/wm/Session;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/accessibility/IAccessibilityManager$Stub$Proxy;-registerUiTestAutomationService-(Landroid/os/IBinder; Landroid/accessibilityservice/IAccessibilityServiceClient; Landroid/accessibilityservice/AccessibilityServiceInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcApplication;-onCreate-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/inputmethodservice/KeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/sip/ISipService;-open3-(Landroid/net/sip/SipProfile; Landroid/app/PendingIntent; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/server/wifi/WifiController$2;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-nvWriteItem-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SmsStorageMonitor;-handleIccFull-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-updateSmsSendStatus-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-dialInternal-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-onUserSwitched-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/MediaSource;-pauseVideo-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/LauncherActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-setLocaleFromCsim-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/IWindowSession$Stub;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getSubscriberIdForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/service/voice/VoiceInteractionSessionService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IUiAutomationConnection$Stub;-disconnect-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/TextClock;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodSubtypeMenu-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-handleSrvccStateChanged-([I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ProgressBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/ChooseAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-setExternalState-(Lcom/android/internal/telephony/IccCardConstants$State; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL$RILReceiver;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ToggleButton;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DockObserver$2;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/BroadcastQueue;-skipPendingBroadcastLocked-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService$10;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DateTimeView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-checkVoldPassword-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/service/notification/NotificationListenerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyCellInfo-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/NetworkScoreManager;-requestScores-([Landroid/net/NetworkKey;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEstablished-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/commands/dpm/Dpm;-runSetDeviceOwner-()V' : ['android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$Service;-getWindow-(I)Landroid/view/accessibility/AccessibilityWindowInfo;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getSampleEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-initializeMulticastFiltering-()Z' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordExpirationTimeout-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/FrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getApplicationRestrictions-(Landroid/content/ComponentName; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-resetRadio-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditText;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomaticallyAsUser-(Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/nfc/NfcBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/handover/HandoverService;-enableBluetooth-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager;-renameAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/location/LocationManager;-addGpsMeasurementListener-(Landroid/location/GpsMeasurementsEvent$Listener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-processMessagePart-(Lcom/android/internal/telephony/InboundSmsTracker;)Z' : ['android.permission.RECEIVE_MMS', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/widget/AdapterViewFlipper;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-setPackageScreenCompatMode-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setLockTaskPackages-(Landroid/content/ComponentName; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-dialInternal-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/renderscript/RSTextureView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Telephony$Mms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Landroid/media/IAudioService$Stub$Proxy;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getUserData-(I)Lcom/android/server/devicepolicy/DevicePolicyManagerService$DevicePolicyData;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastStickyIntent-(Landroid/content/Intent; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/GLTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/BasicTagTechnology;-connect-()V' : ['android.permission.NFC'],
	'Landroid/filterpacks/base/FrameFetch;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getKeyguardStoredPasswordQuality-(I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/inputmethodservice/KeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub;-updateStoredMessageStatus-(Ljava/lang/String; Landroid/net/Uri; Landroid/content/ContentValues;)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/OverlayDisplayAdapter;-updateOverlayDisplayDevices-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPermittedAccessibilityServicesForUser-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-performServiceRestartLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityStackSupervisor$VirtualActivityContainer;-release-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getIccSerialNumberForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/InputMethodManagerService;-startInputInnerLocked-()Lcom/android/internal/view/InputBindResult;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/MifareClassic;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/google/android/mms/pdu/PduPersister;-updateHeaders-(Landroid/net/Uri; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordHistoryLength-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyDataConnectionForSubscriber-(J I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothA2dpService;-handleSinkStateChange-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-nvWriteItem-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerInternal;-startIsolatedProcess-(Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I Ljava/lang/Runnable;)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$100-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/P2pEventListener;-onP2pSendComplete-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/display/DisplayManagerService$LocalService$1;-requestDisplayState-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterfw/core/Filter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/AccessibilityInputFilter;-processBatchedEvents-(J)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccountAsUser-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler; Landroid/os/UserHandle;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/TintFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/commands/pm/Pm;-run-([Ljava/lang/String;)V' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getVoiceMailNumberForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/telephony/SmsManager;-importMultimediaMessage-(Landroid/net/Uri; Ljava/lang/String; J Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-getPrintJobInfo-(Landroid/print/PrintJobId; I I)Landroid/print/PrintJobInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiScanningServiceImpl$WifiScanningStateMachine;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/CoreSettingsObserver;-beginObserveCoreSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/WebVttRenderingWidget;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ResolverActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setScreenCaptureDisabled-(Landroid/content/ComponentName; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/lights/LightsService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pManager;-initialize-(Landroid/content/Context; Landroid/os/Looper; Landroid/net/wifi/p2p/WifiP2pManager$ChannelListener;)Landroid/net/wifi/p2p/WifiP2pManager$Channel;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$5500-(Lcom/android/server/accessibility/AccessibilityManagerService; Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-nvWriteItem-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setUiccSubscription-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterFunction;-executeWithArgList-([Ljava/lang/Object;)Landroid/filterfw/core/Frame;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$P2pEnabledState;-enter-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/IAccessibilityManager;-unregisterUiTestAutomationService-(Landroid/accessibilityservice/IAccessibilityServiceClient;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/os/IPowerManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService;-dumpAnimatorLocked-(Ljava/io/PrintWriter; [Ljava/lang/String; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/CoreSettingsObserver;-sendCoreSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub;-importTextMessage-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; J Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/nfc/handover/HandoverManager;-createBluetoothHandoverSelectMessage-(Z)Landroid/nfc/NdefMessage;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendTextForSubscriber-(J Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPermittedAccessibilityServices-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifySignalStrengthForSubscriber-(J Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/IPrintManager;-getPrintJobInfo-(Landroid/print/PrintJobId; I I)Landroid/print/PrintJobInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-nvResetConfig-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/SaturateEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsUsageMonitor; Lcom/android/internal/telephony/ImsSMSDispatcher; Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetUpIdleModeText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/widget/LockPatternUtils;-getAppWidgets-()[I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getAccountTypesWithManagementDisabled-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameBranch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getCrossProfileCallerIdDisabledForUser-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/Invert;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/RegisteredServicesCache$Callback;-onServicesUpdated-(I Ljava/util/List;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/State;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/widget/RadialTimePickerView;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/BlendFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollStateDone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/WindowManagerPolicy;-wakingUp-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/os/IPowerManager$Stub$Proxy;-updateWakeLockUids-(Landroid/os/IBinder; [I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IHardwareService$Stub;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Landroid/widget/ExpandableListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/FragmentBreadCrumbs;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TelephonyRegistry;-notifyDataConnectionForSubscriber-(J I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/Filter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/backup/BackupManagerService$PerformInitializeTask;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/pm/Installer;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/AccessibilityController;-drawMagnifiedRegionBorderIfNeededLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-isUninstallBlocked-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub;-setColor-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/telephony/SmsManager;-sendStoredMultipartTextMessage-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/UiccSmsController;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/display/DisplayAdapter$2;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accessibilityservice/IAccessibilityServiceConnection;-getWindows-()Ljava/util/List;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/inputmethodservice/InputMethodService;-onCreate-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameFetch;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/BluetoothPeripheralHandover;-complete-(Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/AlarmManagerService$2;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/nfc/cardemulation/AppChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordMinimumNonLetter-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipCallBase;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/GLTextureTarget;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/SubtitleController;-getDefaultTrack-()Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getAccountTypesWithManagementDisabled-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-checkPassword-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcTag;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Landroid/nfc/tech/Ndef;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Landroid/nfc/tech/Ndef;-makeReadOnly-()Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/dataconnection/DcController;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/WebVttRenderingWidget$RegionLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneFactory;-setDefaultSubscription-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/PowerManager$WakeLock;-acquire-(J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/trust/TrustAgentService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-ensureWindowsAvailableTimed-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/hdmi/HdmiCecController$4;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService$4;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$5100-(Lcom/android/server/accessibility/AccessibilityManagerService; Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/display/AutomaticBrightnessController;-updateAutoBrightness-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-release-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-inputDispatchingTimedOut-(I Z Ljava/lang/String;)J' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-<init>-(Ljava/lang/String; Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-removePrintJobStateChangeListener-(Landroid/print/IPrintJobStateChangeListener; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService;-notifyProfileRemoved-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService;-setDisplayPropertiesInternal-(I Z F Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-focusChangedLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManagerPolicy$WindowState;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/ResolverDrawerLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord$Token;-windowsVisible-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-updateAdnRecordsInEfByIndexForSubscriber-(J I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/net/sip/SipAudioCall;-access$800-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-cancelPrintJob-(Landroid/print/PrintJobId; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager$CardEmulationInterface;-setDefaultForNextTap-(I Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone; Landroid/telephony/CellInfo;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CellBroadcastHandler;-makeCellBroadcastHandler-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneBase;)Lcom/android/internal/telephony/CellBroadcastHandler;' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler$SmsBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiController$4;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setMaximumTimeToLock-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/backup/SystemBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/wifi/WifiScanningServiceImpl$WifiScanningStateMachine$StartedState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendImsCdmaSms-([B I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/tv/TvInputManagerService$1;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/SystemServiceManager;-startBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/net/NetworkScorerAppManager;-isCallerActiveScorer-(Landroid/content/Context; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-startPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/pm/IPackageManager;-getInstallLocation-()I' : ['android.permission.READ_PROFILE'],
	'Landroid/print/PrinterDiscoverySession;-finalize-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-deleteFromRawTable-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_SMS'],
	'Lcom/android/ims/internal/IImsCallSessionListener$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getNetworkCapabilities-(Ljava/lang/String;)Landroid/net/NetworkCapabilities;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier$MagnificationController;-setScaleAndMagnifiedRegionCenter-(F F F Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/ChooseAccountActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/display/AutomaticBrightnessController;-updateAmbientLux-(J)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/tts/TextToSpeech;-getVoices-()Ljava/util/Set;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/CaptioningManager;-getFontScale-()F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-findTaskToMoveToFrontLocked-(Lcom/android/server/am/TaskRecord; I Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/SupplicantStateTracker;-access$300-(Lcom/android/server/wifi/SupplicantStateTracker; Landroid/net/wifi/SupplicantState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telecom/ConnectionService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-addTrackerToRawTableAndSendMessage-(Lcom/android/internal/telephony/InboundSmsTracker;)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyCellInfo-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/SystemGesturesPointerEventListener$Callbacks;-onSwipeFromRight-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcTag$Stub;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-updateSmsSendStatus-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-queryPin1State-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/display/DisplayManagerService;-access$3700-(Lcom/android/server/display/DisplayManagerService; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/AdapterView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/NumberPicker$CustomEditText;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/NetInitiatedActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-moveTaskBackwards-(I)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getCrossProfileCallerIdDisabled-(Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(J Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/accounts/AccountManagerService;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodSubtypeListLocked-(Landroid/view/inputmethod/InputMethodInfo;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ims/internal/IImsCallSessionListener$Stub$Proxy;-callSessionStartFailed-(Lcom/android/ims/internal/IImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/dataconnection/DcTrackerBase;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$P2pDisabledState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextViewWithCircularIndicator;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getSelectedInputMethod-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/SmsManager;-deleteStoredMessage-(Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/app/DisableCarModeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/server/LocationManagerService$Receiver;-updateMonitoring-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ExpandableListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteEndpointDiscovered-(Lcom/android/nfc/DeviceHost$TagEndpoint;)V' : ['android.permission.VIBRATE'],
	'Landroid/text/method/TextKeyListener;-getPrefs-(Landroid/content/Context;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-stopServiceLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-updateImsPhone-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/text/format/DateUtils;-getRelativeDateTimeString-(Landroid/content/Context; J J J I)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setHdmiPlugged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-getDisplayContentLocked-(I)Lcom/android/server/wm/DisplayContent;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsNavigationMessageListener-(Landroid/location/IGpsNavigationMessageListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/display/AutomaticBrightnessController$2;-onTwilightStateChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-wipeData-(I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgentHelper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/GlobalActions;-onAirplaneModeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wm/AccessibilityController$WindowsForAccessibilityObserver;-populateVisibleWindowsOnScreenLocked-(Landroid/util/SparseArray;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendStoredMultipartText-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-startProcessLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/print/IPrintManager$Stub;-addPrintJobStateChangeListener-(Landroid/print/IPrintJobStateChangeListener; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$DriverStoppingState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/media/projection/MediaProjectionManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipProfile; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState$DeactingState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/voiceinteraction/SoundTriggerHelper;-stopAllRecognitions-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-addCircularFence-(I Landroid/hardware/location/GeofenceHardwareRequestParcelable; Landroid/hardware/location/IGeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wm/WindowManagerService$2;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/service/textservice/SpellCheckerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-renameAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/mock/MockContentResolver;-requestSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/ActivityManager;-getTaskThumbnail-(I)Landroid/app/ActivityManager$TaskThumbnail;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-getSelectedSpellChecker-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Global;-getFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/TouchExplorer$PerformLongPressDelayed;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/notification/NotificationManagerService$NotificationListeners;-onPackagesChanged-(Z [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowStateAnimator;-applyEnterAnimationLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-setAndPersistDeviceName-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$ApplyRoutingTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/GrayscaleEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IEthernetManager;-setConfiguration-(Landroid/net/IpConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-getCellLocation-()Landroid/telephony/CellLocation;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/WaveView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/print/PrintManager;-restartPrintJob-(Landroid/print/PrintJobId;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkScoreService$Stub$Proxy;-clearScores-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowAnimator;-setAppLayoutChanges-(Lcom/android/server/wm/AppWindowAnimator; I Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/NfcService$TagService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/provider/Telephony$Sms$Outbox;-addMessage-(J Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long; Z J)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncActivityTooManyDeletes;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcActivatingState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiStateMachine$ObtainingIpState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Settings$Global;-getInt-(Landroid/content/ContentResolver; Ljava/lang/String; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/MmsServiceBroker$BinderService;-addMultimediaMessageDraft-(Ljava/lang/String; Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService$15;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/NativeActivity$NativeContentView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getVoiceMailNumberForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/dreams/DreamManagerService;-startDreamLocked-(Landroid/content/ComponentName; Z Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cat/CatService;-sendTerminalResponse-(Lcom/android/internal/telephony/cat/CommandDetails; Lcom/android/internal/telephony/cat/ResultCode; Z I Lcom/android/internal/telephony/cat/ResponseData;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms$Stub;-sendMessage-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-getCurrentSpellCheckerSubtype-(Ljava/lang/String; Z)Landroid/view/textservice/SpellCheckerSubtype;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CropFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/CantAddAccountActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-packageHasActiveAdmins-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ISyncAdapter;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/EthernetManager;-setConfiguration-(Landroid/net/IpConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/wm/WindowManagerService$3;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/nfc/NfcService$TagService;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/server/wm/WindowManagerService;-reevaluateStatusBarVisibility-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/twilight/TwilightService$TwilightListenerRecord;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/GLTextureTarget;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateUtils;-formatDateTime-(Landroid/content/Context; J I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-updateAdnByIndex-(I Lcom/android/internal/telephony/uicc/AdnRecord; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DockObserver;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiController$ScanOnlyLockHeldState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms;-sendTextForSubscriber-(J Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager;-onPreferredForegroundServiceChanged-(Landroid/content/ComponentName;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/WaveView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/ISipService;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/server/wifi/WifiScanningServiceImpl$WifiChangeStateMachine;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; Landroid/os/WorkSource; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/ExpandedMenuView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService$10;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/nfc/NfcApplication;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getIMEI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine$DriverStoppingState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-acknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMALTEPhone;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/WifiStateMachine$DriverStoppingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/ContentService;-getSyncAutomaticallyAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/widget/Editor$SelectionEndHandleView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcB;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/mock/MockContentResolver;-isSyncPendingAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/notification/ManagedServices;-access$600-(Lcom/android/server/notification/ManagedServices;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/NativeActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/notification/NotificationManagerService$NotificationListeners;-onUserSwitched-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/SearchDialog$SearchBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayPowerController;-animateScreenStateChange-(I Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setPasswordMinimumNumeric-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/printservice/PrintService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/MediaController;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-access$300-(Lcom/android/server/LocationManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/app/AliasActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/nsd/NsdManager;-init-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/widget/LockPatternUtils;-getBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/service/notification/ConditionProviderService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/FullBackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/widget/RotarySelector;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContentResolver;-getSyncStatusAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/InboundSmsHandler$DefaultState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/print/IPrintManager$Stub;-getInstalledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-enableCellBroadcastForSubscriber-(J I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/app/AlertActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/PlaybackQueueItem;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager;-getPermittedAccessibilityServices-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/QuickContactBadge;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GeofenceManager;-addFence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; I I Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Landroid/widget/SpellChecker;-resetSession-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothManager;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/effect/effects/ColorTemperatureEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/os/SystemVibrator;-vibrate-([J I Landroid/media/AudioAttributes;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/TintFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/DisplayContent;-switchUserStacks-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-updateThisDevice-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService$Lifecycle;-onBootPhase-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cat/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager;-onServicesUpdated-(I Ljava/util/List;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl$2;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getAutoTimeRequired-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcF;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getTimeCacheMaxAge-()J' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ActivityGroup;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService$VolumeStreamState;-<init>-(Landroid/media/AudioService; Ljava/lang/String; I Landroid/media/AudioService$1;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-systemReady-(Lcom/android/internal/app/IAppOpsService;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardwareService;-access$200-(Landroid/hardware/location/GeofenceHardwareService; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-access$3600-(Lcom/android/server/power/PowerManagerService; J I I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setAccountManagementDisabled-(Landroid/content/ComponentName; Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TableRow;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService;-disableSafeMediaVolume-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/power/PowerManagerService;-userActivityInternal-(J I I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-showBootMessage-(Ljava/lang/CharSequence; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/pm/PackageManagerService$11;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-clearSubInfo-()I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getDataRoamingEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-sendAdminCommandToSelfAndProfilesLocked-(Ljava/lang/String; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IMediaHTTPConnection$Stub$Proxy;-getMIMEType-()Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/server/connectivity/PacManager;-access$700-(Lcom/android/server/connectivity/PacManager;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/Session;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/power/PowerManagerService$BinderService;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/PreferenceActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getKeyguardDisabledFeatures-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/SpeechRecognizer;-stopListening-()V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPermittedAccessibilityServices-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-setRestrictBackground-(Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-moveInputMethodDialogsLocked-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/SubscriptionController;-clearSubInfo-()I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Landroid/service/textservice/SpellCheckerService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Presentation$1;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-keyguardGoingAway-(Z Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/GridView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-pollBatchedScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/AliasActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/TechListChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/tech/IsoDep;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Landroid/provider/Settings$System;-getShowGTalkServiceStatusForUser-(Landroid/content/ContentResolver; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-onSubscriptionActivated-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/IWifiManager$Stub;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-clearPackagePersistentPreferredActivities-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/LauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-isLockTaskPermitted-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService$Stub;-disableSafeMediaVolume-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter;-setP2pModes-(I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeech;-playSilentUtterance-(J I Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/input/InputManagerService; Z Z Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/CheckedTextView;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/ServiceWatcher$2;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-access$1100-(Lcom/android/server/wm/WindowManagerService;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/SystemServiceManager;-startService-(Ljava/lang/Class;)Lcom/android/server/SystemService;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SubscriptionController;-getSubInfoForSubscriber-(J)Landroid/telephony/SubInfoRecord;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/IntentForwarderActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SubscriptionController;-setDisplayNumber-(Ljava/lang/String; J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/LinearLayoutWithDefaultTouchRecepient;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/preference/PreferenceActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/SubscriptionManager;-setDefaultSmsSubId-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wifi/WifiServiceImpl$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-getReceiverLocked-(Landroid/app/PendingIntent; I I Ljava/lang/String; Landroid/os/WorkSource; Z)Lcom/android/server/LocationManagerService$Receiver;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ProxyController;-updateDataConnectionTracker-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/NetworkMonitor$OfflineState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accounts/AccountManagerService;-addAccountAsUser-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle; I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/text/format/DateUtils;-formatDateRange-(Landroid/content/Context; J J I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService$8;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/accessibility/CaptioningManager;-getUserStyle-()Landroid/view/accessibility/CaptioningManager$CaptionStyle;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-reportGeofenceMonitorStatus-(I I Landroid/location/Location; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/app/UiAutomationConnection;-registerUiTestAutomationServiceLocked-(Landroid/accessibilityservice/IAccessibilityServiceClient;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-sendImsGsmSms-(Ljava/lang/String; Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/ActivityView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/util/AsyncService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-detachStack-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/BaseCommands;-setUiccSubscription-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$WindowManagerCallbacks;-notifyANR-(Lcom/android/server/input/InputApplicationHandle; Lcom/android/server/input/InputWindowHandle; Ljava/lang/String;)J' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/AliasActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/MultiAutoCompleteTextView;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FlipFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processDisplayText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/UiccSmsController;-updateMessageOnIccEf-(Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/updates/SELinuxPolicyInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordQuality-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/app/AlertActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-requestSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/LauncherAppsService$LauncherAppsImpl$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/widget/TextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-requestSync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-updatePhoneObject-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/am/ActivityStack;-completePauseLocked-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService;-removeProviderLocked-(Lcom/android/server/location/LocationProviderInterface;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/HandoverService;-disableBluetoothIfNeeded-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/backup/BackupAgent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/accessibility/CaptioningManager$2;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-getTaskThumbnail-(I)Landroid/app/ActivityManager$TaskThumbnail;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/display/DisplayPowerController$2;-onAnimationEnd-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterfw/core/FilterFunction;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingInsecureRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStackSupervisor;-moveTaskToStack-(I I Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceRemovedLocked-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothSocket;-initSocketNative-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/UiAutomationConnection;-disconnect-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/server/wm/WindowManagerService;-requestTraversalLocked-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager;-getBatchedScanResults-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-reportSuccessfulPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/INfcAdapter$Stub;-setReaderMode-(Landroid/os/IBinder; Landroid/nfc/IAppCallback; I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/NativeActivity$NativeContentView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-<init>-(Ljava/lang/String; Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipAudioCall;-setSpeakerMode-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/LauncherActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/TabActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/uicc/IsimUiccRecords;-getIsimChallengeResponse-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/AdapterView;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/FrameLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/wifi/WifiSettingsStore;-getPersistedScanAlwaysAvailable-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AdapterView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getDevPersistBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayPowerController;-<init>-(Landroid/content/Context; Landroid/hardware/display/DisplayManagerInternal$DisplayPowerCallbacks; Landroid/os/Handler; Landroid/hardware/SensorManager; Lcom/android/server/display/DisplayBlanker;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/WaveView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-unregisteredPreferredForegroundService-(I)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/ILockSettings$Stub;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-isDataPossible-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ListView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/TintFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/WakeLockStateMachine$WaitingState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/server/LocationManagerService;-switchUser-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-loadDefaultsFromSettings-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/WapPushOverSms;-writeInboxMessage-(J [B)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/nfc/cardemulation/TapAgainDialog;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-shutdownRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/GpsLocationProvider;-access$3600-(Lcom/android/server/location/GpsLocationProvider; I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/widget/AbsoluteLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/IActivityContainer$Stub$Proxy;-release-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-handleSandman-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/BackgroundDexOptService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-createUser-(Landroid/content/ComponentName; Ljava/lang/String;)Landroid/os/UserHandle;' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/cardemulation/CardEmulation;-getAidsForService-(Landroid/content/ComponentName; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/preference/SeekBarVolumizer;-onStopSample-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-access$000-(Lcom/android/server/accessibility/ScreenMagnifier; Landroid/graphics/Region;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/backup/BackupManagerService$Lifecycle;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-updateWindowsForAccessibilityCallbackLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onRegistrationFailed-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-appDiedLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/app/IApplicationThread;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/LayoutInflater$BlinkLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/inputmethodservice/ExtractEditLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setSafeMode-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService;-vibratePattern-(I Ljava/lang/String; [J I I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetupCall-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/IDropBoxManagerService$Stub$Proxy;-add-(Landroid/os/DropBoxManager$Entry;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-getSyncManager-()Lcom/android/server/content/SyncManager;' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/CalendarView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readConfigurationForUserStateLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager;-startPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IUiAutomationConnection$Stub$Proxy;-shutdown-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/tech/MifareUltralight;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-setDeviceOwner-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-update-(Lcom/android/ims/ImsCall; Lcom/android/internal/telephony/Call$State;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/EnableAccessibilityController;-enableAccessibility-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserStop-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/Ndef;-getNdefMessage-()Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Landroid/inputmethodservice/KeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/wallpaper/WallpaperService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/hardware/location/GeofenceHardwareService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiServiceImpl;-checkAndStartWifi-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager;-getCrossProfileCallerIdDisabled-(Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/SupplicantStateTracker$HandshakeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/cardemulation/CardEmulation;-removeAidsForService-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-setP2pModes-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub$Stub;-setDisplayName-(Ljava/lang/String; J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/Ndef;-writeNdefMessage-(Landroid/nfc/NdefMessage;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiController$NoLockHeldState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-cleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-isGlobalAccessibilityGestureEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipAudioCall;-transferToNewSession-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/base/FrameFetch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/GLTextureSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IntentService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentialsAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/service/dreams/DreamService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/CertBlacklister;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/notification/ManagedServices;-disableNonexistentServices-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/hdmi/HdmiControlService;-access$1200-(Lcom/android/server/hdmi/HdmiControlService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/AlarmManagerService$InteractiveStateReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/voice/VoiceInteractionSessionService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager;-enableAggressiveHandover-(I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-applyPostLayoutPolicyLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManager$LayoutParams;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-enableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-updateMaximumTimeToLockLocked-(Lcom/android/server/devicepolicy/DevicePolicyManagerService$DevicePolicyData;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/tv/TvView$3;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothServerSocket;-<init>-(I Z Z I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-reportActivityInfo-()Landroid/net/wifi/WifiActivityEnergyInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/TelephonyRegistry;-broadcastDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS'],
	'Landroid/app/backup/BackupAgent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/NullFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-removeCrossProfileWidgetProvider-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/SubtitleTrack$RenderingWidget;-setVisible-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-isLocationProviderEnabledForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-setKeyboardMode-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-deletePackageLI-(Ljava/lang/String; Landroid/os/UserHandle; Z [I [Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accessibilityservice/AccessibilityService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readTouchExplorationGrantedAccessibilityServicesLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager;-isAdminActive-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-updateWallpaperVisibilityLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/sip/ISipService$Stub;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/print/PrintManager;-removePrintJobStateChangeListener-(Landroid/print/PrintManager$PrintJobStateChangeListener;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-processMsg-(Landroid/os/Message;)Lcom/android/internal/util/State;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-rebootSafeMode-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/RotarySelector;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/IGeofenceHardware$Stub;-pauseGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/opengl/GLSurfaceView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/WebVttRenderingWidget;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/SubscriptionManager;-setDefaultVoiceSubId-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeechService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateCurrentCarrierInProvider-(Ljava/lang/String;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifySignalStrengthForSubscriber-(J Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActiveServices;-removeConnectionLocked-(Lcom/android/server/am/ConnectionRecord; Lcom/android/server/am/ProcessRecord; Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-setDataAllowed-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TableLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-create-(Landroid/content/Context; Landroid/net/Uri; Landroid/view/SurfaceHolder;)Landroid/media/MediaPlayer;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SubInfoRecordUpdater;-updateSimInfoByIccId-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/twilight/TwilightService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService$TagService;-isNdef-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-processCdmaWapPdu-([B I Ljava/lang/String; J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/DockObserver;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/server/accounts/AccountManagerService$8;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifySignalStrengthForSubscriber-(J Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiServiceImpl;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/NfcActivityManager;-setNdefPushContentUriCallback-(Landroid/app/Activity; Landroid/nfc/NfcAdapter$CreateBeamUrisCallback;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-onUidToBackground-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiAutoJoinController;-newHalScanResults-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowManagerService;-setTokenVisibilityLocked-(Lcom/android/server/wm/AppWindowToken; Landroid/view/WindowManager$LayoutParams; Z I Z Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPDPContextList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telecom/ConnectionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-loadInputMethodAndSubtypeHistoryLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewOverlay$OverlayViewGroup;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccSmsController;-sendStoredText-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine;-<init>-(Landroid/content/Context; Landroid/os/Messenger;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setPasswordQuality-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/NativeActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/nfc/handover/HandoverService;-access$100-(Lcom/android/nfc/handover/HandoverService; Landroid/content/Intent; I)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendMultipartSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/accessibility/AccessibilityInputFilter;-onMotionEvent-(Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/content/SyncManager$7;-onSyncRequest-(Lcom/android/server/content/SyncStorageEngine$EndPoint; I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z)J' : ['android.permission.INTERNET'],
	'Landroid/hardware/display/DisplayManagerInternal;-initPowerManagement-(Landroid/hardware/display/DisplayManagerInternal$DisplayPowerCallbacks; Landroid/os/Handler; Landroid/hardware/SensorManager;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/cardemulation/CardEmulation;-setDefaultForNextTap-(Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doRestoreFinished-(I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifyDataConnectionForSubscriber-(J I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/widget/EditText;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/RotationPolicy;-getRotationLockOrientation-(Landroid/content/Context;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/InstrumentationCoreTestRunner;-finish-(I Landroid/os/Bundle;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/INfcTag$Stub;-isNdef-(I)Z' : ['android.permission.NFC'],
	'Landroid/media/ClosedCaptionWidget;-manageChangeListener-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager;-onNfcEnabled-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceResumeStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-getAudioSessionId-()I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setSecureSetting-(Landroid/content/ComponentName; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService$TestFeaturesSession;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/server/DropBoxManagerService;-access$300-(Lcom/android/server/DropBoxManagerService;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GeofenceManager;-getFreshLocationLocked-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/ims/ImsEcbmStateListener;-onECBMEntered-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeech;-isLanguageAvailable-(Ljava/util/Locale;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaSubscriptionSourceManager;-getDefault-(Landroid/content/Context;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowSession;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordMinimumNonLetter-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/wifi/WifiStateMachine$TetheringState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/service/media/MediaBrowserService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/CheckBox;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/SlidingTab;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performAuditoryFeedbackForAccessibilityIfNeed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService$17;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendNewSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/SmsHeader; I Landroid/app/PendingIntent; Landroid/app/PendingIntent; Z Ljava/util/concurrent/atomic/AtomicInteger; Ljava/util/concurrent/atomic/AtomicBoolean; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/view/inputmethod/InputMethodManager;-getEnabledInputMethodSubtypeList-(Landroid/view/inputmethod/InputMethodInfo; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ims/ImsCall$ImsCallSessionListenerProxy;-callSessionTerminated-(Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-disableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter;-invokeBeamInternal-(Landroid/nfc/BeamShareData;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/am/ActivityStackSupervisor$ActivityContainer;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCommandInterface;-setDataAllowed-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getRemoveWarning-(Landroid/content/ComponentName; Landroid/os/RemoteCallback; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/ITextToSpeechService;-speak-(Landroid/os/IBinder; Ljava/lang/CharSequence; I Landroid/os/Bundle; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/AutomaticBrightnessController;-configure-(Z F)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-setInitialAttachApn-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/NdefFormatable;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastIntentLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Landroid/content/Intent; Ljava/lang/String; Landroid/content/IIntentReceiver; I Ljava/lang/String; Landroid/os/Bundle; Ljava/lang/String; I Z Z I I I)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readDisplayMagnificationEnabledSettingLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaPlayer$4;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getCameraDisabled-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService;-onInputDeviceChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub;-setAutoPersisting-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SMS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getScreenCaptureDisabled-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/tv/TvView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-installKeyPair-(Landroid/content/ComponentName; [B [B Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-handleAnimatingStoppedAndTransitionLocked-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNetworkCapabilities-(Ljava/lang/String;)Landroid/net/NetworkCapabilities;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setPasswordExpirationTimeout-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService$13;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService$Stub;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/search/SearchManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/app/ActivityManagerNative;-bootAnimationComplete-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/MediaFocusControl;-access$1400-(Landroid/media/MediaFocusControl;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumNumeric-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/updates/IntentFirewallInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub$Proxy;-setStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/widget/DialogTitle;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/cardemulation/HostApduService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/handover/ConfirmConnectActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getBatchedScanResults-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/ActivityView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/AccessibilityInteractionClient;-getWindow-(I I)Landroid/view/accessibility/AccessibilityWindowInfo;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ProxyController;-enableDataConnectivity-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getScanResults-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Landroid/app/IActivityManager;-getTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/accounts/IAccountManager;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Landroid/speech/tts/TextToSpeech$8;-run-(Landroid/speech/tts/ITextToSpeechService;)Ljava/util/Locale;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Z Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/DropBoxManager;-addFile-(Ljava/lang/String; Ljava/io/File; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setDataProfile-([Lcom/android/internal/telephony/dataconnection/DataProfile; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setAutoTimeRequired-(Landroid/content/ComponentName; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/appwidget/AppWidgetHostView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getDataEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/webkit/WebViewUpdateService;-access$000-(Lcom/android/server/webkit/WebViewUpdateService;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-updatePointerSpeedFromSettings-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/test/InstrumentationCoreTestRunner;-onStart-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-deleteSystemPackageLI-(Lcom/android/server/pm/PackageSetting; [I [Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/SubInfoRecordUpdater;-queryIccId-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine;-sendNetworkStateChangeBroadcast-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/ComprehensiveCountryDetector$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/updates/TZInfoInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Lcom/android/internal/telephony/Phone;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/hdmi/HdmiControlService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/ActionMenuPresenter$OverflowMenuButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/DragState;-endDragLw-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringLogger;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionCallReceiverImpl;-access$1600-(Lcom/android/server/sip/SipSessionGroup$SipSessionImpl; Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/MountServiceIdler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/SipAudioCall;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/TabWidget;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/backup/BackupManagerService$PerformClearTask;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiScanningServiceImpl$WifiChangeStateMachine;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-onConnect-(Lcom/android/internal/telephony/dataconnection/DataConnection$ConnectionParams;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaFocusControl;-filterMediaKeyEvent-(Landroid/view/KeyEvent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-startBluetoothSco-(Landroid/os/IBinder; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getStorageEncryption-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/SRTTrack;-hide-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.READ_CONTACTS'],
	'Landroid/widget/CheckedTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/IsoDep;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/location/provider/LocationProviderBase;-reportLocation-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy;-finishPostLayoutPolicyLw-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/backup/FullBackupAgent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/DhcpStateMachine$RunningState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/cdma/CdmaCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/SMSDispatcher$SettingsObserver;-<init>-(Landroid/os/Handler; Ljava/util/concurrent/atomic/AtomicInteger; Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LockSettingsService;-checkReadPermission-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/FrameLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/MifareClassic;-authenticate-(I [B Z)Z' : ['android.permission.NFC'],
	'Landroid/net/INetworkScoreService;-clearScores-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiServiceImpl;-requestBatchedScan-(Landroid/net/wifi/BatchedScanSettings; Landroid/os/IBinder; Landroid/os/WorkSource;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-removeActiveAdmin-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/MmsServiceBroker$BinderService;-updateStoredMessageStatus-(Ljava/lang/String; Landroid/net/Uri; Landroid/content/ContentValues;)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncStorageEngine;-setIsTargetServiceActive-(Landroid/content/ComponentName; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/provider/ContactsContract$RawContacts$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/am/CompatModePackages;-setPackageScreenCompatModeLocked-(Landroid/content/pm/ApplicationInfo; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/SmsStorageMonitor$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SmsMessage;-getSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z [B I I I)Lcom/android/internal/telephony/gsm/SmsMessage$SubmitPdu;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPermittedInputMethodsForCurrentUser-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/TouchExplorer;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCall;-merge-(Lcom/android/internal/telephony/imsphone/ImsPhoneCall; Lcom/android/internal/telephony/Call$State;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-updateSmsSendStatus-(I Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Service;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessLimit-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActiveServices;-killServicesLocked-(Lcom/android/server/am/ProcessRecord; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/hardware/location/IGeofenceHardware;-addCircularFence-(I Landroid/hardware/location/GeofenceHardwareRequestParcelable; Landroid/hardware/location/IGeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccount-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/SystemServer$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-getNetworkCapabilities-(Ljava/lang/String;)Landroid/net/NetworkCapabilities;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StopTetheringErrorState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/AlarmManagerService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-access$500-(Lcom/android/server/devicepolicy/DevicePolicyManagerService; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-clearProfileOwner-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/CertBlacklister$BlacklistObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToRuim-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ToggleButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/telecom/ConnectionService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/input/InputManagerService;-getShowTouchesSetting-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcBackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcastRangeForSubscriber-(J I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/BaseCommands;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/AdapterViewAnimator;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService$VolumeController;-loadSettings-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserSwitch-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-isFeatureSupported-(I)Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/DigitalClock;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService$1;-getSummaryForNetwork-(Landroid/net/NetworkTemplate; J J)Landroid/net/NetworkStats;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onRadioAvailable-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/dreams/DreamManagerService$LocalService;-startDream-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-deleteStoredConversation-(Ljava/lang/String; J)Z' : ['android.permission.WRITE_SMS'],
	'Landroid/media/IAudioService$Stub$Proxy;-adjustStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/GhostView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$6;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/TrafficStats;-stopDataProfiling-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/updates/TZInfoInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/AlarmManagerService;-interactiveStateChangedLocked-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telecom/InCallService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$1;-startTask-()V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/CoreSettingsObserver;-populateSettings-(Landroid/os/Bundle; Ljava/util/Map;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/NotificationManagerService$5;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/AccessibilityController$DisplayMagnifier$MagnifiedViewport;-recomputeBoundsLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/IAudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-switchToState-(I F F)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-replaceSystemPackageLI-(Landroid/content/pm/PackageParser$Package; Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; [I [Z Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-handlePackagesChanged-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/UserState;-updateIfNeededLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcCardEmulation$Stub;-getAidGroupForService-(I Landroid/content/ComponentName; Ljava/lang/String;)Landroid/nfc/cardemulation/AidGroup;' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/view/IWindowSession$Stub;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/telephony/SmsManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcActiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/power/PowerManagerService;-updateUserActivitySummaryLocked-(J I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-removePrintJobStateChangeListener-(Landroid/print/IPrintJobStateChangeListener; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/ExtractEditText;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ViewAnimator;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-access$200-(Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/ConditionProviders$DowntimeCallback;-onDowntimeChanged-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-notifySignalStrength-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService$14;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-saveSettingsLocked-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ims/internal/IImsCallSessionListener;-callSessionStartFailed-(Lcom/android/ims/internal/IImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Ljava/net/HttpURLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wallpaper/WallpaperManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/SmsUsageMonitor$SettingsObserverHandler;-<init>-(Landroid/content/Context; Ljava/util/concurrent/atomic/AtomicBoolean;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/text/ToUpperCase;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/app/DisableCarModeActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/display/DisplayPowerController;-access$500-(Lcom/android/server/display/DisplayPowerController;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-startDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setGlobalSetting-(Landroid/content/ComponentName; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/SubtitleTrack;-hide-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/view/menu/ExpandedMenuView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/display/DisplayManagerService;-access$1600-(Lcom/android/server/display/DisplayManagerService; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/ClosedCaptionWidget;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Telephony$Sms$Draft;-addMessage-(J Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothAdapter;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleModeChange-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getEnabledProviders-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/service/dreams/DreamService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/display/AutomaticBrightnessController;-handleLightSensorEvent-(J F)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService$Stub$Proxy;-setMasterSyncAutomaticallyAsUser-(Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/provider/CalendarContract$EventDays;-query-(Landroid/content/ContentResolver; I I [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-deleteFromRawTable-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_SMS'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/accounts/AccountManager$2;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/DropBoxManagerService;-trimToFit-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-sendRawPdu-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup;-processIOException-(Ljavax/sip/IOExceptionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms;-enableCellBroadcastForSubscriber-(J I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/server/display/OverlayDisplayAdapter;-access$000-(Lcom/android/server/display/OverlayDisplayAdapter;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptKeyBeforeQueueing-(Landroid/view/KeyEvent; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeechService$SynthesisToFileOutputStreamSpeechItemV1;-getSpeechRate-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-updateSettingsLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/SmsApplication$SmsPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/accessibility/CaptioningManager;-registerObserver-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RadioButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setPropertiesByCarrier-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-temporaryEnableAccessibilityStateUntilKeyguardRemoved-(Landroid/content/ComponentName; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/Activity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/AlarmManagerService;-formatNextAlarm-(Landroid/content/Context; Landroid/app/AlarmManager$AlarmClockInfo;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-updateCurrentCarrierInProvider-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telecom/InCallService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/content/ContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/IAlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/BluetoothManagerService;-isBluetoothPersistedStateOn-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-iccTransmitApduLogicalChannel-(I I I I I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ChooserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothManager;-unregisterStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/DeviceHost$TagDisconnectedCallback;-onTagDisconnected-(J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringLogger;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/InputStreamSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-handleOnRectangleOnScreenRequested-(I I I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setApplicationRestrictions-(Landroid/content/ComponentName; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-ensureBootCompleted-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/net/DhcpStateMachine;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/view/ViewStub;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Presentation$1;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ReceiverRestrictedContext;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager$Stub;-getBaseDisplayDensity-(I)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/TechListChooserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-<init>-(Landroid/content/Context; Landroid/location/ILocationManager; Landroid/os/Looper;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/CalendarView$LegacyCalendarViewDelegate$WeekView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-getLockTaskPackages-(Landroid/content/ComponentName;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WaveView;-waveUpdateFrame-(F F Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccSmsController;-injectSmsPdu-([B Ljava/lang/String; Landroid/app/PendingIntent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$AudioServiceBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Landroid/speech/tts/TextToSpeechService;-getSettingsLocale-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeechService$SynthesisSpeechItemV1;-getSpeechRate-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService;-access$700-(Lcom/android/server/net/NetworkStatsService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/MmsServiceBroker;-access$900-()Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/widget/AdapterViewAnimator;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/Invert;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/FlipEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/cardemulation/OffHostApduService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/widget/DateTimeView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Activity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/CountryDetectorService$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-invokeExitMethods-(Lcom/android/internal/util/StateMachine$SmHandler$StateInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/text/ToUpperCase;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-nvReadItem-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-onServicesUpdated-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/CertBlacklister;-registerObservers-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/UserDictionary$Words;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/test/IsolatedContext$MockAccountManager;-removeAccount-(Landroid/accounts/Account; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/content/SyncManager$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/widget/NumberPicker$AccessibilityNodeProviderImpl;-sendAccessibilityEventForVirtualText-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/cardemulation/CardEmulation;-registerAidsForService-(Landroid/content/ComponentName; Ljava/lang/String; Ljava/util/List;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/power/ShutdownThread;-access$000-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-setGrabbedState-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendMultipartTextForSubscriber-(J Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getSubscriberIdForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/widget/Switch;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/AlarmManagerService;-deliverAlarmsLocked-(Ljava/util/ArrayList; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getLastKnownLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/notification/ConditionProviders;-access$300-(Lcom/android/server/notification/ConditionProviders;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsRecorder;-recoverFromWtf-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub$Proxy;-getCurrentSpellChecker-(Ljava/lang/String;)Landroid/view/textservice/SpellCheckerInfo;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditText;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/voice/VoiceInteractionService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/backup/LocalTransportService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-getInitialMaxRetry-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService;-access$400-(Lcom/android/server/BluetoothManagerService;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms;-sendStoredMultipartText-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/RemoteViewsService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/trust/TrustManagerService;-access$1100-(Lcom/android/server/trust/TrustManagerService; Z I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-addTrackerToRawTable-(Lcom/android/internal/telephony/InboundSmsTracker;)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/widget/CheckedTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Switch;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/dreams/DreamManagerInternal;-stopDream-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/RotarySelector;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService;-setSyncAutomaticallyAsUser-(Landroid/accounts/Account; Ljava/lang/String; Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-print-(Ljava/lang/String; Landroid/print/IPrintDocumentAdapter; Landroid/print/PrintAttributes; Ljava/lang/String; I I)Landroid/os/Bundle;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager$CardEmulationInterface;-registerAidGroupForService-(I Landroid/content/ComponentName; Landroid/nfc/cardemulation/AidGroup;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/hdmi/HdmiCecLocalDeviceTv;-<init>-(Lcom/android/server/hdmi/HdmiControlService;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-isOffChannelTdlsSupported-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onSetUserDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccPhoneBookController;-getAdnRecordsSizeForSubscriber-(J I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-update-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/BrowserContract$Bookmarks;-buildFolderUri-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BroadcastQueue;-deliverToRegisteredReceiverLocked-(Lcom/android/server/am/BroadcastRecord; Lcom/android/server/am/BroadcastFilter; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$ProvisionDiscoveryState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/GpsMeasurementListenerTransport;-registerWithServer-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/ZoomButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-nvResetConfig-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/dreams/DreamManagerService;-finishSelfInternal-(Landroid/os/IBinder; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-updateCarrierMccMncConfiguration-(Ljava/lang/String; Ljava/lang/String; Landroid/content/Context;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/wm/WindowManagerService;-handleAppTransitionReadyLocked-(Lcom/android/server/wm/WindowList;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-dispatchMessageRadioSpecific-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-getAnyDataEnabled-(Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DigitalClock;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/IRecognitionService$Stub;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/wifi/WifiServiceImpl$3;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/IAudioService$Stub;-setMicrophoneMute-(Z Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneProxy;-setInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub$Stub;-setDefaultVoiceSubId-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableAggressiveHandover-(I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService$11;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/backup/FullBackupJob;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowManager;-keyguardGoingAway-(Z Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-dialInternal-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/media/MediaPlayer;-create-(Landroid/content/Context; I)Landroid/media/MediaPlayer;' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/RetargetFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindow;-openPanel-(Lcom/android/internal/policy/impl/PhoneWindow$PanelFeatureState; Landroid/view/KeyEvent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-update-(Lcom/android/internal/telephony/DriverCall;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord;-setTask-(Lcom/android/server/am/TaskRecord; Lcom/android/server/am/TaskRecord;)V' : ['android.permission.SEND_SMS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/monkey/MonkeySourceNetwork;-getNextEvent-()Lcom/android/commands/monkey/MonkeyEvent;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/hardware/input/InputManager$InputDeviceVibrator;-vibrate-([J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-access$2600-(Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService$2;-onProximityNegative-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-importMultimediaMessage-(Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; J Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/IActivityManager;-killBackgroundProcesses-(Ljava/lang/String; I)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Landroid/print/IPrintManager$Stub$Proxy;-restartPrintJob-(Landroid/print/PrintJobId; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-enableSystemApp-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-userActivityFromNative-(J I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/ExpandableListActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/server/content/SyncManager;-increaseBackoffSetting-(Lcom/android/server/content/SyncOperation;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/text/method/QwertyKeyListener;-onKeyDown-(Landroid/view/View; Landroid/text/Editable; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordMinimumNonLetter-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncAutomaticallyAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/notification/DowntimeConditionProvider;-onRequestConditions-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer$2;-addTrack-()I' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/LocationListener; Landroid/os/Looper; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/notification/NotificationManagerService;-access$4000-(Lcom/android/server/notification/NotificationManagerService; Landroid/os/Message;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/notification/NotificationManagerService$SettingsObserver;-update-(Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/monkey/Monkey;-runMonkeyCycles-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/tts/TtsEngines;-isLocaleSetToDefaultForEngine-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ContextWrapper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/TelephonyManager;-listen-(Landroid/telephony/PhoneStateListener; I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumSymbols-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcAdapter$Stub;-setP2pModes-(I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AsyncPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/am/ActivityStackSupervisor;-scheduleIdleLocked-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/handover/HandoverTransfer;-cancel-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/pm/LauncherAppsService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-uninstallCaCert-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent$Stub;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService$ScoClient;-incCount-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub$Proxy;-isRotationFrozen-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-conference-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-setDefaultDataSubId-(J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$5400-(Lcom/android/server/accessibility/AccessibilityManagerService; Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setKeyguardDisabledFeatures-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/gesture/GestureOverlayView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-getDataOnRoamingEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/KeyguardManager$KeyguardLock;-disableKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/pm/PackageManagerService$12;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/hdmi/HdmiControlService;-setControlEnabled-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/NfcActivityManager;-setNdefPushMessage-(Landroid/app/Activity; Landroid/nfc/NdefMessage; I)V' : ['android.permission.NFC'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtilsCache;-checkPassword-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcV;-reconnect-()V' : ['android.permission.NFC'],
	'Lcom/android/server/hdmi/HdmiCecLocalDeviceTv$1;-onDeviceDiscoveryDone-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-handleDisplayAddedLocked-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getImsRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getSubInfoForSubscriber-(J)Landroid/telephony/SubInfoRecord;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/PacManager;-getDownloadDelay-(I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/am/Am$IntentReceiver;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/CheckBox;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyLocationChanged-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumNumeric-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateUtils;-getRelativeTimeSpanString-(J J J I)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Contacts$People;-addToMyContactsGroup-(Landroid/content/ContentResolver; J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipManager;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/updates/SELinuxPolicyInstallReceiver;-access$000-(Lcom/android/server/updates/ConfigUpdateInstallReceiver; Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-setCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/uiautomator/core/UiAutomationShellWrapper;-disconnect-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms;-updateStoredMessageStatus-(Ljava/lang/String; Landroid/net/Uri; Landroid/content/ContentValues;)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-updateImsPhone-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/mock/MockApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCallForward-(I I I Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$Service$2;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getSupportedFeatures-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/CalendarView$LegacyCalendarViewDelegate;-onScroll-(Landroid/widget/AbsListView; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-setDisplayNumberFormat-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/ethernet/EthernetNetworkFactory$1;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordExpirationTimeout-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/PrintManager;-getEnabledPrintServices-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplaySizeLocked-(Lcom/android/server/wm/DisplayContent; I I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/notification/RankingReconsideration;-work-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiStateMachine;-setNetworkDetailedState-(Landroid/net/NetworkInfo$DetailedState;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-access$000-(Lcom/android/internal/telephony/RIL;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setCameraDisabled-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/MenuBuilder$Callback;-onMenuModeChange-(Lcom/android/internal/view/menu/MenuBuilder;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getMsisdnForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RadialTimePickerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/GpsNavigationMessageListenerTransport;-add-(Ljava/lang/Object;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/JobSchedulerImpl;-schedule-(Landroid/app/job/JobInfo;)I' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/AccessibilityController;-onWindowFocusChangedLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/text/format/DateFormat;-getDateFormat-(Landroid/content/Context;)Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setUninstallBlocked-(Landroid/content/ComponentName; Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-isMasterVolumeMuted-(Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/tv/TvInputService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-getSupportedFeatures-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/util/IState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/UiccSmsController;-getAllMessagesFromIccEfForSubscriber-(J Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/widget/EditText;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiManager;-isAdditionalStaSupported-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getSampleEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayManagerService$LocalService;-setDisplayProperties-(I Z F Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/SubscriptionManager;-getDefaultSmsSubId-()J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FilterSurfaceView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ActivityManager;-getRunningTasks-(I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$InactiveState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewOverlay$OverlayViewGroup;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/GridView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/VignetteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService$BinderService;-updateWakeLockUids-(Landroid/os/IBinder; [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService$NsdStateMachine;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-nvWriteCdmaPrl-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertActivity;-onStop-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/content/pm/IPackageManager;-systemReady-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-setCameraDisabled-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setMute-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IApplicationToken$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$AudioHandler$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-reportActivityInfo-()Landroid/net/wifi/WifiActivityEnergyInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wifi/SupplicantStateTracker$InactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Landroid/nfc/NfcAdapter;-disableForegroundDispatch-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/location/ILocationManager$Stub;-getProviderProperties-(Ljava/lang/String;)Lcom/android/internal/location/ProviderProperties;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/hardware/IConsumerIrService;-getCarrierFrequencies-()[I' : ['android.permission.TRANSMIT_IR'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/MountServiceIdler;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/trust/TrustAgentService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeech;-access$1700-(Landroid/speech/tts/TextToSpeech;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-pollStateDone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/WiredAccessoryManager;-access$200-(Lcom/android/server/WiredAccessoryManager;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-startProcessLocked-(Ljava/lang/String; Landroid/content/pm/ApplicationInfo; Z I Ljava/lang/String; Landroid/content/ComponentName; Z Z Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/textservice/ITextServicesManager;-getCurrentSpellCheckerSubtype-(Ljava/lang/String; Z)Landroid/view/textservice/SpellCheckerSubtype;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DayPickerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onSomePackagesChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/tv/TvInputManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/NfcService$TagService;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Landroid/speech/tts/TextToSpeech;-setLanguage-(Ljava/util/Locale;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/InputPort;-pushFrame-(Landroid/filterfw/core/Frame;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/DownloadManager;-enqueue-(Landroid/app/DownloadManager$Request;)J' : ['android.permission.INTERNET'],
	'Landroid/accounts/CantAddAccountActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IIntentReceiver$Stub$Proxy;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getWifiEnabledState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/IAudioService$Stub$Proxy;-setRingerMode-(I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getDataConnectionState-()Lcom/android/internal/telephony/PhoneConstants$DataState;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/nfc/NfcActivityManager;-enableReaderMode-(Landroid/app/Activity; Landroid/nfc/NfcAdapter$ReaderCallback; I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService;-unrouteAids-(Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/ISub$Stub;-getDefaultVoiceSubId-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipWakeLock;-release-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-isPatternEverChosen-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/FlipFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/OutputStreamTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncActivityTooManyDeletes;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/tv/TvInputService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine$LinkMonitoringState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothMap;-close-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/P2pLinkManager$ConnectTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$FrequencyConflictState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/P2pEventManager;-onP2pHandoverNotSupported-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState$ActedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/UiccSmsController;-isImsSmsSupported-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/wm/Session; Lcom/android/server/wm/WindowState;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/VibratorService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub$SettingsObserver;-<init>-(Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub; Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$17700-(Lcom/android/server/wifi/WifiStateMachine;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/View;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-goingToSleepLocked-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setCameraDisabled-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/text/format/DateUtils;-formatDateRange-(Landroid/content/Context; Ljava/util/Formatter; J J I)Ljava/util/Formatter;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-onUserStateChangedLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LocationManagerService;-removeUpdates-(Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-createUser-(Landroid/content/ComponentName; Ljava/lang/String;)Landroid/os/UserHandle;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/BatteryService;-processValuesLocked-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/ContextImpl;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/WindowManagerPolicy;-interceptKeyBeforeQueueing-(Landroid/view/KeyEvent; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/ConfirmConnectToWifiNetworkActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-isPackageDeviceAdmin-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/QuickContactBadge;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/SmsManager;-addMultimediaMessageDraft-(Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/accessibility/AccessibilityWindowInfo;-getChild-(I)Landroid/view/accessibility/AccessibilityWindowInfo;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/print/PrinterDiscoverySession;-<init>-(Landroid/print/IPrintManager; Landroid/content/Context; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/RecognitionService;-checkPermissions-(Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteFieldActivated-()V' : ['android.permission.VIBRATE'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/dreams/DreamManagerService;-access$2000-(Lcom/android/server/dreams/DreamManagerService; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-restatDataDir-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-clearPackagePersistentPreferredActivities-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/monkey/MonkeyNetworkMonitor;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine$SoftApStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/widget/TextView;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/TelephonyManager;-getImei-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/trust/TrustManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/provider/ContactsContract$Groups$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCommandInterface;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Landroid/bluetooth/BluetoothAdapter;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub;-getBaseDisplaySize-(I Landroid/graphics/Point;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-addTask-(I I Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager;-getAccountsForPackage-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-nvWriteCdmaPrl-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$7200-(Lcom/android/server/wifi/WifiStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-reportSuccessfulPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/backup/LocalTransportService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcCardEmulation$Stub$Proxy;-unsetPreferredService-()Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/media/effect/effects/StraightenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onSetInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiStateMachine;-startBatchedScan-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IProcessObserver$Stub$Proxy;-onProcessDied-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/print/PrintManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcCardEmulation$Stub$Proxy;-isDefaultServiceForAid-(I Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/server/power/PowerManagerService$LocalService;-setUserActivityTimeoutOverrideFromWindowManager-(J)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-access$8900-(Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcAdapter$Stub;-invokeBeam-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/notification/NotificationManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-getPrintJobInfos-(I I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/service/fingerprint/FingerprintUtils;-getFingerprintIdsForUser-(Landroid/content/ContentResolver; I)[I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-startScan-(Landroid/net/wifi/ScanSettings; Landroid/os/WorkSource;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/MediaFocusControl;-startVoiceBasedInteractions-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/ims/internal/ImsCallSession$Listener;-callSessionMerged-(Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/ImsCallProfile;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SmsUsageMonitor$SettingsObserver;-<init>-(Landroid/os/Handler; Landroid/content/Context; Ljava/util/concurrent/atomic/AtomicBoolean;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setReaderMode-(Landroid/os/IBinder; Landroid/nfc/IAppCallback; I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordHistoryLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/UiccCarrierPrivilegeRules;-<init>-(Lcom/android/internal/telephony/uicc/UiccCard; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/AccessibleDateAnimator;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-isDataAllowed-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneFactory;-calculatePreferredNetworkType-(Landroid/content/Context;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/am/Am;-runKillAll-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/internal/view/RotationPolicy;-isRotationLocked-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/service/media/MediaBrowserService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumLowerCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/CheckedTextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-wipeData-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/LauncherAppsService$LauncherAppsImpl$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/INfcTag$Stub;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Landroid/net/wifi/WifiManager;-isPasspointSupported-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wm/AccessibilityController;-onWindowLayersChangedLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/UiccSmsController;-updateMessageOnIccEfForSubscriber-(J Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl$2;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GeofenceManager;-updateFences-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/SubscriptionController;-getSubInfoUsingSlotIdWithCheck-(I Z)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/wm/WindowManagerService;-setAppVisibility-(Landroid/os/IBinder; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/WebVttRenderingWidget$SpanLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/CoreSettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/job/JobServiceContext;-access$300-(Lcom/android/server/job/JobServiceContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/nfc/P2pLinkManager$ConnectTask;-onPostExecute-(Ljava/lang/Boolean;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/sip/SipManager;-getSessionFor-(Landroid/content/Intent;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCommandInterface;-setUiccSubscription-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$3;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/MutableContextWrapper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/SyncRunner;-step-()I' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/notification/ConditionProviders;-access$600-(Lcom/android/server/notification/ManagedServices;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/SimpleMonthView;-drawMonthTitle-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub;-setDefaultVoiceSubId-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SubtitleView;-setStyle-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-lockNow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/PlatLogoActivity$1;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-isApplicationHidden-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/ContextThemeWrapper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/DigitalClock;-initClock-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/TrafficStats;-getDataLayerSnapshotForUid-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RatingBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FieldPort;-transfer-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-setCrossProfileCallerIdDisabled-(Landroid/content/ComponentName; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-createAllApnList-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/AccessibilityController$DisplayMagnifier$MagnifiedViewport;-populateWindowsOnScreenLocked-(Landroid/util/SparseArray;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/TabActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/PhoneNumberUtils;-isLocalEmergencyNumberInternal-(Ljava/lang/String; Landroid/content/Context; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FilterGraph;-closeFilters-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-systemReady-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getIccSimChallengeResponse-(J I Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/KeyboardView;-access$400-(Landroid/inputmethodservice/KeyboardView; Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/view/IWindowManager$Stub$Proxy;-screenshotApplications-(Landroid/os/IBinder; I I I Z)Landroid/graphics/Bitmap;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/notification/NotificationIntrusivenessExtractor$1;-run-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiStateMachine$ScanModeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setDeviceOwner-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CellBroadcastHandler;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z Z)J' : ['android.permission.INTERNET'],
	'Lcom/android/server/INativeDaemonConnectorCallbacks;-onDaemonConnected-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/IWindowManager$Stub;-statusBarVisibilityChanged-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/dhimpl/NativeNfcTag$PresenceCheckWatchdog;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-setProfileName-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/AppChooserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onSomePackagesChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-stopDtmf-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/TabActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/Button;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService;-setMicrophoneMute-(Z Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/view/IWindowSession$Stub$Proxy;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-removeUser-(Landroid/content/ComponentName; Landroid/os/UserHandle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-stopPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService;-setCurrentSpellCheckerLocked-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcTag$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-getSelectedSpellCheckerSubtype-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getPasswordMinimumLowerCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$5800-(Lcom/android/server/accessibility/AccessibilityManagerService; Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/AutoFixEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/pm/PackageManagerService$8;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler;-handleSmsMessage-(Landroid/os/Message;)Z' : ['android.permission.RECEIVE_SMS'],
	'Landroid/net/wifi/WifiManager;-startCustomizedScan-(Landroid/net/wifi/ScanSettings;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onDisconnectDcRetrying-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$AudioHandler;-cleanupPlayer-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-doVibratorOff-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiEnabled-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-updateCurrentCarrierInProvider-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/ClosedCaptionWidget;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRetrySms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getTrustAgentFeaturesEnabled-(Landroid/content/ComponentName; Landroid/content/ComponentName; I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/widget/PopupWindow$PopupViewContainer;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/widget/TableLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ILockSettings;-setLockPassword-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/method/TextKeyListener$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-getAccountsForPackage-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onTrySetupData-(Lcom/android/internal/telephony/dataconnection/ApnContext;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/backup/SystemBackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/P2pEventListener;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/connectivity/PacManager$1;-run-()V' : ['android.permission.READ_PROFILE', 'android.permission.INTERNET'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/restrictions/RestrictionsManagerService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DatePicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/display/DisplayPowerController;-requestPowerState-(Landroid/hardware/display/DisplayManagerInternal$DisplayPowerRequest; Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/Installer;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordMinimumSymbols-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$6;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/FilterGraphEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getAllSubInfoList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Editor$InsertionHandleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/net/NetworkStatsService;-advisePersistThreshold-(J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getNetworkTotalBytes-(Landroid/net/NetworkTemplate; J J)J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-removeFence-(Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/HorizontalScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-addAppLocked-(Landroid/content/pm/ApplicationInfo; Z Ljava/lang/String;)Lcom/android/server/am/ProcessRecord;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/MobileDataStateTracker;-startMonitoring-(Landroid/content/Context; Landroid/os/Handler;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/backup/LocalTransportService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/SupplicantStateTracker;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/FilterSurfaceView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/WebVttRenderer;-createTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-fetchDunApn-()Lcom/android/internal/telephony/dataconnection/ApnSetting;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-shutdownRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-access$300-(Lcom/android/internal/telephony/RIL;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getUidConfig-()Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings$Config;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/OutputStreamTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Presentation$1;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiServiceImpl;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-getSyncAutomaticallyAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/BeamShareActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LockSettingsService;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-showBootMessage-(Ljava/lang/CharSequence; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/app/IBatteryStats;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-updateNetworkRulesLocked-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStack;-activityPausedLocked-(Landroid/os/IBinder; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/TabActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getPDPContextList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/CheckBox;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-access$1400-(Lcom/android/server/LocationManagerService; Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onSetInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ims/ImsCall$ImsCallSessionListenerProxy;-callSessionHoldFailed-(Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/DeviceHost$TagEndpoint;-startPresenceChecking-(I Lcom/android/nfc/DeviceHost$TagDisconnectedCallback;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-getIccSimChallengeResponse-(I Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/MountServiceIdler;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/job/JobServiceContext$JobServiceHandler;-handleCancelH-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub;-systemRunning-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/RadioButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ContentResolver;-getIsSyncableAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-nvWriteCdmaPrl-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService;-interceptKeyBeforeDispatching-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)J' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-queryCLIP-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine$DriverStoppedState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/NfcAdapter;-setOnNdefPushCompleteCallback-(Landroid/nfc/NfcAdapter$OnNdefPushCompleteCallback; Landroid/app/Activity; [Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-launchAssistLongPressAction-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getGlobalLong-(Ljava/lang/String; J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/GlobalActions$GlobalActionsDialog;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/content/IContentService;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/accounts/AccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/os/SystemVibrator;-vibrate-(I Ljava/lang/String; J Landroid/media/AudioAttributes;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/app/IntentForwarderActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/trust/TrustManagerService;-dispatchUnlockAttempt-(Z I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/IBackupManager;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/AppChooserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/MmsServiceBroker$BinderService;-addTextMessageDraft-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothHeadsetClient;-close-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wifi/WifiStateMachine$DisconnectingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/content/SyncStorageEngine;-requestSync-(Landroid/accounts/Account; I I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/TelephonyRegistry;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordMinimumLetters-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager$CardEmulationInterface;-getAidGroupForService-(I Landroid/content/ComponentName; Ljava/lang/String;)Landroid/nfc/cardemulation/AidGroup;' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getRemoveWarning-(Landroid/content/ComponentName; Landroid/os/RemoteCallback; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker$3;-onCallMerged-(Lcom/android/ims/ImsCall; Lcom/android/ims/ImsCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Editor$SelectionEndHandleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-checkPassword-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-inputDispatchingTimedOut-(I Z Ljava/lang/String;)J' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/DialogTitle;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IUiAutomationConnection$Stub$Proxy;-connect-(Landroid/accessibilityservice/IAccessibilityServiceClient;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/cardemulation/DefaultRemovedActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowManager$Stub;-screenshotApplications-(Landroid/os/IBinder; I I I Z)Landroid/graphics/Bitmap;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$2400-(Lcom/android/server/wifi/WifiStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/BeamShareActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.VIBRATE'],
	'Landroid/media/MediaPlayer;-create-(Landroid/content/Context; Landroid/net/Uri;)Landroid/media/MediaPlayer;' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService;-restoreMasterVolume-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameFetch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/TtmlRenderingWidget;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-setWfdInfo-(Landroid/net/wifi/p2p/WifiP2pWfdInfo;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/WapPushOverSms;-isDuplicateNotification-(Landroid/content/Context; Lcom/google/android/mms/pdu/NotificationInd;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-setPropertiesByCarrier-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/DhcpStateMachine$WaitBeforeRenewalState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseAccountActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/ViewStub;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-requestShutdown-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/BatteryService;-updateBatteryWarningLevelLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayManagerService;-windowManagerAndInputReady-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/commands/settings/SettingsCmd;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ISub;-getSubInfoUsingSlotId-(I)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-getAdnRecordsInEfForSubscriber-(J I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setAutoTimeRequired-(Landroid/content/ComponentName; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager;-cancelActiveSync-(Lcom/android/server/content/SyncStorageEngine$EndPoint; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getIsimChallengeResponse-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/pm/PackageManagerService$MeasureParams;-startCopy-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Activity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-enforceCanManageCaCerts-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeech$Connection$SetupConnectionAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/handover/ConfirmConnectActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/MediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/app/admin/IDevicePolicyManager;-setActiveAdmin-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager;-performBootDexOpt-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Telephony$Sms;-addMessageToUri-(Landroid/content/ContentResolver; Landroid/net/Uri; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long; Z Z)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/DropBoxManager;-addData-(Ljava/lang/String; [B I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/PlatLogoActivity$1;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setRecommendedGlobalProxy-(Landroid/content/ComponentName; Landroid/net/ProxyInfo;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/wifi/WifiScanningServiceImpl$WifiChangeStateMachine;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-makeNetworkCapabilities-()Landroid/net/NetworkCapabilities;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setUserRestriction-(Landroid/content/ComponentName; Ljava/lang/String; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncStorageEngine;-clearAndReadState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/appwidget/AppWidgetServiceImpl$SecurityPolicy;-isProviderInCallerOrInProfileAndWhitelListed-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/display/DisplayManagerInternal;-setDisplayProperties-(I Z F Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/media/MediaSessionService$SessionManagerImpl;-startVoiceInput-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-getInitialDisplayDensity-(I)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/NetworkScoreManager;-updateScores-([Landroid/net/ScoredNetwork;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-playSoundEffect-(I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/AccessibilityWindowInfo;-getParent-()Landroid/view/accessibility/AccessibilityWindowInfo;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/ims/ImsCall$Listener;-onCallResumed-(Lcom/android/ims/ImsCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/trust/TrustManagerService$3;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl$2;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$2;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendActionDownAndUp-(Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/ReceiverRestrictedContext;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ims/internal/ImsCallSession$IImsCallSessionListenerProxy;-callSessionStartFailed-(Lcom/android/ims/internal/IImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiNetworkScoreCache;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordMinimumLowerCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCellBroadcastHandler;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-shutdownRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiController;-initializeAndRegisterForSettingsChange-(Landroid/os/Looper;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$TagService;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/nfc/handover/HandoverTransfer;-updateFileProgress-(F)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/telecom/InCallService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/dreams/DreamManagerService;-access$600-(Lcom/android/server/dreams/DreamManagerService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SubscriptionController;-clearDefaultsForInactiveSubIds-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getLine1AlphaTagForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/ISms$Stub;-getPreferredSmsSubscription-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager$CdmaBroadcastRangeManager;-tryAddRanges-(I I Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/ManagedServices;-onPackagesChanged-(Z [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/notification/ConditionProviderService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/IAudioService$Stub$Proxy;-disableSafeMediaVolume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-setLockPassword-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/MmsServiceBroker;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/IWallpaperManager;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/TimePickerSpinnerDelegate;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-cancelRequest-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine$EnabledState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyDataConnectionFailedForSubscriber-(J Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView$2;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/WifiDisplayController;-updateSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getIsimChallengeResponse-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SubscriptionManager;-getAllSubInfoCount-()I' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-reconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-setInstallLocation-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/SettingInjectorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/android/mms/pdu/PduPersister;-loadRecipients-(I Ljava/util/HashSet; Ljava/util/HashMap; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/PlatLogoActivity$2$1;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-updateMessageOnIccEf-(Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/wifi/WifiServiceImpl;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS', 'android.permission.SEND_SMS'],
	'Lcom/android/server/LockSettingsService;-systemReady-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getUidTagConfig-()Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings$Config;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/content/MutableContextWrapper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiServiceImpl;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPermittedInputMethodsForCurrentUser-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$WpsRunningState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms;-updateMessageOnIccEfForSubscriber-(J Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setProfileEnabled-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Landroid/inputmethodservice/ExtractButton;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/ResolverActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-performBootTimeout-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-setCellBroadcastActivation-(Z)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/ShutdownThread;-beginShutdownSequence-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-deleteAndCreatePhone-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/widget/LockPatternUtils;-getActivePasswordQuality-()I' : ['android.permission.READ_PROFILE'],
	'Landroid/accessibilityservice/IAccessibilityServiceConnection$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-iccTransmitApduBasicChannel-(I I I I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/server/wm/WindowManagerService;-resizeStack-(I Landroid/graphics/Rect;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$GroupCreatingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/DateTimeView$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-reportSmsMemoryStatus-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/accessibility/CaptioningManager;-notifyFontScaleChanged-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringLogger;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService;-create-(Landroid/content/Context;)Lcom/android/server/NsdService;' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setFrequencyBand-(I Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/accessibility/TouchExplorer$DoubleTapDetector;-onMotionEvent-(Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager$3;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/ConfirmConnectToWifiNetworkActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/tech/MifareClassic;-transfer-(I)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wallpaper/WallpaperManagerService;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-checkAddPermission-(Landroid/view/WindowManager$LayoutParams; [I)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-initSstIcc-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-sendDelayedMotionEvents-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-killApplicationWithAppId-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAudioSourceFunction-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager;-switchUser-(Landroid/content/ComponentName; Landroid/os/UserHandle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/BackgroundDexOptService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameBranch;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyCellLocation-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/PhoneNumberUtils;-isEmergencyNumberInternal-(Ljava/lang/String; Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$System;-getLong-(Landroid/content/ContentResolver; Ljava/lang/String;)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BroadcastQueue;-setBroadcastTimeoutLocked-(J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchUnhandledKey-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/SizeChangeEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ContextThemeWrapper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ViewFlipper;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-resumeGeofence-(I I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-createDisplayContentLocked-(Landroid/view/Display;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/IAccountManager;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/nfc/tech/IsoDep;-transceive-([B)[B' : ['android.permission.NFC'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-loadProvidersLocked-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipService$SipKeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-doVibratorOn-(J I I)V' : ['android.permission.VIBRATE'],
	'Landroid/widget/RadioButton;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IIntentReceiver$Stub;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/ILocationManager$Stub;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccountsAsUser-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/SpellChecker;-<init>-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-displayReady-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/power/PowerManagerService;-access$2100-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$19100-(Lcom/android/server/wifi/WifiStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/view/accessibility/CaptioningManager;-notifyUserStyleChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-removeUpdatesLocked-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-removeCrossProfileWidgetProvider-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-setScreenCaptureDisabled-(Landroid/content/ComponentName; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-getBaseDisplaySize-(I Landroid/graphics/Point;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wifi/WifiStateMachine$UntetheringState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumSymbols-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setPermittedInputMethods-(Landroid/content/ComponentName; Ljava/util/List;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/os/IHardwareService;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/nfc/NfcService;-onRemoteFieldActivated-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/app/ResolverActivity$1;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-handleSrvccStateChanged-([I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-close-(I)I' : ['android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/input/InputManagerService;-interceptKeyBeforeQueueing-(Landroid/view/KeyEvent; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager$Stub$Proxy;-getBaseDisplayDensity-(I)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-onDisconnect-(I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtilsCache;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextClock;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-reevaluateStatusBarVisibility-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/ReceiverRestrictedContext;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/hardware/location/IGeofenceHardware$Stub;-unregisterForMonitorStateChangeCallback-(I Landroid/hardware/location/IGeofenceHardwareMonitorCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getEnabledInputMethodSubtypeList-(Ljava/lang/String; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer$2;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CallManager;-acceptCall-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/dreams/DreamManagerInternal;-startDream-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/telephony/gsm/SmsMessage;-calculateLength-(Ljava/lang/CharSequence; Z)[I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmCellBroadcastHandler;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setCallWaiting-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayPowerController;-sendUpdatePowerStateLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/content/ContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/job/JobServiceContext;-executeRunnableJob-(Lcom/android/server/job/controllers/JobStatus;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/MmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/trust/TrustManagerService;-maybeEnableFactoryTrustAgents-(Lcom/android/internal/widget/LockPatternUtils; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager;-getAccountsAsUser-(I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-pollCallsWhenSafe-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$DisconnectedState;-enter-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-access$100-(Landroid/hardware/location/GeofenceHardwareImpl;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RemoteViewsService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumLowerCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/UiccSmsController;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService;-applyRouting-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-setApplicationHidden-(Landroid/content/ComponentName; Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-nvReadItem-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ActionBarContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/commands/svc/WifiCommand;-run-([Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/Editor$HandleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/service/dreams/DreamService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothHeadset;-close-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$System;-getLongForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/MountService;-access$2000-(Lcom/android/server/MountService;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-onUserContextChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ImageSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/SubscriptionManager;-getAllSubInfoList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyRepeatWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/connectivity/Tethering$StateReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncStorageEngine;-init-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/text/StringSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Instrumentation;-finish-(I Landroid/os/Bundle;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/ContextThemeWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService;-commitRouting-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-shutdownLocked-(I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getCurrentFailedPasswordAttempts-(I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setPropertiesByCarrier-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcCardEmulation$Stub;-isDefaultServiceForCategory-(I Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/media/IAudioService$Stub;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService;-updateProviderListenersLocked-(Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/ShutdownActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/policy/impl/ImmersiveModeConfirmation$ClingWindowView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-editProperties-(Ljava/lang/String; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/inputmethodservice/ExtractButton;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/LocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl$2;-onSomePackagesChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/ZenModeHelper;-updateZenMode-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setUiccSubscription-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$4;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/ActionMenuView$MenuBuilderCallback;-onMenuModeChange-(Lcom/android/internal/view/menu/MenuBuilder;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager;-addCrossProfileIntentFilter-(Landroid/content/ComponentName; Landroid/content/IntentFilter; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/wifi/WifiSettingsStore;-handleAirplaneModeToggled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/ChooserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/INetworkPolicyManager;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/DisableCarModeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/SearchView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState$ActingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-isAirplaneModeOn-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncManager$9;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setForegroundDispatch-(Landroid/app/PendingIntent; [Landroid/content/IntentFilter; Landroid/nfc/TechListParcel;)V' : ['android.permission.NFC'],
	'Landroid/widget/ToggleButton;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-<init>-(Lcom/android/internal/telephony/gsm/GSMPhone;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/ContentResolver;-setMasterSyncAutomaticallyAsUser-(Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/SubtitleController;-doSelectTrack-(Landroid/media/SubtitleTrack;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wallpaper/WallpaperManagerService$MyPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneMmiCode;-onQueryCfComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiController$NoLockHeldState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_PROFILE', 'android.permission.READ_SMS'],
	'Lcom/android/server/voiceinteraction/SoundTriggerHelper;-onRecognitionFailureLocked-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/NfcService$TagService;-reconnect-(I)I' : ['android.permission.NFC'],
	'Landroid/net/wifi/IWifiManager;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/updates/SmsShortCodesInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-updateCarrierMccMncConfiguration-(Ljava/lang/String; Ljava/lang/String; Landroid/content/Context;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/media/MediaPlayer;-deselectTrack-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-access$000-(Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TextViewWithCircularIndicator;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-validatePrinters-(Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onCleanUpConnection-(Z I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/ManagedServices;-rebindServices-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/IWifiP2pManager$Stub$Proxy;-getP2pStateMachineMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-processLockedState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-isLockTaskPermitted-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/MccTable;-setSystemLocale-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-disableDataCallInEmergencyCall-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/Connection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DigitalClock;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccSmsController;-sendData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/base/NullFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/media/MediaBrowserService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/handover/ConfirmConnectActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-getAutoTime-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/Context;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeechService$SynthesisToFileOutputStreamSpeechItemV1;-<init>-(Landroid/speech/tts/TextToSpeechService; Ljava/lang/Object; I I Landroid/os/Bundle; Ljava/lang/String; Ljava/lang/CharSequence; Ljava/io/FileOutputStream;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-getWifiApState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/EditText;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AutoCompleteTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-createPrinterDiscoverySession-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStack;-resetTaskIfNeededLocked-(Lcom/android/server/am/ActivityRecord; Lcom/android/server/am/ActivityRecord;)Lcom/android/server/am/ActivityRecord;' : ['android.permission.SEND_SMS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/ims/ImsCall$ImsCallSessionListenerProxy;-callSessionStartFailed-(Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-updateConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/tech/MifareUltralight;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Landroid/view/IWindowManager$Stub;-inputMethodClientHasFocus-(Lcom/android/internal/view/IInputMethodClient;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiStateMachine$InitialState;-enter-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-nvWriteItem-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/backup/BackupManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/TextClock;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/notification/NotificationManagerService;-access$3300-(Lcom/android/server/notification/NotificationManagerService; Lcom/android/server/notification/NotificationRecord;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothManager;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/os/IVibratorService$Stub;-vibrate-(I Ljava/lang/String; J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcRetryingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$3;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/AccessibilityController;-onSomeWindowResizedOrMovedLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager;-getAggressiveHandover-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/INfcTag;-transceive-(I [B Z)Landroid/nfc/TransceiveResult;' : ['android.permission.NFC'],
	'Landroid/media/AsyncPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-updateProgramWithTarget-(I Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent;-doRestoreFinished-(I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/Application;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager;-isRotationFrozen-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/NumberPicker;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardwareService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$P2pNotSupportedState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/SubtitleController;-doShow-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendSMS-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-getCurrentSyncsAsUser-(I)Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$9800-(Lcom/android/server/wifi/WifiStateMachine;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/BeamShareActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/storage/DeviceStorageMonitorService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/NfcRootActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/dreams/DreamManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayPowerController;-access$1000-(Lcom/android/server/display/DisplayPowerController; J Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/ListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-getPackageSizeInfo-(Ljava/lang/String; I Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Landroid/provider/Settings$System;-getInt-(Landroid/content/ContentResolver; Ljava/lang/String; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/SmsBroadcastUndelivered;-scanRawTable-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/power/PowerManagerService;-handleSettingsChangedLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/provider/Browser;-deleteHistoryTimeFrame-(Landroid/content/ContentResolver; J J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/nfc/NfcAdapter$1;-onPaused-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/IAccountManager;-removeAccountAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/speech/IRecognitionService;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/ProgramPort;-pushFrame-(Landroid/filterfw/core/Frame;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/UiccSmsController;-copyMessageToIccEfForSubscriber-(J Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/SubscriptionController;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-addMultimediaMessageDraft-(Ljava/lang/String; Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/RIL;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-sendIntentEnter-(Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordMinimumUpperCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cat/IconLoader;-readId-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-syncClirSetting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-clearWakeLock-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Global;-getInt-(Landroid/content/ContentResolver; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/app/StatusBarManager;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-shutdownRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/MultiAutoCompleteTextView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-handleInjectSms-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-getCellLocationId-()I' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FieldPort;-setFieldFrame-(Landroid/filterfw/core/Frame; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IVibratorService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/server/InputMethodManagerService;-updateKeyboardFromSettingsLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-getDeviceIdentity-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub$Proxy;-getPreferredOptionsPanelGravity-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-onReady-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateCmdParamsReady;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getCdmaSubscriptionSource-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/appops/AppOpsCommand;-main-([Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-<init>-(Landroid/content/Context; I I Ljava/lang/Integer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$OngoingGroupRemovalState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/backup/SystemBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/PrinterDiscoverySession;-validatePrinters-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DialerFilter;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/INfcCardEmulation$Stub$Proxy;-setDefaultForNextTap-(I Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ethernet/EthernetServiceImpl;-enforceAccessPermission-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/EditText;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-syncDeviceCapabilitiesLocked-(Lcom/android/server/devicepolicy/DevicePolicyManagerService$DevicePolicyData;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/Filter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateUtils;-getRelativeTimeSpanString-(J J J)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncStorageEngine;-setSyncAutomatically-(Landroid/accounts/Account; I Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/cardemulation/HostApduService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Presentation$1;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub$1;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-onLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Service;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-handleSimRefresh-(Lcom/android/internal/telephony/uicc/IccRefreshResponse;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/ForegroundUtils;-onForegroundActivitiesChanged-(I I Z)V' : ['android.permission.VIBRATE'],
	'Landroid/widget/StackView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/lights/LightsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/server/WiredAccessoryManager;-onSystemReady-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/PreferenceActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setVoiceCallForwardingFlag-(I Z Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-sendRetrySms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/content/IContentService$Stub$Proxy;-syncAsUser-(Landroid/content/SyncRequest; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/speech/tts/TextToSpeechService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/net/NetworkStatsService;-getNetworkTotalBytes-(Landroid/net/NetworkTemplate; J J)J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getCrossProfileWidgetProviders-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/gsm/SmsManager;-copyMessageToSim-([B [B I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderLocation-(Ljava/lang/String; Landroid/location/Location;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-downloadMessage-(J Ljava/lang/String; Ljava/lang/String; Landroid/net/Uri; Landroid/os/Bundle; Landroid/app/PendingIntent;)V' : ['android.permission.RECEIVE_MMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-finishWindowsDrawn-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/Instrumentation;-getUiAutomation-()Landroid/app/UiAutomation;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/TextClock;-setFormat24Hour-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ScrollingTabContainerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/display/DisplayManagerService;-requestGlobalDisplayStateInternal-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/MediaController;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/ValidateNotificationPeople;-resolvePhoneContact-(Landroid/content/Context; Ljava/lang/String;)Lcom/android/server/notification/ValidateNotificationPeople$LookupResult;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/net/NetworkStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-removeActiveAdmin-(Landroid/content/ComponentName; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-access$3900-(Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/statusbar/StatusBarManagerService;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/app/ContextImpl;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-getNetworkCapabilities-(Ljava/lang/String;)Landroid/net/NetworkCapabilities;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager$ActiveSyncContext;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/notification/NotificationListenerService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/RttService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/trust/TrustManagerService$3;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getDataConnectionState-(Ljava/lang/String;)Lcom/android/internal/telephony/PhoneConstants$DataState;' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcTag;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ApplicationPackageManager;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-makeInboundSmsHandler-(Landroid/content/Context; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;)Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/SubtitleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-nvResetConfig-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActiveServices;-realStartServiceLocked-(Lcom/android/server/am/ServiceRecord; Lcom/android/server/am/ProcessRecord; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/WakeGestureListener;-onWakeUp-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/inputmethod/InputMethodManager;-getCurrentInputMethodSubtype-()Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager;-getDefaultServiceForCategory-(I Ljava/lang/String; Z)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub$Proxy;-getLastInputMethodSubtype-()Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-dial-(Ljava/lang/String; I I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getRemoveWarning-(Landroid/content/ComponentName; Landroid/os/RemoteCallback; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$Global;-getLong-(Landroid/content/ContentResolver; Ljava/lang/String;)J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/FrameBranch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothManager;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wifi/WifiStateMachine$DefaultState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/tech/MifareUltralight;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/server/accounts/AccountManagerService;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDisconnectingState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/DayPickerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ActionBarView$HomeView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService$4;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/uicc/IsimUiccRecords;-getIccSimChallengeResponse-(I Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-getScanResults-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wm/AccessibilityController;-setWindowsForAccessibilityCallback-(Landroid/view/WindowManagerInternal$WindowsForAccessibilityCallback;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/handover/ConfirmConnectActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordExpirationTimeout-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/handover/ConfirmConnectActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/test/mock/MockContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/CropFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DropBoxManagerService$1$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendUpForInjectedDownPointers-(Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/textservice/TextServicesManager;-newSpellCheckerSession-(Landroid/os/Bundle; Ljava/util/Locale; Landroid/view/textservice/SpellCheckerSession$SpellCheckerSessionListener; Z)Landroid/view/textservice/SpellCheckerSession;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/content/IContentService$Stub$Proxy;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/nfc/tech/NdefFormatable;-formatReadOnly-(Landroid/nfc/NdefMessage;)V' : ['android.permission.NFC'],
	'Landroid/net/wifi/IWifiManager$Stub;-getAggressiveHandover-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/preference/SeekBarVolumizer;-<init>-(Landroid/content/Context; I Landroid/net/Uri; Landroid/preference/SeekBarVolumizer$Callback;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-finishKeyguardDrawn-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/dreams/DreamManagerService$6;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getIccSerialNumberForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendMotionEvent-(Landroid/view/MotionEvent; I I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/AbsSpinner;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-access$800-(Lcom/android/internal/policy/impl/PhoneWindowManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IMms;-deleteStoredMessage-(Ljava/lang/String; Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-screenTurningOn-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/IContentService;-getIsSyncableAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/service/voice/VoiceInteractionService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkStatsService;-internalGetSummaryForNetwork-(Landroid/net/NetworkTemplate; J J)Landroid/net/NetworkStats;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-changeIccLockPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/ims/ImsCall;-notifyConferenceStateUpdated-(Lcom/android/ims/ImsConferenceState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-getPackageSizeInfo-(Ljava/lang/String; I Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/server/backup/FullBackupJob;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayBlanker;-requestDisplayState-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/backup/BackupManagerService$PerformFullTransportBackupTask$SinglePackageBackupRunner;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService$28;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/CantAddAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-addGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/Ringtone;-getTitle-(Landroid/content/Context; Landroid/net/Uri; Z)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy;-screenTurningOn-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCall;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/MifareUltralight;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-getIMEISV-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumLetters-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-getVoiceRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-requestSyncAsUser-(Landroid/accounts/Account; Ljava/lang/String; I Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/widget/DateTimeView;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/content/ContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accessibilityservice/AccessibilityService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/RenamingDelegatingContext;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/AlarmManagerService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-access$5200-(Lcom/android/server/power/PowerManagerService; I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/Session;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-observe-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/NativeActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/SearchView$SearchAutoComplete;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager;-access$900-(Lcom/android/server/content/SyncManager; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/Button;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-isDataPossible-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager;-removeUpdates-(Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager;-getInitialDisplaySize-(I Landroid/graphics/Point;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/preference/PreferenceActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-doRecovery-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-prepare-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/ViewGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getCrossProfileWidgetProviders-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-loadMediaPackages-(Landroid/util/ArrayMap; [I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState;-access$1200-(Lcom/android/internal/telephony/dataconnection/DcSwitchState; Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-onActionTapAndHold-(Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-scanInternalSubtitleTracks-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-updateProgramWithTarget-(I Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RemoteViewsService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/RestrictionsPinActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings;-getUidTagPersistBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-toStringSimple-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$000-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-cleanUpRemovedTaskLocked-(Lcom/android/server/am/TaskRecord; Landroid/content/ComponentName; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/text/StringLogger;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncStorageEngine;-setIsSyncable-(Landroid/accounts/Account; I Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onCreate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-enableScreenAfterBoot-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/SmsApplication;-setDefaultApplicationInternal-(Ljava/lang/String; Landroid/content/Context; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-setAppCallback-(Landroid/nfc/IAppCallback;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/ISms;-getAllMessagesFromIccEfForSubscriber-(J Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/InputMethodManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/wm/WindowManagerService;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISub;-clearDefaultsForInactiveSubIds-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/hdmi/HdmiControlService;-onWakeUp-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker$ApnChangeObserver;-onChange-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/TelephonyRegistry;-listenForSubscriber-(J Ljava/lang/String; Lcom/android/internal/telephony/IPhoneStateListener; I Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-dispatchMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/notification/ConditionProviders;-<init>-(Landroid/content/Context; Landroid/os/Handler; Lcom/android/server/notification/ManagedServices$UserProfiles; Lcom/android/server/notification/ZenModeHelper;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-getNetworkCapabilities-(Ljava/lang/String;)Landroid/net/NetworkCapabilities;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-disableCellBroadcastRangeForSubscriber-(J I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/base/InputStreamSource;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-scanAvailableAsecs-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IMediaHTTPConnection$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.INTERNET'],
	'Lcom/android/server/wm/WindowManagerService;-makeWindowFreezingScreenIfNeededLocked-(Lcom/android/server/wm/WindowState;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-setCurrentSpellChecker-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/accessibility/TouchExplorer;-handleMotionEventGestureDetecting-(Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/base/FrameStore;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/sip/SipWakeLock;-acquire-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-getPersistedDeviceName-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Telephony$Sms$Inbox;-addMessage-(J Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long; Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getAccountTypesWithManagementDisabledAsUser-(I)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ShutdownActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/accounts/AccountManagerService;-checkAuthenticateAccountsPermission-(Landroid/accounts/Account;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/accounts/AccountAuthenticatorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-getPreferredOptionsPanelGravity-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-hangup-(Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/media/Media;-main-([Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/app/AlertController$RecycleListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/power/PowerManagerService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncStorageEngine;-<init>-(Landroid/content/Context; Ljava/io/File;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/AutoFixEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateImsPhone-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/am/CompatModePackages;-setFrontActivityScreenCompatModeLocked-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl$SipKeepAlive;-onError-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiNotificationController;-<init>-(Landroid/content/Context; Lcom/android/server/wifi/WifiStateMachine;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-updateResizingWindows-(Lcom/android/server/wm/WindowState;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL$1;-onDisplayChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ImageButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/AppChooserActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService;-onConnectivityChanged-(Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/DragState;-unregister-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-startPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/InputStreamSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowState;-hideLw-(Z Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-nvReadItem-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/TabActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-loadSettingsLocked-(Lcom/android/server/devicepolicy/DevicePolicyManagerService$DevicePolicyData; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/MmsServiceBroker$BinderService;-importMultimediaMessage-(Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; J Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPattern-(Ljava/util/List; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/handover/HandoverService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub$Proxy;-reportLocation-(Landroid/location/Location; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-isApnTypeAvailable-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-setRingerMode-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$7;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/LocalePicker;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setMaximumFailedPasswordsForWipe-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-processUnsolicited-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager$CardEmulationInterface;-setPreferredService-(Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/server/wifi/WifiServiceImpl;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/BluetoothManagerService;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager$CardEmulationInterface;-setDefaultServiceForCategory-(I Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getLastSubtypeForInputMethodLocked-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/WakeLockStateMachine$IdleState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-nvWriteItem-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/SearchView$SearchAutoComplete;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/DhcpStateMachine$DefaultState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/SubtitleController$Renderer;-createTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderEnabled-(Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/content/ContentResolver;-setSyncAutomaticallyAsUser-(Landroid/accounts/Account; Ljava/lang/String; Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getXtPersistBytes-(J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/UiModeManagerService$4;-onTwilightStateChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/nfc/BeamShareActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/FragmentBreadCrumbs;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/google/android/mms/pdu/PduPersister;-load-(Landroid/net/Uri;)Lcom/google/android/mms/pdu/GenericPdu;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/server/backup/BackupManagerService$Lifecycle;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccountAsUser-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle; I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/telecom/ConnectionService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService;-switchUserLocked-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-shutdown-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/MmsServiceBroker;-access$800-()Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/content/IContentService;-getMasterSyncAutomaticallyAsUser-(I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/text/ToUpperCase;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDisconnectionErrorCreatingConnection;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/backup/PackageManagerBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getImei-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/webkit/WebViewUpdateService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-getUnknownSourcesSettings-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayAdapter$1;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/hardware/location/GeofenceHardware;-unregisterForMonitorStateChangeCallback-(I Landroid/hardware/location/GeofenceHardwareMonitorCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/Phone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DigitalClock;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SubscriptionController;-setDisplayNumberFormat-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityManagerService$Lifecycle;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getIccSimChallengeResponse-(J I Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub;-syncAsUser-(Landroid/content/SyncRequest; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker$4;-onCallMerged-(Lcom/android/ims/ImsCall; Lcom/android/ims/ImsCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountAuthenticatorActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/Switch;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/dreams/DreamManagerService;-access$1700-(Lcom/android/server/dreams/DreamManagerService; Landroid/os/IBinder; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-openToReceiveCalls-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NetworkTimeUpdateService;-onPollNetworkTime-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/NetInitiatedActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-access$1100-(Lcom/android/server/pm/PackageManagerService;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/SizeAdaptiveLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneFactory;-getSMSSubscription-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/tv/TvInputManagerService$1;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordExpiration-(Landroid/content/ComponentName; I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-wakingUp-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceTransition-(I I D D D F F F J I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-addCrossProfileWidgetProvider-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BatteryService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readEnabledAccessibilityServicesLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-changeIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState$IdleState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/LockPatternUtils;-isLockPasswordEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-setCurrentSpellCheckerSubtype-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService$DefaultNetworkStatsSettings;-getDevConfig-()Lcom/android/server/net/NetworkStatsService$NetworkStatsSettings$Config;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getCrossProfileCallerIdDisabledForUser-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/DisableCarModeActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-hangup-(Lcom/android/internal/telephony/imsphone/ImsPhoneCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.RECEIVE_SMS'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordMinimumLength-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-isDeviceProvisioned-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-killApplication-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/display/DisplayPowerController$ScreenOnUnblocker;-onScreenOn-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/print/IPrintManager$Stub$Proxy;-startPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker$3;-onCallStartFailed-(Lcom/android/ims/ImsCall; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$VolumeStreamState;-readSettings-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/INotificationManager;-setZenModeConfig-(Landroid/service/notification/ZenModeConfig;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/MifareUltralight;-writePage-(I [B)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateCarrierMccMncConfiguration-(Ljava/lang/String; Ljava/lang/String; Landroid/content/Context;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-access$200-(Lcom/android/server/accessibility/ScreenMagnifier;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/ExtractButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/PreferenceImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/IActivityManager;-killUid-(I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-sendP2pStateChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/cardemulation/AidRoutingManager;-clearNfcRoutingTableLocked-()V' : ['android.permission.VIBRATE'],
	'Landroid/location/LocationManager;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setActiveAdmin-(Landroid/content/ComponentName; Z I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-isApplicationHidden-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-handleOnMagnifiedBoundsChanged-(Landroid/graphics/Region;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/accounts/AccountManagerService$GetAccountsByTypeAndFeatureSession;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/ILockSettings;-checkPassword-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IMms;-downloadMessage-(J Ljava/lang/String; Ljava/lang/String; Landroid/net/Uri; Landroid/os/Bundle; Landroid/app/PendingIntent;)V' : ['android.permission.RECEIVE_MMS'],
	'Lcom/android/nfc/TechListChooserActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NsdService$NsdStateMachine$DefaultState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCellLocation-()Landroid/telephony/CellLocation;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/WeightedLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/PendingIntent$FinishedDispatcher;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/AccessibilityController;-onRotationChangedLocked-(Lcom/android/server/wm/DisplayContent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-performLayoutAndPlaceSurfacesLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneFactory;-isPromptEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/Filter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$1;-onDeleteGroup-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-registerContentObservers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RadioButton;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/google/android/mms/util/PduCache;-put-(Landroid/net/Uri; Lcom/google/android/mms/util/PduCacheEntry;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/service/dreams/Sandman;-isScreenSaverActivatedOnDock-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-getChannelList-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-switchHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiStateMachine$SupplicantStoppingState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/textservice/SpellCheckerService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleSrvccStateChanged-([I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/CrossProcessEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcCardEmulation$Stub;-setDefaultForNextTap-(I Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/view/WindowManagerInternal;-waitForAllWindowsDrawn-(Ljava/lang/Runnable; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternUtils;-getAppWidgets-(I)[I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-updateMessageOnIccEfForSubscriber-(J Ljava/lang/String; I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/widget/VideoView;-resume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl;-access$1600-(Lcom/android/server/sip/SipSessionGroup$SipSessionImpl; Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wallpaper/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/server/wm/WindowManagerService;-startAppFreezingScreenLocked-(Lcom/android/server/wm/AppWindowToken;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$P2pEnabledState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ISyncStatusObserver$Stub$Proxy;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService$Receiver;-<init>-(Lcom/android/server/LocationManagerService; Landroid/location/ILocationListener; Landroid/app/PendingIntent; I I Ljava/lang/String; Landroid/os/WorkSource; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/dhimpl/NativeNfcManager;-notifyRfFieldDeactivated-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-getNetworkQuotaInfoUnchecked-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/nfc/handover/HandoverService;-access$000-(Lcom/android/nfc/handover/HandoverService; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/Call;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/UserManager;-isUserSwitcherEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-removeGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/DialogTitle;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordMinimumNonLetter-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/NetInitiatedActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-changeIccFdnPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsUsageMonitor; Lcom/android/internal/telephony/ImsSMSDispatcher;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/updates/CertPinInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService;-access$1000-(Lcom/android/server/BluetoothManagerService;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-getCrossProfileWidgetProviders-(Landroid/content/ComponentName;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService;-access$200-(Lcom/android/server/accounts/AccountManagerService; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/power/ShutdownThread;-shutdown-(Landroid/content/Context; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/WindowAnimator$1;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-handleRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ExpandableListView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LinearLayoutWithDefaultTouchRecepient;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$AmsTask;-doWork-()V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcastRange-(I I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-handleVoicemailTeleservice-(Lcom/android/internal/telephony/cdma/SmsMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$7;-onSwipeFromBottom-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-restartDataStallAlarm-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Chronometer;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$GroupNegotiationState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/monkey/MonkeyEventSource;-getNextEvent-()Lcom/android/commands/monkey/MonkeyEvent;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccCard;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri;)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/os/IPowerManager;-acquireWakeLockWithUid-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/IccCard;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/job/JobService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/content/SyncManager$8;-onServiceChanged-(Ljava/lang/Object; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wifi/RttService$RttServiceImpl$RttStateMachine$EnabledState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/text/format/DateFormat;-is24HourFormat-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccountsByTypeAsUser-(Ljava/lang/String; Landroid/os/UserHandle;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/AccountManager$1;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getChannelList-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/MutableContextWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/MultiAutoCompleteTextView;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Z Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayPowerController;-setScreenState-(I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/preference/PreferenceActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-startPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-access$1100-(Lcom/android/server/InputMethodManagerService;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/IntentForwarderActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/tech/NfcBarcode;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/WakeLockStateMachine;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/ObjectSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub$Proxy;-setMicrophoneMute-(Z Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccountsForPackage-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityStackSupervisor;-pauseBackStacks-(Z Z Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService$UpdateRecord;-disposeLocked-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NfcBarcode;-reconnect-()V' : ['android.permission.NFC'],
	'Lcom/android/nfc/P2pEventListener;-onP2pHandoverNotSupported-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/InputMethodManagerService;-updateInputMethodsFromSettingsLocked-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/LauncherActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/content/ContentService;-syncAsUser-(Landroid/content/SyncRequest; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/SubtitleController;-addTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/handover/HandoverService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager;-addGpsMeasurementsListener-(Landroid/location/IGpsMeasurementsListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-notifyCellInfo-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-showPreview-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/telephony/SmsManager;-archiveStoredConversation-(J Z)Z' : ['android.permission.WRITE_SMS'],
	'Landroid/view/IWindowSession;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService$1;-getHistoryForNetwork-(Landroid/net/NetworkTemplate; I)Landroid/net/NetworkStatsHistory;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothAdapter;-getProfileProxy-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/P2pEventListener;-onP2pResumeSend-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/wm/WindowManagerService;-performLayoutAndPlaceSurfacesLockedInner-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-access$200-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Landroid/content/Intent; Ljava/lang/String; Landroid/content/IIntentReceiver; I Ljava/lang/String; Landroid/os/Bundle; Ljava/lang/String; I Z Z I I I)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-cleanUpAllConnections-(Z Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider$7;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/dataconnection/DcTrackerBase;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/BootReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-startCustomizedScan-(Landroid/net/wifi/ScanSettings; Landroid/os/WorkSource;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-notifySignalStrength-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/IsimUiccRecords;-handleIsimRefresh-(Lcom/android/internal/telephony/uicc/IccRefreshResponse;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RadioButton;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsUsageMonitor; Lcom/android/internal/telephony/ImsSMSDispatcher;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/WaveView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$InitialState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/provider/Settings$Global;-getLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onSetDependencyMet-(Ljava/lang/String; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms$Stub;-deleteStoredConversation-(Ljava/lang/String; J)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/widget/ActionBarOverlayLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcRootActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setStorageEncryption-(Landroid/content/ComponentName; Z I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/app/UiAutomation;-connect-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/MifareUltralight;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendNewSubmitPdu-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/SmsHeader; I Landroid/app/PendingIntent; Landroid/app/PendingIntent; Z Ljava/util/concurrent/atomic/AtomicInteger; Ljava/util/concurrent/atomic/AtomicBoolean; Landroid/net/Uri;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeIccPin2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/AccessibleDateAnimator;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService;-sync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/GlobalActions;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/nfc/NfcRootActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-comeOutOfSleepIfNeededLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/AutoCompleteTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/TextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$UntetheringState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameSource;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowStateAnimator;-commitFinishDrawingLocked-(J)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendSMSExpectMore-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-getFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-updateConfigurationLocked-(Landroid/content/res/Configuration; Lcom/android/server/am/ActivityRecord; Z Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-handleStartNetStatPoll-(Lcom/android/internal/telephony/DctConstants$Activity;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getSupportedFeatures-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/power/PowerManagerService$BinderService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ISub$Stub;-getSubInfoUsingSlotId-(I)Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/display/AutomaticBrightnessController$Callbacks;-updateBrightness-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/AgendaWindowAdapter;-buildQueryUri-(I I)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/commands/dpm/Dpm;-run-([Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/nfc/NfcService$TagService;-transceive-(I [B Z)Landroid/nfc/TransceiveResult;' : ['android.permission.NFC'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncActivityTooManyDeletes;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/media/MediaSessionService;-enforceMediaPermissions-(Landroid/content/ComponentName; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BitmapSource;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DropBoxManagerService;-add-(Landroid/os/DropBoxManager$Entry;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent$Stub;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-backgroundServicesFinishedLocked-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/IsimUiccRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/ManagedServices$SettingsObserver;-<init>-(Lcom/android/server/notification/ManagedServices; Landroid/os/Handler; Lcom/android/server/notification/ManagedServices$1;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-getAutoTime-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/NetworkTimeUpdateService$SettingsObserver;-observe-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/WebVttRenderingWidget;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/trust/TrustAgentService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getLine1AlphaTagForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/telephony/SubscriptionManager;-clearDefaultsForInactiveSubIds-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/provider/Contacts$People;-queryGroups-(Landroid/content/ContentResolver; J)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/BluetoothManagerService;-registerStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/WakeLockStateMachine;-handleSmsMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-unregisterListener-(Landroid/location/LocationListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Settings$Secure;-getLongForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService;-access$1000-(Lcom/android/server/net/NetworkStatsService; [I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setProfileEnabled-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/textservice/SpellCheckerService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService;-acquireWakeLockInternal-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; Landroid/os/WorkSource; Ljava/lang/String; I I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/GLTextureTarget;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/P2pEventManager;-onP2pNfcTapRequested-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onDataStallAlarm-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ims/ImsCall$ImsCallSessionListenerProxy;-callSessionStarted-(Lcom/android/ims/internal/ImsCallSession; Lcom/android/ims/ImsCallProfile;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-startDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/notification/NotificationListenerService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/WebVttRenderingWidget$SpanLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-requestLoadAllAdnLike-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/hdmi/HdmiControlService;-onInitializeCecComplete-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService;-readPersistedSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-getDhcpInfo-()Landroid/net/DhcpInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/provider/Settings$System;-getShowGTalkServiceStatus-(Landroid/content/ContentResolver;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneFactory;-isSMSPromptEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityManagerService$28;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/CallbackFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/view/IInputMethodManager;-getEnabledInputMethodSubtypeList-(Ljava/lang/String; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/RegisteredServicesCache;-removeAidGroupForService-(I I Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/NetworkPolicyManager;-setRestrictBackground-(Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/INfcCardEmulation;-unsetPreferredService-()Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodsAndSubtypeListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-dispose-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/input/InputManagerService; Z Z Z Lcom/android/server/wm/WindowManagerService$1;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService;-removeUserLocked-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/google/android/mms/pdu/PduPersister;-getPendingMessages-(J)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getWifiServiceMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/IContentService;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/nfc/P2pLinkManager$SendTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/ListPopupWindow$DropDownListView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TelephonyRegistry;-broadcastDataConnectionStateChanged-(I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; Z J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService;-access$2400-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/media/projection/MediaProjectionManagerService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-finishScreenTurningOn-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/app/ChooserActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebViewFactory;-prepareWebViewInSystemServer-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getPasswordQuality-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-startDataStallAlarm-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService;-onRemoteEndpointDiscovered-(Lcom/android/nfc/DeviceHost$TagEndpoint;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/INetworkScoreService;-disableScoring-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase$3;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getLastInputMethodSubtype-()Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getIsimChallengeResponse-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppCrashLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/statusbar/StatusBarManagerService;-enforceExpandStatusBar-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/BluetoothManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/admin/IDevicePolicyManager;-setTrustAgentFeaturesEnabled-(Landroid/content/ComponentName; Landroid/content/ComponentName; Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/PrinterDiscoverySession;-stopPrinterStateTracking-(Landroid/print/PrinterId;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-sendDtmf-(C Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/BluetoothManagerService;-loadStoredNameAndAddress-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/hardware/location/IGeofenceHardware;-unregisterForMonitorStateChangeCallback-(I Landroid/hardware/location/IGeofenceHardwareMonitorCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService$1$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/WallpaperManager;-suggestDesiredDimensions-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/BeamShareActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/voice/VoiceInteractionService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-nvResetConfig-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-restartPrintJob-(Landroid/print/PrintJobId; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/cardemulation/AppChooserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-isUninstallBlocked-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WaveView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/NumberPicker$CustomEditText;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenByFeatures-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/app/Activity; Landroid/os/Bundle; Landroid/os/Bundle; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-reportSuccessfulPasswordAttempt-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/UiccPhoneBookController;-updateAdnRecordsInEfBySearchForSubscriber-(J I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-getPasswordMinimumUpperCase-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/IWifiP2pManager;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/StatusBarManager;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/widget/Chronometer;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/ResolverActivity$1;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-updateExternalState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setPreferredVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$Receiver;-access$1500-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-<init>-(Landroid/content/Context; Landroid/speech/tts/TextToSpeech$OnInitListener; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService$Stub;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-removeProximityAlert-(Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-shutdownRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-(J)Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub;-switchImplementationIfNeededLocked-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/ScreenMagnifier$MagnifiedContentInteractonStateHandler;-onScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/accounts/AccountManagerService$9;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/speech/tts/TextToSpeechService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/app/LauncherActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService;-adjustSuggestedStreamVolume-(I I I Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/SpeechRecognizer;-destroy-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-requestShutdown-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/test/SyncBaseInstrumentation;-cancelSyncsandDisableAutoSync-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-setUiccSubscription-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/print/IPrintManager;-getInstalledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/WakeLockStateMachine;-<init>-(Ljava/lang/String; Landroid/content/Context; Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/fingerprint/FingerprintService;-handleNotify-(I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityRecord;-keyDispatchingTimedOut-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/telephony/SubscriptionManager;-setColor-(I J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onSomePackagesChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager$SyncHandler;-runSyncFinishedOrCanceledLocked-(Landroid/content/SyncResult; Lcom/android/server/content/SyncManager$ActiveSyncContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager;-getKeyguardDisabledFeatures-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-incrementPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/VpnService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/content/SyncManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accounts/AccountManagerService;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/InputMethodManagerService;-getCurrentInputMethodSubtype-()Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub;-archiveStoredConversation-(Ljava/lang/String; J Z)Z' : ['android.permission.WRITE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-acquireMulticastLock-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-getActiveSubInfoCount-()I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/hdmi/HdmiControlService;-registerContentObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/ActivityView;-release-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ExpandableListActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wifi/WifiController;-readStayAwakeConditions-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/StateMachine;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AppSecurityPermissions$PermissionItemView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-setVoiceCallForwardingFlag-(I Z Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncManager$SyncHandler;-dispatchSyncOperation-(Lcom/android/server/content/SyncOperation;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/TimePicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object; J)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$5600-(Lcom/android/server/accessibility/AccessibilityManagerService; Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-trySetupData-(Lcom/android/internal/telephony/dataconnection/ApnContext;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/NetworkScoreService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipAudioCall$1;-onError-(Landroid/net/sip/SipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-registerForScanModeChange-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/widget/MultiAutoCompleteTextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/CallbackFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onSetPolicyDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-access$000-(Lcom/android/server/devicepolicy/DevicePolicyManagerService; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-getBluetoothHeadset-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/commands/ime/Ime;-runList-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/text/StringSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/telephony/SubscriptionManager;-clearSubInfo-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/location/LocationFudger;-<init>-(Landroid/content/Context; Landroid/os/Handler;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/content/PackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-sendSMSExpectMore-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/InputMethodManagerService;-getEnabledInputMethodSubtypeList-(Ljava/lang/String; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WeightedLinearLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/content/PackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/job/JobService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/backup/IBackupManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/TimePickerClockDelegate;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceAddStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/SystemServer;-performPendingShutdown-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Phone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/BroadcastQueue;-scheduleBroadcastsLocked-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/ActivityManagerNative;-moveTaskToBack-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/commands/am/Am;-onRun-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES'],
	'Landroid/provider/Telephony$Mms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub$1;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/DigitalClock$FormatChangeObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-access$900-(Lcom/android/internal/telephony/InboundSmsHandler; Landroid/content/Intent;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS'],
	'Landroid/media/AudioService$ScoClient;-clearCount-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/PreferredServices;-onHostEmulationDeactivated-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-addTrackerToRawTableAndSendMessage-(Lcom/android/internal/telephony/InboundSmsTracker;)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrashInner-(Ljava/lang/String; Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/AppWindowAnimator;-showAllWindowsLocked-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/gsm/GsmCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/test/mock/MockContentResolver;-getIsSyncableAsUser-(Landroid/accounts/Account; Ljava/lang/String; I)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/TtmlTrack;-hide-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/base/FrameStore;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-blockingGetAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/backup/BackupManagerService$RunBackupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService;-onLlcpLinkActivated-(Lcom/android/nfc/DeviceHost$NfcDepEndpoint;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/nfc/P2pLinkManager;-onManualBeamInvoke-(Landroid/nfc/BeamShareData;)V' : ['android.permission.VIBRATE'],
	'Landroid/view/IWindowManager;-startFreezingScreen-(I I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/print/IPrintManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothManager;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/am/ActivityStackSupervisor$ActivityContainer;-release-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/twilight/TwilightService$LocationHandler;-enableLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/backup/FullBackupJob;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ApplicationPackageManager;-getPackageSizeInfo-(Ljava/lang/String; I Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAvrcpController;-close-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/sip/SipSessionGroup;-processDialogTerminated-(Ljavax/sip/DialogTerminatedEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall;-grabWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/text/StringLogger;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/NfcAdapter;-setBeamPushUris-([Landroid/net/Uri; Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-enableSystemAppWithIntent-(Landroid/content/ComponentName; Landroid/content/Intent;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setDataAllowed-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-dialInternal-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/DialogTitle;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-writeInboxMessage-(Landroid/content/Intent;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS'],
	'Landroid/filterfw/core/GraphRunner;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/RenamingDelegatingContext;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/IsolatedContext;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/location/GpsLocationProvider;-checkSmsSuplInit-(Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ActivityManagerNative;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onRegistrationTimeout-(Landroid/net/sip/ISipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IVibratorService$Stub$Proxy;-vibrate-(I Ljava/lang/String; J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-privatizeCellInfoList-(Ljava/util/List;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getAutoTimeRequired-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/CameraSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/accessibility/CaptioningManager;-getRawLocale-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/hardware/location/IGeofenceHardware;-removeGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl;-enforceChangePermission-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/text/StringLogger;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/job/JobSchedulerService$JobHandler;-maybeRunPendingJobsH-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-wipeData-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-access$100-(Lcom/android/internal/telephony/imsphone/ImsPhone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/DigitalClock;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStackSupervisor;-handleDisplayRemovedLocked-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/WindowManagerInternal;-requestTraversalFromDisplayManager-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/speech/IRecognitionService;-startListening-(Landroid/content/Intent; Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/telephony/TelephonyManager;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/provider/Settings$System;-getStringForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-createAndInitializeUser-(Landroid/content/ComponentName; Ljava/lang/String; Ljava/lang/String; Landroid/content/ComponentName; Landroid/os/Bundle;)Landroid/os/UserHandle;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-nvReadItem-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/WakeLockStateMachine$IdleState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/wifi/IWifiManager;-setFrequencyBand-(I Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getCrossProfileCallerIdDisabled-(Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WaveView;-vibrate-(J)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/os/IPowerManager;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-handleGroupCreationFailure-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService$SetupContentObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CompoundButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-access$9100-(Landroid/media/AudioService; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-handleInjectSms-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/wm/WindowAnimator;-animateLocked-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wm/DragState;-broadcastDragStartedLw-(F F)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/os/BaseCommand;-run-([Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.RESTART_PACKAGES', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/IActivityManager;-moveTaskToBack-(I)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/filterpacks/imageproc/BlendFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DebugService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/TextClock;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/NfcAdapter;-enable-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyApnIdUpToCurrent-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/FilterContext;-tearDown-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/HandoverServer$ConnectionThread;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccCloseLogicalChannel-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RelativeLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Contacts$Settings;-setSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-addCrossProfileIntentFilter-(Landroid/content/ComponentName; Landroid/content/IntentFilter; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/hardware/location/IGeofenceHardware;-resumeGeofence-(I I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/IRecognitionService$Stub;-stopListening-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getIsimChallengeResponse-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-removeAccount-(Landroid/accounts/Account; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/location/GpsLocationProvider$6;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AsyncPlayer;-access$500-(Landroid/media/AsyncPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplayDensityLocked-(Lcom/android/server/wm/DisplayContent; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ISub;-getDefaultVoiceSubId-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/TintFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-getStorageEncryption-(Landroid/content/ComponentName; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/NfcService;-sendMockNdefTag-(Landroid/nfc/NdefMessage;)V' : ['android.permission.VIBRATE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-validatePrinters-(Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-handleDown-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler$DeliveringState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.RECEIVE_WAP_PUSH', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_MMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/voiceinteraction/SoundTriggerHelper;-onServiceDiedLocked-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/GpsLocationProvider;-sendMessage-(I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/NetworkPolicyManager;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-scanPackageLI-(Landroid/content/pm/PackageParser$Package; I I J Landroid/os/UserHandle;)Landroid/content/pm/PackageParser$Package;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiController$ApEnabledState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/am/ActiveServices;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/lights/LightsService;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/CountdownConditionProvider;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/nfc/NfcAdapter;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcRetryingState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipManager;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-notifyApnIdUpToCurrent-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/gsm/GsmCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/CountdownConditionProvider;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/accessibility/AccessibilityInputFilter;-enableFeatures-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/os/IPowerManager$Stub;-acquireWakeLockWithUid-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayPowerController;-debounceProximitySensor-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager$10;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordMinimumUpperCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getRestrictionsProvider-(I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DctController;-enableApnType-(J Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AdapterViewFlipper;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/backup/BackupManagerService$PerformUnifiedRestoreTask;-restoreFinished-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/IAccountManager$Stub;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/BitmapSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/DnsPinger;-<init>-(Landroid/content/Context; Ljava/lang/String; Landroid/os/Looper; Landroid/os/Handler; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameFetch;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/webkit/WebViewUpdateService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/CalendarView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextView;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkStatsService$Stub;-getNetworkTotalBytes-(Landroid/net/NetworkTemplate; J J)J' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaFocusControl;-onReevaluateRemoteControlDisplays-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/TtmlRenderer;-createTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Gallery;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-getSpnFsm-(Z Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/cardemulation/HostApduService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-access$100-(Lcom/android/internal/telephony/RIL;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/dataconnection/DcTrackerBase;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/usb/UsbDeviceManager$1;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-updateSurface-(Z Z Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/widget/DigitalClock;-access$1200-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/LinearLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Ljava/lang/String; J F Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/ScreenMagnifier$MagnifiedContentInteractonStateHandler;-onScale-(Landroid/view/ScaleGestureDetector;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/notification/NotificationManagerService$NotificationListeners;-rebindServices-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/RecognitionService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccOpenLogicalChannel-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-getFloatForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)F' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService;-cancelRequest-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/content/PackageHelper;-resolveInstallLocation-(Landroid/content/Context; Ljava/lang/String; I J I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/internal/policy/impl/PhoneWindow;-onKeyUpPanel-(I Landroid/view/KeyEvent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-activityIdleInternalLocked-(Landroid/os/IBinder; Z Landroid/content/res/Configuration;)Lcom/android/server/am/ActivityRecord;' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/os/Vibrator;-vibrate-([J I Landroid/media/AudioAttributes;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$Service;-getWindows-()Ljava/util/List;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneCallTracker;-processCallStateChange-(Lcom/android/ims/ImsCall; Lcom/android/internal/telephony/Call$State; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordMinimumUpperCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AppSecurityPermissions$PermissionItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-installCaCert-(Landroid/content/ComponentName; [B)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/CaptioningManager;-addCaptioningChangeListener-(Landroid/view/accessibility/CaptioningManager$CaptioningChangeListener;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothManager;-disable-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onError-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processLaunchBrowser-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Editor$InsertionHandleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/NfcService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/telephony/CellBroadcastMessage;-getDateString-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/SpellChecker;-setLocale-(Ljava/util/Locale;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-performEnableScreen-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/print/PrintManager;-getPrintJob-(Landroid/print/PrintJobId;)Landroid/print/PrintJob;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService$Session;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/content/ContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/restrictions/RestrictionsManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$Future2Task;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ActivityManagerNative;-updatePersistentConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/ColorTemperatureEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/backup/BackupManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/view/IWindowManager$Stub$Proxy;-inputMethodClientHasFocus-(Lcom/android/internal/view/IInputMethodClient;)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService$ScoClient;-requestScoState-(I I)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/text/ToUpperCase;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiScanningServiceImpl$WifiChangeStateMachine$StationaryState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-updateImsPhone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-updateImsPhone-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BatteryService;-logOutlierLocked-(J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindow$DecorView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IMms$Stub$Proxy;-archiveStoredConversation-(Ljava/lang/String; J Z)Z' : ['android.permission.WRITE_SMS'],
	'Landroid/content/IContentService$Stub;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readHighTextContrastEnabledSettingLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/SubscriptionManager;-getDefaultVoicePhoneId-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceStatus-(I I D D D F F F J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService;-<init>-(Landroid/app/Application;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/net/wifi/IWifiManager;-getWifiServiceMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/ActionMenuPresenter$OverflowMenuButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/media/ClosedCaptionRenderer;-createTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager;-confirmCredentialsAsUser-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler; Landroid/os/UserHandle;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setPasswordMinimumNumeric-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/tech/NdefFormatable;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Landroid/app/backup/FullBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/INetworkScoreService$Stub$Proxy;-disableScoring-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/NotificationManagerService;-listenForCallState-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityStack;-setVisibile-(Lcom/android/server/am/ActivityRecord; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-createSipSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipSession$Listener;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/power/PowerManagerService;-access$1100-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-checkBootAnimationCompleteLocked-()Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/View;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/app/PlatLogoActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiStateMachine;-access$2500-(Lcom/android/server/wifi/WifiStateMachine; Z Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/UiccSmsController;-getPremiumSmsPermission-(Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/GlobalActions$GlobalActionsDialog;-onStart-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager$6;-startTask-()V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-getEnabledTrustAgents-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ListActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTime-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionCallReceiverImpl;-processCommand-(Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-handleNewSms-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ISub$Stub$Proxy;-setDisplayName-(Ljava/lang/String; J)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/TextServicesManagerService;-access$800-(Lcom/android/server/TextServicesManagerService; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/CaptioningManager;-notifyLocaleChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-getLogRecString-(Landroid/os/Message;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/dreams/DreamManagerService;-access$1000-(Lcom/android/server/dreams/DreamManagerService; I)[Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ServiceWatcher$2;-onSomePackagesChanged-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine;-isWatchdogEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/le/BluetoothLeAdvertiser;-totalBytes-(Landroid/bluetooth/le/AdvertiseData;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService$Lifecycle;-onBootPhase-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService$11;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-refreshCache-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/DhcpStateMachine$StoppedState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager$Stub$Proxy;-startFreezingScreen-(I I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-doWork-()V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipAudioCall;-access$1300-(Landroid/net/sip/SipAudioCall; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/notification/ConditionProviderService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/twilight/TwilightService;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/view/IWindowManager;-prepareAppTransition-(I Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcSwitchState$DeactingState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/display/DisplayManagerService;-access$1300-(Lcom/android/server/display/DisplayManagerService; Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccountsByTypeAndFeatures-(Ljava/lang/String; [Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/nfc/TechListChooserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/MediaController;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/ILocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/IInputMethodManager$Stub$Proxy;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-sync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/nfc/cardemulation/HostApduService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-pollBatchedScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/handover/BluetoothPeripheralHandover;-nextStepConnect-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-notifyLockTaskModeChanged-(Z Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/RingtoneManager;-stopPreviousRingtone-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/Context;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine;-access$10800-(Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-dispatchMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/admin/IDevicePolicyManager;-setAutoTimeRequired-(Landroid/content/ComponentName; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendDataForSubscriber-(J Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/nfc/handover/HandoverTransfer;-sendBluetoothCancelIntentAndUpdateState-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BlendFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/NullFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager;-setPasswordMinimumUpperCase-(Landroid/content/ComponentName; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/hdmi/HdmiCecLocalDeviceTv;-getSystemAudioModeSetting-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/NumberPicker;-dispatchHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/tv/TvView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/PhoneNumberUtils;-getDefaultVoiceSubId-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/InboundSmsHandler$StartupState;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-getDefaultWindowListLocked-()Lcom/android/server/wm/WindowList;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/content/IContentService$Stub$Proxy;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/widget/Button;-performLongClick-()Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/ims/ImsCall;-setListener-(Lcom/android/ims/ImsCall$Listener; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usb/UsbDeviceManager;-systemReady-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/SmsManager;-enableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/server/wifi/p2p/WifiP2pServiceImpl$P2pStateMachine$P2pNotSupportedState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/base/RetargetFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/RecentApplicationsDialog;-onStart-()V' : ['android.permission.GET_TASKS'],
	'Ljava/net/URL;-getContent-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-proceedAfterWaitChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextClock$1;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService$1;-onUserSwitching-(I Landroid/os/IRemoteCallback;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPermittedAccessibilityServicesForUser-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameBranch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/CallbackFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-startBluetoothScoVirtualCall-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/base/InputStreamSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setApplicationHidden-(Landroid/content/ComponentName; Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ShutdownActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/EditText;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-decrementPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-proceedAfterWildChar-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/fingerprint/FingerprintService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String; Landroid/content/ComponentName;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/view/accessibility/CaptioningManager;-isEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-disconnectBluetoothSco-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/content/SyncManager;-updateRunningAccounts-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/display/DisplayPowerController;-updatePowerState-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$HideNavInputEventReceiver;-onInputEvent-(Landroid/view/InputEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/View;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RadioGroup;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/nfc/cardemulation/HostApduService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService;-switchToLastInputMethod-(Landroid/os/IBinder;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcast-(I)Z' : ['android.permission.RECEIVE_SMS'],
	'Landroid/speech/tts/TextToSpeechService;-access$500-(Landroid/speech/tts/TextToSpeechService;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService$Stub$Proxy;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/SubscriptionController;-getDefaultVoiceSubId-()J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaPlayer;-create-(Landroid/content/Context; I Landroid/media/AudioAttributes; I)Landroid/media/MediaPlayer;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-stopDtmf-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/TelephonyManager;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/INfcCardEmulation$Stub;-removeAidGroupForService-(I Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.NFC'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getAutoTimeRequired-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/SlidingDrawer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-detectSafeMode-()Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccTransmitApduLogicalChannel-(I I I I I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/ConditionProviders;-setZenModeCondition-(Landroid/service/notification/Condition; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Browser;-updateVisitedHistory-(Landroid/content/ContentResolver; Ljava/lang/String; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/UiccSmsController;-sendStoredMultipartText-(J Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/ISub$Stub;-clearSubInfo-()I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-setImsRegistrationState-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/notification/NotificationManagerService;-applyZenModeLocked-(Lcom/android/server/notification/NotificationRecord;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/ExtractButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RemoteViewsService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/cardemulation/DefaultRemovedActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager;-removeCrossProfileWidgetProvider-(Landroid/content/ComponentName; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/BeamShareActivity;-parseShareIntentAndFinish-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/GeofenceHardwareService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-unregisterStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telecom/InCallService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/voice/VoiceInteractionSessionService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipAudioCallAdapter;-onCallEnded-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/tv/TvInputService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/NetworkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityStackSupervisor;-processStoppingActivitiesLocked-(Z)Ljava/util/ArrayList;' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/effect/effects/SharpenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/service/voice/VoiceInteractionService;-isActiveService-(Landroid/content/Context; Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$UserState;-onSwitchToAnotherUser-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub;-reconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/media/MediaSessionService;-updateActiveSessionListeners-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BatteryService;-onBootPhase-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/text/method/PasswordTransformationMethod;-onTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setOperatorBrandOverride-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/bluetooth/BluetoothAvrcpController;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/BitmapSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/InboundSmsHandler$IdleState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ethernet/EthernetService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/server/connectivity/PacManager;-access$800-(Lcom/android/server/connectivity/PacManager;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-isMasterVolumeMuted-(Landroid/content/ComponentName;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/base/FrameStore;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IEthernetManager;-getConfiguration-()Landroid/net/IpConfiguration;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/IWindowSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/MmsServiceBroker;-access$1100-()Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/widget/VideoView;-access$2200-(Landroid/widget/VideoView; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$Lifecycle;-<init>-(Landroid/content/Context;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-handleInCallMmiCommands-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getVoiceMailAlphaTagForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-init-(Landroid/content/Context; Landroid/view/IWindowManager; Landroid/view/WindowManagerPolicy$WindowManagerFuncs;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/backup/BackupManagerService$ProvisionedObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/view/menu/SubMenuBuilder;-changeMenuMode-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/NativeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/cardemulation/HostApduService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setUserRestriction-(Landroid/content/ComponentName; Ljava/lang/String; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-restartDataStallAlarm-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/StackView$StackFrame;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-setMaximumTimeToLock-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-onInitializeAccessibilityNodeInfo-(Landroid/view/accessibility/AccessibilityNodeInfo;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TextView$ChangeWatcher;-beforeTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/display/AutomaticBrightnessController;-access$300-(Lcom/android/server/display/AutomaticBrightnessController; Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$21;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/UiAutomationConnection;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/commands/svc/Svc;-main-([Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/job/JobServiceContext$JobServiceHandler;-handleOpTimeoutH-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-updateInputFilter-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/ClosedCaptionWidget$CCLineBox;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-clearProfileOwner-(Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IWallpaperManager$Stub;-setDisplayPadding-(Landroid/graphics/Rect;)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/test/mock/MockContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wm/WindowState;-setAppOpVisibilityLw-(Z)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$1;-run-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/IWindowManager$Stub$Proxy;-getInitialDisplayDensity-(I)I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/ConfirmConnectToWifiNetworkActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/SettingInjectorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-getConnectionStatistics-()Landroid/net/wifi/WifiConnectionStatistics;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateUsbState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/IAudioService$Stub$Proxy;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkPolicyManagerService$6;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/RenamingDelegatingContext;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/power/ShutdownThread$5;-run-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/connectivity/Tethering;-getUpstreamIfaceTypes-()[I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/HandoverTransfer;-updateStateAndNotification-(I)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService;-resetDefaultImeLocked-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/PopupWindow$PopupViewContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityStack;-resetTargetTaskIfNeededLocked-(Lcom/android/server/am/TaskRecord; Z)Landroid/app/ActivityOptions;' : ['android.permission.SEND_SMS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/service/dreams/Sandman;-isScreenSaverEnabled-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-writeOutboxMessage-(J Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS'],
	'Landroid/nfc/tech/NfcV;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/cardemulation/DefaultRemovedActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-handleStartNetStatPoll-(Lcom/android/internal/telephony/DctConstants$Activity;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/LomoishEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/job/JobServiceContext$JobServiceHandler;-handleServiceBoundH-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IMms;-importMultimediaMessage-(Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; J Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateCmdParamsReady;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/DatePickerDialog;-updateTitle-(I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-adjustStreamVolume-(I I I Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setExpirationAlarmCheckLocked-(Landroid/content/Context; Lcom/android/server/devicepolicy/DevicePolicyManagerService$DevicePolicyData;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-installPackageLI-(Lcom/android/server/pm/PackageManagerService$InstallArgs; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/LauncherActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryFacilityLockForApp-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-onDestroy-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/trust/TrustManagerService;-onBootPhase-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/content/ContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-registerUiTestAutomationService-(Landroid/os/IBinder; Landroid/accessibilityservice/IAccessibilityServiceClient; Landroid/accessibilityservice/AccessibilityServiceInfo;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$ScoClient;-binderDied-()V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/location/CountryDetectorBase;-setCountryListener-(Landroid/location/CountryListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-showEmulatorDisplayOverlayIfNeeded-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/commands/bmgr/Bmgr;-run-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayPowerState$PhotonicModulator;-requestDisplayState-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/IAudioService$Stub;-setRingerMode-(I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/SystemServer;-startCoreServices-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.READ_PROFILE'],
	'Landroid/app/Application;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setRestrictionsProvider-(Landroid/content/ComponentName; Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/TtmlRenderingWidget;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/CallbackFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-sendDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/RecognitionService$RecognitionServiceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-sendMultipartSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-setPropertiesByCarrier-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/display/DisplayPowerController;-initialize-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/videosrc/CameraSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleSrvccStateChanged-([I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-access$1000-(Lcom/android/server/InputMethodManagerService; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-installCaCert-(Landroid/content/ComponentName; [B)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomaticallyAsUser-(I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-disableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/app/Activity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getDataRoamingEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/cdma/CdmaCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/SmsBroadcastUndelivered;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/speech/tts/TextToSpeech$Connection;-runAction-(Landroid/speech/tts/TextToSpeech$Action; Ljava/lang/Object; Ljava/lang/String; Z Z)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiStateMachine$TetheredState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextSwitcher;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/notification/ManagedServices$SettingsObserver;-observe-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/Session;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.SYSTEM_ALERT_WINDOW', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification; Lcom/android/internal/telephony/cdma/CdmaCallTracker; Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocalListenerHelper;-add-(Ljava/lang/Object;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/backup/BackupManagerService$PerformBackupTask;-invokeAgentForBackup-(Ljava/lang/String; Landroid/app/IBackupAgent; Lcom/android/internal/backup/IBackupTransport;)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/INfcTag$Stub;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/app/RestrictionsPinActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayPowerController$8;-onSensorChanged-(Landroid/hardware/SensorEvent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/input/InputManagerService;-updateShowTouchesFromSettings-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager;-getRestrictionsProvider-(I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-callProviderEnabledLocked-(Ljava/lang/String; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/net/INetworkScoreService$Stub;-updateScores-([Landroid/net/ScoredNetwork;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/nfc/INfcTag$Stub;-ndefWrite-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Lcom/android/server/backup/FullBackupJob;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/ims/ImsCall$Listener;-onCallStartFailed-(Lcom/android/ims/ImsCall; Lcom/android/ims/ImsReasonInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-setPasswordExpirationTimeout-(Landroid/content/ComponentName; J I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/gsm/SmsManager;-sendDataMessage-(Ljava/lang/String; Ljava/lang/String; S [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/PhoneProxy;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcBackupAgent;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetIpForwardingEnabledErrorState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcAdapter$Stub;-enableNdefPush-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/backup/BackupManagerService$PerformBackupTask;-agentErrorCleanup-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-updateAdnBySearch-(I Lcom/android/internal/telephony/uicc/AdnRecord; Lcom/android/internal/telephony/uicc/AdnRecord; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/NetworkIdentity;-buildNetworkIdentity-(Landroid/content/Context; Landroid/net/NetworkState;)Landroid/net/NetworkIdentity;' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/NfcService;-sendMessage-(I Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ViewSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/BluetoothManagerService;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingRfcommOn-(I)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/server/wm/WindowManagerService$LocalService;-waitForAllWindowsDrawn-(Ljava/lang/Runnable; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/uicc/RuimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService;-handleDisplayDeviceChanged-(Lcom/android/server/display/DisplayDevice;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-cleanUpAllConnections-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/provider/Browser;-getAllBookmarks-(Landroid/content/ContentResolver;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneBase;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-getPasswordMinimumLength-(Landroid/content/ComponentName; I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-addPhoneStateListener-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/LockPatternUtils;-passwordToHash-(Ljava/lang/String; I)[B' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Call;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-setMaximumScreenOffTimeoutFromDeviceAdminInternal-(I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-getAllowScansWithTraffic-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/pm/BackgroundDexOptService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiServiceImpl;-enforceMulticastChangePermission-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleEnterEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BatteryService;-update-(Landroid/os/BatteryProperties;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-access$400-(Lcom/android/server/am/ActivityManagerService; Ljava/lang/String; I Z Z Z Z Z I Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/dreams/DreamManagerService;-stopDreamLocked-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-hasUserSetupCompleted-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/print/PrintManagerService$PrintManagerImpl;-getPrintJobInfos-(I I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-chooseNewDefaultIMELocked-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoController;-getDeviceIdForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine;-access$000-(Lcom/android/server/wifi/WifiWatchdogStateMachine;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-enableCellBroadcastRangeForSubscriber-(J I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/widget/ScrollingTabContainerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/TextProgressBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/CantAddAccountActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/Context;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/DisableCarModeActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-toString-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/nfc/BeamShareActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-wipeData-(I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-<init>-(Landroid/content/Context; I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/imsphone/ImsPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-access$4600-(Lcom/android/server/power/PowerManagerService; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/inputmethod/InputMethodManager;-switchToLastInputMethod-(Landroid/os/IBinder;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-cancelPendingUssd-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/devicepolicy/DevicePolicyManagerService;-setActiveAdmin-(Landroid/content/ComponentName; Z I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowStateAnimator;-cancelExitAnimationForNextAnimationLocked-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/effect/effects/BitmapOverlayEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setGlobalProxy-(Landroid/content/ComponentName; Ljava/lang/String; Ljava/lang/String; I)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/InboundSmsHandler$WaitingState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/print/PrintManager;-addPrintJobStateChangeListener-(Landroid/print/PrintManager$PrintJobStateChangeListener;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/UserState;-readEnabledPrintServicesLocked-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent; Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterfw/core/Filter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/UiAutomation;-disconnect-()V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/LocationManagerService;-access$400-(Lcom/android/server/LocationManagerService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/MediaSource;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService$LocalService;-initPowerManagement-(Landroid/hardware/display/DisplayManagerInternal$DisplayPowerCallbacks; Landroid/os/Handler; Landroid/hardware/SensorManager;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Landroid/service/textservice/SpellCheckerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/hdmi/SystemAudioAutoInitiationAction;-handleTimerEvent-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService$Stub;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/widget/TextViewWithCircularIndicator;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/Installer;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/WifiStateMachine$DriverStoppedState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyCellInfo-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-getChannelList-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getLockTaskPackages-(Landroid/content/ComponentName;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/wifi/WifiServiceImpl;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/IsimUiccRecords;-onReady-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowState;-hideLw-(Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/videosrc/CameraSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/content/IContentService$Stub;-getMasterSyncAutomaticallyAsUser-(I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usage/UsageStatsService;-onStartUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallHeld-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/trust/TrustManagerService$3;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-handleMotionEventStateDelegating-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/admin/IDevicePolicyManager$Stub;-setProfileName-(Landroid/content/ComponentName; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/CaptioningManager;-access$200-(Landroid/view/accessibility/CaptioningManager;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService$SettingsObserver;-<init>-(Lcom/android/server/wm/WindowManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/admin/IDevicePolicyManager$Stub$Proxy;-getAccountTypesWithManagementDisabled-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/PersistentDataBlockService;-onSwitchUser-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/imsphone/ImsPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setCellInfoListRate-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TextServicesManagerService;-setCurrentSpellCheckerSubtype-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SubscriptionController;-getActiveSubInfoCount-()I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/cardemulation/RegisteredServicesCache;-getInstalledServices-(I)Ljava/util/ArrayList;' : ['android.permission.NFC'],
	'Lcom/android/server/wm/WindowManagerService;-handleDisplayRemovedLocked-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/IAccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/accounts/AccountManager$11;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/nfc/INfcCardEmulation;-setPreferredService-(Landroid/content/ComponentName;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager;-onHostCardEmulationDeactivated-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getMsisdnForSubscriber-(J)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/ActionBarContextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiWatchdogStateMachine$OnlineState;-exit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/telecom/ConnectionService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/content/ContentResolver;-startSync-(Landroid/net/Uri; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/renderscript/RSSurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/voiceinteraction/SoundTriggerHelper;-startRecognition-(I Landroid/hardware/soundtrigger/SoundTrigger$KeyphraseSoundModel; Landroid/hardware/soundtrigger/IRecognitionStatusCallback; Landroid/hardware/soundtrigger/SoundTrigger$RecognitionConfig;)I' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/NetInitiatedActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/LinearLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeLastIncomingGsmSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/AdapterView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCdmaBroadcastActivation-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/trust/TrustManagerService;-access$1400-(Lcom/android/server/trust/TrustManagerService; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Ljava/net/URL;-openConnection-()Ljava/net/URLConnection;' : ['android.permission.INTERNET'],
	'Landroid/print/IPrintManager;-getEnabledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/mtp/MtpDatabase;-endSendObject-(Ljava/lang/String; I I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/notification/DowntimeConditionProvider;-onSubscribe-(Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AbsListView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ILockSettings$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/NumberPicker$AccessibilityNodeProviderImpl;-performAction-(I I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent$Stub;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/pm/PackageManagerService$InstallParams$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-stopDtmf-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/HandoverManager;-tryHandoverRequest-(Landroid/nfc/NdefMessage;)Landroid/nfc/NdefMessage;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ethernet/EthernetServiceImpl;-setConfiguration-(Landroid/net/IpConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/nfc/tech/NfcA;-reconnect-()V' : ['android.permission.NFC'],
	'Landroid/speech/RecognitionService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/TelephonyRegistry;-broadcastServiceStateChanged-(Landroid/telephony/ServiceState; J)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/voice/VoiceInteractionSessionService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/IBackupManager$Stub;-clearBackupData-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/voiceinteraction/VoiceInteractionManagerService$VoiceInteractionManagerServiceStub$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkScoreService$Stub;-disableScoring-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-adjustWallpaperWindowsLocked-()I' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/nfc/cardemulation/CardEmulationManager;-onPreferredPaymentServiceChanged-(Landroid/content/ComponentName;)V' : ['android.permission.VIBRATE'],
	'Landroid/view/WindowManagerPolicy$WindowState;-hideLw-(Z)Z' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/widget/TextViewWithCircularIndicator;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/UiccSmsController;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/nfc/handover/HandoverService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/P2pLinkManager$SendTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.BLUETOOTH'],
	'Landroid/gesture/GestureOverlayView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.SEND_SMS', 'android.permission.ACCESS_COARSE_LOCATION', 'android.pe