#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 14 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-checkQualityAndStartPreview-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/vcard/VCardEntry$BirthdayData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/base/GLTextureTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/SnapshotTab$LoadData;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.INTERNET'],
	'Landroid/webkit/HTML5VideoInline;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLRootView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/ProfileProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStack;-startActivityMayWait-(Landroid/app/IApplicationThread; I Landroid/content/Intent; Ljava/lang/String; [Landroid/net/Uri; I Landroid/os/IBinder; Ljava/lang/String; I Z Z Ljava/lang/String; Landroid/os/ParcelFileDescriptor; Z Landroid/app/IActivityManager$WaitResult; Landroid/content/res/Configuration;)I' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-drawFrameLocked-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/INetworkManagementService$Stub;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/SoundSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternView;-addCellToPattern-(Lcom/android/internal/widget/LockPatternView$Cell;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/calendar/agenda/AgendaFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DataUsageSummary;-updateTabs-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/ui/StaticBackground;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/VpnService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/RecentApplicationsBackground;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/GoogleCalendarUriIntentFilter;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-getPanDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/soundrecorder/Recorder;-delete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteFromEventRelatedTable-(Ljava/lang/String; Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/provider/VoicemailContract$Status;-buildSourceUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/DTMFTwelveKeyDialerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/EnableFdnScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/VideoEditorActivity$23;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-setDeviceOutOfBandData-(Ljava/lang/String; [B [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/TetherSettings;-setUsbTethering-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-updateConnectionState-(Landroid/net/NetworkInfo$DetailedState;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/WifiService$NotificationEnabledSettingObserver;-register-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/SuggestionsAdapter$SlowFilterTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/CropFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor;-saveAndRegisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/phone/CdmaCallOptions;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManagerService;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/email/activity/MessageListFragment;-onLoadMoreMessages-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/musicfx/Compatibility$Redirector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/DownloadUtils;-requestDownload-(Lcom/android/gallery3d/util/ThreadPool$JobContext; Ljava/net/URL;)[B' : ['android.permission.INTERNET'],
	'Lcom/android/launcher2/PagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnablerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$LoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SettingsActivity;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-onOpenAttachment-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Ljava/lang/String; J F Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-handleAccessibilityEnabledSettingChangedLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/FrameSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference$MyHandler;-handleSetVPResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/NonPhoneActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/PackageManagerBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/HTML5VideoViewProxy;-setBaseLayer-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-getName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BackupManagerService;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/LockScreen$MultiWaveViewMethods;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LocationManagerService;-_getProvidersLocked-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CallLogAsync$AddCallTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothProfileState$StableState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/SpeechRecognizer;-cancel-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapAuthenticatorService$PopImapAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothA2dpService;-onSinkPropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/nfc/tech/NdefFormatable;-connect-()V' : ['android.permission.NFC'],
	'Landroid/filterpacks/base/GLTextureSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentService;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/server/BluetoothService;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-setupFlattenedList-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/MessageListItem;-updateAvatarView-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1400-(Lcom/android/internal/policy/impl/KeyguardViewMediator; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/NotificationPlayer;-play-(Landroid/content/Context; Landroid/net/Uri; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processPlayTone-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardViewProperties;-createKeyguardView-(Landroid/content/Context; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardWindowController;)Lcom/android/internal/policy/impl/KeyguardViewBase;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/TrackBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wm/Session;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/InCallScreen;-onStop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$4900-(Lcom/android/mms/ui/ComposeMessageActivity; I Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updatePhoneState-(Lcom/android/internal/telephony/Phone$State;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage;-resume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-handleConnectionOfOtherProfiles-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/tts/BlockingMediaPlayer;-access$000-(Landroid/speech/tts/BlockingMediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Service;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-computeAddress-(Lcom/android/gallery3d/util/ReverseGeocoder$SetLatLong;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpaceBeforeWritingToFile-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/emailcommon/service/IEmailService;-searchMessages-(J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/FdnList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/VoicemailStatusTable;-insert-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/DownloadTouchIcon;-storeIcon-(Landroid/graphics/Bitmap;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/ThrottleService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/SupplicantStateTracker$DormantState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/SystemUIService;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/PhoneProxy;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupDetailFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/DockService;-access$100-(Lcom/android/settings/bluetooth/DockService; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/certinstaller/CertInstaller;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/MailService$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/CallContactActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/TetherSettings;-onStart-()V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/GroupBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhones-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/ui/CropView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub$Proxy;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/providers/media/MediaScannerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/InLineSettingKnob;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/settings/SettingsHelper;-setGpsLocation-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$RecipientsMenuClickListener;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/systemui/net/NetworkOverLimitActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-agentErrorCleanup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/nfc/NfcAdapter;-getTagService-()Landroid/nfc/INfcTag;' : ['android.permission.NFC'],
	'Landroid/inputmethodservice/KeyboardView;-onTouchEventInternal-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-<init>-(J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/Dictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/server/NotificationManagerService;-access$1700-(Lcom/android/server/NotificationManagerService; Lcom/android/server/NotificationManagerService$ToastRecord;)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/MifareClassic;-decrement-(I I)V' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/ui/AlbumSlidingWindow$AlbumDisplayItem;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasOutboxService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I Landroid/content/DialogInterface$OnClickListener; Landroid/content/DialogInterface$OnCancelListener;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ChooseLockPassword;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideshowActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PostalAddressListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-addRfcommServiceRecord-(Ljava/lang/String; Landroid/os/ParcelUuid; I Landroid/os/IBinder;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/PolicyService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateTracker;-teardown-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment;-access$000-(Lcom/android/launcher2/WallpaperChooserDialogFragment; I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Ljava/util/List; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/NfcA;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/base/FrameSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConfirmRateLimitActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-requestLocationUpdates-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/location/ILocationListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ConversationList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3100-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/videoeditor/widgets/MediaLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/util/DraftCache;-access$000-(Lcom/android/mms/util/DraftCache;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/InCallScreen;-updateManageConferencePanelIfNecessary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/RunningProcesses;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onWarningChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayView;-initNextView-(I)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/musicfx/ActivityMusic;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkTimeUpdateService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-access$1100-(Lcom/android/phone/PhoneApp;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/VibratorService;-startVibrationLocked-(Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-prepareEmptyView-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiManager;-setCountryCode-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothAtPhonebook;-handleAccessPermissionResult-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree;-setAudioState-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-acquireScheduleNextAlarmWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parseResponse-()Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$6;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/keychain/KeyChainActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$700-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/UrlInputView;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Landroid/widget/RadioGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$14;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/SlideshowPage;-showPendingBitmap-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/ProfileProvider;-enforceWritePermission-()V' : ['android.permission.WRITE_PROFILE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataStallAlarm-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/MoreSuggestionsView$1;-onPress-(I Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$DockEventHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-access$600-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/test/FragmentTestActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-untetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/SearchActivity;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$PduBodyCache;-getPduBody-(Landroid/content/Context; Landroid/net/Uri;)Lcom/google/android/mms/pdu/PduBody;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/ConnectivityService;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-onAccountChosen-(Lcom/android/contacts/model/AccountWithDataSet; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-handleCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/AccountServiceProxy$6;-run-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/DownloadThread;-notifyThroughDatabase-(I Z I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/server/BluetoothPanProfileHandler;-connectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfo-(Lcom/android/mms/data/Contact;)Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/music/AudioPreview;-playPauseClicked-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/Camera;-initializeFirstTime-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/SnapshotTab;-<init>-(Lcom/android/browser/WebViewController; J)V' : ['android.permission.INTERNET'],
	'Lcom/android/mms/transaction/PushReceiver;-access$000-(Landroid/content/Context; Lcom/google/android/mms/pdu/GenericPdu; I)J' : ['android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkManagementService;-setInterfaceConfig-(Ljava/lang/String; Landroid/net/InterfaceConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/Tab$2;-onPageFinished-(Landroid/webkit/WebView; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.INTERNET'],
	'Landroid/filterpacks/text/StringSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-setSystemUiVisibility-(I)V' : ['android.permission.GET_TASKS'],
	'Landroid/app/NativeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionUp-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ConversationList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity$BluetoothTransferContentObserver;-onChange-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter;-enableForegroundDispatch-(Landroid/app/Activity; Landroid/app/PendingIntent; [Landroid/content/IntentFilter; [[Ljava/lang/String;)V' : ['android.permission.NFC'],
	'Lcom/android/providers/calendar/CalendarProviderIntentService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/videosrc/MediaSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarEventModel;-<init>-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AllInOneActivity;-onBackPressed-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager;-reconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/deskclock/SetAlarm;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-access$400-(Lcom/android/contacts/group/GroupBrowseListFragment;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$3;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-recreateLockScreen-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/ContactsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/VideoCamera;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/WeekSelector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub;-getDnsForwarders-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEventInternal-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-updateDisplayNamesAndLookupKeys-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/socialwidget/SocialWidgetProvider$1;-onLoadComplete-(Landroid/content/Loader; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/SetAlarm;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-wakeWhenReadyTq-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/IThrottleManager$Stub;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/PackageBrowser;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingRestore;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-createDataConnection-()Lcom/android/internal/telephony/gsm/GsmDataConnection;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/view/RigidWebView;-performSizeChange-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-access$6000-(Lcom/android/phone/BluetoothHandsfree;)Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/keychain/KeyChainActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/LomoishEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/SettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/BubbleTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/ServiceProxy$ProxyRunnable;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/CheckedTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onTextInput-(Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/contacts/editor/ContactEditorFragment$JoinSuggestedContactDialogFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/Phone$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifyLlcpLinkActivation-(Lcom/android/nfc/nxp/NativeP2pDevice;)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/systemui/net/NetworkOverLimitActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BackupManagerService$PerformInitializeTask;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$IntervalMeasurementProcess;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/SpeechRecognizer;-handleCancelMessage-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/os/INetworkManagementService;-wifiFirmwareReload-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/OtherSettingsPopup;-onSettingChanged-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/LogViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/NetInitiatedActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService;-notifyChange-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingA2dp;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-access$2100-(Lcom/android/calendar/agenda/AgendaWindowAdapter; Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/ControllerResultUiThreadWrapper$5;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/videosrc/MediaSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WifiService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_MULTICAST_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/ViewStub;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-access$900-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/launcher2/Cling;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/VolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/MediaPlaybackService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/CropImage;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/editor/SplitContactConfirmationDialogFragment$Listener;-onSplitContactConfirmed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/NavTabView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/LatinIME;-launchSettingsClass-(Ljava/lang/Class;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/browser/AccountsChangedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/WebViewCore;-contentScrollTo-(I I Z Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$DelayWalledGardenState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/development/Details;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/SyncManager;-sendSyncFinishedOrCanceledMessage-(Landroid/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/provider/EmailProvider;-upgradeFromVersion21ToVersion22-(Landroid/database/sqlite/SQLiteDatabase; Landroid/content/Context;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onTrySetupData-(Lcom/android/internal/telephony/ApnContext;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AppWidgetPickActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-pokeWakelock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/camera/VideoCamera;-onUserInteraction-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/PolicyService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/ContactLoader;-access$2000-(Lcom/android/contacts/ContactLoader;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-access$900-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserBookmarksPage$OpenAllInTabsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiManager$MulticastLock;-release-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/settings/ApnSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/IAudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/RecognitionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/MoviePlayer;-pauseVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipEditor;-access$500-(Lcom/android/phone/sip/SipEditor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-getContactMethodType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-createAllDataConnectionList-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkManagementService;-notifyLimitReached-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/setup/AccountSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageFileView;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/ChooseAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/accessibility/AccessibleKeyboardViewProxy$KeyboardFlickGestureDetector;-access$000-(Lcom/android/inputmethod/accessibility/FlickGestureDetector; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-startListening-(Landroid/content/Intent; Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$000-(Lcom/android/mms/transaction/SmsReceiverService; Landroid/content/Intent; I)V' : ['android.permission.VIBRATE', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$ContactLoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-shutdown-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LocationManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService$AppDeathRecipient;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/statusbar/StatusBar;-setSystemUiVisibility-(I)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/ConnectivityService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-getInstance-(Landroid/content/Context;)Lcom/android/settings/bluetooth/LocalBluetoothManager;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/SmsReceiverService;-insertMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/ChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/FilterGraphEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION'],
	'Lcom/android/inputmethod/accessibility/FlickGestureDetector;-dispatchFlick-(Landroid/view/MotionEvent; Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calculator2/Calculator;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcTag$Stub;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/emailcommon/service/IEmailService;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/ContactStatusLoader;-getContactInfo-(Landroid/content/Context; Ljava/lang/String;)Lcom/android/email/activity/ContactStatusLoader$Result;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/EmergencyCallbackModeService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-onClose-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothEventLoop;-onDeviceCreated-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/Utils;-showError-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/provision/DefaultActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/UserDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$200-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Lcom/android/tts/compat/CompatTtsService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/Tag;-rediscover-()Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/systemui/usb/UsbStorageActivity$8;-run-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/providers/contacts/VoicemailPermissions;-packageHasFullAccess-(Ljava/lang/String;)Z' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/Transaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/os/INetworkManagementService$Stub;-detachPppd-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/editor/PhotoEditorView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/NetworkManagementService;-listTtys-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadThread;-updateDatabaseFromHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/MediaPlaybackService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GetPin2Screen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-sendConnectionAccessIntent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/CallDetailActivityQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/systemui/statusbar/tablet/NotificationIconArea$IconLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkManagementEventObserver;-interfaceStatusChanged-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/AudioAttachmentView;-onPlaybackError-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/CryptKeeper;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub;-getConnectedInputDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Vpn$LegacyVpnRunner;-execute-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$5;-onChange-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-processMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/WifiService;-enforceMulticastChangePermission-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserDictionary;-addWord-(Ljava/lang/String; I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-disconnectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/EventInfoFragment;-showContactInfo-(Lcom/android/calendar/CalendarEventModel$Attendee; Landroid/graphics/Rect;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/preference/PreferenceFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowDream;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/inputmethodservice/KeyboardView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProviderIntentService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-handleHeadsetHook-(Lcom/android/internal/telephony/Phone; Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkManagementService;-startTethering-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/SimPukUnlockScreen$CheckSimPuk$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$30;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/SyncManager;-access$900-(Landroid/content/SyncManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/ContactListFilterController;-setContactListFilter-(Lcom/android/contacts/list/ContactListFilter; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-disconnectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-createSubWindow-()Z' : ['android.permission.INTERNET'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertSettings-(Landroid/net/Uri; Landroid/content/ContentValues;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/RIL;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/MessagingNotification;-access$200-(Landroid/content/Context; Landroid/content/Intent; Ljava/lang/String; I Z Ljava/lang/CharSequence; J Ljava/lang/String; I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-broadcastIccStateChangedIntent-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/SmoothPagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ClassChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-executeNextState-(Lcom/android/server/BackupManagerService$BackupState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestLocationUpdatesPI-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/list/ContactListFilterController;-notifyContactListFilterChanged-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadingState$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/TintFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothEventLoop;-onPanDeviceConnectionResult-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/ActivityState;-resume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CdmaSubscriptionListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$23;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/Conversation;-dumpSmsTable-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/email/MessagingController;-loadMessageForView-(J Lcom/android/email/MessagingListener;)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/PhoneApp$PhoneAppBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CellBroadcastSms;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/IMediaPlaybackService;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings$TetherChangeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/FrameStore;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/browser/PageProgressView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-resume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardScreenCallback; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-killApplicationWithUid-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/IAudioService$Stub;-reloadAudioSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-stopWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-updateProgressState-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/mms/ui/ConversationList;-access$100-(Lcom/android/mms/ui/ConversationList;)V' : ['android.permission.READ_SMS'],
	'Landroid/media/effect/effects/SepiaEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-execute-(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/Welcome$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/view/BookmarkContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2800-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/inputmethodservice/KeyboardView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/email/activity/setup/MailboxSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/CropView$HighlightRectangle;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackActivity;-access$600-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$3;-onExceededDatabaseQuota-(Ljava/lang/String; Ljava/lang/String; J J J Landroid/webkit/WebStorage$QuotaUpdater;)V' : ['android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/settings/BandMode;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getPanDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onKey-(I [I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager;-sendCancelSyncsMessage-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ApplicationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-addMoreNetworks-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/spellcheck/DictionaryPool;-take-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterfw/core/Filter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportParsed-(Lcom/android/contacts/vcard/ImportRequest; I Lcom/android/vcard/VCardEntry; I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/UI;-onBackKey-()Z' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/PlaylistBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/ApnEditor;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/deviceinfo/Status;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/TetherSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DataUsageSummary$6;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/PeopleActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/SipAudioCall;-transferToNewSession-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothA2dp;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadNotification;-notificationForCompletedDownload-(J Ljava/lang/String; I I J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnByIndex-(I Lcom/android/internal/telephony/AdnRecord; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TouchInterceptor$RemoveListener;-remove-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/group/GroupEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/providers/contacts/VoicemailCleanupService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/SearchActivity;-handleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ResolverActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GetPin2Screen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/vcard/VCardEntry$PhotoData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/gsm/SimCard;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-separateCall-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/UserDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/editor/LabeledEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/EventInfoFragment;-updateAttendees-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/server/BluetoothService;-removeBondInternal-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-updateWidget-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/google/common/io/MultiReader;-advance-()V' : ['android.permission.INTERNET'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-flushInterfaceDnsCache-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/emailcommon/service/IAccountService$Stub;-notifyLoginFailed-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/ConnectivityService;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/SyncAdapterDriver;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/DayView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/camera/CameraAppImpl;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$PhoneNumberLoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/base/RetargetFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-blockNetworkLoads-(Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/voicedialer/RecognizerClient;-onMicrophoneStart-(Ljava/io/InputStream;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/group/SuggestedMemberListAdapter$SuggestedMemberFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/videoeditor/widgets/EditorRelativeLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogQueryHandler;-fetchVoicemailOnly-()V' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/mail/Store;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/WifiService;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/DownloadHandler;-onDownloadStart-(Landroid/app/Activity; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/NetworkManagementService;-setInterfaceIpv6PrivacyExtensions-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-access$100-(Lcom/android/internal/telephony/IccCard; Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/RefreshManager;-refreshMessageList-(J J Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetDnsForwardersErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothAdapterStateMachine$PerProcessState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/AccessibilityEnableScriptInjectionPreference;-setSystemSetting-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/sip/SipService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/phone/EnableFdnScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/LockScreen;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$PlaybackPositionListener;-onStartTrackingTouch-(Landroid/widget/SeekBar;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/GoogleAccountLogin;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLock-(I Landroid/os/IBinder; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DropBoxManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_LOGS'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-fetchRuimRecords-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/AddBookmarkPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/MailboxSettings$LoadMailboxTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/tech/NfcF;-getMaxTransceiveLengthInternal-()I' : ['android.permission.NFC'],
	'Lcom/android/email/mail/store/ImapStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onClicked-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setNumberOfPairedDevices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallNotifier;-onCfiChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-handleCallKey-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-open-([J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothInputDevice;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/ShortcutPicker;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Contact;-getPhoneUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/videoeditor/widgets/AudioTrackView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/Gallery;-startDefaultPage-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/power/PowerUI;-playLowBatterySound-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-updateDeviceName-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onAddNetworkButtonPressed-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/HTML5Audio;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/certinstaller/CertFile;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/PagedViewIcon;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyDefaultData-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallCard;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService;-buildInputMethodListLocked-(Ljava/util/ArrayList; Ljava/util/HashMap;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-haveSomethingToCopyToSDCard-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-restartRadio-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine$ConnectModeState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackActivity;-startPlayback-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService$2;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogNotificationsService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DevicePickerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/vcard/VCardEntry;-iterateAllData-(Lcom/android/vcard/VCardEntry$EntryElementIterator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/music/ScanningProgress;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/chips/RecipientEditTextView$IndividualReplacementTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/ClearMissedCallsService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-updateWakeState-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/storage/IMountService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/os/INetworkManagementService;-getIpForwardingEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/SmsReceiverService;-handleSmsReceived-(Landroid/content/Intent; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SearchActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask;-restoreOneFile-(Ljava/io/InputStream; [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/list/DirectoryListLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/SnapshotTab;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-sendMessageRequest-(Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/EmailActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.NFC'],
	'Lcom/android/phone/BluetoothHandsfree$26;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/videoeditor/widgets/MediaItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/ILocationManager$Stub;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setBluetoothStateInt-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-access$900-(Lcom/android/systemui/usb/UsbStorageActivity;)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessageDelayed-(Landroid/os/Message; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/AppHwPref;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-handleMultiTouchInWebView-(Landroid/view/MotionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry;-iterateOneList-(Ljava/util/List; Lcom/android/vcard/VCardEntry$EntryElementIterator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.SIGNAL_PERSISTENT_PROCESSES', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/BatteryStatsService;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/telephony/SmsProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/wifi/WifiAPITest;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/quickcontact/QuickContactActivity;-show-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/IMediaPlaybackService;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AbstractCalendarActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-replaceSystemPackageLI-(Landroid/content/pm/PackageParser$Package; Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-acquireWakeLock-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering;-interfaceStatusChanged-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/videoeditor/VideoEditorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/HandleSetAlarm;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-unmountVolume-(Ljava/lang/String; Z Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/videosrc/MediaSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$ConnectingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmAlert;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/Ringer;-stopRing-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/preferences/SearchSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-startDictionaryLoadingTaskLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/settings/ActivityPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/HTML5VideoFullScreen;-pauseAndDispatch-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/BasicSlideEditorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/CalendarSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmClock;-access$100-(Lcom/android/deskclock/AlarmClock; Z Lcom/android/deskclock/Alarm;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wm/InputMonitor;-dispatchUnhandledKey-(Lcom/android/server/wm/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/development/BadBehaviorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/LockScreen;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/BluetoothInputDevice;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub;-getInputDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/util/IState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageUtils;-handleReadReport-(Landroid/content/Context; Ljava/util/Collection; I Ljava/lang/Runnable;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/ui/AlbumView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/deprecated/VoiceProxy;-revertVoiceInput-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/phone/FdnSetting;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/BadBehaviorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleShift-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onOptionalFieldVisibilityChange-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/PhoneUtils;-switchHoldingAndActive-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$RunBackupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/NfcRootActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-startRecording-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactsSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetooth$Stub;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessagesAdapter$MessagesCursorLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GLView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession$ClientThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BitmapSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/CryptKeeperConfirm$Blank;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ActivityBase;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/StatusBar;-makeStatusBarView-()Landroid/view/View;' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.GET_TASKS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/provider/BrowserContract$SyncState;-set-(Landroid/content/ContentProviderClient; Landroid/accounts/Account; [B)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserPreferencesPage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/UrlInputView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/DockService;-msgTypeDocked-(Landroid/bluetooth/BluetoothDevice; I I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onReplay-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcTag;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/email/service/MailService$3;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBluetoothState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$ConnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/CryptKeeper$ValidationTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-start-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.GET_TASKS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PieControlBase$TabAdapter$1;-onClick-(Landroid/view/View;)V' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/bluetooth/IBluetooth;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AudioService$SetModeDeathHandler;-binderDied-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-serviceTimeout-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/Controller$ServiceCallbackWrapper;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/TrackBrowserActivity$TrackListAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideViewInterface;-setAudio-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/LinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/DataUsageListener;-updatePolicy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-sendMessage-(J)Z' : ['android.permission.SEND_SMS', 'android.permission.READ_SMS'],
	'Landroid/accounts/ChooseAccountTypeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PickerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/PhoneUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-ensurePaired-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-onDestroyActionMode-(Landroid/view/ActionMode;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/Controller$5;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-reportInetCondition-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothHeadset;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothInputProfileHandler;-connectInputDeviceInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/ActionMenuPresenter$OverflowMenuButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DeleteEventHelper;-access$800-(Lcom/android/calendar/DeleteEventHelper;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/SuggestionsView$2;-onTextInput-(Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/musicfx/ActivityMusic;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebSettings;-verifyNetworkAccess-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/IntRangeManager;-tryAddSingleRange-(I I Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-openTabToHomePage-()Lcom/android/browser/Tab;' : ['android.permission.INTERNET'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService$BookmarkFactory;-loadBookmarks-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/provider/WidgetProvider$WidgetService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SimCard;-handleIccCardStatus-(Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/AppHwConfigList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/development/ConfigurationViewer;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/Controller$ControllerService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/filterfw/core/FilterGraph;-tearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/TimelineHorizontalScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/DhcpStateMachine$RunningState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TelephonyRegistry;-broadcastSignalStrengthChanged-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/widget/WidgetConfiguration;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-access$500-(Lcom/android/bluetooth/opp/BluetoothOppNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/DialogPicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-getCachedBluetoothDevice-(Landroid/bluetooth/BluetoothDevice;)Lcom/android/settings/bluetooth/CachedBluetoothDevice;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/ImageWallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/test/FragmentTestActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Browser;-deleteHistoryTimeFrame-(Landroid/content/ContentResolver; J J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$DnsCheckFailureState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.VIBRATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-handleIncomingConnection-(I Z)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/ContactsUtils;-areContactWritableAccountsAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEvent-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/Recycler;-checkForThreadsOverLimit-(Landroid/content/Context;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/SearchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/CallManager;-acceptCall-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DriverStoppedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-setBackupEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothHealth;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-bailOutAfterErrorDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/usb/UsbConfirmActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/statusbar/LatestItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/view/IWindowManager$Stub;-setForcedDisplaySize-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-mountVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/settings/DataUsageSummary;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageCompose;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Service;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/ChooserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/TechListChooserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/MenuExecutor$MediaOperation;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/BluetoothHandsfree$19;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$11;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-addRoute-(Ljava/lang/String; Landroid/net/RouteInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/RadioInfo;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$Handler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-changeApplicationBluetoothState-(Z Landroid/bluetooth/IBluetoothStateChangeCallback; Landroid/os/IBinder;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountServerBaseFragment$4;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/PlaylistBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/KeyboardView;-onLongPress-(Landroid/inputmethodservice/Keyboard$Key;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/RadioInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/PeopleActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService$1$1;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/DataList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/agenda/AgendaListView;-initView-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaListView$3;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onMenuClicked-(Landroid/view/MenuItem; Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)Z' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/IWifiManager;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/nfc/INfcTag;-transceive-(I [B Z)Landroid/nfc/TransceiveResult;' : ['android.permission.NFC'],
	'Landroid/telephony/TelephonyManager;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-finish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$19;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothAdapter;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-lookupAddress-(D D Z)Landroid/location/Address;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DeviceAdminAdd;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/ConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cat/CatService;-<init>-(Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/IccRecords; Landroid/content/Context; Lcom/android/internal/telephony/IccFileHandler; Lcom/android/internal/telephony/IccCard;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/SetAlarm$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/DeleteItems;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/DeleteEventHelper$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/am/ActivityManagerService;-processNextBroadcast-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$VCardScanThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SetFullBackupPassword;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/HTML5VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UI;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Landroid/media/IAudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/SettingsLicenseActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$SetIpForwardingDisabledErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/InLineSettingSwitch;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/EffectsRecorder$4;-onRunnerDone-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DigitalClock;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onApnChanged-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Landroid/location/Criteria; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/RingtoneManager;-getRingtone-(I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-access$300-(Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/nfc/NfcEnabler;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.NFC'],
	'Landroid/server/BluetoothEventLoop;-onDeviceDisconnectRequested-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/VoiceDialerActivity$3;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(J I Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-changeVolumeBy-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarUtils$TimeZoneUtils;-getTimeZone-(Landroid/content/Context; Ljava/lang/Runnable;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/GetPin2Screen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/view/ScrollerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-prepareOperationTimeout-(I J Lcom/android/server/BackupManagerService$BackupRestoreTask;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-onRecordLoaded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_CONFIGURATION'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$SequentialSource;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneBase;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/InCallScreen$14;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/packageinstaller/UninstallerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/editor/GroupMembershipView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-makeNowPlayingCursor-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1700-(Lcom/android/bluetooth/opp/BluetoothOppService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService;-getProviderInfo-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/IccLockSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/INotificationManager$Stub$Proxy;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHandsfree;-userWantsAudioOn-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-refreshName-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/effect/effects/FillLightEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/RocketLauncher;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/deprecated/languageswitcher/InputLanguageSelection;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncActivityTooManyDeletes;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/CropFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/CallContactActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/MailService;-access$000-(Lcom/android/email/service/MailService; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/NativeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub;-setAnimationScales-([F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/DialtactsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$4;-start-()Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/WifiService;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/text/ToUpperCase;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$SyncHandler;-onBootCompleted-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/calendar/CalendarProviderBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall;-releaseWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothEventLoop;-onHealthDevicePropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/LatinIME;-pickDefaultSuggestion-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/server/pm/PackageManagerService;-access$3000-(Lcom/android/server/pm/PackageManagerService; Ljava/lang/String; Z Z I)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/ActivityRecord;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/RotateFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/AsyncService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/Screensaver;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/AppHwConfigList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IntentService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/SystemBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/ContactsContract$Directory;-notifyDirectoryChange-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/socialwidget/SocialWidgetConfigureActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/GroupMessagingListener;-loadMessageForViewStarted-(J)V' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commit-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-updateIncomingCallWidgetHint-(I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree$27;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/IThrottleManager$Stub;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/MediaSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/settings/wifi/WifiConfigInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/WallpaperHandler;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/LocalBluetoothAdapter; Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager; Lcom/android/settings/bluetooth/BluetoothEventManager;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri;)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipEditor;-unregisterProfile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AllInOneActivity;-configureActionBar-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/MusicUtils;-togglePartyShuffle-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/UserDictionarySettings;-deleteWord-(Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/development/PackageSummary;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onDeviceAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/activities/PeopleActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockPassword$ChooseLockPasswordFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/browser/BrowserWebViewFactory;-createWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Landroid/view/IWindowSession$Stub$Proxy;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/WorkingMessage;-asyncDeleteDraftSmsMessage-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/backup/IBackupManager;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/storage/IMountService;-finishMediaUpdate-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/net/IConnectivityManager;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifyNdefMessageListeners-(Lcom/android/nfc/nxp/NativeNfcTag;)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DataUsageSummary$DataUsageAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/ControlPanelLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$PanStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/RotateLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/commands/monkey/Monkey;-main-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SIGNAL_PERSISTENT_PROCESSES', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/Connectivity;-onRoutedSocketRequest-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/Controller$15;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettings;-pauseWifiScan-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/nfc/NfcService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CallFeaturesSetting;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/WorkingMessage;-createDraftMmsMessage-(Lcom/google/android/mms/pdu/PduPersister; Lcom/google/android/mms/pdu/SendReq; Lcom/android/mms/model/SlideshowModel;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/media/effect/effects/RedEyeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-removeItem-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/screenshot/GlobalScreenshot;-notifyScreenshotError-(Landroid/content/Context; Landroid/app/NotificationManager;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-delete-(Landroid/net/Uri; I J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ManageSimMessages;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$TagService;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/videoeditor/widgets/ZoomControl;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/applications/ApplicationsProvider$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/detail/ContactDetailFragmentCarousel;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getOutgoingCallerIdDisplay-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController$EventHandler;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri; I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasSyncService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DateTimeView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/email/view/RigidWebView;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/NfcA;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/JoinContactActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/camera/VideoCamera;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/phone/InCallScreenShowActivation;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/applications/ApplicationLauncher;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/AbsActionBarView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/OpenDownloadReceiver;-onReceiveAsync-(Landroid/content/Context; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/location/ComprehensiveCountryDetector$2;-onCountryDetected-(Landroid/location/Country;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Display;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/filterpacks/videosrc/CameraSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager;-sendCheckAlarmsMessage-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/backup/FullBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onError-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-pullVcardEntry-([B Lcom/android/bluetooth/pbap/BluetoothPbapObexServer$AppParamValue; Ljavax/obex/Operation; Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-hideLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/view/ContextThemeWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/GetSampleText;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentSlide-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/SlideModel;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-closeCurrentTab-(Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SimCard;-access$100-(Lcom/android/internal/telephony/IccCard; Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/ClearCallLogDialog$1$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/event/EditEventView;-updateHomeTime-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/VideoView$6;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$DisplayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/widget/BookmarkWidgetConfigure;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService$SettingsObserver;-onChange-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/WifiAPITest$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/MusicPicker;-stopMediaPlayer-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-loadViewState-(Ljava/io/InputStream;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NewCallsQuery;-query-()[Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NewCall;' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-delayedCleanupAfterDisconnect-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/ShowActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/event/EditEventFragment;-access$600-(Lcom/android/calendar/event/EditEventFragment; I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/SipAudioCall;-access$700-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/RefreshManager;-refreshMessageList-(J J Z Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/os/storage/IMountService$Stub;-formatVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/mms/ui/Presenter;-present-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyDialer;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$CheckSimPin$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/WifiService;-startScan-(Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/INetworkStatsService;-forceUpdate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/event/AttendeesView;-updateAttendeeView-(Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasAuthenticatorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccount-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/launcher2/WallpaperChooser;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EmailServiceUtils;-isServiceAvailable-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/support/v4/app/FragmentActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebIconDatabase$EventHandler;-bulkRequestIcons-(Landroid/os/Message;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/FdnSetting;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-doStatusCallback-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/GpsLocationProvider;-addListener-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-createBond-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-getAllThreads-(Landroid/content/Context;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/RIL;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-getBatteryUsageHint-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/downloads/DownloadProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.INTERNET'],
	'Landroid/webkit/WebView;-onSizeChanged-(I I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Lcom/android/internal/telephony/ApnContext; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/GLTextureTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/systemui/LoadAverageService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onDataStallAlarm-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/SecurityPolicy;-policiesRequired-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/Transaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/performance/ThroughputFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppCrashLocked-(Lcom/android/server/am/ProcessRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub$Proxy;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/recent/RecentsPanelView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PackageSummary;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ZoomControls;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/InputMethodManagerService;-resetSelectedInputMethodAndSubtypeLocked-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ui/IndicatorControlContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/vcard/CancelActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyNoData-(Lcom/android/internal/telephony/DataConnection$FailCause;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/ex/chips/BaseRecipientAdapter;-access$100-(Lcom/android/ex/chips/BaseRecipientAdapter; Ljava/lang/CharSequence; I Ljava/lang/Long;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/StorageManager;-findSpace-(Ljava/io/File; J I)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-suspendSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment; Landroid/widget/ProgressBar;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-openTab-(Ljava/lang/String; Lcom/android/browser/Tab; Z Z)Lcom/android/browser/Tab;' : ['android.permission.INTERNET'],
	'Lcom/android/launcher2/Launcher;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentFailed-(J J J Lcom/android/emailcommon/mail/MessagingException; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$1100-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/model/AudioModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/Settings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disconnectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndActive-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/policy/NetworkController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/CallContactActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Browser;-deleteFromHistory-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/IContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/Application;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/GsmUmtsCallOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewManager;-onScreenTurnedOn-(Lcom/android/internal/policy/impl/KeyguardViewManager$ShowListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/widget/WaveView;-setGrabbedState-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/phone/NetworkSetting;-selectNetworkAutomatic-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/MessagingController;-loadAttachment-(J J J J Lcom/android/email/MessagingListener; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-putInForeground-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/EasSyncService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaPerformActivation-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/photoeditor/actions/PosterizeAction;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView$CalendarGestureListener;-onScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardParserImpl_V30;-parseOneVCard-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/MailboxFinder$FindMailboxTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccCard;-handleIccCardStatus-(Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree;-userWantsAudioOff-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EmailSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/browser/Tab$3;-onRequestFocus-(Landroid/webkit/WebView;)V' : ['android.permission.INTERNET'],
	'Landroid/accounts/IAccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/BluetoothHandsfree$21;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-<init>-(Landroid/os/Handler; Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/latin/LatinIME;-checkAddToDictionary-(Ljava/lang/CharSequence; I Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebViewCore;-sendMessageAtFrontOfQueue-(I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-canMakeReadOnly-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/server/wm/WindowManagerService;-setAnimationScale-(I F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getPhoneUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/IWifiManager;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/bluetooth/IBluetooth;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller$ControllerService$1;-loadAttachment-(J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-load-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-tetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothService;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Landroid/os/INetworkManagementService$Stub;-getIpForwardingEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/util/StateMachine$SmHandler$QuittingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothService;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/Development;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/ui/CorpusView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo$12;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/base/ObjectSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/IndicatorControl;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/CallContactActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-reloadDictionaryIfRequired-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-isSyncable-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/preference/PreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/sip/SipSettings$1;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/contacts/ContactsProvider2;-getDefaultAccount-()Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-bindEditors-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wm/InputManager;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calculator2/CalculatorEditText;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v13/dreams/BasicDream$BasicDreamView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen;-dontAddVoiceMailNumber-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/editor/ContactEditorUtils;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/ResolverActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/ChangeIccPinScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EditFdnContactScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-access$700-(Lcom/android/development/DevelopmentSettings;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/ActivityManagerNative;-getTasks-(I I Landroid/app/IThumbnailReceiver;)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/deskclock/AlarmKlaxon;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/ObjectSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/UIControllerBase;-onActivityCreated-()V' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideViewInterface;-stopAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.PROCESS_OUTGOING_CALLS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockPassword;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/base/FrameFetch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/Nyandroid;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncManager;-scheduleSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/PicoService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/NetworkManagementService;-addSecondaryRoute-(Ljava/lang/String; Landroid/net/RouteInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/ChooseLockPassword;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processGetInkey-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/DragView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/IConnectivityManager;-getLinkProperties-(I)Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DevelopmentSettings;-writeCpuUsageOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/Device;-getConsistentDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PointerLocation;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/CropView$FaceHighlightView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/net/NetworkPolicyManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/videoeditor/TransitionsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/MailboxSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/sip/SipEditor;-access$700-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/view/IWindowManager;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/NetworkManagementService;-addRoute-(Ljava/lang/String; Landroid/net/RouteInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/camera/EffectsRecorder;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/EffectContext;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccounts-()[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$AccountSet;-buildDiff-()Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/calendar/CalendarController;-refreshCalendars-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/ISyncAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-readPairedDevices-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller$LegacyListener;-checkMailFinished-(Landroid/content/Context; J J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdatesPI-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-performServiceRestartLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/Preloader;-cancelSearchBoxPreload-(Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/Controller$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/MailService$5;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/preference/PreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/DuotoneEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/list/JoinContactListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/NavTabScroller;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/systemui/screenshot/TakeScreenshotService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller;-closeCurrentTab-()V' : ['android.permission.INTERNET'],
	'Landroid/content/SyncManager$SyncHandler;-runSyncFinishedOrCanceledLocked-(Landroid/content/SyncResult; Landroid/content/SyncManager$ActiveSyncContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadNotification;-updateNotification-(Ljava/util/Collection;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/settings/DeviceInfoSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MusicUtils;-addToCurrentPlaylist-(Landroid/content/Context; [J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-listInterfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/ui/BaseSuggestionView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/UrlInputView$UrlInputListener;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Landroid/view/IApplicationToken;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/DeleteEventHelper;-deleteRepeatingEvent-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/email/activity/MessageListFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/ContactsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onSomePackagesChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/ConnectivityService;-access$800-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyServiceState-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebIconDatabase;-retainIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-onWindowFocusChanged-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setSystemLocale-(Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/server/ConnectivityService;-sendGeneralBroadcast-(Landroid/net/NetworkInfo; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/os/IVibratorService;-vibrate-(J Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/BadBehaviorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDevice;-cancelBondProcess-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/photoeditor/actions/ScaleSeekBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/NetworkStateTracker;-reconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/HidProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/NfcRootActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/DevelopmentSettings;-writeCompatibilityOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/Controller$15;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/Email;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/alerts/AlertAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SlideshowEditActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/INfcTag$Stub;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/data/Clustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/AudioAttachmentView;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/DialogPicker;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/NumberPicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-stopDhcpServer-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cat/CatService;-getInstance-(Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/IccRecords; Landroid/content/Context; Lcom/android/internal/telephony/IccFileHandler; Lcom/android/internal/telephony/IccCard;)Lcom/android/internal/telephony/cat/CatService;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-displayReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/browser/PreloadRequestReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookOneVcard-(Ljavax/obex/Operation; I Z Ljava/lang/String; I)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/videoeditor/VideoEditorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ApnSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/IBatteryStats;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/calllog/CallLogNotificationsService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$StorageUseActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/AirplaneModeEnabler;-setAirplaneModeInECM-(Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService$AudioHandler$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkManagementEventObserver$Stub;-interfaceAdded-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestCursor;-runQuery-(Ljava/lang/CharSequence;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader;-startBackgroundThread-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/detail/ContactDetailFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/tablet/PanelBackgroundView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$LocationSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/BackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/PostalAddressPickerFragment;-onClose-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/contacts/GlobalSearchSupport;-handleSearchSuggestionsQuery-(Landroid/database/sqlite/SQLiteDatabase; Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/UiController;-createNewSnapshotTab-(J Z)Lcom/android/browser/SnapshotTab;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelWithoutUids-(Landroid/os/Parcel; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendEmergencyCallbackModeChange-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering;-configureUsbIface-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/provider/WidgetProvider$WidgetService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/CallCard;-updatePhotoForCallState-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterfw/core/FilterSurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/ui/AdaptiveBackground;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactsLiveFolders$AllContacts;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/widget/LockScreenWidgetCallback;-userActivity-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentials-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/downloads/DownloadService;-scanFile-(Lcom/android/providers/downloads/DownloadInfo; Z Z)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/ThrottleService$MyHandler;-clearThrottleAndNotification-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/JoinContactActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/ContactsContract$SyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/SMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothInputProfileHandler;-connectInputDevice-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothDeviceProfileState;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothHeadset;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/commands/monkey/Monkey;-signalPersistentProcesses-()V' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/TintFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService$5;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.GET_TASKS', 'android.permission.SET_PROCESS_LIMIT', 'android.permission.SIGNAL_PERSISTENT_PROCESSES', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.SET_DEBUG_APP', 'android.permission.WAKE_LOCK', 'android.permission.REORDER_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_ALWAYS_FINISH', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.RESTART_PACKAGES'],
	'Landroid/media/effect/effects/DuotoneEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-access$6400-(Landroid/bluetooth/BluetoothDeviceProfileState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/EasAuthenticatorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageViewFragment;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startDisambiguationQuery-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/app/ActivityManagerNative;-moveTaskToFront-(I I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/contacts/widget/PinnedHeaderListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/PopImapAuthenticatorService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyNoData-(Lcom/android/internal/telephony/DataConnection$FailCause; Lcom/android/internal/telephony/ApnContext;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-dumpInputDeviceProfile-(Ljava/io/PrintWriter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/HTML5VideoView;-prepareDataAndDisplayMode-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/spellcheck/DictionaryPool;-takeOrGetNull-()Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterpacks/imageproc/TintFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/AlarmClock;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/CalendarContract$EventDays;-query-(Landroid/content/ContentResolver; I I [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$DeviceFoundHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MusicPicker;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$SettingsPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/Service;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DebugIntentSender;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-scanPackageLI-(Landroid/content/pm/PackageParser$Package; I I J)Landroid/content/pm/PackageParser$Package;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEnded-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-rescheduleMissedAlarms-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/Wallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService;-getSdpRecordsAndConnect-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/EmailAddressAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/MoviePlayer$6;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vpndialogs/ConfirmDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/Email;-onCreate-()V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/GrainFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$Result;-serviceCheckMailCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$GroupCreatedState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onSystemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/StaticBackground;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/tech/MifareClassic;-authenticateSectorWithKeyA-(I [B)Z' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/SlideViewInterface;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/DialtactsActivity;-setCurrentTab-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/email/activity/setup/AccountSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/exchange/EmailSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateShare-(Landroid/database/Cursor; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onSingleTapUp-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/DayView;-access$4200-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/server/BluetoothA2dpService;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onSyncStateUpdated-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/contacts/ContactSaveService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-createNewWebView-()Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServiceFragment;-onPreferenceToggled-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/ApnSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-connectScoThread-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/mms/model/MediaModelFactory;-getGenericMediaModel-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lorg/w3c/dom/smil/SMILMediaElement; Lcom/google/android/mms/pdu/PduPart; Lcom/android/mms/model/RegionModel;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/TetherSettings;-access$300-(Lcom/android/settings/TetherSettings;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$H$1;-onClick-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/deskclock/SettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-startPreview-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-reportFailedUnlockAttempt-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/AppWidgetPickActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/NetInitiatedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageUtils$3$1;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-access$2000-(Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Application;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetConfigure;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/DownloadInfo;-checkCanUseNetwork-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/model/EntityModifier;-parseExtras-(Landroid/content/Context; Lcom/android/contacts/model/AccountType; Lcom/android/contacts/model/EntityDelta; Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-supplyIccPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$ScoClient;-incCount-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/MifareClassic;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/FrameStore;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/SearchActivity$1;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationsAtStartup-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/os/IDropBoxManagerService$Stub$Proxy;-getNextEntry-(Ljava/lang/String; J)Landroid/os/DropBoxManager$Entry;' : ['android.permission.READ_LOGS'],
	'Lcom/android/gallery3d/app/Gallery;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothEventLoop;-onDeviceFound-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosrc/MediaSource;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/Alarms;-deleteAlarm-(Landroid/content/Context; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-showPausePromptDialog-(Lcom/android/internal/telephony/Connection; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/EventLoader$LoadEventDaysRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/widget/WidgetConfiguration;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/google/common/io/Resources;-readLines-(Ljava/net/URL; Ljava/nio/charset/Charset; Lcom/google/common/io/LineProcessor;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-startDictionaryLoadingTaskLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterfw/core/SyncRunner;-performStep-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/providers/downloads/SystemFacade;-postNotification-(J Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Landroid/accounts/IAccountManager$Stub;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/LockScreen$MultiWaveViewMethods;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/TestActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/ExchangeService$2;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ListActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/recent/RecentsHorizontalScrollView$3;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/ui/ContactSuggestionView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset;-stopScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontFromLaunchLocked-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/ModelInterpreter;-<init>-(Ljava/net/InetSocketAddress;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/mail/store/ServiceStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/RadioInfo;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FieldPort;-setFieldFrame-(Landroid/filterfw/core/Frame; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-isDisabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub$Proxy;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/filterpacks/base/CallbackFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$1;-onClick-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/email/service/MailService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/net/NetworkStatsService;-performPoll-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1300-(Lcom/android/internal/policy/impl/KeyguardViewMediator; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/UnderdevelopedSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/spellcheck/SpellCheckerSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/calendar/CalendarDebugActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/CameraSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/alerts/AlertActivity;-onStop-()V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/Controller;-updateMailbox-(J J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ManageSimMessages$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-checkPendingNotification-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-installSystemProviders-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/vcard/VCardService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$9;-run-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/view/IWindowManager;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/email/SingleRunningTask;-runInternal-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/contacts/VoicemailPermissions;-callerHasOwnVoicemailAccess-()Z' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/DreamSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/SyncActivityTooManyDeletes;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipEditor;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-initializeHdmiState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleSmses-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-handleDocked-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/wifi/WifiStateMachine;-access$14000-(Landroid/net/wifi/WifiStateMachine; Landroid/net/wifi/WifiConfiguration;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/ui/ManageSimMessages;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-onRequestOobData-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pConnectionChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessages-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment;-onDestroy-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/LocationManagerService;-addProximityAlert-(D D F J Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/sip/SipSharedPreferences;-setReceivingCallsEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-access$5400-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/policy/LocationController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/MoreSuggestionsView$1;-onCodeInput-(I [I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/CalendarBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OtaUtils;-setSpeaker-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/NotificationMgr;-updateMwi-(Z)V' : ['android.permission.VIBRATE'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/ChipsAddressTextView;-createAlternatesAdapter-(Lcom/android/ex/chips/RecipientChip;)Landroid/widget/ListAdapter;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/RotateFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-addRouteToAddress-(Landroid/net/LinkProperties; Ljava/net/InetAddress;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/StateManager;-restoreFromState-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine;-access$9900-(Landroid/net/wifi/WifiStateMachine; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/FolderIcon;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-<init>-(Landroid/preference/VolumePreference; Landroid/content/Context; Landroid/widget/SeekBar; I Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-access$1800-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/SetAlarm;-saveAlarm-(Lcom/android/deskclock/Alarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-tetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-access$300-(Lcom/android/mms/data/WorkingMessage; Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothService;-getConnectedInputDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/ApplicationSettings$1;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavigationBarPhone;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/ex/variablespeed/SingleThreadedMediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragment;-reloadUiFromBody-(Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/StateManager;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-access$1900-(Lcom/android/email/activity/MessageViewFragmentBase; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/INetworkManagementService$Stub;-addRoute-(Ljava/lang/String; Landroid/net/RouteInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageFileViewFragment;-addAttachment-(Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-revertToNitzTime-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountCheckSettingsFragment$AccountCheckTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/detail/ContactLoaderFragment$1;-onLoadFinished-(Landroid/content/Loader; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForWatchdogToggle-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$2;-onServiceConnected-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.SET_PROCESS_LIMIT', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/accounts/ChooseAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub$Proxy;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/tts/compat/CompatTtsService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendThisDeviceChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/settings/DatabaseHelper;-upgradeLockPatternLocation-(Landroid/database/sqlite/SQLiteDatabase;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/NetworkManagementService;-getNetworkStatsSummary-()Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/performance/ThroughputFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothEventLoop;-onHealthDeviceChannelChanged-(Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/http/RequestQueue$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaitingReject-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/KeyguardManager;-exitKeyguardSecurely-(Landroid/app/KeyguardManager$OnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/ui/SlideshowPresenter;-present-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-fixTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/RIL;-changeIccPin-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/TransactionService;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/deviceinfo/MiscFilesHandler;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onRestore-(Landroid/app/backup/BackupDataInput; I Landroid/os/ParcelFileDescriptor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothHeadset;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/tablet/SettingsView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/WindowManagerService;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$2;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker$TimerProxy;-startKeyRepeatTimer-(J I Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ConversationList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/EngineSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/model/MediaModelFactory;-getRegionMediaModel-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lorg/w3c/dom/smil/SMILRegionMediaElement; Lcom/android/mms/model/LayoutModel; Lcom/google/android/mms/pdu/PduPart;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-initialize-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/ITelephony;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/cdma/CdmaCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/JoinContactActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/TetherSettings;-startTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/AttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/email/AttachmentInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ActivityGroup;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ShutdownActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioManager;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/nfc/NfcService$EnableDisableDiscoveryTask;-doInBackground-([Ljava/lang/Boolean;)Ljava/lang/Void;' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-allowIncomingConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/photoeditor/actions/DoodleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PeopleActivity$ContactDetailLoaderFragmentListener$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-getTriState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IActivityManager;-setProcessForeground-(Landroid/os/IBinder; I Z)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Lcom/android/music/IMediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CdmaCallOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/SlideshowDream;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/AlbumPage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/usb/UsbPermissionActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/AccountManagerService;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/cat/CatService;-handleProactiveCommand-(Lcom/android/internal/telephony/cat/CommandParams;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-disconnectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/ui/ConversationList;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/FrameSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$4000-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService$ProximityListener;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAdbNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/NavScreen;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/graphics/Bitmap; I I Lcom/android/launcher2/DragSource; Ljava/lang/Object; I Landroid/graphics/Point; Landroid/graphics/Rect;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/widget/SlidingTab;-cancelGrab-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/IConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideshowEditActivity$SlideListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/SipCallOptionHandler;-access$300-(Lcom/android/phone/SipCallOptionHandler; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.USE_SIP', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$IncomingScoAcceptThread;-run-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-onUuidChanged-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/CallLogFragment;-startCallsQuery-()V' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/WifiManager;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/CallNotifier$1;-onCallForwardingIndicatorChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/OwnerInfoSettings;-saveToDb-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothPbap;-disconnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ShutdownActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-findIntendedAccount-(Ljava/lang/String;)Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/alerts/AlertActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreenShowActivation;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/AllInOneActivity;-onUserLeaveHint-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-onSuccess-(Ljava/lang/Void;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/webkit/WebIconDatabase;-open-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/os/INetworkManagementService$Stub;-disableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/ui/Icon;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/svox/pico/EngineSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/HeadsetBase;-handleInput-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/AlbumPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/SipCallOptionHandler;-createSipPhoneIfNeeded-(Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.USE_SIP', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpace-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$UuidChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stopSample-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab$10;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-requestSelectionToScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetooth;-getRemoteName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/DayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/phone/sip/SipSharedPreferences;-setSipCallOption-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/downloads/DownloadThread;-processResponseHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState; Lorg/apache/http/HttpResponse;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendSubmitPdu-(Lcom/android/internal/telephony/cdma/SmsMessage$SubmitPdu; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ChangeIccPinScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-dispatchGsmMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-connect-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/phone/EditFdnContactScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/tech/BasicTagTechnology;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/music/MediaPlaybackActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/ProfileProvider;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/VpnService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/SmsManager;-getAllMessagesFromIcc-()Ljava/util/ArrayList;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/content/SyncManager$SyncAlarmIntentReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/wm/Session;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-sendLocalChanges-(Lcom/android/exchange/adapter/Serializer;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-dialRecipient-()V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/mms/ui/ConversationList;-confirmDeleteThread-(J Landroid/content/AsyncQueryHandler;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/spellcheck/DictionaryPool;-take-()Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/preference/YesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/AbstractCalendarActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/backup/IBackupManager;-setBackupProvisioned-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BookmarkItem;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BlendFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/latin/Suggest;-<init>-(Landroid/content/Context; Ljava/io/File; J J [Lcom/android/inputmethod/latin/Flag; Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/ui/SlideEditorActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-onPostExecute-(Lcom/android/contacts/model/EntityDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-setRestrictBackground-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/calllog/CallLogFragment;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/systemui/statusbar/phone/ExpandedView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinIME;-vibrate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/browser/SuggestionsAdapter;-onClick-(Landroid/view/View;)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/activities/DialtactsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/DayView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/launcher2/Workspace;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/test/FragmentTestActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/Controller;-searchMore-(J)V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$400-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.VIBRATE', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/SearchActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-toggleSpeaker-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/SupplicantStateTracker;-access$200-(Landroid/net/wifi/SupplicantStateTracker; Landroid/net/wifi/SupplicantState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener$Adapter;-onCodeInput-(I [I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/sip/SipService$MyExecutor;-executeInternal-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AccountSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/am/ActivityStack;-checkReadyForSleepLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/quickcontact/QuickContactActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pDisablingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/Phone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/ChooseAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/SearchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateExtensions-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/CdmaCallOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/EasTestAuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/RetargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager;-addProximityAlert-(D D F J Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/vcard/ExportProcessor;-doFinishNotification-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/DockService;-hasOtherConnectedDevices-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/sip/SipEditor;-access$600-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/phone/EnableIccPinScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteReminders-(Landroid/net/Uri; Z Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/ListActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/MessagingNotification;-getMmsNewMessageNotificationInfo-(Landroid/content/Context; Ljava/util/Set;)Lcom/android/mms/transaction/MessagingNotification$MmsSmsNotificationInfo;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/media/AudioService$SettingsObserver;-<init>-(Landroid/media/AudioService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/AppHwConfigList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-validate-(Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/SyncManager$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/GeolocationPermissionsPrompt;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/OtherSettingsPopup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothAdapter;-createNewRfcommSocketAndRecord-(Ljava/lang/String; Ljava/util/UUID; Z Z)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$2;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/alerts/DismissAllAlarmsService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendVCards-(Ljavax/obex/Operation; Ljava/lang/String; Z Ljava/lang/String; Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/AccessibilitySettings$TogglePreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/TileImageView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/view/PieMenu;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/MutableContextWrapper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/Button;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$3;-keyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/browser/GoogleAccountLogin;-getAccounts-(Landroid/content/Context;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/quicksearchbox/google/SearchBaseUrlHelper$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/MovieActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/detail/ContactDetailFragment$AddToMyContactsQuickFix;-execute-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-manageServicesLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/socialwidget/SocialWidgetConfigureActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkManagementService;-getDnsForwarders-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-flashAndSetGenericTrue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AppWidgetPickActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/google/common/io/Resources;-toString-(Ljava/net/URL; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/providers/calendar/CalendarProvider2;-regenerateInstancesTable-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-setAudioMode-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/GpsLocationProvider;-removeListener-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine$WallpaperObserver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$AppNotResponding;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-<init>-(Lcom/android/music/MediaPlaybackService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/SyncAdapterDriver;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/IRecognitionService$Stub$Proxy;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage;-onTop-(Lcom/android/browser/BreadCrumbView; I Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/AccessibilityTutorialActivity$TouchTutorialModule2;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-setViewStates-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/deviceinfo/MiscFilesHandler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/media/MtpService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/systemui/SystemUIService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/sharedstoragebackup/SharedStorageAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/UsbDeviceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/BandMode;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmAlertFullScreen$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/VibratorService$Vibration;-binderDied-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RemoteViewsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-notifyInvalidSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ConfirmLockPattern;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/HTML5VideoFullScreen;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicfx/Compatibility$Redirector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateIncomingFileConfirmNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-detectAndSendKey-(I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/activities/CallLogActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-getInputDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/PolicyService$1;-policiesRequired-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-getNfcTagInterface-()Landroid/nfc/INfcTag;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions;-access$300-(Lcom/android/internal/policy/impl/GlobalActions; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setEnabled-(Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/certinstaller/CertFile;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebView;-handleTouchEventCommon-(Landroid/view/MotionEvent; I I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-tryFailover-(I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/server/BluetoothEventLoop;-isOtherSinkInNonDisconnectedState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/AccountsTester$ButtonClickListener;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/nfc/NfcBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-onConnectedInOrOut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavigationBarBase;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/activities/JoinContactActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/systemui/usb/StorageNotification;-onUsbMassStorageConnectionChangedAsync-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/search/SearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/socialwidget/SocialWidgetProvider;-bindRemoteViews-(Landroid/content/Context; I Landroid/appwidget/AppWidgetManager; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserHistoryPage$ClearHistoryTask;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ui/Icon;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/media/MediaScannerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-queryExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-onHoldClick-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/HTML5VideoViewProxy;-enterFullScreenVideo-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowManagerService;-startFreezingDisplayLocked-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-access$1500-(Lcom/android/server/pm/PackageManagerService; Lcom/android/server/pm/PackageManagerService$InstallArgs; Z Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-buildFromCursor-(Landroid/database/Cursor; Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$ControllerService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteUuids-(Ljava/lang/String;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EmergencyCallbackModeService;-showNotification-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/Exchange;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/common/io/Files;-toString-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService$1$2;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-refreshAccessPoints-(Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-prepareVpn-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/WebStorageSizeManager;-scheduleOutOfSpaceNotification-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/IConnectivityManager$Stub;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Activity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/LockPatternUtils;-checkPasswordHistory-(Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/provider/WidgetProvider$WidgetService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ui/IndicatorControlWheel;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;-delete-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/graphics/Bitmap; I I Lcom/android/launcher2/DragSource; Ljava/lang/Object; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-restorePmMetadata-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/exchange/ExchangeService$ServiceCallbackWrapper;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-fillDigitsIfNecessary-(Landroid/content/Intent;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-updateAutoSelectionCB-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-queryInternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/quickcontact/QuickContactActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserWebView;-handleTouchEventCommon-(Landroid/view/MotionEvent; I I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/DialtactsActivity$5;-onHomeInActionBarSelected-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/HandleSetAlarm;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NotificationManagerService;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/UserBigramDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/SizeChangeEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parse-()Z' : ['android.permission.READ_CALENDAR'],
	'Landroid/server/BluetoothA2dpService;-isDisconnectSinkFeasible-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactsLiveFolders$StarredContacts;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/deviceinfo/Status;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/InputMethodManagerService;-access$000-(Lcom/android/server/InputMethodManagerService; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SubSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/activities/ContactEditorAccountsChangedActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/INetworkPolicyManager;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/TrackingView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$ActiveSyncContext;-<init>-(Landroid/content/SyncManager; Landroid/content/SyncOperation; J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLRoot;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/DeskClock;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHeadsetService;-onStart-(Landroid/content/Intent; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-access$1000-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SmsReceiverService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/SelectAccountDialogFragment;-access$000-(Lcom/android/contacts/editor/SelectAccountDialogFragment; Lcom/android/contacts/model/AccountWithDataSet;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-startDictionaryLoadingTaskLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/DataUsageSummary;-hasMobileRadio-(Landroid/content/Context;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-finishAnimationLw-()I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/DeleteFdnContactScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-startTethering-(Ljava/util/ArrayList;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/provider/BrowserProvider2;-updateBookmarksInTransaction-(Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/DayFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/group/GroupEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/calendar/event/EditEventActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-setRetryAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/pm/PackageManagerService;-<init>-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallLogAsync$GetLastOutgoingCallTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/server/BluetoothBondState;-<init>-(Landroid/content/Context; Landroid/server/BluetoothService;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/sip/SipManager;-register-(Landroid/net/sip/SipProfile; I Landroid/net/sip/SipRegistrationListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/INetworkManagementEventObserver$Stub$Proxy;-interfaceLinkStateChanged-(Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiManager;-setFrequencyBand-(I Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/WifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/AccessibilityTutorialActivity$TutorialModule;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/view/SurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/NetInitiatedActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/BrowserContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/telephony/SmsProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/nfc/NfcService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateTracker;-setRadio-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onSimReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/XLargeUi;-onBackKey-()Z' : ['android.permission.INTERNET'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/PopImapAuthenticatorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/DataUsage;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/webkit/WebView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-access$3900-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/emailcommon/service/EmailServiceProxy;-<init>-(Landroid/content/Context; Landroid/content/Intent; Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/NameConverter;-structuredNameToDisplayName-(Landroid/content/Context; Ljava/util/Map;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/widget/InterpolatingLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-selectBackupTransport-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-putRecoveryAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipSessionGroup;-processTransactionTerminated-(Ljavax/sip/TransactionTerminatedEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vpndialogs/ConfirmDialog;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/InLineSettingSwitch$1;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/SlideshowView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-onRuimReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/RecipientsEditor;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/usb/UsbPermissionActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/widget/LockPatternUtils;-setLockPatternEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageViewFragment;-performAttachmentSave-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)Ljava/io/File;' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/base/GLTextureSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/PhoneWindow$DecorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SmsReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/Device;-getDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService;-restartPortMappingLifetimeMeasurement-(Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-clearOtaState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/DockService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/MailService;-syncOneAccount-(Lcom/android/email/Controller; J I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getCallHistorySize-(I)I' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/am/ActivityManagerService;-finishInstrumentationLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/support/v4/view/ViewPager;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/development/AppHwConfigList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-buildAppWidgetModel-(Landroid/content/Context; Landroid/database/Cursor; Ljava/lang/String;)Lcom/android/calendar/widget/CalendarAppWidgetModel;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/KeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/FilmStripView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/downloads/DownloadNotification;-updateCompletedNotification-(Ljava/util/Collection;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity$4;-onTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/BluetoothAdapter;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/KeyguardViewManager$KeyguardViewHost;-dispatchDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/LatinIME;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/PhoneInterfaceManager;-answerRingingCallInternal-()V' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/LockScreen;-updateConfiguration-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/MessageFileViewFragment;-showPicturesInHtml-()V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowSession$Stub;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockGeneric$ChooseLockGenericFragment;-updateUnlockMethodAndFinish-(I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmClock;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/AliasActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/ProjectsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DataUsageSummary;-setMobilePolicySplit-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-addCachedDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/deviceinfo/MiscFilesHandler;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary$LoadDictionaryTask;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/music/MusicPicker;-setSelected-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PeopleActivity;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessagesInSameThreadAsMessage-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/server/BluetoothA2dpService;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/ProgressBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/IDropBoxManagerService;-getNextEntry-(Ljava/lang/String; J)Landroid/os/DropBoxManager$Entry;' : ['android.permission.READ_LOGS'],
	'Lcom/android/mms/ui/ConversationList$2;-run-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DockService;-connectIfEnabled-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/DownloadUtils;-requestDownload-(Lcom/android/gallery3d/util/ThreadPool$JobContext; Ljava/net/URL; Ljava/io/File;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageListener;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/panorama/PanoramaActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/util/Recycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/CryptKeeper$Blank;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkPermissionsAndCreateUriData-(Landroid/net/Uri;)Lcom/android/providers/contacts/VoicemailContentProvider$UriData;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/development/SyncAdapterDriver;-startSyncSelected-(Landroid/view/View;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/WirelessSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$9;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/SlideshowEditActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/accounts/AccountSyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/NavScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.INTERNET'],
	'Lcom/android/systemui/usb/StorageNotification$1;-run-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/IBackupAgent;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Landroid/net/sip/SipAudioCall;-access$900-(Landroid/net/sip/SipAudioCall; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset;-createIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/AllInOneActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameFetch;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-switchViews-(Z F F F)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NetworkManagementService;-startAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/os/INetworkManagementService;-getInterfaceConfig-(Ljava/lang/String;)Landroid/net/InterfaceConfiguration;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/net/NetworkOverLimitActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPdus-([[B)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-init-(Landroid/content/Context; Lcom/android/internal/telephony/CallManager;)Lcom/android/phone/BluetoothHandsfree;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportListItem;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-savePhonebookPermissionChoice-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/DockService;-applyBtSettings-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ThrottleService$MyHandler;-onResetAlarm-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/Network;-enablePlatformNotifications-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/OtaUtils;-startNonInteractiveOtasp-(Landroid/content/Context;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/FilmStripView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/PrivacySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager$Stub;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/FrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onSingleTapUp-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/connectivity/Tethering;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/IConnectivityManager; Landroid/os/Looper;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/SipCallOptionHandler;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-resetRadio-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/GalleryActionBar$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-reconnectAfterFail-(Lcom/android/internal/telephony/DataConnection$FailCause; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/GetPin2Screen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/AdaptiveBackground;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingWidget-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/nfc/NfcBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IThrottleManager$Stub;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/IPowerManager$Stub;-acquireWakeLock-(I Landroid/os/IBinder; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ManageSimMessages;-access$000-(Lcom/android/mms/ui/ManageSimMessages;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/Downloads$ByUri;-removeAllDownloadsByPackage-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/widget/AdapterViewFlipper;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/renderscript/RSTextureView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiApEnabler;-updateTetherState-([Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/server/BluetoothDeviceProperties;-addProperties-(Ljava/lang/String; [Ljava/lang/String;)Ljava/util/Map;' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/Telephony$Mms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$StorageUseActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-buildEntries-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService$2;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub;-stopAccessPoint-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHid;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/music/AlbumBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AllInOneActivity;-updateSecondaryTitleFields-(J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameFetch;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen$15;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/server/BluetoothA2dpService;-onConnectSinkResult-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/socialwidget/SocialWidgetConfigureActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/inputmethodservice/KeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary;-access$1200-(Lcom/android/settings/DataUsageSummary; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpConnection-(Z I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onJoinCompleted-(Landroid/net/Uri;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DataUsageSummary;-access$2800-(Lcom/android/settings/DataUsageSummary; J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/alerts/AlertService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupAccountType;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/MifareClassic;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Lcom/android/deskclock/AlarmKlaxon;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/ApnEditor;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchBroadcastPdus-([[B Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/android/mms/pdu/PduPersister;-updateHeaders-(Landroid/net/Uri; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/ThrottleManager;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/calllog/CallLogQueryHandler;-fetchVoicemailStatus-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/policy/IFaceLockCallback$Stub;-cancel-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/server/BluetoothA2dpService;-access$100-(Landroid/server/BluetoothA2dpService;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/location/GpsLocationProvider;-requestSetID-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/ui/SlotView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/settings/Settings$DevelopmentSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setFilter-(Lcom/android/contacts/list/ContactListFilter; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackService;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentFinished-(J J J)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/Settings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/Nyandroid;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/smspush/WapPushManager;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService$ScoClient;-requestScoState-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller;-getServiceForAccount-(J)Lcom/android/emailcommon/service/IEmailService;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/P2pEventListener;-onP2pSendComplete-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createMessageForEventId-(Landroid/content/Context; J I Ljava/lang/String; Lcom/android/emailcommon/provider/Account; Ljava/lang/String;)Lcom/android/emailcommon/provider/EmailContent$Message;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterfw/core/Filter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/TintFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/commands/pm/Pm;-run-([Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactListItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/AddBookmarkPage;-getUriForFolder-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/wifi/WifiSettings;-forget-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen$UnlockPatternListener;-onPatternDetected-(Ljava/util/List;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/ExchangeService;-done-(Lcom/android/exchange/AbstractSyncService;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/CoreSettingsObserver;-beginObserveCoreSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/CalendarEventModel;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/server/BluetoothAdapterStateMachine$WarmUp;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/photoeditor/actions/ColorSeekBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-untetherInterface-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/BrowserSettings;-clearCache-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$6;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-connectHeadset-(Landroid/bluetooth/HeadsetBase; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/soundrecorder/Recorder;-setState-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/RecipientAdapter;-doQuery-(Ljava/lang/CharSequence; I Ljava/lang/Long;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/gallery3d/app/Gallery;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/TransportControlView;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/ConfirmLockPattern;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterfw/core/FilterFunction;-executeWithArgList-([Ljava/lang/Object;)Landroid/filterfw/core/Frame;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/service/PopImapAuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DataUsageSummary$AppDetailsFragment;-onStop-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$BluetoothPhoneState;-<init>-(Lcom/android/phone/BluetoothHandsfree; Lcom/android/phone/BluetoothHandsfree$1;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRecordsLoaded-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/server/BluetoothService;-pairingAttempt-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$NotConnectedState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService;-_getProviderInfoLocked-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onProgressComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity$10;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-enforceChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/SuggestionsView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-getBigrams-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/settings/widget/ChartNetworkSeriesView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkManagementService;-getInterfaceConfig-(Ljava/lang/String;)Landroid/net/InterfaceConfiguration;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-start-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/group/GroupDetailFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/SecuritySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/SaturateEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingKnob;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/tech/MifareClassic;-increment-(I I)V' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/ContactsUnavailableFragment;-setMessageText-(I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/certinstaller/CertInstallerMain;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/ProjectsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetUpIdleModeText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/SelectAccountDialogFragment;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnectedProfile-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AccountsChangedReceiver$DeleteRemovedAccounts;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardEntry$EntryElement;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/NavScreen;-access$000-(Lcom/android/browser/NavScreen; Lcom/android/browser/Tab;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/filterpacks/base/FrameBranch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ViewInterface;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/Invert;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/WifiService;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/music/AudioPreview;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/State;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/BlendFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-storeMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-handleVerifyUnlock-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/AsyncQueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/widget/LockPatternUtils;-setTactileFeedbackEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/connectivity/Tethering;-access$600-(Lcom/android/server/connectivity/Tethering; Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-setPropertyBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/os/IHardwareService$Stub;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/development/AccountsTester;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$17;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/LightsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/contacts/ContactsApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-updateSleepPolicySummary-(Landroid/preference/Preference; Ljava/lang/String;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/phone/sip/SipEditor;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/ADNList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-onCreate-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getHealthDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/CalendarSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/TestingSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-restoreSelectedUri-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/DataUsage;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/BandMode;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/soundrecorder/Recorder;-clear-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupBrowseListFragment$3;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CellBroadcastSms;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-clearInterfaceAddresses-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Landroid/content/Intent;)Ljava/lang/Void;' : ['android.permission.READ_SMS'],
	'Lcom/android/exchange/EmailSyncAdapterService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoPage$2;-onLoadingFinished-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothAdapter;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveDraft-(Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/IWindowManager$Stub;-setAnimationScale-(I F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/inputmethod/latin/UserUnigramDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/development/AppPicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/util/JobLimiter$JobWrapper;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Landroid/filterpacks/base/FrameFetch;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService;-onSeEmvCardRemoval-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/providers/calendar/CalendarProviderIntentService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/data/WorkingMessage;-loadDraft-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/data/Conversation;)Lcom/android/mms/data/WorkingMessage;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/AudioService$AudioHandler;-persistVolume-(Landroid/media/AudioService$VolumeStreamState; Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DebugIntentSender;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/MountService;-unmountVolume-(Ljava/lang/String; Z Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/provider/Browser;-addSearchUrl-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/DataUsageSummary;-access$3400-(Lcom/android/settings/DataUsageSummary; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/server/BluetoothService;-getKnownDevices-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/sip/SipCallBase;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/service/ApiService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-onCreatePairedDeviceResult-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebView$TouchEventQueue;-runNextQueuedEvents-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/SlidingTab$OnTriggerListener;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/music/MusicUtils;-clearQueue-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/InputManager;-registerShowTouchesSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/KeyguardManager$KeyguardLock;-disableKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/view/IWindowManager;-thawRotation-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/GsmUmtsAdditionalCallOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/StateManager;-startStateForResult-(Ljava/lang/Class; I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService;-main-(Landroid/content/Context; Z Z)Landroid/content/pm/IPackageManager;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/nfc/tech/Ndef;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Landroid/nfc/tech/Ndef;-makeReadOnly-()Z' : ['android.permission.NFC'],
	'Landroid/media/AudioService;-access$1100-(Landroid/media/AudioService; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$ScoSocketConnectThread;-run-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/phone/PhoneApp;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/statusbar/StatusBar;-disable-(I)V' : ['android.permission.GET_TASKS'],
	'Landroid/server/BluetoothService;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onDevicePreferenceClick-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-setForegroundNdefPush-(Landroid/nfc/NdefMessage; Landroid/nfc/INdefPushCallback;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-showEmptyState-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowManager$Stub;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/AtCommandHandler;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/phone/PhoneUtils;-mergeCalls-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/INetworkPolicyManager$Stub;-snoozePolicy-(Landroid/net/NetworkTemplate;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/browser/TabControl;-createNewTab-()Lcom/android/browser/Tab;' : ['android.permission.INTERNET'],
	'Lcom/android/mms/transaction/TransactionService$ServiceHandler;-processTransaction-(Lcom/android/mms/transaction/Transaction;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-release-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragment;-blockNetworkLoads-(Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeRemoteWipe-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsHorizontalScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/tech/IsoDep;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/ProjectsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/Suggest;-getSuggestions-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/keyboard/ProximityInfo;)Lcom/android/inputmethod/latin/SuggestedWords;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/editor/LabeledEditorView;-onOptionalFieldVisibilityChange-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-parseIntent-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/detail/ContactDetailFragment$InvitableAccountTypesAdapter;-<init>-(Landroid/content/Context; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/sip/SipSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/ContactsProvider2;-call-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-finishLoadAttachment-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/NullFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-showConfigUi-(Lcom/android/settings/wifi/AccessPoint; Z)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/AccountFilterActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/ByteStreams;-getChecksum-(Lcom/google/common/io/InputSupplier; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/LatinIME$UIHandler;-onStartInputView-(Landroid/view/inputmethod/EditorInfo; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/phone/BluetoothHandsfree;-getAudioState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/widget/TransitionAnimationView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-access$1400-(Landroid/net/wifi/WifiWatchdogStateMachine;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-loadAttachment-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/svox/pico/Pico;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageFileView$LoadFilenameTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/IAccountManager;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/calendar/DayFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-createIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onResume-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DataUsageSummary$11;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/DataUsageSummary;-setRestrictBackground-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/media/MediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onCardEmulationAidSelected-([B)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/settings/IccLockSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendFullNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/media/effect/effects/TintEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetoothHeadset;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-onError-(Landroid/media/MediaRecorder; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetooth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/musicfx/seekbar/AbsSeekBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-connectInputDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/UsageStatsService$2;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/ActivityManagerNative;-setDebugApp-(Ljava/lang/String; Z Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_DEBUG_APP'],
	'Lcom/android/server/StatusBarManagerService;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-replaceMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-<init>-(Landroid/content/Context; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/TransactionService$ConnectivityBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/providers/calendar/CalendarProviderIntentService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/CalendarSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/inputmethod/InputMethodAndLanguageSettings;-onPause-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiService;-getDhcpInfo-()Landroid/net/DhcpInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/service/ApiService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub;-isTetheringOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$LegacyListener;-checkMailStarted-(Landroid/content/Context; J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/Settings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmAlert;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/PermissionDetails;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-importContacts-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$6;-start-()Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/nfc/INfcTag$Stub;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService$UpdateThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-sendSettings-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore;-sendMessage-(I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-updateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/AdapterView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ChangeIccPinScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/ClassZeroActivity$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/VoiceContact;-redialNumber-(Landroid/app/Activity;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/exchange/EasOutboxService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/phone/NetworkQueryService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiConfigInfo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/settings/SettingsHelper;-applyAudioSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/EffectsRecorder;-startPreview-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/MusicPicker;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/MultiStateButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-pokeWakelock-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/vcard/VCardParserImpl_V30;-handleNest-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/camera/Camera;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl;-processCommand-(Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/RingtonePickerActivity;-stopAnyPlayingRingtone-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore;-layersDraw-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SettingsSafetyLegalActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/ExchangeBroadcastProcessorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$000-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothInputProfileHandler;-disconnectInputDeviceInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/development/EnterURL;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/UiController;-openIncognitoTab-()Lcom/android/browser/Tab;' : ['android.permission.INTERNET'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBarView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/Utils;-getDayOfWeekString-(I I J Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/backupconfirm/BackupRestoreConfirmation;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/ui/DownloadList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ExpandableListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createUserEntryDialog-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteEndpointDiscovered-(Lcom/android/nfc/DeviceHost$TagEndpoint;)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/net/IConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageFileViewFragment;-blockNetworkLoads-(Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/policy/BrightnessController;-setMode-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDataStallAlarm-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeUtil;-putSelectedInputMethodSubtype-(Landroid/content/ContentResolver; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvisionImpl-(Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/VideoEditorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onCancelRequest-(Lcom/android/contacts/vcard/CancelRequest; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDisconnectDone-(I Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountAuthenticatorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmKlaxon;-startAlarm-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-getNetworkStatsUidDetail-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/backup/BackupAgentHelper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener$Adapter;-onCustomRequest-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-next-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/EmailConnectivityManager;-isAutoSyncAllowed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WifiService;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/server/BluetoothService;-connectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onCreate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterFunction;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onBindView-(Landroid/view/View;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/gadget/WidgetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/WebStorageSizeManager;-onReachedMaxAppCacheSize-(J J Landroid/webkit/WebStorage$QuotaUpdater;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/Phone$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/VideoBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/VideoEditorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onCardEmulationDeselected-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/phone/NetworkQueryService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onPause-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-forgotPattern-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/CalendarBackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder;-getInstance-(Landroid/os/Handler; Lcom/android/internal/telephony/IccFileHandler;)Lcom/android/internal/telephony/cat/RilMessageDecoder;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-internalSilenceRinger-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/ui/SlideEditorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageViewFragment;-addAttachment-(Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-setPairable-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/WindowManagerPolicy;-detectSafeMode-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-isDuplicateMessage-(Landroid/content/Context; Lcom/google/android/mms/pdu/RetrieveConf;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/PushReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-putFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/EventLoader$LoadEventsRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccessibilitySettings;-handleTogglePowerButtonEndsCallPreferenceClick-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-removeSecondaryRoute-(Ljava/lang/String; Landroid/net/RouteInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/effects/GrayscaleEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/IccLockSettings;-tryChangePin-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-startRfcommSocketListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/ZoomControl;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/Camera;-initializeSecondTime-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/WaveView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/ContactSaveService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-allowIncomingConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-addWord-(Ljava/lang/String; I)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-requery-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-getProperty-(Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$BondedDevice;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-onLongPress-(Lcom/android/inputmethod/keyboard/Key; Lcom/android/inputmethod/keyboard/PointerTracker;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointers-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onUuidChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/DontPressWithParentLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothAtPhonebook;-queryPhonebook-(Ljava/lang/String; Lcom/android/phone/BluetoothAtPhonebook$PhonebookResult;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/nfc/NfcService$TagService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Landroid/nfc/NfcAdapter;-getAdapterState-()I' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/ui/Icon;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/vpndialogs/ConfirmDialog;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/RespondViaSmsManager$Settings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountAdapter;-getChildrenCursor-(Landroid/database/Cursor;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/SyncActivityTooManyDeletes;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/DownloadVoiceData;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$14;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/TouchInterceptor;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/datepicker/DatePicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavScreen$2;-onLayout-(I I I I)V' : ['android.permission.INTERNET'],
	'Lcom/android/systemui/statusbar/AnimatedImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternView;-detectAndAddHit-(F F)Lcom/android/internal/widget/LockPatternView$Cell;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddBookmarkPage$UpdateBookmarkTask;-doInBackground-([Landroid/content/ContentValues;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/CryptKeeperConfirm$Blank;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertReceiver;-makeNewAlertNotification-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I Z J Z)Landroid/app/Notification;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/FocusOnlyTabWidget;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadInfo;-isReadyToStart-(J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$9;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/NfcB;-getMaxTransceiveLength-()I' : ['android.permission.NFC'],
	'Lcom/android/music/TrackBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/ui/InLineSettingSwitch;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cat/CatService;-sendTerminalResponse-(Lcom/android/internal/telephony/cat/CommandDetails; Lcom/android/internal/telephony/cat/ResultCode; Z I Lcom/android/internal/telephony/cat/ResponseData;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/screenshot/TakeScreenshotService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallTouchUi;-updateState-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/AccountsTester$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/CropFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-loadSubMediaSets-()Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/MediaFormat;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinIME$UIHandler;-postUpdateSuggestions-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/wm/WindowManagerService;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-access$000-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Landroid/content/Intent; Ljava/lang/String; Landroid/content/IIntentReceiver; I Ljava/lang/String; Landroid/os/Bundle; Ljava/lang/String; Z Z I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/editor/AggregationSuggestionView;-handleItemClickEvent-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/GLTextureTarget;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-stopBluetoothSco-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService$AndroidSpellCheckerSession;-onGetSuggestions-(Landroid/view/textservice/TextInfo; I)Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebView;-onPinchToZoomAnimationEnd-(Landroid/view/ScaleGestureDetector;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/ui/ZoomControlWheel;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/preference/ContactsPreferenceActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/interactions/PhoneNumberInteraction$PhoneDisambiguationDialogFragment;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/SipCallOptionHandler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller;-sendPendingMessages-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier;-createPhoneNumberHelper-(Landroid/content/Context;)Lcom/android/contacts/calllog/PhoneNumberHelper;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/AppWidgetPickActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/ShutdownThread;-rebootOrShutdown-(Z Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/ContactPhotoManagerImpl$LoaderThread;-loadPhotosFromDatabase-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/TextProgressBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM;-setLastError-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/AccountManagerService;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/calendar/alerts/AlertService;-postNotification-(Landroid/content/Context; Landroid/content/SharedPreferences; Ljava/lang/String; Ljava/lang/String; I Z Z J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/ChooseLockGeneric;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DataUsageSummary$LimitEditorFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-createDevicePreference-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-startLocationBasedDetector-(Landroid/location/CountryListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/provider/BrowserProvider2;-deleteBookmarks-(Ljava/lang/String; [Ljava/lang/String; Z)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/HTML5VideoInline;-prepareDataAndDisplayMode-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifySendFailed-(Landroid/content/Context; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/server/RecognitionManagerService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/LockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardScreenCallback;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifySeApduReceived-([B)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/providers/applications/ApplicationLauncher;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/GLView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMALTEPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-access$600-(Lcom/android/contacts/group/GroupEditorFragment; Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-resetPrepareStartPlaying-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-access$2100-(Landroid/media/AudioService; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallFeaturesSetting;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/CryptKeeper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Settings$Bookmarks;-add-(Landroid/content/ContentResolver; Landroid/content/Intent; Ljava/lang/String; Ljava/lang/String; C I)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationDone-(Landroid/net/sip/ISipSession; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/FdnList;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PhotoPage;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/TetherSettings;-updateBluetoothState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/DhcpStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$5;-reportFailedAttempt-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/net/NetworkAlertObserver;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/PlaylistBrowserActivity$1;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/photoeditor/actions/EffectAction;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IVibratorService$Stub$Proxy;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-fetchCalls-()V' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/os/INetworkManagementService$Stub;-isTetheringStarted-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServiceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/GeneralPreferences;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/TetherSettings;-updateState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/RenamePlaylist;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/InputStreamSource;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-handleBluetoothStateOn-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-addAcount-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/email/activity/Welcome;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactSaveService;-removeMembersFromGroup-(Landroid/content/ContentResolver; [J J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/ContactSaveService$Listener;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/widget/RotarySelector;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothAdapterProperties;-getAllProperties-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/location/LocationManager;-addNmeaListener-(Landroid/location/GpsStatus$NmeaListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/ApplicationSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneUtils;-startGetCallerInfo-(Landroid/content/Context; Lcom/android/internal/telephony/Connection; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/phone/PhoneUtils$CallerInfoToken;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE'],
	'Landroid/server/BluetoothService;-sendUuidIntent-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimStateCallback;-onSimStateChanged-(Lcom/android/internal/telephony/IccCard$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/webkit/WebView;-drawCoreAndCursorRing-(Landroid/graphics/Canvas; I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramFailureDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/IAccountService$Stub;-reconcileAccounts-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/SystemBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-getDrmMimeType-(J)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/providers/contacts/ContactsProvider2$PipeMonitor;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/media/effect/effects/ColorTemperatureEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/CropView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/speech/RecognitionService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/INetworkManagementEventObserver;-limitReached-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/RecognizerEngine;-recognize-(Lcom/android/voicedialer/RecognizerClient; Landroid/app/Activity; Ljava/io/File; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/PowerManagerService;-releaseWakeLock-(Landroid/os/IBinder; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/Downloads$ByUri;-startDownloadByUri-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Z I Z Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)J' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyDownloadFailed-(Landroid/content/Context; J)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/development/AppPicker;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/FdnList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub;-setIpForwardingEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/TabControl;-removeTab-(Lcom/android/browser/Tab;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$31;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/DebugFragment;-clearWebViewCache-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cat/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/base/FrameFetch;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/WebView;-drawContent-(Landroid/graphics/Canvas; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityGroup;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/MessageListItem;-bind-(Lcom/android/mms/ui/MessageItem; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SettingsPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEventInternal-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/videoeditor/widgets/AudioTrackLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onPress-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SettingsObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/TouchInterceptor;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-switchViews-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$12;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$23;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mms/ui/WarnOfStorageLimitsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/pm/PackageManagerService$11;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getSelectedGroupPosition-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-access$600-(Lcom/android/voicedialer/VoiceDialerActivity; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportItems-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/CryptKeeper;-access$600-(Lcom/android/settings/CryptKeeper;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BaseUi;-showWeb-(Z)V' : ['android.permission.INTERNET'],
	'Landroid/server/BluetoothHealthProfileHandler;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/DebugSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/RadioInfo$20;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-enableBluetooth-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/preference/PreferenceActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-startTethering-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/speech/SpeechRecognizer;-stopListening-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/os/storage/IMountService;-formatVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/phone/BluetoothHandsfree$DebugThread;-run-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CellBroadcastSms;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-changeApplicationBluetoothState-(Z Landroid/bluetooth/IBluetoothStateChangeCallback; Landroid/os/IBinder;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/UIControllerTwoPane$RefreshTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-handleTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-addNotificationViews-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.GET_TASKS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateFromProvider-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/browser/BrowserBackupAgent;-addBookmark-(Lcom/android/browser/BrowserBackupAgent$Bookmark;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/DevicePolicyManagerService;-saveGlobalProxy-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/BluetoothHandsfree;-access$3800-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/applications/RunningProcessesView$TimeTicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/TechListChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-play-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/tech/IsoDep;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/app/MovieActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/soundrecorder/SoundRecorder;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/photoeditor/EffectsBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IAccountService$Stub$Proxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateUri-()Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; Ljava/util/Collection; I)V' : ['android.permission.READ_SMS'],
	'Landroid/app/LauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$People;-createPersonInMyContactsGroup-(Landroid/content/ContentResolver; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SearchActivity$TextViewSnippet;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/certinstaller/CertFileList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothHealthProfileHandler;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/DevelopmentSettings;-access$400-(Lcom/android/development/DevelopmentSettings;)V' : ['android.permission.SET_ALWAYS_FINISH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-assignContactFromPhone-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/gsm/GsmCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-callListenerOnPressAndCheckKeyboardLayoutChange-(Lcom/android/inputmethod/keyboard/Key; Z)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/Wallpaper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentRegionMedia-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/RegionMediaModel; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ContactsProvider2;-openAssetFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/content/res/AssetFileDescriptor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/CallLogActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiInfo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-getInterfaceRxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessagesAdapter$MessagesCursorLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/adapter/Search;-searchMessages-(Landroid/content/Context; J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-invokeNextAgent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/server/BluetoothService;-setPropertyInteger-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService;-autoDiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab$3;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['android.permission.INTERNET'],
	'Landroid/nfc/tech/BasicTagTechnology;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/InputMethodManagerService$InputMethodSettings;-putEnabledInputMethodsStr-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/EasAuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/AppHwConfigList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/UserBigramDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/webkit/WebView$TouchEventQueue;-handleQueuedTouch-(Landroid/webkit/WebView$QueuedTouch;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothTetheringDataTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/DisplaySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/RunningProcesses;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IActivityManager;-moveTaskToBack-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession;-start-(Landroid/os/Handler;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlideshowView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/transaction/RetryScheduler;-getResponseStatus-(J)I' : ['android.permission.READ_SMS'],
	'Landroid/app/ExpandableListActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothAdapter;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupForegroundResumeBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/DialtactsActivity$ViewPagerVisibilityListener;-onVisibilityChanged-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/WifiManager;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-reloadDataAndSetSelectedUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/SetAlarm;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WiredAccessoryObserver;-init-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/deviceinfo/PercentageBarChart;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/SystemUIService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/FlipFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processDisplayText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$ScanState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ClassZeroActivity;-access$200-(Lcom/android/mms/ui/ClassZeroActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/GsmUmtsCallForwardOptions;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/INetworkManagementService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity$4;-onClick-(Landroid/view/View;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/EffectSettingPopup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DataUsageSummary;-access$100-(Lcom/android/settings/DataUsageSummary;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/sharedstoragebackup/SharedStorageAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getInputDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disconnectInputDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getContactMethodUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/media/effect/effects/TintEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothService;-registerAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration; Landroid/bluetooth/IBluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/EdgeView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-setContactData-(Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnection;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-loadFromUri-(Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setHdmiPlugged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EditFdnContactScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/recent/RecentsCallback;-handleSwipe-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/development/LogViewer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabScrollView$TabLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasOutboxService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiSettings;-onAddNetworkPressed-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingInsecureRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/EventInfoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity$ImportTask;-doInBackground-([Lcom/android/contacts/vcard/VCardService;)Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/DevicePickerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-refreshStats-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/BluetoothSocket;-initSocketNative-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/photoeditor/actions/SepiaAction;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['android.permission.INTERNET'],
	'Landroid/net/IConnectivityManager;-setUsbTethering-(Z)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipSettings;-access$900-(Lcom/android/phone/sip/SipSettings;)V' : ['android.permission.USE_SIP'],
	'Landroid/widget/RemoteViewsService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$TagService;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$HeaderAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/SlideViewInterface;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertStatusUpdate-(Landroid/content/ContentValues;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/transaction/TransactionService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothService;-runBluetooth-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackActivity;-access$1100-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardScreenCallback;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/svox/pico/PicoService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/SettingsRedirector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-toggleShuffle-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NetworkManagementService;-flushInterfaceDnsCache-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/camera/ui/InLineSettingKnob$3;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-getViewAt-(I)Landroid/widget/RemoteViews;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Landroid/net/wifi/SupplicantStateTracker$UninitializedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/sip/SipAudioCall;-setSpeakerMode-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/calendar/EventInfoFragment;-updateResponse-(J J I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/BluetoothDevice;-setRemoteOutOfBandData-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/connectivity/Tethering;-setUsbTethering-(Z)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/LauncherActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onAllRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingCalendars-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen$UnlockPatternListener;-onPatternCellAdded-(Ljava/util/List;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ChooserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/ShortcutPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/TabActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothA2dpService;-<init>-(Landroid/content/Context; Landroid/server/BluetoothService;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/util/EmptyService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/tech/MifareClassic;-restore-(I)V' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onSetPolicyDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/location/GpsNetInitiatedHandler;-handleNiNotification-(Lcom/android/internal/location/GpsNetInitiatedHandler$GpsNiNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/RingerVolumePreference;-onBindDialogView-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/support/v4/app/NoSaveStateFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ContactEditorAccountsChangedActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/MailService$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/EasSyncService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManager;-editProperties-(Ljava/lang/String; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/ConnectivityService;-modifyRoute-(Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/RouteInfo; I Z Z)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$BluetoothPhoneState;-access$1700-(Lcom/android/phone/BluetoothHandsfree$BluetoothPhoneState; Z Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/Session;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/vcard/ProcessorBase;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/EditFdnContactScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinIME;-onRefreshKeyboard-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/SimPukUnlockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Bookmarks$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterpacks/imageproc/TintFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/DataList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/ContactSaveService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/MediaModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackActivity;-access$900-(Lcom/android/music/MediaPlaybackActivity; I J)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/SmsManager;-sendDataMessage-(Ljava/lang/String; Ljava/lang/String; S [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserYesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/GeolocationService;-start-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-removeServiceRecord-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/SyncAdapterDriver;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/vcard/ExportVCardActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$31;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/exchange/ExchangeService$1;-syncMailboxStatus-(J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DockService;-processMessage-(Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/TransactionService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeSipPhone-(Ljava/lang/String;)Lcom/android/internal/telephony/sip/SipPhone;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$StartStopButtonListener;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/UserDictionarySettings$MyAdapter;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/music/CreatePlaylist;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/NoConfirmationSendService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-updateVoiceDetails-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/RepeatingImageButton;-access$000-(Lcom/android/music/RepeatingImageButton; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/AddAccountSettings;-addAccount-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-onDataSetChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/ContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/email/Controller$ControllerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestionsExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/Utils;-getTetheringLabel-(Landroid/net/ConnectivityManager;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/NotificationPlayer;-access$700-(Lcom/android/server/NotificationPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/Controller$ControllerService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/RingtoneManager;-setActualDefaultRingtoneUri-(Landroid/content/Context; I Landroid/net/Uri;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/LayoutInflater$BlinkLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$Download;-saveDataUri-()V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/RenamePlaylist;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/systemui/statusbar/phone/NavigationBarView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/WiredAccessoryObserver;-update-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab$2;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DriverUnloadedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiManager;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/tech/MifareUltralight;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDoneDrawing-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManagerService;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/providers/contacts/VoicemailCleanupService;-onHandleIntent-(Landroid/content/Intent;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/DataUsageSummary$13;-onWarningChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/deprecated/languageswitcher/InputLanguageSelection;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiService;-access$1400-(Lcom/android/server/WifiService;)V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/tech/Ndef;-getNdefMessage-()Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Landroid/inputmethodservice/KeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/EmergencyCallbackModeService;-access$200-(Lcom/android/phone/EmergencyCallbackModeService; J)V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothHealthProfileHandler;-onHealthDevicePropertyChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/RingtonePickerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MailboxFinder$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/providers/media/MtpService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onWakeMotionWhenKeyguardShowingTq-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setNotification-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2700-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/Ndef;-writeNdefMessage-(Landroid/nfc/NdefMessage;)V' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2900-(Lcom/android/mms/ui/ComposeMessageActivity; J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/development/AccountsTester$GetAndInvalidateAuthTokenCallback;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/ComboViewActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/service/wallpaper/WallpaperService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContentService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/AccountFilterActivity;-loadAccountFilters-(Landroid/content/Context;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/IConnectivityManager$Stub;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ThrottleService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/Camera$9;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/base/FrameFetch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/ConfigurationViewer;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IThrottleManager$Stub;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/NullFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/applications/InstalledAppDetailsTop;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-refresh-(Landroid/text/format/Time; J Ljava/lang/String; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/deskclock/SetAlarm;-onBackPressed-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/app/backup/IRestoreSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IntentService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-cleanUpConnection-(Z Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/deprecated/languageswitcher/InputLanguageSelection;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/DhcpStateMachine$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ManageSimMessages;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/NetworkManagementService;-enableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/photoeditor/actions/SharpenAction;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/LockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothService;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/SendTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/UsbDeviceActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DateTimeSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$16;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/DialtactsActivity;-onBackPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/p2p/WifiP2pService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/email/MessagingController$11;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/calendar/event/EditEventFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/BrowserActivity;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/settings/ChooseLockGeneric;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-animateCollapse-(Z F)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/deskclock/Alarms;-disableAlert-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/SyncManager$6;-onServiceChanged-(Landroid/content/SyncAdapterType; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/contacts/VoicemailCleanupService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothServerSocket;-<init>-(I Z Z I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/Invert;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/AlbumSetView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/BlockingMediaPlayer$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/LogViewer;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothEnabler;-<init>-(Landroid/content/Context; Landroid/widget/Switch;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-parsePingResult-(Ljava/io/InputStream; Landroid/content/ContentResolver; Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/CallNotifier;-sendMwiChangedDelayed-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-removeBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/NullFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/WifiManager;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/ActivityStack;-scheduleIdleLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/interactions/ImportExportDialogFragment;-handleImportRequest-(I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/view/VolumePanel;-onShowVolumeChanged-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-makeWifiWatchdogStateMachine-(Landroid/content/Context;)Landroid/net/wifi/WifiWatchdogStateMachine;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/media/MediaScannerService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/Divot;-assignContactFromEmail-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-setKeyboardMode-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accessibilityservice/AccessibilityService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/google/common/io/Files;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/File; Ljava/nio/charset/Charset;)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/NetworkSetting;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$8;-handleMotion-(Landroid/view/MotionEvent; Landroid/view/InputQueue$FinishedCallback;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/browser/ShortcutActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/VideoCamera;-updateEffectSelection-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/ConfirmLockPattern;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/StateManager;-switchState-(Lcom/android/gallery3d/app/ActivityState; Ljava/lang/Class; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-doQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$2;-userActivity-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-addPreferencesForActivity-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/pinyin/CandidatesContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeechService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/MessagingNotification;-getDownloadFailedMessageCount-(Landroid/content/Context;)I' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-queryForAllRawContactIds-(Landroid/content/ContentResolver; J)Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/server/BluetoothInputProfileHandler;-<init>-(Landroid/content/Context; Landroid/server/BluetoothService;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/TimeConsumingPreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallNotifier;-showIncomingCall-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/vpn2/VpnSettings;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/JoinContactListFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/music/TrackBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/util/AccountPromptUtils;-launchAccountPrompt-(Landroid/app/Activity;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/downloads/DownloadService;-access$800-(Lcom/android/providers/downloads/DownloadService; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DateTimeSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/widget/PinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/server/BluetoothService;-getHealthDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ThrottleService$DataRecorder;-addData-(J J)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/ConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Ljava/lang/Appendable;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/PhoneProxy;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Settings$Secure;-putLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/SimContacts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$ConnectedState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onCreate-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/musicfx/ActivityMusic;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Ljava/util/Map; Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/MasterClear;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub$Proxy;-sendMessageStatus-(J Ljava/lang/String; I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/ConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/widget/AutoScrollListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/Connectivity;-access$2100-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WpsStateMachine$InactiveState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/EnableIccPinScreen;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/view/InputQueue;-dispatchMotionEvent-(Landroid/view/InputHandler; Landroid/view/MotionEvent; J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z)J' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/server/BluetoothEventLoop;-onNetworkDeviceDisconnected-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/policy/ToggleSlider$Listener;-onChanged-(Lcom/android/systemui/statusbar/policy/ToggleSlider; Z Z I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/email/Controller$15$1;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/widgets/MediaLinearLayout$1;-onLongPress-(Landroid/view/View; Landroid/view/MotionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogDisabledState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactSaveService$2;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/ActivityManagerNative;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/ConnectivityService;-access$1400-(Lcom/android/server/ConnectivityService; I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/FdnSetting;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/AlarmClock;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onFinishAction-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/adapter/Parser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/Connectivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/sip/SipSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/Utils;-setTimeZone-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/server/BluetoothService;-disconnectSink-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-delete-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/LoadAverageService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM;-<init>-(Lcom/android/server/connectivity/Tethering; Ljava/lang/String; Landroid/os/Looper; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/RemoteViewsAdapter$RemoteViewsFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/NetworkManagementService;-enableIpv6-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/os/INetworkManagementService$Stub;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/MediaFormat;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/NonPhoneActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen$4;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ShutdownThread;-shutdown-(Landroid/content/Context; Z)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarController$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/WifiManager;-startScan-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/SlidingTab;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isBusy-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EmergencyDialer;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/Screensaver;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$27;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/mms/data/Conversation$2;-run-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/app/ResolverActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlideshowView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/MessagingListener;-synchronizeMailboxFinished-(J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserBackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothInputProfileHandler;-getInstance-(Landroid/content/Context; Landroid/server/BluetoothService;)Landroid/server/BluetoothInputProfileHandler;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/WirelessSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onScreenTurnedOff-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/NotificationPlayer;-enqueueLocked-(Lcom/android/server/NotificationPlayer$Command;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-restoreMuteState-()Ljava/lang/Boolean;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-getContactUriForPhoneNumber-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/nfc/tech/NdefFormatable;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/contacts/group/GroupBrowseListFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/preference/VolumePreference;-onSampleStarting-(Landroid/preference/VolumePreference$SeekBarVolumizer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onMuteClick-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DeviceAdminAdd;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/phone/NotificationMgr;-updateCfi-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-showPhonebookDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumPage$4;-onLongTap-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSetupExchangeFragment;-saveSettingsAfterEdit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/SearchActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService;-onDestroy-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onPollPdp-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothAdapter;-getConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/SearchView$SearchAutoComplete;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageFileViewFragment;-access$1900-(Lcom/android/email/activity/MessageViewFragmentBase; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ConfirmLockPassword$ConfirmLockPasswordFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/camera/VideoCamera;-access$2800-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/SearchActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-getUsableInvitableAccountTypes-()Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/SubSettings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-loadAccountsInBackground-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/sip/ISipService$Stub;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadset;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/SelectionManager$SelectionListener;-onSelectionModeChange-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/email/MessagingController$10;-run-()V' : ['android.permission.INTERNET'],
	'Lcom/android/browser/BrowserWebView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-rebuildStructuredName-(Lcom/android/contacts/model/EntityDelta$ValuesDelta;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/widget/TabWidget;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/SelectionManager;-enterSelectionMode-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/bluetooth/IBluetooth;-getInputDevicePriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-requestRouteToHostAddress-(I [B)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothEventLoop;-checkPairingRequestAndGetAddress-(Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/SingleRunningTask;-run-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onBtClassChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkManagementService;-getNetworkStatsUidDetail-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/SipManager;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onClose-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/FdnSetting;-updatePINChangeState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/RadioInfo;-access$4000-(Lcom/android/settings/RadioInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/UsageStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEvent-(I I J Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BatteryService$2;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/preferences/SearchSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelLocked-(Landroid/os/Parcel; Z I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-setUsbTethering-(Z)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmKlaxon;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramFailure-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/server/BluetoothService;-getDeviceServiceChannelForUuid-(Ljava/lang/String; Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-setGlobalProxy-(Landroid/net/ProxyProperties;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDevice;-setPasskey-(I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager;-clearForcedDisplaySize-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/LatinIME;-revertLastWord-(Landroid/view/inputmethod/InputConnection;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/settings/MasterClear;-establishInitialState-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndHolding-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createView-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/ProcessInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-attemptAutoPair-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/DragState;-endDragLw-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/Connection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/AccountService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/text/StringLogger;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-maybeEnableFallback-(Landroid/content/Context;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/Settings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/videosrc/MediaSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/common/contacts/DataUsageStatUpdater;-updateWithRfc822Address-(Ljava/util/Collection;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/browser/NavigationBarPhone;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/vcard/VCardParserImpl_V21;-handleNest-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/PreloadRequestReceiver;-isOnWifi-(Landroid/content/Context;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$LocationSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaSystemSelectListPreference$MyHandler;-handleQueryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getDataUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/event/EditEventView$DateListener;-onDateSet-(Landroid/widget/DatePicker; I I I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/tech/NfcA;-getTimeout-()I' : ['android.permission.NFC'],
	'Landroid/net/ConnectivityManager;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-addNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/DhcpStateMachine$RunningState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/Alarms;-addAlarm-(Landroid/content/Context; Lcom/android/deskclock/Alarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/cdma/CdmaCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/GroupBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/quicksearchbox/DialogActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/SupplicantStateTracker$InactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/MifareClassic;-authenticate-(I [B Z)Z' : ['android.permission.NFC'],
	'Lcom/android/exchange/EasCertificateRequestor;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/ChooseLockPattern;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDevice;-createBond-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/IEmailService;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-snoozePolicy-(Landroid/net/NetworkTemplate;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/DataUsageSummary$ConfirmDataRoamingFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-isTetheringOn-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth;-connectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/camera/Camera;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHeadsetService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-buildUpdate-(Landroid/content/Context;)Landroid/widget/RemoteViews;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/GLView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LocationManagerService$SettingsObserver;-update-(Ljava/util/Observable; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockGeneric$ChooseLockGenericFragment;-updatePreferencesOrFinish-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-<init>-(Lcom/android/internal/policy/impl/LockPatternKeyguardView; Landroid/accounts/AccountManager;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessLimit-(I)V' : ['android.permission.SET_PROCESS_LIMIT', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-setCurrentTab-(Lcom/android/contacts/activities/ActionBarAdapter$TabState;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/util/DownloadManager;-markState-(Landroid/net/Uri; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/EditPinPreference$OnPinEnteredListener;-onPinEntered-(Lcom/android/settings/EditPinPreference; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StopTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppLiveFolder;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/systemui/usb/UsbResolverActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/vpn2/VpnSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/storage/IMountService$Stub;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/exchange/ExchangeService$ConnectivityReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-onBluetoothDisabled-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/RingtonePickerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothAtPhonebook;-access$900-(Lcom/android/phone/BluetoothAtPhonebook;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/AdapterViewAnimator;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/WallpaperManager;-clear-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothA2dp;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/vcard/VCardEntry$NicknameData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/widget/AnimatedImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-updateBigramPredictions-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/music/DeleteItems;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/LauncherApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onPause-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/group/GroupEditorFragment;-getAccountType-()Lcom/android/contacts/model/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothBondState;-loadBondState-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/DeleteItems;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/NotificationTransaction;-<init>-(Landroid/content/Context; I Lcom/android/mms/transaction/TransactionSettings; Lcom/google/android/mms/pdu/NotificationInd;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/music/RepeatingImageButton$RepeatListener;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/RunningProcesses;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/model/EntityDeltaList;-beginKeepTogether-()Landroid/content/ContentProviderOperation$Builder;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/os/INetworkManagementService;-setAccessPoint-(Landroid/net/wifi/WifiConfiguration; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ScanningStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$6;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/TrafficStats;-stopDataProfiling-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getRemoteServiceChannel-(Ljava/lang/String; Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/ContactTileListFragment$2;-onContactSelected-(Landroid/net/Uri;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/util/AccountsListAdapter;-<init>-(Landroid/content/Context; Lcom/android/contacts/util/AccountsListAdapter$AccountListFilter; Lcom/android/contacts/model/AccountWithDataSet;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getInputDevicePriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SlideshowPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/IAudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment;-access$000-(Lcom/android/contacts/detail/ContactDetailUpdatesFragment; Lcom/android/contacts/util/StreamItemEntry;)Lcom/android/contacts/model/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/calendar/CalendarDebugActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-bindData-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactTileView$Listener;-onClick-(Lcom/android/contacts/list/ContactTileView;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService;-readPersistedSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/SettingsView;-onClick-(Landroid/view/View;)V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues; Z)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/DisplaySettings;-writeFontSizePreference-(Ljava/lang/Object;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothProfileState$PendingCommandState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactsUtils;-areGroupWritableAccountsAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexServerSession;-onPut-(Ljavax/obex/Operation;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/calendar/alerts/AlertActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-enableKeyguard-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/screenshot/SaveImageInBackgroundTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/browser/ShortcutActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/calendar/CalendarDebugActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothPanProfileHandler;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/DeviceStorageMonitorService;-access$000-(Lcom/android/server/DeviceStorageMonitorService; Z)V' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/test/FragmentTestActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/TextModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/pinyin/ComposingView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-itemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ADNList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-createContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/SplitContactConfirmationDialogFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/UsbDeviceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-replacePackageLI-(Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/videoeditor/NoSearchActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/content/ContentService;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/AccessibilitySettings$TogglePreferenceFragment$2;-onBeforeCheckedChanged-(Lcom/android/settings/AccessibilitySettings$ToggleSwitch; Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/HandleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TelephonyRegistry;-broadcastDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AsyncQueryServiceHelper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/p2p/WifiP2pSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/text/ToUpperCase;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/app/DisableCarModeActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactListFilterController;-selectCustomFilter-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/wifi/WifiAPITest;-onPreferenceClick-(Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/calllog/CallLogFragment;-updateOnTransition-(Z)V' : ['android.permission.WRITE_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/CallLogNotificationsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-startDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$IntervalMeasurementProcess;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/DialtactsActivity$4;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/BrowserPreferencesPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/view/menu/ExpandedMenuView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-getConnectionStatus-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/deviceinfo/Status;-setWifiStatus-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-initPreferences-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/os/storage/IMountService$Stub;-mountVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/phone/EditFdnContactScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree;-access$6100-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/RepeatingImageButton;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AllInOneActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/BatteryService;-processValues-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/quicklaunch/BookmarkPicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/deviceinfo/MiscFilesHandler;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleModeChange-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/ChangeIccPinScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/service/ApiService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/UrlHandler$RLZTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/alerts/AlertActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-stopScanning-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/policy/EventHole;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/webkit/GeolocationService;-registerForLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/videoeditor/ProjectsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/PlaylistBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier;-getInstance-(Landroid/content/Context;)Lcom/android/contacts/calllog/DefaultVoicemailNotifier;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/NetworkManagementService;-access$400-(Lcom/android/server/NetworkManagementService; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$7400-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup;-processIOException-(Ljavax/sip/IOExceptionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment$EntityDeltaComparator;-compare-(Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/EntityDelta;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-onHealthDevicePropertyChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleOnClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS', 'android.permission.GET_TASKS'],
	'Lcom/android/settings/accounts/ChooseAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/INetworkManagementService;-disableIpv6-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOffUpstreamMobileConnection-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/backup/FullBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/RadioButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setGlobalProxy-(Landroid/net/ProxyProperties;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/mms/transaction/SmsReceiverService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ThrottleService$MyHandler;-onIfaceUp-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHid;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/EnableFdnScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ActivityBase;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService;-startManualSync-(J I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/Activity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-removeBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-trySetupData-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/ActivityState;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/GsmUmtsCallForwardOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/BadBehaviorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/GoogleCalendarUriIntentFilter;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupExchangeFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/packageinstaller/UninstallerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$ScreenNailJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/MccTable;-updateMccMncConfiguration-(Lcom/android/internal/telephony/PhoneBase; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/text/StringLogger;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/InputStreamSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/AlbumBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageListItem;-bindNotifInd-(Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onBackPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneUtils;-turnOnSpeaker-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-ensureBootCompleted-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/AllInOneActivity;-access$500-(Lcom/android/calendar/AllInOneActivity; J)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/tech/Ndef;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateNextButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportRequests-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-updateOnEntry-()V' : ['android.permission.WRITE_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/mms/ui/VideoAttachmentView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideListItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$DayAdapterInfo;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/OtaUtils;-otaShowActivateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/MmsMessageSender;-sendReadRec-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/ManageConferenceUtils;-separateConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getGroupUriFromId-(J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/deviceinfo/Memory;-unmount-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/musicfx/Compatibility$Service;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/TechListChooserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/DataUsage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/compat/InputMethodServiceCompatWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportCanceled-(Lcom/android/contacts/vcard/ImportRequest; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/development/PointerLocation;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/util/NameConverter;-displayNameToStructuredName-(Landroid/content/Context; Ljava/lang/String;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pStateChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallHelper;-onServiceStateChanged-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService;-chooseNewDefaultIMELocked-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-endInCallScreenSession-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/datepicker/DatePickerDialog$OnDateSetListener;-onDateSet-(Lcom/android/contacts/datepicker/DatePicker; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-access$300-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/effect/effects/FlipEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-insertShare-(Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DataUsageSummary$ConfirmLimitFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/MmsApp;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-requestAnimationLocked-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/settings/GallerySettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-setInputDevicePriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$23;-onResizeResult-(Lcom/google/android/mms/pdu/PduPart; Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-disable-(I)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/NetworkManagementService;-setInterfaceDown-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/FakePhoneActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/CountryDetectorService$2;-run-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/EmailActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmReceiver;-handleIntent-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/util/HttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/systemui/screenshot/TakeScreenshotService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-invokeExitMethods-(Lcom/android/internal/util/StateMachine$SmHandler$StateInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/deviceinfo/FileItemInfoLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-sleep-(J Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodPreference;-setChecked-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayFragment;-goTo-(Landroid/text/format/Time; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-redial-()Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/SlideshowPresenter$5;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/detail/ContactDetailTabCarousel;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/server/BluetoothAdapterStateMachine;-access$4500-(Landroid/server/BluetoothAdapterStateMachine;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AppWidgetPickActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/development/AppHwPref;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/RecipientsAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/webkit/HTML5VideoFullScreen;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/EmailServiceProxy$12;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/DevelopmentSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/LauncherApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getLastKnownLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM;-start-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/PanProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ISms;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/webkit/WebView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-disableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-initBluetoothAfterTurningOn-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebViewCore;-webkitDrawLayers-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleSwipe-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-executeDownload-(Lcom/android/providers/downloads/DownloadThread$State; Landroid/net/http/AndroidHttpClient; Lorg/apache/http/client/methods/HttpGet;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-updateNotification-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/inputmethod/latin/SuggestionsView$Listener;-addWordToDictionary-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/server/LocationManagerService;-loadProviders-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$ShuffleSource;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebViewCore$EventHub;-sendMessage-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewCore$EventHub;-access$7600-(Landroid/webkit/WebViewCore$EventHub; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/DownloadManager$4;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/SetFullBackupPassword;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CdmaSubscriptionListPreference$CdmaSubscriptionButtonHandler;-handleSetCdmaSubscriptionMode-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/CursorEntityIterator;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PickerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendCallLogVcards-(I Ljavax/obex/Operation; I I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/list/ContactsUnavailableFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/WifiManager;-startScanActive-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/CreateShortcut;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/ApnEditor;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/NoSearchActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/deviceinfo/Status;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-setFormattedDigits-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/keyboard/MiniKeyboardView$1;-onPress-(I Z)V' : ['android.permission.VIBRATE'],
	'Landroid/server/BluetoothEventLoop;-onAgentAuthorize-(Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CellBroadcastSms;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-doJoinSuggestedContact-([J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/INetworkManagementService$Stub;-setDefaultInterfaceForDns-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/phone/SimContacts;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/EditSlideDurationActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/accounts/AddAccountSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onStart-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/CalendarView$WeekView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager$UnlockSim;-unlockSim-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2600-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/view/ContextMenu; Lcom/android/mms/ui/ComposeMessageActivity$MsgListMenuClickListener; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/net/NetworkStatsService;-generateRandomLocked-([Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/BluetoothHandsfree$24;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/DataUsageSummary$13;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/SimFullReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/ActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/browser/BrowserBookmarksPage$2;-actionItemClicked-(Landroid/view/View; Lcom/android/browser/BookmarkDragHandler$BookmarkDragState;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/app/MovieActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth;-getInputDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/DevelopmentSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-initApnContextsAndDataConnection-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/MessagingPreferenceActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService$2;-startSync-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-requestServiceBindingsLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-startObexSession-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CreateShortcut;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CryptKeeperConfirm$Blank;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/AlertActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/EmergencyCallbackModeExitDialog;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/DownloadThread;-handleEndOfStream-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportProcessed-(Lcom/android/contacts/vcard/ImportRequest; I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Exception;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallNotifier;-access$000-(Lcom/android/phone/CallNotifier; Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/deviceinfo/Memory;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/exchange/ExchangeService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/camera/ui/CameraPicker;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/ExchangeService;-access$900-(Lcom/android/exchange/ExchangeService; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnablerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity$TestPinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$7800-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/exchange/ExchangeService;-requestSync-(Lcom/android/emailcommon/provider/Mailbox; I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-drawTopPanel-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$InnerTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/app/IActivityManager;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/ui/QuickContactDivot;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getSalt-()Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmAlert;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/webkit/WebIconDatabase$EventHandler;-access$900-(Landroid/webkit/WebIconDatabase$EventHandler; Landroid/os/Message;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageItem;-interpretFrom-(Lcom/google/android/mms/pdu/EncodedStringValue; Landroid/net/Uri;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/browser/BrowserWebView;-handleMultiTouchInWebView-(Landroid/view/MotionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/TransitionsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/sip/SipEditor$3;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/calendar/Utils;-formatMonthYear-(Landroid/content/Context; Landroid/text/format/Time;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsApplication;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/Nyandroid;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-restoreState-(Landroid/os/Bundle; J Z Z)V' : ['android.permission.INTERNET'],
	'Landroid/webkit/HTML5Audio;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowDream;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/NfcAdapter;-isNdefPushEnabled-()Z' : ['android.permission.NFC'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-buildQueryUri-(I I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/ExpandableListActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/FullBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/CallDetailActivity;-getPhoneCallDetailsForUri-(Landroid/net/Uri;)Lcom/android/contacts/PhoneCallDetails;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/LocationManagerService$Receiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocationSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/text/ToUpperCase;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-clearShortcut-(C)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-disableNat-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-readFirstLine-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WiredAccessoryObserver;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/WindowManagerService$1;-acquired-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$ScoSocketConnectThread;-connectSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/calendar/CalendarViewAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/systemui/usb/UsbResolverActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/EntityModifier;-migrateStructuredName-(Landroid/content/Context; Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/DataKind;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetooth;-setTrust-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AsyncPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-moveItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/Camera;-onWindowFocusChanged-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactSaveService;-updateGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/contacts/activities/PeopleActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WifiService;-getPersistedWifiState-()I' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/PermissionDetails;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ManageSimMessages;-init-()V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/data/ContactList;-blockingGetByUris-([Landroid/os/Parcelable;)Lcom/android/mms/data/ContactList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/DockObserver;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getConnectedPanDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/settings/TetherSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/TrackBrowserActivity$4;-drop-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IVibratorService$Stub;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker$ApnChangeObserver;-onChange-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/phone/NetworkSetting;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-next-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/compat/VibratorCompatWrapper;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/quicksearchbox/AppsCorpus;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/CorpusResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothService;-getInputDevicePriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/DataConnection$DcInactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/NfcV;-reconnect-()V' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/util/DraftCache;-rebuildCache-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MusicBrowserActivity$1;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/MediaScannerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/AtCommandHandler;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BreadCrumbView;-pop-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/INotificationManager$Stub;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/HandleSetAlarm;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/performance/ThroughputFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfile;-setPreferred-(Landroid/bluetooth/BluetoothDevice; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ReceiverRestrictedContext;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/P2pLinkManager;-prepareMessageToSend-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/music/VideoBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/CheckableRelativeLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebIconDatabase;-requestIconForPageUrl-(Ljava/lang/String; Landroid/webkit/WebIconDatabase$IconListener;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailcommon/service/IPolicyService$Stub$Proxy;-policiesRequired-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/net/IThrottleManager;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Contacts$People;-addToMyContactsGroup-(Landroid/content/ContentResolver; J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/DockObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/contacts/ContactsProvider2;-importLegacyContacts-(Lcom/android/providers/contacts/LegacyContactImporter;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/app/MovieActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserWebView;-onPinchToZoomAnimationEnd-(Landroid/view/ScaleGestureDetector;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateCurrentCarrierInProvider-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/phone/NetworkSetting;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCallForward-(I I I Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/VideoBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/GalleryAppImpl;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/server/BluetoothService;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/screenshot/SaveImageInBackgroundTask;-<init>-(Landroid/content/Context; Lcom/android/systemui/screenshot/SaveImageInBackgroundData; Landroid/app/NotificationManager; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/pm/PackageManagerService;-killApplication-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accessibilityservice/AccessibilityService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/deviceinfo/Status;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/SystemUIService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/GoogleCalendarUriIntentFilter;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/Welcome;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/PickerActivity;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageCommandButtonView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-trySetupData-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/AlbumView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/PhoneApp;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ConversationList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallHelper;-onDisconnect-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$WaitForUserActionState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/accessibility/AccessibleKeyboardViewProxy;-onHoverEventInternal-(Landroid/view/MotionEvent; Lcom/android/inputmethod/keyboard/PointerTracker;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$14;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardViewBase;-onScreenTurnedOn-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/ConnectivityService;-enforcePreference-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-refreshWifiInfo-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-access$200-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NetworkManagementService;-access$200-(Lcom/android/server/NetworkManagementService; Ljava/lang/String; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BookmarkSearch;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mms/transaction/TransactionService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/FakePhoneActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-setBluetoothStateOn-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/SupplicantStateTracker$HandshakeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-getNetworkStatsTethering-([Ljava/lang/String;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/Downloads$ById;-deleteDownload-(Landroid/content/Context; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/util/IState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/packageinstaller/InstallAppProgress;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-handleConnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter$EasEmailSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/service/EasTestAuthenticatorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/AliasActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmAlert;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/ConfigurationViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-setVisiblePatternEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/vpn2/VpnSettings;-getDefaultNetwork-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/HTML5VideoViewProxy$VideoPlayer;-pauseAndDispatch-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Application;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/GrainEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForSettingsChanges-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/am/ActivityManagerService;-access$200-(Lcom/android/server/am/ActivityManagerService; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/BluetoothHandsfree$19;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoPage;-initFilmStripView-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/UIControllerOnePane;-onRefresh-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/InputHandler;-handleMotion-(Landroid/view/MotionEvent; Landroid/view/InputQueue$FinishedCallback;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/effect/effects/VignetteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PeopleActivity;-showContactsUnavailableFragmentIfNecessary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyApnIdUpToCurrent-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/photoeditor/PhotoEditor;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-getWifiState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/SimCard;-supplyPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$QuickResponseChecker;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHandsfree;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/widget/VideoView;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-restoreNoiseSuppression-(Landroid/content/Context;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri; Z Z Z Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/AudioPreview;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AudioService$AudioHandler$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/nfc/NfcAdapter;-disableForegroundDispatch-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/browser/BrowserPreferencesPage;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-createBond-(Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/smspush/WapPushManager;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/voicedialer/VoiceContact;-getVoiceContacts-(Landroid/app/Activity;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/RIL;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/AppPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-connectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserSettings;-clearHistory-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/downloads/DownloadProvider;-checkInsertPermissions-(Landroid/content/ContentValues;)V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/os/IDropBoxManagerService$Stub;-getNextEntry-(Ljava/lang/String; J)Landroid/os/DropBoxManager$Entry;' : ['android.permission.READ_LOGS'],
	'Landroid/widget/TextSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/StaticBackground;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/CommandsInterface;-cancelPendingUssd-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-acquireWakeLock-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MusicPicker;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-clearInterfaceAddresses-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/ProjectsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/UsbDeviceActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothInputProfileHandler;-disconnectInputDevice-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothDeviceProfileState;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/util/DownloadManager;-getMessage-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/google/common/io/CharStreams$2;-getInput-()Ljava/io/InputStreamReader;' : ['android.permission.INTERNET'],
	'Lcom/android/mms/ui/AttachmentEditor;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactTileAdapter$ContactTileRow;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactNamesByNumber-(Ljava/lang/String;)Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/camera/ActivityBase;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-commandsParser-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/SimPukUnlockScreen;-onAttachedToWindow-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/VideoEditorBaseActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipWakeLock;-release-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/PostalAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/tts/compat/CompatTtsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/TitleBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-onDiscoverServicesResult-(Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/AlarmInitReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller;-onPreloginFinished-(Landroid/os/Bundle; Landroid/content/Intent; J Z Z)V' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/FlipFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/OutputStreamTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-addRoute-(Landroid/net/LinkProperties; Landroid/net/RouteInfo; Z)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/content/SyncActivityTooManyDeletes;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/SplitAggregateView;-<init>-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-updateProgressbar-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/FilmStripView;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/interactions/ImportExportDialogFragment;-doShareVisibleContacts-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/UserUnigramDictionary;-<init>-(Landroid/content/Context; Lcom/android/inputmethod/latin/LatinIME; Ljava/lang/String; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerBase;-onRefresh-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onProgressComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-writeImmediatelyDestroyActivitiesOptions-()V' : ['android.permission.SET_ALWAYS_FINISH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/CalendarApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/BackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/SupplicantStateTracker$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$2;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/wm/Session; Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment$2;-onRequest-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/INetworkManagementService;-setInterfaceUp-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/mms/data/WorkingMessage$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/AudioService;-access$5300-(Landroid/media/AudioService;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/InLineSettingRestore;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/app/ContextImpl;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/BitmapSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Preloader;-handlePreloadRequest-(Ljava/lang/String; Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleInCallMmiCommands-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/Icon;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-cancelDiscovery-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSignalStrength-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager;-setAnimationScales-([F)V' : ['android.permission.SET_ANIMATION_SCALE'],
	'Lcom/android/phone/BluetoothHandsfree;-stopVoiceRecognition-()Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/RecognitionService;-checkPermissions-(Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteFieldActivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastStickyIntent-(Landroid/content/Intent; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-startVoicemailStatusQuery-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/Controller$Result;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/ChooseAccountActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onSetUserDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; J I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$20;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/AddBookmarkPage;-onRootFolderFound-(J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Ljava/net/URL;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/vcard/ImportProcessor;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getLinkProperties-(I)Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$TagService;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/browser/view/SnapshotGridView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AbstractCalendarActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WifiService;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/ControllerResultUiThreadWrapper$4;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-getOriginalId-(Ljava/lang/String;)J' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/AccessibilityTutorialActivity;-onPause-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/event/EditEventHelper;-saveRemindersWithBackRef-(Ljava/util/ArrayList; I Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumPage;-doCluster-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/INetworkManagementService$Stub;-setInterfaceConfig-(Ljava/lang/String; Landroid/net/InterfaceConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/service/AccountService$1;-notifyLoginFailed-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/media/effect/effects/StraightenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-checkStorageUsersAsync-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/net/VpnService;-prepare-(Landroid/content/Context;)Landroid/content/Intent;' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/ShowActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/DeleteEventHelper;-deleteExceptionEvent-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetooth;-disconnectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/TrackBrowserActivity;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/MailboxSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/camera/VideoCamera;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/effects/NegativeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/DataUsageSummary;-isMobilePolicySplit-()Z' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-resumeSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/CreateShortcut;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/AllInOneActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/calllog/CallLogFragment;-callSelectedEntry-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/camera/VideoCamera$MyBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-dispatchDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSetupOptions$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onLoadComplete-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/MediaPlaybackActivity;-scanBackward-(I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset;-acceptIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/nfc/P2pEventManager;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/app/ShutdownThread$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/CryptKeeperConfirm$Blank;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/CropImage$LoadBitmapDataTask;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getOperator-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/NfcB;-getMaxTransceiveLengthInternal-()I' : ['android.permission.NFC'],
	'Lcom/android/exchange/EmailSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/IWindowManager;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/server/BluetoothEventLoop;-onInputDevicePropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MailboxListItem;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicfx/ControlPanelPicker;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$CheckSimPin;-onSimLockChangedResponse-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhoto-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogDisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothA2dpService;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserBookmarksPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/ConnectivityManager;-startUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/location/GpsLocationProvider;-requestRefLocation-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/ProcessInfo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/INfcTag$Stub;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/packageinstaller/InstallAppProgress;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/nfc/NfcManager;-<init>-(Landroid/content/Context;)V' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/ui/GLRootView;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-updateSubtype-(Lcom/android/inputmethod/compat/InputMethodSubtypeCompatWrapper;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/phone/CdmaCallOptions;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/provider/BrowserProvider2$DatabaseHelper;-onUpgrade-(Landroid/database/sqlite/SQLiteDatabase; I I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/INetworkManagementService$Stub;-getInterfaceConfig-(Ljava/lang/String;)Landroid/net/InterfaceConfiguration;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setForegroundNdefPush-(Landroid/nfc/NdefMessage; Landroid/nfc/INdefPushCallback;)V' : ['android.permission.NFC'],
	'Lcom/android/vcard/VCardEntry$PostalData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/app/PickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/MusicBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/agenda/AgendaFragment;-goTo-(Lcom/android/calendar/CalendarController$EventInfo; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/content/MutableContextWrapper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/SyncRunner;-step-()I' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/sip/SipManager;-createSipSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipSession$Listener;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/photoeditor/PhotoEditor;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/INetworkStatsService$Stub;-forceUpdate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DebugIntentSender;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-handleInetConditionHoldEnd-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/TransactionService;-endMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/detail/CarouselTab;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/VolumePreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/provider/WidgetProvider$WidgetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/TrafficStats;-getDataLayerSnapshotForUid-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/INetworkManagementService;-setDefaultInterfaceForDns-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/development/ShowActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/Launcher;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/DialtactsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/UsageStats;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-cancelMmiCode-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ManageSimMessages;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/event/EditEventView;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterfw/core/FieldPort;-transfer-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DefaultRingtonePreference;-onSaveRingtone-(Landroid/net/Uri;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/VolumePanel;-onVolumeChanged-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-adjustUserActivityLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/exchange/EasOutboxService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiPickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/ex/chips/RecipientAlternatesAdapter;-<init>-(Landroid/content/Context; J J I Lcom/android/ex/chips/RecipientAlternatesAdapter$OnCheckedItemChangedListener;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/quicksearchbox/SearchActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadBodyTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcTag$Stub;-reconnect-(I)I' : ['android.permission.NFC'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/Controller$ControllerService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/SecuritySettings;-setNonMarketAppsAllowed-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/DialtactsActivity$6;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/service/textservice/SpellCheckerService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/NetworkSetting;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasOutboxService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/music/PlaylistBrowserActivity;-playPodcasts-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-systemReady-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/MessagingController$12;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService;-setInterfaceConfig-(Ljava/lang/String; Landroid/net/InterfaceConfiguration;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/widget/SearchEditText;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-access$1000-(Lcom/android/server/ConnectivityService; I Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/ItemOperationsParser;-parseFetch-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/Camera;-doOnResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/PhoneApp;-access$900-(Lcom/android/phone/PhoneApp; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/calendar/alerts/AlertService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/inputmethodservice/KeyboardView;-access$400-(Landroid/inputmethodservice/KeyboardView; Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-removeAllDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/recent/RecentsPanelView$2;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-pokeWakelock-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/nfc/NfcService;-onCardEmulationAidSelected-([B)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/gallery3d/ui/AlbumSlidingWindow$AlbumDisplayItem;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectChannelToSource-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/VoiceDialerActivity$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/SuggestionsView$2;-onCodeInput-(I [I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/AlbumPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/AudioAttachmentView;-access$000-(Lcom/android/mms/ui/AudioAttachmentView;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmAlert;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/ComboAlbum;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.SET_ALWAYS_FINISH', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/common/widget/CompositeCursorAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/camera/ui/EffectSettingPopup;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage$1;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/net/NetworkPolicyEditor$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-stopDtmf-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/TabActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-populateDayInfo-(I Landroid/text/format/Time;)Lcom/android/calendar/widget/CalendarAppWidgetModel$DayInfo;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/ui/FilmStripView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/adapter/ItemOperationsParser;-parseResponse-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/ContactSaveService;-renameGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/bluetooth/opp/BluetoothOppReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowSession$Stub$Proxy;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/Recorder;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/FdnSetting;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-stopWifi-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/browser/BrowserBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/LocationManager;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/NetworkManagementService;-notifyInterfaceAdded-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-access$400-(Lcom/android/contacts/model/AccountTypeManagerImpl; Landroid/content/Context;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/nfc/TechListChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/email/service/EmailServiceUtils$NullEmailService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/ExchangeService$1$3;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateEventRelatedTable-(Landroid/net/Uri; Ljava/lang/String; Z Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/INfcTag$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertService;-updateAlertNotification-(Landroid/content/Context;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/speech/SpeechRecognizer;-access$200-(Landroid/speech/SpeechRecognizer;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinIME;-resetContactsDictionary-(Lcom/android/inputmethod/latin/ContactsDictionary;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-listBonds-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/media/effect/effects/AutoFixEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/webkit/HTML5VideoFullScreen$1;-surfaceDestroyed-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilityEnableScriptInjectionPreference;-onDialogClosed-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setScanMode-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Z)V' : ['android.permission.INTERNET'],
	'Landroid/media/AudioService$AudioHandler;-cleanupPlayer-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PackageSummary;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/DockService;-createDialog-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WiredAccessoryObserver;-sendIntents-(I I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-getProfileConnectionState-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/view/EventRedirectingFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/QueryBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-registerForSuppServiceNotification-(Landroid/os/Handler; I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-putString-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/InputStreamSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onLabelRebuilt-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/bluetooth/IBluetooth$Stub;-connectChannelToSource-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/location/LocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateSettings-(Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-access$600-(Lcom/android/bluetooth/opp/BluetoothOppTransfer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/P2pEventListener;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-update-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-setInterfaceThrottle-(Ljava/lang/String; I I)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/svox/pico/PicoService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/IVibratorService;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-setUsbMassStorageEnabled-(Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/server/BluetoothService;-connectInputDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ModePicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller$9;-doInBackground-([Lcom/android/browser/Tab;)Ljava/lang/Long;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/PhoneApp;-initForNewRadioTechnology-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/MessageUtils;-getNotificationIndDetails-(Landroid/content/Context; Landroid/database/Cursor;)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackActivity$5;-onClick-(Landroid/view/View;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarUtils$TimeZoneUtils;-setTimeZone-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/recent/RecentsPanelView;-refreshRecentTasksList-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/mms/data/Conversation;-loadFromThreadId-(J Z)Z' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/widget/CompoundButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService$6;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller$3;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/deprecated/VoiceProxy$6;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/widget/HorizontalScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/deviceinfo/Memory;-doUnmount-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/settings/widget/ChartSweepView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadThread;-openResponseEntity-(Lcom/android/providers/downloads/DownloadThread$State; Lorg/apache/http/HttpResponse;)Ljava/io/InputStream;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-bringUpServiceLocked-(Lcom/android/server/am/ServiceRecord; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/contacts/DatabaseModifier;-update-(Ljava/lang/String; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/activities/PeopleActivity;-showEmptyStateForTab-(Lcom/android/contacts/activities/ActionBarAdapter$TabState;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-makeStatusBarView-()Landroid/view/View;' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/CreatePlaylist;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/NotificationManagerService;-enqueueNotificationInternal-(Ljava/lang/String; I I Ljava/lang/String; I I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Landroid/provider/Contacts$ContactMethods;-addPostalLocation-(Landroid/content/Context; J D D)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsHorizontalScrollView$2;-onClick-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/contacts/vcard/CancelActivity;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/TestActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-setNetworkTemplateEnabled-(Landroid/net/NetworkTemplate; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/BrowserWebView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/OutputStreamTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/provider/CallLog$Calls;-getLastOutgoingCall-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/ui/EdgeView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/CallDetailActivity$1UpdateContactDetailsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/p2p/WifiP2pService;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/ContactEditorFragment$EntityDeltaComparator;-compare-(Ljava/lang/Object; Ljava/lang/Object;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/service/wallpaper/WallpaperService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/IBatteryStats;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DataUsageSummary;-getActiveSubscriberId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/storage/IMountService;-shutdown-(Landroid/os/storage/IMountShutdownObserver;)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/phone/InCallScreen;-internalAnswerCall-()V' : ['android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-updateNetworkRulesLocked-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/MailService;-setupAccountManagerAccount-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Z Z Z Landroid/accounts/AccountManagerCallback;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEvent-(Ljava/lang/Object; J J J J I I J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/connectivity/Vpn;-prepare-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getPDPContextList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToFrontLocked-(Lcom/android/server/am/TaskRecord; Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-onClickRecentButton-()V' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/Gallery;-startGetContent-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/transaction/MessagingNotification;-updateNotification-(Landroid/content/Context; Landroid/content/Intent; Ljava/lang/String; I Z Ljava/lang/CharSequence; J Ljava/lang/String; I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary$UidDetailTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DataUsageSummary;-buildLimitedNetworksList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/alerts/AlertService;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/app/AlbumPicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/deskclock/DigitalClock;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/os/INetworkManagementService$Stub;-getInterfaceTxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Settings$System;-putLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallTouchUi;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-outputRawContactsAsVCard-(Landroid/net/Uri; Ljava/io/OutputStream; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/content/SyncManager$SyncHandler;-maybeStartNextSyncLocked-()J' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/NfcAdapter;-setOnNdefPushCompleteCallback-(Landroid/nfc/NfcAdapter$OnNdefPushCompleteCallback; Landroid/app/Activity; [Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BookmarkSearch;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/RadioInfo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/InputManager$Callbacks;-notifyANR-(Lcom/android/server/wm/InputApplicationHandle; Lcom/android/server/wm/InputWindowHandle;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$CustomFilterConfigurationLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-getSpnFsm-(Z Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/nfc/NfcBackupAgent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/DataUsage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/VideoCamera;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-updateWallpaperLocked-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/launcher2/PagedViewGridLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/UserDictionarySettings;-access$200-(Lcom/android/settings/UserDictionarySettings; Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/VCardService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ConfirmLockPattern;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-onContentChanged-()V' : ['android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/MountService;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$NotificationClicker;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.USE_CREDENTIALS', 'android.permission.GET_TASKS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/Controller;-loadMessageForView-(J)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/Suggest;-<init>-(Landroid/content/Context; I Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/music/MediaPlaybackActivity;-access$700-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Tab$7;-onDownloadStart-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/AttachmentDownloadService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-createServerSession-(Ljavax/obex/ObexTransport;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupAccountType;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallNotifier$1;-onMessageWaitingIndicatorChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/media/MtpService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onLongTap-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/Suggest;-initWhitelistAndAutocorrectAndPool-(Landroid/content/Context; Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/server/BluetoothService;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ActivityBase;-onPause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/photoeditor/actions/CropView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnection;-makeDataConnection-(Lcom/android/internal/telephony/PhoneBase; I Lcom/android/internal/telephony/RetryManager;)Lcom/android/internal/telephony/gsm/GsmDataConnection;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/BackupManagerService$PerformFullBackupTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onScreenTurnedOn-(Lcom/android/internal/policy/impl/KeyguardViewManager$ShowListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/phone/sip/SipSettings;-access$500-(Lcom/android/phone/sip/SipSettings; Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$ImportRequestConnection;-sendImportRequest-(Ljava/util/List;)V' : ['android.permission.VIBRATE'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AllInOneActivity;-initFragments-(J I Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-addVoiceMailNumberPanel-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MusicUtils;-playAll-(Landroid/content/Context; [J I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/accounts/AddAccountSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/videoeditor/OverlayTitleEditor;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothA2dp;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/Workspace;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingItem;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactTileSecondaryTargetView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothPanProfileHandler;-disconnectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/LockPatternUtils;-setBoolean-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/alerts/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/ActivityPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/base/FrameFetch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/ContactTileStarredView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/PhoneApp;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/activities/ContactDetailActivity$2$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ApnSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/AppsCustomizeTabHost;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/development/EnterURL$UrlEditText;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/panorama/PanoramaActivity;-releaseSoundRecorder-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-setPropertiesByCarrier-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/WebViewFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/util/NameConverter;-structuredNameToDisplayName-(Landroid/content/Context; Landroid/content/ContentValues;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnBySearch-(I Lcom/android/internal/telephony/AdnRecord; Lcom/android/internal/telephony/AdnRecord; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseAccountActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageFileViewFragment;-reloadUiFromMessage-(Lcom/android/emailcommon/provider/EmailContent$Message; Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.INTERNET'],
	'Lcom/android/server/net/NetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/development/Connectivity;-access$2500-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/NavScreen$1;-onRemovePosition-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfoForSelf-()Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/app/RingtonePickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/settings/ChooseLockPassword;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/AttachmentDownloadService;-watchdogAlarm-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/activities/PeopleActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageFileViewFragment;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/svox/pico/CheckVoiceData;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/TrackBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/ui/DownloadList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/photoeditor/PhotoView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/SizeLimitActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/UserUnigramDictionary;-<init>-(Landroid/content/Context; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onActionIntentReconnectAlarm-(Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/Activity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/TechListChooserActivity;-onCreate-(Landroid/os/Bundle; Landroid/content/Intent; Ljava/lang/CharSequence; [Landroid/content/Intent; Ljava/util/List; Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/VideoCamera;-onInfo-(Landroid/media/MediaRecorder; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/google/common/io/CharStreams;-readFirstLine-(Lcom/google/common/io/InputSupplier;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/net/IConnectivityManager;-prepareVpn-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/MediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-requestCloseOtaFailureNotice-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneInterfaceManager;-supplyPuk-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/Settings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/MccTable;-setLocaleFromMccIfNeeded-(Lcom/android/internal/telephony/PhoneBase; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/phone/DataUsageListener$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/DeleteItems;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService$6;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-prepareEmptyView-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/ChooseLockPatternTutorial;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/model/EntityDeltaList;-buildSplitContactDiff-(Ljava/util/ArrayList; [I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-onNegative-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-readDataConnectionState-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-onBackPressed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/deskclock/AlarmKlaxon;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-removeTracksInternal-(I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-scanForward-(I J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/Suggest;-initAsynchronously-(Landroid/content/Context; I Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/inputmethod/deprecated/voice/VoiceInput;-<init>-(Landroid/content/Context; Lcom/android/inputmethod/deprecated/voice/VoiceInput$UiListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/bluetooth/BluetoothHeadset;-startScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-setupService-()Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/photoeditor/actions/RedEyeAction;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/search/SearchManagerService$GlobalSearchProviderObserver;-<init>-(Landroid/server/search/SearchManagerService; Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IAccountService$Stub$Proxy;-notifyLoginFailed-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/videoeditor/KenBurnsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyDialer;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItems-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/ProviderStatusLoader$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/pm/PackageManagerService$AppDirObserver;-onEvent-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/DeviceAccountLogin;-handleLogin-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/event/AttendeesView;-access$100-(Lcom/android/calendar/event/AttendeesView; Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/svox/pico/DownloadVoiceData;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/SwipeHelper$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$2;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$3;-forgotPattern-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/pm/PackageManagerService;-deletePackageLI-(Ljava/lang/String; Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/UserBigramDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/util/EmptyService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-getWithUri-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)Landroid/util/Pair;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-showUnbondMessage-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/ManageCachePage;-resume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserPreferencesPage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onInvalidSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wm/WindowManagerService;-addWindow-(Lcom/android/server/wm/Session; Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/NavScreen;-openNewTab-()V' : ['android.permission.INTERNET'],
	'Lcom/android/development/DevelopmentSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$TagService;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/providers/media/MediaScannerService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree;-access$700-(Lcom/android/phone/BluetoothHandsfree; I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/commands/bmgr/Bmgr;-doRestoreAll-(J Ljava/util/HashSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/RunningProcesses;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-updateBluetoothIndication-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BrowserWebView;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlotView$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/settings/GallerySettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/view/menu/ListMenuItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/TabStripView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-readLines-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/util/List;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetooth$Stub;-listBonds-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-initialize-(Landroid/os/Bundle; Lcom/android/contacts/list/ContactsRequest;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/MessagingController;-checkMail-(J J Lcom/android/email/MessagingListener;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/Screensaver;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/SetAlarm$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ActionBarAdapter$MyTabListener;-onTabSelected-(Landroid/app/ActionBar$Tab; Landroid/app/FragmentTransaction;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/vpndialogs/ManageDialog;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$AmsTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/deskclock/HandleSetAlarm;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$24;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/EmailConnectivityManager;-waitForConnectivity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/ChooseLockPattern;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth$Stub;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/VideoView$2;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/DevelopmentSettings$9;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaListView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/settings/wifi/WifiApEnabler;-<init>-(Landroid/content/Context; Landroid/preference/CheckBoxPreference;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/RadioInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/AlbumSetView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/gadget/WidgetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-setInstallLocation-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/Conversation;-ensureThreadId-()J' : ['android.permission.READ_SMS'],
	'Lcom/android/exchange/EmailSyncAdapterService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnection-(I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/net/LinkProperties; Landroid/net/LinkCapabilities; I Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumSetDataAdapter;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/WifiService;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/music/MediaPlaybackService;-openCurrent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/SimContacts;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/event/EditEventView$3;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/IConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ListActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/DataUsageSummary;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Landroid/widget/TextView$HandleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactLoader$LoadContactTask;-doInBackground-([Ljava/lang/Void;)Lcom/android/contacts/ContactLoader$Result;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-finalizeBackup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LightsService$1;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/settings/ApnSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onContactUriQueryFinished-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$GroupDelta;-fromSettings-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Lcom/android/contacts/list/CustomContactListFilterActivity$GroupDelta;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/InCallScreen;-updateDialpadVisibility-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/sip/SipAudioCall;-endCall-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-isBluetoothA2dpOn-()Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RemoteViewsService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/Email;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TableLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService;-setDnsServersForInterface-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/nfc/tech/NfcB;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Landroid/nfc/INfcTag$Stub;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/inputmethod/latin/DictionaryCollection;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/effects/SharpenEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/CommandsInterface;-reportSmsMemoryStatus-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/group/GroupDetailFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/text/StringLogger;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/PopImapAuthenticatorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyDefaultData-(Lcom/android/internal/telephony/ApnContext;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$3;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/OtaStartupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/IActivityManager;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/LocationManager;-getProviders-(Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/CrossProcessEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/pm/PackageManagerService;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/exchange/CalendarSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/RuimCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/MifareClassic;-transfer-(I)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mms/model/MediaModelFactory;-getMediaModel-(Landroid/content/Context; Lorg/w3c/dom/smil/SMILMediaElement; Lcom/android/mms/model/LayoutModel; Lcom/google/android/mms/pdu/PduBody;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadService;-access$500-(Lcom/android/providers/downloads/DownloadService; Lcom/android/providers/downloads/DownloadInfo$Reader; Lcom/android/providers/downloads/DownloadInfo; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET'],
	'Lcom/android/email/Controller$LegacyListener;-loadMessageForViewStarted-(J)V' : ['android.permission.INTERNET'],
	'Lcom/android/providers/calendar/CalendarProvider2;-doUpdateTimezoneDependentFields-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-initSstIcc-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/CallbackFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/webkit/HTML5VideoView;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/ChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-createDictAndProximity-(Ljava/util/Locale;)Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/net/wifi/SupplicantStateTracker;-sendSupplicantStateChangedBroadcast-(Landroid/net/wifi/SupplicantState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameBranch;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/DownloadManager;-getUriForDownloadedFile-(J)Landroid/net/Uri;' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/pm/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchUnhandledKey-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/BatteryStatsService;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserHistoryPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/BackupManagerService;-bindToAgentSynchronous-(Landroid/content/pm/ApplicationInfo; I)Landroid/app/IBackupAgent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/IFaceLockCallback;-cancel-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/transaction/SendTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$5500-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/provider/BrowserProvider;-doSuggestQuery-(Ljava/lang/String; [Ljava/lang/String; Z)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$AudioFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ConnectivityService;-sendGeneralBroadcastDelayed-(Landroid/net/NetworkInfo; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/LogViewer;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/AudioModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/videoeditor/TransitionsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/EmergencyDialer;-keyPressed-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/music/QueryBrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity;-onQueryTextSubmit-(Ljava/lang/String;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/EnableIccPinScreen;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/TetherSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/view/IWindowSession$Stub$Proxy;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/location/ILocationManager$Stub;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/Gallery;-initializeByIntent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSettingsFragment;-onPause-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-onRestrictedStateChanged-(Landroid/os/AsyncResult;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService;-onSeMifareAccess-([B)V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-removeRoute-(Ljava/lang/String; Landroid/net/RouteInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-handleIMEIDisplay-(Landroid/content/Context; Ljava/lang/String; Z)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-signalPersistentProcesses-(I)V' : ['android.permission.SIGNAL_PERSISTENT_PROCESSES'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1000-(Lcom/android/internal/policy/impl/KeyguardViewMediator;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/emailcommon/service/AccountServiceProxy$1;-run-()V' : ['android.permission.VIBRATE'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/applications/LinearColorBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/vcard/CancelActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/VideoCamera;-startVideoRecording-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/latin/LatinIME;-onPress-(I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onShowMoreKeysPanel-(I I J Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/base/RetargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-sendPing-([B I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Email;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/Settings$DeviceAdminSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/nfc/NfcService;-onRemoteFieldActivated-()V' : ['android.permission.VIBRATE', 'android.permission.GET_TASKS'],
	'Lcom/android/gallery3d/ui/SlideshowView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-setDataOnRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavTabScroller;-onLayout-(Z I I I I)V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/MonthByWeekFragment$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setFilter-(Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/INfcTag;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-createImportRequest-()Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine$DriverUnloadingState$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageListAdapter;-onContentChanged-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/ContextImpl;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager$Stub;-freezeRotation-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/ContactsLiveFolders$PhoneContacts;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/WeekSelector;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$TagService;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/phone/BluetoothHeadsetService;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockPattern$ChooseLockPatternFragment;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/WorkingMessage;-deleteDraftSmsMessage-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/os/IPowerManager$Stub$Proxy;-setStayOnSetting-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-dispatchAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView$2;-onClick-(Landroid/view/View;)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Lcom/android/server/wm/AppWindowToken; I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ManageConferenceUtils;-endConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/IccFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConversationList;-createNewMessage-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-hideNavScreen-(I Z)V' : ['android.permission.INTERNET'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/util/EmptyService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BaseUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-readChunked-(Ljava/io/InputStream; Ljava/io/OutputStream; I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettings;-refreshAccessPoints-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragment;-onOpenAttachment-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/WeekSelector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/TrackBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ThrottleService;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreenShowActivation;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NotificationPlayer;-access$500-(Lcom/android/server/NotificationPlayer; Lcom/android/server/NotificationPlayer$Command;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiApEnabler;-setSoftapEnabled-(Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/camera/VideoCamera;-updateRecordingTime-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/WifiStateMachine;-access$6900-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/Files;-move-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/ShowActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ContactListItemView$DontPressWithParentImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/text/StringSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/keychain/KeyChainService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-updateFullImage-(J Lcom/android/gallery3d/util/Future;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/Controller;-serviceLogging-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/systemui/usb/UsbPermissionActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/MessageList$1;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/BackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/contacts/LegacyContactImporter;-insertCall-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$UserAuthorizingGroupNegotiationState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-connectChannelToSource-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ActionBarContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/MessagingController$2;-run-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/SearchActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListPinnedHeaderView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$5$1$3;-run-()V' : ['android.permission.GET_TASKS'],
	'Lcom/android/email/service/AttachmentDownloadService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/statusbar/tablet/NotificationPeekPanel;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dispose-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-requestStateChange-(Landroid/content/Context; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/ExchangeService$2;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/ImageSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/event/EditEventHelper$EditDoneRunnable;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/camera/VideoCamera;-access$600-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/activities/PeopleActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-processMiscUsage-()V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackActivity;-cycleRepeat-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/LauncherApplication;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/calllog/ContactInfoHelper;-queryContactInfoForSipAddress-(Ljava/lang/String;)Lcom/android/contacts/calllog/ContactInfo;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/server/ConnectivityService;-prepareVpn-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/ContextThemeWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/AbsoluteLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/AlarmAlert;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/IAudioService$Stub;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/svox/pico/DownloadVoiceData;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/DataConnection$DcActivatingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage$4;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHeadsetService$RfcommConnectThread;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/development/DataList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-onPlayPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$IncomingScoAcceptThread;-<init>-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-startScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapSyncAdapterService$SyncAdapterImpl;-onPerformSync-(Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-setDnsForwarders-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/widget/LockPatternUtils;-setPermanentlyLocked-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/INetworkManagementService$Stub$Proxy;-getInterfaceRxThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/SettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/AtParser;-process-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/AllInOneActivity$3;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothA2dp;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/calendar/CalendarSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinIME;-commitTyped-(Landroid/view/inputmethod/InputConnection;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/data/WorkingMessage;-preSendSmsWorker-(Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/DevicePolicyManagerService;-access$200-(Lcom/android/server/DevicePolicyManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDone-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/data/WorkingMessage;-saveDraft-(Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/data/WorkingMessage;-saveAsMms-(Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/TrackBrowserActivity;-getTrackCursor-(Lcom/android/music/TrackBrowserActivity$TrackListAdapter$TrackQueryHandler; Ljava/lang/String; Z)Landroid/database/Cursor;' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService$2;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/usb/UsbAccessoryUriActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/FlipFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-goTo-(J Z Z Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingApplication-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/deskclock/AlarmKlaxon;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/CallContactActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/interactions/ContactDeletionInteraction;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/model/VideoModel;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setForegroundDispatch-(Landroid/app/PendingIntent; [Landroid/content/IntentFilter; Landroid/nfc/TechListParcel;)V' : ['android.permission.NFC'],
	'Landroid/support/v4/app/FragmentActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/usb/UsbAccessoryUriActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessForeground-(Landroid/os/IBinder; I Z)V' : ['android.permission.SET_PROCESS_LIMIT'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothAdapterStateMachine$PerProcessState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiManager$WifiLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/policy/NotificationRowLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-reconnect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/RingtonePickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-query-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/Conversation;-dumpThreadsTable-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setLocaleFromCsim-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Phone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/NfcHandler;-register-(Landroid/app/Activity; Lcom/android/contacts/detail/ContactDetailFragment;)V' : ['android.permission.NFC'],
	'Landroid/net/IThrottleManager;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/BandMode;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/Workspace;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/launcher2/RocketLauncher$Board;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/Connection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/RotateImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/app/FragmentActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/Downloads$ByUri;-getCurrentOtaDownloads-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/NullFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-access$400-(Lcom/android/calendar/event/EditEventView;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/WifiManager;-getWifiApState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumPage$1;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/UsageStats;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onVisibilityChanged-(Z)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothHealth;-registerAppConfiguration-(Ljava/lang/String; I I I Landroid/bluetooth/BluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/homepages/RequestHandler;-doHandleRequest-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ActivityManagerNative;-updateConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/quicksearchbox/util/JavaNetHttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-handleVolumeKey-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-copyMedia-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/music/AudioPreview;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/TileImageView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp;-connectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-orientationChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CellBroadcastSms;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$1;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment; Landroid/widget/ProgressBar; Lcom/android/email/activity/MessageViewFragmentBase$1;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasTestAuthenticatorService$EasAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/AccessibilityTutorialActivity$TouchTutorialModule1;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/PeopleActivity;-areGroupWritableAccountsAvailable-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService;-checkScoAudioState-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/SuggestionsView;-addToDictionary-(Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_USER_DICTIONARY'],
	'Landroid/view/IWindowManager$Stub$Proxy;-clearForcedDisplaySize-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.CALL_PHONE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItems-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/telephony/PhoneNumberUtils;-isVoiceMailNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/phone/EnableIccPinScreen;-access$300-(Lcom/android/phone/EnableIccPinScreen;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-handleInetConditionChange-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$CustomFilterConfigurationLoader;-loadInBackground-()Lcom/android/contacts/list/CustomContactListFilterActivity$AccountSet;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/email/view/RigidWebView;-onPinchToZoomAnimationEnd-(Landroid/view/ScaleGestureDetector;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/SystemUIService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setPropertiesByCarrier-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/accessibility/FlickGestureDetector;-clearFlick-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_USER_DICTIONARY', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallCard;-updateForegroundCall-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/model/MediaModelFactory;-createEmptyTextModel-(Landroid/content/Context; Lcom/android/mms/drm/DrmWrapper; Lcom/android/mms/model/RegionModel;)Lcom/android/mms/model/MediaModel;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-startSync-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AsyncPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-placeCall-(Landroid/content/Context; Lcom/android/internal/telephony/Phone; Ljava/lang/String; Landroid/net/Uri; Z Landroid/net/Uri;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.BROADCAST_STICKY', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/util/SingleThreadNamedTaskExecutor$Worker;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/Application;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/BluetoothHandsfree$22;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/