/* tracker-xml-cursor.c generated by valac 0.56.0, the Vala compiler
 * generated from tracker-xml-cursor.vala, do not modify */

/*
 * Copyright (C) 2016 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include "tracker-remote-soup2.h"
#include <libxml/tree.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <libxml/parser.h>

#define TRACKER_REMOTE_XML_CURSOR_XSD_NS "http://www.w3.org/2001/XMLSchema#"

enum  {
	TRACKER_REMOTE_XML_CURSOR_0_PROPERTY,
	TRACKER_REMOTE_XML_CURSOR_N_COLUMNS_PROPERTY,
	TRACKER_REMOTE_XML_CURSOR_NUM_PROPERTIES
};
static GParamSpec* tracker_remote_xml_cursor_properties[TRACKER_REMOTE_XML_CURSOR_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerRemoteXmlCursorNextAsyncData TrackerRemoteXmlCursorNextAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerRemoteXmlCursorPrivate {
	xmlNode* _results;
	xmlNode* _cur_row;
	GHashTable* _cur_row_map;
	gchar** _vars;
	gint _vars_length1;
	gint __vars_size_;
};

struct _TrackerRemoteXmlCursorNextAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteXmlCursor* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

static gint TrackerRemoteXmlCursor_private_offset;
static gpointer tracker_remote_xml_cursor_parent_class = NULL;

static xmlNode* tracker_remote_xml_cursor_find_first_child_node (TrackerRemoteXmlCursor* self,
                                                          xmlNode* node);
static xmlNode* tracker_remote_xml_cursor_find_next_node (TrackerRemoteXmlCursor* self,
                                                   xmlNode* node);
static xmlNode* tracker_remote_xml_cursor_lookup_child_node (TrackerRemoteXmlCursor* self,
                                                      xmlNode* node,
                                                      const gchar* name);
static xmlAttr* tracker_remote_xml_cursor_lookup_attribute (TrackerRemoteXmlCursor* self,
                                                     xmlNode* node,
                                                     const gchar* name);
static void tracker_remote_xml_cursor_parse_vars (TrackerRemoteXmlCursor* self,
                                           xmlNode* vars);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _g_free0_ (gpointer var);
static TrackerSparqlValueType tracker_remote_xml_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                                                      gint column);
static const gchar* tracker_remote_xml_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                               gint column);
static const gchar* tracker_remote_xml_cursor_real_get_string (TrackerSparqlCursor* base,
                                                        gint column,
                                                        glong* length);
static gboolean tracker_remote_xml_cursor_real_next (TrackerSparqlCursor* base,
                                              GCancellable* cancellable,
                                              GError** error);
static void tracker_remote_xml_cursor_real_next_async_data_free (gpointer _data);
static void tracker_remote_xml_cursor_real_next_async (TrackerSparqlCursor* base,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean tracker_remote_xml_cursor_real_next_async_co (TrackerRemoteXmlCursorNextAsyncData* _data_);
static void tracker_remote_xml_cursor_real_rewind (TrackerSparqlCursor* base);
static void tracker_remote_xml_cursor_real_close (TrackerSparqlCursor* base);
static void tracker_remote_xml_cursor_finalize (GObject * obj);
static GType tracker_remote_xml_cursor_get_type_once (void);
static void _vala_tracker_remote_xml_cursor_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tracker_remote_xml_cursor_get_instance_private (TrackerRemoteXmlCursor* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerRemoteXmlCursor_private_offset);
}

static xmlNode*
tracker_remote_xml_cursor_find_first_child_node (TrackerRemoteXmlCursor* self,
                                                 xmlNode* node)
{
	xmlNode* result;
#line 30 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "tracker-xml-cursor.c"
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp0_;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = node->children;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		iter = _tmp0_;
#line 146 "tracker-xml-cursor.c"
		{
			gboolean _tmp1_ = FALSE;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_tmp1_ = TRUE;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			while (TRUE) {
#line 153 "tracker-xml-cursor.c"
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				xmlNode* _tmp6_;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!_tmp1_) {
#line 159 "tracker-xml-cursor.c"
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp2_ = iter;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp3_ = _tmp2_->next;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					iter = _tmp3_;
#line 168 "tracker-xml-cursor.c"
				}
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp1_ = FALSE;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp4_ = iter;
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!(_tmp4_ != NULL)) {
#line 31 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					break;
#line 178 "tracker-xml-cursor.c"
				}
#line 32 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp5_ = iter;
#line 32 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp5_->type != XML_ELEMENT_NODE) {
#line 33 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 186 "tracker-xml-cursor.c"
				}
#line 34 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp6_ = iter;
#line 34 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				result = _tmp6_;
#line 34 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				return result;
#line 194 "tracker-xml-cursor.c"
			}
		}
	}
#line 37 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = NULL;
#line 37 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 202 "tracker-xml-cursor.c"
}

static xmlNode*
tracker_remote_xml_cursor_find_next_node (TrackerRemoteXmlCursor* self,
                                          xmlNode* node)
{
	xmlNode* result;
#line 40 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 212 "tracker-xml-cursor.c"
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp0_;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = node->next;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		iter = _tmp0_;
#line 220 "tracker-xml-cursor.c"
		{
			gboolean _tmp1_ = FALSE;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_tmp1_ = TRUE;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			while (TRUE) {
#line 227 "tracker-xml-cursor.c"
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				xmlNode* _tmp6_;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!_tmp1_) {
#line 233 "tracker-xml-cursor.c"
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp2_ = iter;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp3_ = _tmp2_->next;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					iter = _tmp3_;
#line 242 "tracker-xml-cursor.c"
				}
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp1_ = FALSE;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp4_ = iter;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!(_tmp4_ != NULL)) {
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					break;
#line 252 "tracker-xml-cursor.c"
				}
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp5_ = iter;
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp5_->type != XML_ELEMENT_NODE) {
#line 43 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 260 "tracker-xml-cursor.c"
				}
#line 44 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp6_ = iter;
#line 44 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				result = _tmp6_;
#line 44 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				return result;
#line 268 "tracker-xml-cursor.c"
			}
		}
	}
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = NULL;
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 276 "tracker-xml-cursor.c"
}

static xmlNode*
tracker_remote_xml_cursor_lookup_child_node (TrackerRemoteXmlCursor* self,
                                             xmlNode* node,
                                             const gchar* name)
{
	xmlNode* result;
#line 50 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 289 "tracker-xml-cursor.c"
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp0_;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = node->children;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		iter = _tmp0_;
#line 297 "tracker-xml-cursor.c"
		{
			gboolean _tmp1_ = FALSE;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_tmp1_ = TRUE;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			while (TRUE) {
#line 304 "tracker-xml-cursor.c"
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				xmlNode* _tmp6_;
				const gchar* _tmp7_;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!_tmp1_) {
#line 311 "tracker-xml-cursor.c"
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp2_ = iter;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp3_ = _tmp2_->next;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					iter = _tmp3_;
#line 320 "tracker-xml-cursor.c"
				}
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp1_ = FALSE;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp4_ = iter;
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!(_tmp4_ != NULL)) {
#line 51 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					break;
#line 330 "tracker-xml-cursor.c"
				}
#line 52 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp5_ = iter;
#line 52 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp5_->type != XML_ELEMENT_NODE) {
#line 53 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 338 "tracker-xml-cursor.c"
				}
#line 54 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp6_ = iter;
#line 54 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp7_ = _tmp6_->name;
#line 54 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (g_strcmp0 (_tmp7_, name) == 0) {
#line 346 "tracker-xml-cursor.c"
					xmlNode* _tmp8_;
#line 55 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp8_ = iter;
#line 55 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					result = _tmp8_;
#line 55 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					return result;
#line 354 "tracker-xml-cursor.c"
				}
			}
		}
	}
#line 58 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = NULL;
#line 58 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 363 "tracker-xml-cursor.c"
}

static xmlAttr*
tracker_remote_xml_cursor_lookup_attribute (TrackerRemoteXmlCursor* self,
                                            xmlNode* node,
                                            const gchar* name)
{
	xmlAttr* result;
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 376 "tracker-xml-cursor.c"
	{
		xmlAttr* iter = NULL;
		xmlAttr* _tmp0_;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = node->properties;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		iter = _tmp0_;
#line 384 "tracker-xml-cursor.c"
		{
			gboolean _tmp1_ = FALSE;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_tmp1_ = TRUE;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			while (TRUE) {
#line 391 "tracker-xml-cursor.c"
				xmlAttr* _tmp4_;
				xmlAttr* _tmp5_;
				const gchar* _tmp6_;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!_tmp1_) {
#line 397 "tracker-xml-cursor.c"
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp2_ = iter;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp3_ = _tmp2_->next;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					iter = _tmp3_;
#line 406 "tracker-xml-cursor.c"
				}
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp1_ = FALSE;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp4_ = iter;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!(_tmp4_ != NULL)) {
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					break;
#line 416 "tracker-xml-cursor.c"
				}
#line 63 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp5_ = iter;
#line 63 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp6_ = _tmp5_->name;
#line 63 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (g_strcmp0 (_tmp6_, name) == 0) {
#line 424 "tracker-xml-cursor.c"
					xmlAttr* _tmp7_;
#line 64 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp7_ = iter;
#line 64 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					result = _tmp7_;
#line 64 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					return result;
#line 432 "tracker-xml-cursor.c"
				}
			}
		}
	}
#line 67 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = NULL;
#line 67 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 441 "tracker-xml-cursor.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if ((*length) == (*size)) {
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 456 "tracker-xml-cursor.c"
	}
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	(*array)[(*length)++] = value;
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	(*array)[*length] = NULL;
#line 462 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_parse_vars (TrackerRemoteXmlCursor* self,
                                      xmlNode* vars)
{
#line 70 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_if_fail (self != NULL);
#line 471 "tracker-xml-cursor.c"
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp0_;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = vars->children;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		iter = _tmp0_;
#line 479 "tracker-xml-cursor.c"
		{
			gboolean _tmp1_ = FALSE;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_tmp1_ = TRUE;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			while (TRUE) {
#line 486 "tracker-xml-cursor.c"
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				const gchar* _tmp7_;
				xmlAttr* attr = NULL;
				xmlNode* _tmp9_;
				xmlAttr* _tmp10_;
				xmlAttr* _tmp11_;
				xmlAttr* _tmp12_;
				xmlNode* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!_tmp1_) {
#line 501 "tracker-xml-cursor.c"
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp2_ = iter;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp3_ = _tmp2_->next;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					iter = _tmp3_;
#line 510 "tracker-xml-cursor.c"
				}
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp1_ = FALSE;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp4_ = iter;
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!(_tmp4_ != NULL)) {
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					break;
#line 520 "tracker-xml-cursor.c"
				}
#line 72 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp6_ = iter;
#line 72 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp7_ = _tmp6_->name;
#line 72 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (g_strcmp0 (_tmp7_, "variable") != 0) {
#line 72 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp5_ = TRUE;
#line 530 "tracker-xml-cursor.c"
				} else {
					xmlNode* _tmp8_;
#line 73 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp8_ = iter;
#line 73 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp5_ = _tmp8_->type != XML_ELEMENT_NODE;
#line 537 "tracker-xml-cursor.c"
				}
#line 72 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp5_) {
#line 74 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 543 "tracker-xml-cursor.c"
				}
#line 76 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp9_ = iter;
#line 76 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp10_ = tracker_remote_xml_cursor_lookup_attribute (self, _tmp9_, "name");
#line 76 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				attr = _tmp10_;
#line 77 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp11_ = attr;
#line 77 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp11_ == NULL) {
#line 78 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 557 "tracker-xml-cursor.c"
				}
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp12_ = attr;
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp13_ = _tmp12_->children;
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp14_ = _tmp13_->content;
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp15_ = g_strdup (_tmp14_);
#line 80 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_vala_array_add1 (&self->priv->_vars, &self->priv->_vars_length1, &self->priv->__vars_size_, _tmp15_);
#line 569 "tracker-xml-cursor.c"
			}
		}
	}
}

static void
_g_free0_ (gpointer var)
{
#line 99 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	var = (g_free (var), NULL);
#line 580 "tracker-xml-cursor.c"
}

TrackerRemoteXmlCursor*
tracker_remote_xml_cursor_construct (GType object_type,
                                     const gchar* document,
                                     glong length,
                                     GError** error)
{
	TrackerRemoteXmlCursor * self = NULL;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* root = NULL;
	xmlDoc* _tmp3_;
	xmlNode* _tmp4_;
	xmlNode* _tmp5_;
	xmlNode* vars = NULL;
	xmlNode* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GError* _inner_error0_ = NULL;
#line 84 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 85 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) g_object_new (object_type, NULL);
#line 86 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	xmlInitParser ();
#line 87 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0_ = xmlParseMemory (document, (gint) length);
#line 87 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	doc = _tmp0_;
#line 89 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp1_ = doc;
#line 89 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp1_ == NULL) {
#line 617 "tracker-xml-cursor.c"
		GError* _tmp2_;
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "Could not parse XML document");
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_inner_error0_ = _tmp2_;
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			g_propagate_error (error, _inner_error0_);
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_g_object_unref0 (self);
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			return NULL;
#line 631 "tracker-xml-cursor.c"
		} else {
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			g_clear_error (&_inner_error0_);
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			return NULL;
#line 639 "tracker-xml-cursor.c"
		}
	}
#line 92 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp3_ = doc;
#line 92 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp4_ = xmlDocGetRootElement (_tmp3_);
#line 92 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	root = _tmp4_;
#line 93 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp5_ = tracker_remote_xml_cursor_lookup_child_node (self, root, "results");
#line 93 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self->priv->_results = _tmp5_;
#line 95 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp6_ = tracker_remote_xml_cursor_lookup_child_node (self, root, "head");
#line 95 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	vars = _tmp6_;
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	tracker_remote_xml_cursor_parse_vars (self, vars);
#line 97 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	xmlCleanupParser ();
#line 99 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp7_ = g_str_hash;
#line 99 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp8_ = g_str_equal;
#line 99 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, NULL);
#line 99 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_g_hash_table_unref0 (self->priv->_cur_row_map);
#line 99 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self->priv->_cur_row_map = _tmp9_;
#line 84 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return self;
#line 672 "tracker-xml-cursor.c"
}

TrackerRemoteXmlCursor*
tracker_remote_xml_cursor_new (const gchar* document,
                               glong length,
                               GError** error)
{
#line 84 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return tracker_remote_xml_cursor_construct (TRACKER_REMOTE_TYPE_XML_CURSOR, document, length, error);
#line 682 "tracker-xml-cursor.c"
}

static TrackerSparqlValueType
tracker_remote_xml_cursor_real_get_value_type (TrackerSparqlCursor* base,
                                               gint column)
{
	TrackerRemoteXmlCursor * self;
	xmlNode* _tmp0_;
	gchar* variable = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	xmlNode* node = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	xmlNode* _tmp7_;
	xmlNode* _tmp8_;
	xmlNode* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GQuark _tmp13_ = 0U;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	static GQuark _tmp12_label0 = 0;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	static GQuark _tmp12_label1 = 0;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	static GQuark _tmp12_label2 = 0;
#line 712 "tracker-xml-cursor.c"
	TrackerSparqlValueType result;
#line 106 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 106 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0_ = self->priv->_cur_row;
#line 106 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_vala_return_val_if_fail (_tmp0_ != NULL, "_cur_row != null", 0);
#line 107 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp1_ = self->priv->_vars;
#line 107 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp1__length1 = self->priv->_vars_length1;
#line 107 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp2_ = _tmp1_[column];
#line 107 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 107 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	variable = _tmp3_;
#line 108 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp4_ = self->priv->_cur_row_map;
#line 108 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp5_ = variable;
#line 108 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
#line 108 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	node = (xmlNode*) _tmp6_;
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp7_ = node;
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp7_ == NULL) {
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		result = TRACKER_SPARQL_VALUE_TYPE_UNBOUND;
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_g_free0 (variable);
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return result;
#line 748 "tracker-xml-cursor.c"
	}
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp8_ = node;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp9_ = _tmp8_->children;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp10_ = _tmp9_->name;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp11_ = _tmp10_;
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("uri")))) {
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		switch (0) {
#line 764 "tracker-xml-cursor.c"
			default:
			{
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				result = TRACKER_SPARQL_VALUE_TYPE_URI;
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_g_free0 (variable);
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				return result;
#line 773 "tracker-xml-cursor.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("bnode")))) {
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		switch (0) {
#line 779 "tracker-xml-cursor.c"
			default:
			{
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				result = TRACKER_SPARQL_VALUE_TYPE_BLANK_NODE;
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_g_free0 (variable);
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				return result;
#line 788 "tracker-xml-cursor.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("literal")))) {
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		switch (0) {
#line 794 "tracker-xml-cursor.c"
			default:
			{
				xmlAttr* attr = NULL;
				xmlNode* _tmp14_;
				xmlAttr* _tmp15_;
				xmlAttr* _tmp16_;
				xmlAttr* _tmp17_;
				xmlNode* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				GQuark _tmp22_ = 0U;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label0 = 0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label1 = 0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label2 = 0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label3 = 0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label4 = 0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label5 = 0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				static GQuark _tmp21_label6 = 0;
#line 118 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp14_ = node;
#line 118 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp15_ = tracker_remote_xml_cursor_lookup_attribute (self, _tmp14_, "datatype");
#line 118 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				attr = _tmp15_;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp16_ = attr;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp16_ == NULL) {
#line 120 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					result = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 120 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_g_free0 (variable);
#line 120 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					return result;
#line 836 "tracker-xml-cursor.c"
				}
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp17_ = attr;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp18_ = _tmp17_->children;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp19_ = _tmp18_->content;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp20_ = _tmp19_;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if ((((_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "byte")))) || (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "int"))))) || (_tmp22_ == ((0 != _tmp21_label2) ? _tmp21_label2 : (_tmp21_label2 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "integer"))))) || (_tmp22_ == ((0 != _tmp21_label3) ? _tmp21_label3 : (_tmp21_label3 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "long"))))) {
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					switch (0) {
#line 852 "tracker-xml-cursor.c"
						default:
						{
#line 127 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							result = TRACKER_SPARQL_VALUE_TYPE_INTEGER;
#line 127 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							_g_free0 (variable);
#line 127 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							return result;
#line 861 "tracker-xml-cursor.c"
						}
					}
				} else if ((_tmp22_ == ((0 != _tmp21_label4) ? _tmp21_label4 : (_tmp21_label4 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "decimal")))) || (_tmp22_ == ((0 != _tmp21_label5) ? _tmp21_label5 : (_tmp21_label5 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "double"))))) {
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					switch (0) {
#line 867 "tracker-xml-cursor.c"
						default:
						{
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							result = TRACKER_SPARQL_VALUE_TYPE_DOUBLE;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							_g_free0 (variable);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							return result;
#line 876 "tracker-xml-cursor.c"
						}
					}
				} else if (_tmp22_ == ((0 != _tmp21_label6) ? _tmp21_label6 : (_tmp21_label6 = g_quark_from_static_string (TRACKER_REMOTE_XML_CURSOR_XSD_NS "dateTime")))) {
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					switch (0) {
#line 882 "tracker-xml-cursor.c"
						default:
						{
#line 132 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							result = TRACKER_SPARQL_VALUE_TYPE_DATETIME;
#line 132 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							_g_free0 (variable);
#line 132 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							return result;
#line 891 "tracker-xml-cursor.c"
						}
					}
				} else {
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					switch (0) {
#line 897 "tracker-xml-cursor.c"
						default:
						{
#line 134 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							result = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 134 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							_g_free0 (variable);
#line 134 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
							return result;
#line 906 "tracker-xml-cursor.c"
						}
					}
				}
			}
		}
	} else {
#line 112 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		switch (0) {
#line 915 "tracker-xml-cursor.c"
			default:
			{
#line 137 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				result = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 137 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_g_free0 (variable);
#line 137 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				return result;
#line 924 "tracker-xml-cursor.c"
			}
		}
	}
}

static const gchar*
tracker_remote_xml_cursor_real_get_variable_name (TrackerSparqlCursor* base,
                                                  gint column)
{
	TrackerRemoteXmlCursor * self;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	const gchar* result;
#line 141 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (column < 0) {
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = TRUE;
#line 946 "tracker-xml-cursor.c"
	} else {
		gchar** _tmp1_;
		gint _tmp1__length1;
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp1_ = self->priv->_vars;
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp1__length1 = self->priv->_vars_length1;
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp0_ = column > _tmp1__length1;
#line 956 "tracker-xml-cursor.c"
	}
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp0_) {
#line 143 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		result = NULL;
#line 143 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return result;
#line 964 "tracker-xml-cursor.c"
	}
#line 144 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp2_ = self->priv->_vars;
#line 144 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp2__length1 = self->priv->_vars_length1;
#line 144 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp3_ = _tmp2_[column];
#line 144 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = _tmp3_;
#line 144 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 976 "tracker-xml-cursor.c"
}

static const gchar*
tracker_remote_xml_cursor_real_get_string (TrackerSparqlCursor* base,
                                           gint column,
                                           glong* length)
{
	TrackerRemoteXmlCursor * self;
	glong _vala_length = 0L;
	xmlNode* _tmp0_;
	gchar* variable = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	xmlNode* node = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	xmlNode* _tmp7_;
	xmlNode* child = NULL;
	xmlNode* _tmp8_;
	xmlNode* _tmp9_;
	xmlNode* _tmp10_;
	xmlNode* text = NULL;
	xmlNode* _tmp11_;
	xmlNode* _tmp12_;
	gboolean _tmp13_ = FALSE;
	xmlNode* _tmp14_;
	xmlNode* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	xmlNode* _tmp20_;
	const gchar* _tmp21_;
	const gchar* result;
#line 147 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 147 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0_ = self->priv->_cur_row;
#line 147 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_vala_return_val_if_fail (_tmp0_ != NULL, "_cur_row != null", NULL);
#line 148 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_vala_length = (glong) 0;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp1_ = self->priv->_vars;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp1__length1 = self->priv->_vars_length1;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp2_ = _tmp1_[column];
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	variable = _tmp3_;
#line 151 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp4_ = self->priv->_cur_row_map;
#line 151 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp5_ = variable;
#line 151 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
#line 151 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	node = (xmlNode*) _tmp6_;
#line 152 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp7_ = node;
#line 152 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp7_ == NULL) {
#line 153 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		result = NULL;
#line 153 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_g_free0 (variable);
#line 153 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		if (length) {
#line 153 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			*length = _vala_length;
#line 1051 "tracker-xml-cursor.c"
		}
#line 153 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return result;
#line 1055 "tracker-xml-cursor.c"
	}
#line 155 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp8_ = node;
#line 155 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp9_ = tracker_remote_xml_cursor_find_first_child_node (self, _tmp8_);
#line 155 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	child = _tmp9_;
#line 156 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp10_ = child;
#line 156 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp10_ == NULL) {
#line 157 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		result = NULL;
#line 157 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_g_free0 (variable);
#line 157 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		if (length) {
#line 157 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			*length = _vala_length;
#line 1075 "tracker-xml-cursor.c"
		}
#line 157 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return result;
#line 1079 "tracker-xml-cursor.c"
	}
#line 159 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp11_ = child;
#line 159 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp12_ = _tmp11_->children;
#line 159 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	text = _tmp12_;
#line 160 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp14_ = text;
#line 160 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp14_ == NULL) {
#line 160 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp13_ = TRUE;
#line 1093 "tracker-xml-cursor.c"
	} else {
		xmlNode* _tmp15_;
#line 161 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp15_ = text;
#line 161 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp13_ = _tmp15_->type != XML_TEXT_NODE;
#line 1100 "tracker-xml-cursor.c"
	}
#line 160 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp13_) {
#line 162 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		result = NULL;
#line 162 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_g_free0 (variable);
#line 162 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		if (length) {
#line 162 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			*length = _vala_length;
#line 1112 "tracker-xml-cursor.c"
		}
#line 162 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return result;
#line 1116 "tracker-xml-cursor.c"
	}
#line 164 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp16_ = text;
#line 164 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp17_ = _tmp16_->content;
#line 164 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp18_ = strlen (_tmp17_);
#line 164 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp19_ = _tmp18_;
#line 164 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_vala_length = (glong) _tmp19_;
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp20_ = text;
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp21_ = _tmp20_->content;
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = _tmp21_;
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_g_free0 (variable);
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (length) {
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		*length = _vala_length;
#line 1140 "tracker-xml-cursor.c"
	}
#line 165 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 1144 "tracker-xml-cursor.c"
}

static gboolean
tracker_remote_xml_cursor_real_next (TrackerSparqlCursor* base,
                                     GCancellable* cancellable,
                                     GError** error)
{
	TrackerRemoteXmlCursor * self;
	xmlNode* _tmp0_;
	GHashTable* _tmp5_;
	xmlNode* _tmp6_;
	gboolean result;
#line 168 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 169 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0_ = self->priv->_cur_row;
#line 169 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp0_ == NULL) {
#line 1163 "tracker-xml-cursor.c"
		xmlNode* _tmp1_;
		xmlNode* _tmp2_;
#line 170 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp1_ = self->priv->_results;
#line 170 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp2_ = tracker_remote_xml_cursor_find_first_child_node (self, _tmp1_);
#line 170 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		self->priv->_cur_row = _tmp2_;
#line 1172 "tracker-xml-cursor.c"
	} else {
		xmlNode* _tmp3_;
		xmlNode* _tmp4_;
#line 172 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp3_ = self->priv->_cur_row;
#line 172 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp4_ = tracker_remote_xml_cursor_find_next_node (self, _tmp3_);
#line 172 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		self->priv->_cur_row = _tmp4_;
#line 1182 "tracker-xml-cursor.c"
	}
#line 174 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp5_ = self->priv->_cur_row_map;
#line 174 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_hash_table_remove_all (_tmp5_);
#line 176 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp6_ = self->priv->_cur_row;
#line 176 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_tmp6_ == NULL) {
#line 177 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		result = FALSE;
#line 177 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return result;
#line 1196 "tracker-xml-cursor.c"
	}
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp7_;
		xmlNode* _tmp8_;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp7_ = self->priv->_cur_row;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		_tmp8_ = _tmp7_->children;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		iter = _tmp8_;
#line 1208 "tracker-xml-cursor.c"
		{
			gboolean _tmp9_ = FALSE;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			_tmp9_ = TRUE;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			while (TRUE) {
#line 1215 "tracker-xml-cursor.c"
				xmlNode* _tmp12_;
				xmlNode* _tmp13_;
				const gchar* _tmp14_;
				xmlAttr* attr = NULL;
				xmlNode* _tmp15_;
				xmlAttr* _tmp16_;
				xmlAttr* _tmp17_;
				gchar* binding_name = NULL;
				xmlAttr* _tmp18_;
				xmlNode* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				GHashTable* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				xmlNode* _tmp25_;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!_tmp9_) {
#line 1234 "tracker-xml-cursor.c"
					xmlNode* _tmp10_;
					xmlNode* _tmp11_;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp10_ = iter;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					_tmp11_ = _tmp10_->next;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					iter = _tmp11_;
#line 1243 "tracker-xml-cursor.c"
				}
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp9_ = FALSE;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp12_ = iter;
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (!(_tmp12_ != NULL)) {
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					break;
#line 1253 "tracker-xml-cursor.c"
				}
#line 180 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp13_ = iter;
#line 180 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp14_ = _tmp13_->name;
#line 180 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (g_strcmp0 (_tmp14_, "binding") != 0) {
#line 181 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 1263 "tracker-xml-cursor.c"
				}
#line 183 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp15_ = iter;
#line 183 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp16_ = tracker_remote_xml_cursor_lookup_attribute (self, _tmp15_, "name");
#line 183 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				attr = _tmp16_;
#line 184 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp17_ = attr;
#line 184 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				if (_tmp17_ == NULL) {
#line 185 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
					continue;
#line 1277 "tracker-xml-cursor.c"
				}
#line 187 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp18_ = attr;
#line 187 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp19_ = _tmp18_->children;
#line 187 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp20_ = _tmp19_->content;
#line 187 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp21_ = g_strdup (_tmp20_);
#line 187 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				binding_name = _tmp21_;
#line 188 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp22_ = self->priv->_cur_row_map;
#line 188 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp23_ = binding_name;
#line 188 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp24_ = g_strdup (_tmp23_);
#line 188 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_tmp25_ = iter;
#line 188 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				g_hash_table_insert (_tmp22_, _tmp24_, _tmp25_);
#line 179 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
				_g_free0 (binding_name);
#line 1301 "tracker-xml-cursor.c"
			}
		}
	}
#line 191 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = TRUE;
#line 191 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 1309 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_real_next_async_data_free (gpointer _data)
{
	TrackerRemoteXmlCursorNextAsyncData* _data_;
	_data_ = _data;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_g_object_unref0 (_data_->self);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_slice_free (TrackerRemoteXmlCursorNextAsyncData, _data_);
#line 1323 "tracker-xml-cursor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return self ? g_object_ref (self) : NULL;
#line 1331 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_real_next_async (TrackerSparqlCursor* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerRemoteXmlCursor * self;
	TrackerRemoteXmlCursorNextAsyncData* _data_;
	TrackerRemoteXmlCursor* _tmp0_;
	GCancellable* _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_ = g_slice_new0 (TrackerRemoteXmlCursorNextAsyncData);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_xml_cursor_real_next_async_data_free);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_->self = _tmp0_;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_->cancellable = _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	tracker_remote_xml_cursor_real_next_async_co (_data_);
#line 1364 "tracker-xml-cursor.c"
}

static gboolean
tracker_remote_xml_cursor_next_finish (TrackerSparqlCursor* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	gboolean result;
	TrackerRemoteXmlCursorNextAsyncData* _data_;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (NULL == _data_) {
#line 1378 "tracker-xml-cursor.c"
		gboolean _tmp0_ = FALSE;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return _tmp0_;
#line 1382 "tracker-xml-cursor.c"
	}
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = _data_->result;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 1388 "tracker-xml-cursor.c"
}

static gboolean
tracker_remote_xml_cursor_real_next_async_co (TrackerRemoteXmlCursorNextAsyncData* _data_)
{
#line 194 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	switch (_data_->_state_) {
#line 194 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		case 0:
#line 1398 "tracker-xml-cursor.c"
		goto _state_0;
		default:
#line 194 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		g_assert_not_reached ();
#line 1403 "tracker-xml-cursor.c"
	}
	_state_0:
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_->_tmp0_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _data_->self, _data_->cancellable, &_data_->_inner_error0_);
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		g_object_unref (_data_->_async_result);
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		return FALSE;
#line 1416 "tracker-xml-cursor.c"
	}
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_data_->result = _data_->_tmp0_;
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	if (_data_->_state_ != 0) {
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1428 "tracker-xml-cursor.c"
		}
	}
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_object_unref (_data_->_async_result);
#line 195 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return FALSE;
#line 1435 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_real_rewind (TrackerSparqlCursor* base)
{
	TrackerRemoteXmlCursor * self;
#line 198 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 199 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self->priv->_cur_row = NULL;
#line 1446 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_real_close (TrackerSparqlCursor* base)
{
	TrackerRemoteXmlCursor * self;
#line 202 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 1455 "tracker-xml-cursor.c"
}

static gint
tracker_remote_xml_cursor_real_get_n_columns (TrackerSparqlCursor* base)
{
	gint result;
	TrackerRemoteXmlCursor* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = (TrackerRemoteXmlCursor*) base;
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0_ = self->priv->_vars;
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_tmp0__length1 = self->priv->_vars_length1;
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	result = (gint) _tmp0__length1;
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	return result;
#line 1475 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_class_init (TrackerRemoteXmlCursorClass * klass,
                                      gpointer klass_data)
{
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	tracker_remote_xml_cursor_parent_class = g_type_class_peek_parent (klass);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_type_class_adjust_private_offset (klass, &TrackerRemoteXmlCursor_private_offset);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_value_type = (TrackerSparqlValueType (*) (TrackerSparqlCursor*, gint)) tracker_remote_xml_cursor_real_get_value_type;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_variable_name = (const gchar* (*) (TrackerSparqlCursor*, gint)) tracker_remote_xml_cursor_real_get_variable_name;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->get_string = (const gchar* (*) (TrackerSparqlCursor*, gint, glong*)) tracker_remote_xml_cursor_real_get_string;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next = (gboolean (*) (TrackerSparqlCursor*, GCancellable*, GError**)) tracker_remote_xml_cursor_real_next;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_async = (void (*) (TrackerSparqlCursor*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_remote_xml_cursor_real_next_async;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->next_finish = (gboolean (*) (TrackerSparqlCursor*, GAsyncResult*, GError**)) tracker_remote_xml_cursor_next_finish;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->rewind = (void (*) (TrackerSparqlCursor*)) tracker_remote_xml_cursor_real_rewind;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	((TrackerSparqlCursorClass *) klass)->close = (void (*) (TrackerSparqlCursor*)) tracker_remote_xml_cursor_real_close;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	TRACKER_SPARQL_CURSOR_CLASS (klass)->get_n_columns = tracker_remote_xml_cursor_real_get_n_columns;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_remote_xml_cursor_get_property;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_remote_xml_cursor_finalize;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_REMOTE_XML_CURSOR_N_COLUMNS_PROPERTY, tracker_remote_xml_cursor_properties[TRACKER_REMOTE_XML_CURSOR_N_COLUMNS_PROPERTY] = g_param_spec_int ("n-columns", "n-columns", "n-columns", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 1510 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_instance_init (TrackerRemoteXmlCursor * self,
                                         gpointer klass)
{
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self->priv = tracker_remote_xml_cursor_get_instance_private (self);
#line 1519 "tracker-xml-cursor.c"
}

static void
tracker_remote_xml_cursor_finalize (GObject * obj)
{
	TrackerRemoteXmlCursor * self;
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_REMOTE_TYPE_XML_CURSOR, TrackerRemoteXmlCursor);
#line 25 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	_g_hash_table_unref0 (self->priv->_cur_row_map);
#line 26 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	self->priv->_vars = (_vala_array_free (self->priv->_vars, self->priv->_vars_length1, (GDestroyNotify) g_free), NULL);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	G_OBJECT_CLASS (tracker_remote_xml_cursor_parent_class)->finalize (obj);
#line 1534 "tracker-xml-cursor.c"
}

static GType
tracker_remote_xml_cursor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerRemoteXmlCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_remote_xml_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerRemoteXmlCursor), 0, (GInstanceInitFunc) tracker_remote_xml_cursor_instance_init, NULL };
	GType tracker_remote_xml_cursor_type_id;
	tracker_remote_xml_cursor_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CURSOR, "TrackerRemoteXmlCursor", &g_define_type_info, 0);
	TrackerRemoteXmlCursor_private_offset = g_type_add_instance_private (tracker_remote_xml_cursor_type_id, sizeof (TrackerRemoteXmlCursorPrivate));
	return tracker_remote_xml_cursor_type_id;
}

GType
tracker_remote_xml_cursor_get_type (void)
{
	static volatile gsize tracker_remote_xml_cursor_type_id__once = 0;
	if (g_once_init_enter (&tracker_remote_xml_cursor_type_id__once)) {
		GType tracker_remote_xml_cursor_type_id;
		tracker_remote_xml_cursor_type_id = tracker_remote_xml_cursor_get_type_once ();
		g_once_init_leave (&tracker_remote_xml_cursor_type_id__once, tracker_remote_xml_cursor_type_id);
	}
	return tracker_remote_xml_cursor_type_id__once;
}

static void
_vala_tracker_remote_xml_cursor_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	TrackerRemoteXmlCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_REMOTE_TYPE_XML_CURSOR, TrackerRemoteXmlCursor);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
	switch (property_id) {
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		case TRACKER_REMOTE_XML_CURSOR_N_COLUMNS_PROPERTY:
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		g_value_set_int (value, tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) self));
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		break;
#line 1575 "tracker-xml-cursor.c"
		default:
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../tracker/src/libtracker-sparql/remote/tracker-xml-cursor.vala"
		break;
#line 1581 "tracker-xml-cursor.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

