/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.CompressionConfig;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.Http11Processor;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeGroupInfo;
import org.apache.coyote.http11.upgrade.UpgradeProcessorExternal;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.Util;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractHttp11Protocol.class);
    private final CompressionConfig compressionConfig = new CompressionConfig();
    private ContinueResponseTiming continueResponseTiming = ContinueResponseTiming.IMMEDIATELY;
    private boolean useKeepAliveResponseHeader = true;
    private String relaxedPathChars = null;
    private String relaxedQueryChars = null;
    private boolean allowHostHeaderMismatch = true;
    private boolean rejectIllegalHeader = false;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private String restrictedUserAgents = null;
    private String server;
    private boolean serverRemoveAppProvidedValues = false;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private Set<String> allowedTrailerHeaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<UpgradeProtocol> upgradeProtocols = new ArrayList<UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> httpUpgradeProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> negotiatedProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeGroupInfo> upgradeProtocolGroupInfos = new ConcurrentHashMap<String, UpgradeGroupInfo>();
    private SSLHostConfig defaultSSLHostConfig = null;

    public AbstractHttp11Protocol(AbstractEndpoint<S, ?> abstractEndpoint) {
        super(abstractEndpoint);
        this.setConnectionTimeout(60000);
        AbstractProtocol.ConnectionHandler connectionHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(connectionHandler);
        this.getEndpoint().setHandler(connectionHandler);
    }

    @Override
    public void init() throws Exception {
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            this.configureUpgradeProtocol(upgradeProtocol);
        }
        super.init();
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            if (!(upgradeProtocol instanceof Http2Protocol)) continue;
            ((Http2Protocol)upgradeProtocol).setHttp11Protocol(this);
        }
    }

    @Override
    public void destroy() throws Exception {
        ObjectName objectName = this.getGlobalRequestProcessorMBeanName();
        if (objectName != null) {
            Registry registry = Registry.getRegistry(null, null);
            ObjectName objectName2 = new ObjectName(objectName.getCanonicalName() + ",Upgrade=*");
            Set<ObjectInstance> set = registry.getMBeanServer().queryMBeans(objectName2, null);
            for (ObjectInstance objectInstance : set) {
                registry.unregisterComponent(objectInstance.getObjectName());
            }
        }
        super.destroy();
    }

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    public String getContinueResponseTiming() {
        return this.continueResponseTiming.toString();
    }

    public void setContinueResponseTiming(String string) {
        this.continueResponseTiming = ContinueResponseTiming.fromString(string);
    }

    public ContinueResponseTiming getContinueResponseTimingInternal() {
        return this.continueResponseTiming;
    }

    public boolean getUseKeepAliveResponseHeader() {
        return this.useKeepAliveResponseHeader;
    }

    public void setUseKeepAliveResponseHeader(boolean bl) {
        this.useKeepAliveResponseHeader = bl;
    }

    public String getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    public void setRelaxedPathChars(String string) {
        this.relaxedPathChars = string;
    }

    public String getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    public void setRelaxedQueryChars(String string) {
        this.relaxedQueryChars = string;
    }

    public boolean getAllowHostHeaderMismatch() {
        return this.allowHostHeaderMismatch;
    }

    public void setAllowHostHeaderMismatch(boolean bl) {
        this.allowHostHeaderMismatch = bl;
    }

    public boolean getRejectIllegalHeader() {
        return this.rejectIllegalHeader;
    }

    public void setRejectIllegalHeader(boolean bl) {
        this.rejectIllegalHeader = bl;
    }

    @Deprecated
    public boolean getRejectIllegalHeaderName() {
        return this.rejectIllegalHeader;
    }

    @Deprecated
    public void setRejectIllegalHeaderName(boolean bl) {
        this.rejectIllegalHeader = bl;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int n) {
        this.maxSavePostSize = n;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int n) {
        this.maxHttpHeaderSize = n;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int n) {
        this.connectionUploadTimeout = n;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean bl) {
        this.disableUploadTimeout = bl;
    }

    public void setCompression(String string) {
        this.compressionConfig.setCompression(string);
    }

    public String getCompression() {
        return this.compressionConfig.getCompression();
    }

    public String getNoCompressionUserAgents() {
        return this.compressionConfig.getNoCompressionUserAgents();
    }

    public void setNoCompressionUserAgents(String string) {
        this.compressionConfig.setNoCompressionUserAgents(string);
    }

    @Deprecated
    public String getCompressableMimeType() {
        return this.getCompressibleMimeType();
    }

    @Deprecated
    public void setCompressableMimeType(String string) {
        this.setCompressibleMimeType(string);
    }

    @Deprecated
    public String[] getCompressableMimeTypes() {
        return this.getCompressibleMimeTypes();
    }

    public String getCompressibleMimeType() {
        return this.compressionConfig.getCompressibleMimeType();
    }

    public void setCompressibleMimeType(String string) {
        this.compressionConfig.setCompressibleMimeType(string);
    }

    public String[] getCompressibleMimeTypes() {
        return this.compressionConfig.getCompressibleMimeTypes();
    }

    public int getCompressionMinSize() {
        return this.compressionConfig.getCompressionMinSize();
    }

    public void setCompressionMinSize(int n) {
        this.compressionConfig.setCompressionMinSize(n);
    }

    @Deprecated
    public boolean getNoCompressionStrongETag() {
        return this.compressionConfig.getNoCompressionStrongETag();
    }

    @Deprecated
    public void setNoCompressionStrongETag(boolean bl) {
        this.compressionConfig.setNoCompressionStrongETag(bl);
    }

    public boolean useCompression(Request request, Response response) {
        return this.compressionConfig.useCompression(request, response);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String string) {
        this.restrictedUserAgents = string;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public boolean getServerRemoveAppProvidedValues() {
        return this.serverRemoveAppProvidedValues;
    }

    public void setServerRemoveAppProvidedValues(boolean bl) {
        this.serverRemoveAppProvidedValues = bl;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int n) {
        this.maxTrailerSize = n;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int n) {
        this.maxExtensionSize = n;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int n) {
        this.maxSwallowSize = n;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setAllowedTrailerHeaders(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.allowedTrailerHeaders);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                String string3 = string2.trim().toLowerCase(Locale.ENGLISH);
                if (hashSet.contains(string3)) {
                    hashSet.remove(string3);
                    continue;
                }
                this.allowedTrailerHeaders.add(string3);
            }
            this.allowedTrailerHeaders.removeAll(hashSet);
        }
    }

    protected Set<String> getAllowedTrailerHeadersInternal() {
        return this.allowedTrailerHeaders;
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>(this.allowedTrailerHeaders);
        return StringUtils.join(arrayList);
    }

    public void addAllowedTrailerHeader(String string) {
        if (string != null) {
            this.allowedTrailerHeaders.add(string.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public void removeAllowedTrailerHeader(String string) {
        if (string != null) {
            this.allowedTrailerHeaders.remove(string.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.upgradeProtocols.add(upgradeProtocol);
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.upgradeProtocols.toArray(new UpgradeProtocol[0]);
    }

    private void configureUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        String string;
        String string2 = upgradeProtocol.getHttpUpgradeName(this.getEndpoint().isSSLEnabled());
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            this.httpUpgradeProtocols.put(string2, upgradeProtocol);
            bl = true;
            this.getLog().info((Object)sm.getString("abstractHttp11Protocol.httpUpgradeConfigured", new Object[]{this.getName(), string2}));
        }
        if ((string = upgradeProtocol.getAlpnName()) != null && string.length() > 0) {
            if (this.getEndpoint().isAlpnSupported()) {
                this.negotiatedProtocols.put(string, upgradeProtocol);
                this.getEndpoint().addNegotiatedProtocol(string);
                this.getLog().info((Object)sm.getString("abstractHttp11Protocol.alpnConfigured", new Object[]{this.getName(), string}));
            } else if (!bl) {
                this.getLog().error((Object)sm.getString("abstractHttp11Protocol.alpnWithNoAlpn", new Object[]{upgradeProtocol.getClass().getName(), string, this.getName()}));
            }
        }
    }

    @Override
    public UpgradeProtocol getNegotiatedProtocol(String string) {
        return this.negotiatedProtocols.get(string);
    }

    @Override
    public UpgradeProtocol getUpgradeProtocol(String string) {
        return this.httpUpgradeProtocols.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeGroupInfo getUpgradeGroupInfo(String string) {
        if (string == null) {
            return null;
        }
        UpgradeGroupInfo upgradeGroupInfo = this.upgradeProtocolGroupInfos.get(string);
        if (upgradeGroupInfo == null) {
            Map<String, UpgradeGroupInfo> map = this.upgradeProtocolGroupInfos;
            synchronized (map) {
                upgradeGroupInfo = this.upgradeProtocolGroupInfos.get(string);
                if (upgradeGroupInfo == null) {
                    upgradeGroupInfo = new UpgradeGroupInfo();
                    this.upgradeProtocolGroupInfos.put(string, upgradeGroupInfo);
                    ObjectName objectName = this.getONameForUpgrade(string);
                    if (objectName != null) {
                        try {
                            Registry.getRegistry(null, null).registerComponent((Object)upgradeGroupInfo, objectName, null);
                        }
                        catch (Exception exception) {
                            this.getLog().warn((Object)sm.getString("abstractHttp11Protocol.upgradeJmxRegistrationFail"), (Throwable)exception);
                            upgradeGroupInfo = null;
                        }
                    }
                }
            }
        }
        return upgradeGroupInfo;
    }

    public ObjectName getONameForUpgrade(String string) {
        ObjectName objectName = null;
        ObjectName objectName2 = this.getGlobalRequestProcessorMBeanName();
        if (objectName2 != null) {
            StringBuilder stringBuilder = new StringBuilder(objectName2.getCanonicalName());
            stringBuilder.append(",Upgrade=");
            if (Util.objectNameValueNeedsQuote(string)) {
                stringBuilder.append(ObjectName.quote(string));
            } else {
                stringBuilder.append(string);
            }
            try {
                objectName = new ObjectName(stringBuilder.toString());
            }
            catch (Exception exception) {
                this.getLog().warn((Object)sm.getString("abstractHttp11Protocol.upgradeJmxNameFail"), (Throwable)exception);
            }
        }
        return objectName;
    }

    public boolean isSSLEnabled() {
        return this.getEndpoint().isSSLEnabled();
    }

    public void setSSLEnabled(boolean bl) {
        this.getEndpoint().setSSLEnabled(bl);
    }

    public boolean getUseSendfile() {
        return this.getEndpoint().getUseSendfile();
    }

    public void setUseSendfile(boolean bl) {
        this.getEndpoint().setUseSendfile(bl);
    }

    public int getMaxKeepAliveRequests() {
        return this.getEndpoint().getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int n) {
        this.getEndpoint().setMaxKeepAliveRequests(n);
    }

    public String getDefaultSSLHostConfigName() {
        return this.getEndpoint().getDefaultSSLHostConfigName();
    }

    public void setDefaultSSLHostConfigName(String string) {
        this.getEndpoint().setDefaultSSLHostConfigName(string);
        if (this.defaultSSLHostConfig != null) {
            this.defaultSSLHostConfig.setHostName(string);
        }
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sSLHostConfig) {
        this.getEndpoint().addSslHostConfig(sSLHostConfig);
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return this.getEndpoint().findSslHostConfigs();
    }

    public void reloadSslHostConfigs() {
        this.getEndpoint().reloadSslHostConfigs();
    }

    public void reloadSslHostConfig(String string) {
        this.getEndpoint().reloadSslHostConfig(string);
    }

    private void registerDefaultSSLHostConfig() {
        if (this.defaultSSLHostConfig == null) {
            for (SSLHostConfig sSLHostConfig : this.findSslHostConfigs()) {
                if (!this.getDefaultSSLHostConfigName().equals(sSLHostConfig.getHostName())) continue;
                this.defaultSSLHostConfig = sSLHostConfig;
                break;
            }
            if (this.defaultSSLHostConfig == null) {
                this.defaultSSLHostConfig = new SSLHostConfig();
                this.defaultSSLHostConfig.setHostName(this.getDefaultSSLHostConfigName());
                this.getEndpoint().addSslHostConfig(this.defaultSSLHostConfig);
            }
        }
    }

    public String getSslEnabledProtocols() {
        this.registerDefaultSSLHostConfig();
        return StringUtils.join((String[])this.defaultSSLHostConfig.getEnabledProtocols());
    }

    public void setSslEnabledProtocols(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setProtocols(string);
    }

    public String getSSLProtocol() {
        this.registerDefaultSSLHostConfig();
        return StringUtils.join((String[])this.defaultSSLHostConfig.getEnabledProtocols());
    }

    public void setSSLProtocol(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setProtocols(string);
    }

    public String getKeystoreFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystoreFile();
    }

    public void setKeystoreFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreFile(string);
    }

    public String getSSLCertificateChainFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateChainFile(string);
    }

    public String getSSLCertificateFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateFile();
    }

    public void setSSLCertificateFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateFile(string);
    }

    public String getSSLCertificateKeyFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyFile(string);
    }

    public String getAlgorithm() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getKeyManagerAlgorithm();
    }

    public void setAlgorithm(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setKeyManagerAlgorithm(string);
    }

    public String getClientAuth() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationAsString();
    }

    public void setClientAuth(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerification(string);
    }

    public String getSSLVerifyClient() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationAsString();
    }

    public void setSSLVerifyClient(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerification(string);
    }

    public int getTrustMaxCertLength() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationDepth();
    }

    public void setTrustMaxCertLength(int n) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerificationDepth(n);
    }

    public int getSSLVerifyDepth() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationDepth();
    }

    public void setSSLVerifyDepth(int n) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerificationDepth(n);
    }

    public String getUseServerCipherSuitesOrder() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getHonorCipherOrder();
    }

    public void setUseServerCipherSuitesOrder(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setHonorCipherOrder(string);
    }

    public String getSSLHonorCipherOrder() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getHonorCipherOrder();
    }

    public void setSSLHonorCipherOrder(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setHonorCipherOrder(string);
    }

    public String getCiphers() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCiphers();
    }

    public void setCiphers(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCiphers(string);
    }

    public String getSSLCipherSuite() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCiphers();
    }

    public void setSSLCipherSuite(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCiphers(string);
    }

    public String getKeystorePass() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystorePassword();
    }

    public void setKeystorePass(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystorePassword(string);
    }

    public String getKeyPass() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyPassword();
    }

    public void setKeyPass(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyPassword(string);
    }

    public String getSSLPassword() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyPassword();
    }

    public void setSSLPassword(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyPassword(string);
    }

    public String getCrlFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateRevocationListFile();
    }

    public void setCrlFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListFile(string);
    }

    public String getSSLCARevocationFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateRevocationListFile();
    }

    public void setSSLCARevocationFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListFile(string);
    }

    public String getSSLCARevocationPath() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateRevocationListPath();
    }

    public void setSSLCARevocationPath(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListPath(string);
    }

    public String getKeystoreType() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystoreType();
    }

    public void setKeystoreType(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreType(string);
    }

    public String getKeystoreProvider() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystoreProvider();
    }

    public void setKeystoreProvider(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreProvider(string);
    }

    public String getKeyAlias() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyAlias();
    }

    public void setKeyAlias(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyAlias(string);
    }

    public String getTruststoreAlgorithm() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreAlgorithm();
    }

    public void setTruststoreAlgorithm(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreAlgorithm(string);
    }

    public String getTruststoreFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreFile();
    }

    public void setTruststoreFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreFile(string);
    }

    public String getTruststorePass() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststorePassword();
    }

    public void setTruststorePass(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststorePassword(string);
    }

    public String getTruststoreType() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreType();
    }

    public void setTruststoreType(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreType(string);
    }

    public String getTruststoreProvider() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreProvider();
    }

    public void setTruststoreProvider(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreProvider(string);
    }

    public String getSslProtocol() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getSslProtocol();
    }

    public void setSslProtocol(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSslProtocol(string);
    }

    public int getSessionCacheSize() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getSessionCacheSize();
    }

    public void setSessionCacheSize(int n) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSessionCacheSize(n);
    }

    public int getSessionTimeout() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getSessionTimeout();
    }

    public void setSessionTimeout(int n) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSessionTimeout(n);
    }

    public String getSSLCACertificatePath() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCaCertificatePath();
    }

    public void setSSLCACertificatePath(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCaCertificatePath(string);
    }

    public String getSSLCACertificateFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCaCertificateFile();
    }

    public void setSSLCACertificateFile(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCaCertificateFile(string);
    }

    public boolean getSSLDisableCompression() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getDisableCompression();
    }

    public void setSSLDisableCompression(boolean bl) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setDisableCompression(bl);
    }

    public boolean getSSLDisableSessionTickets() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getDisableSessionTickets();
    }

    public void setSSLDisableSessionTickets(boolean bl) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setDisableSessionTickets(bl);
    }

    public String getTrustManagerClassName() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTrustManagerClassName();
    }

    public void setTrustManagerClassName(String string) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTrustManagerClassName(string);
    }

    @Override
    protected Processor createProcessor() {
        Http11Processor http11Processor = new Http11Processor(this, this.getEndpoint());
        http11Processor.setAdapter(this.getAdapter());
        http11Processor.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
        http11Processor.setConnectionUploadTimeout(this.getConnectionUploadTimeout());
        http11Processor.setDisableUploadTimeout(this.getDisableUploadTimeout());
        http11Processor.setRestrictedUserAgents(this.getRestrictedUserAgents());
        http11Processor.setMaxSavePostSize(this.getMaxSavePostSize());
        return http11Processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socketWrapperBase, UpgradeToken upgradeToken) {
        HttpUpgradeHandler httpUpgradeHandler = upgradeToken.getHttpUpgradeHandler();
        if (httpUpgradeHandler instanceof InternalHttpUpgradeHandler) {
            return new UpgradeProcessorInternal(socketWrapperBase, upgradeToken, this.getUpgradeGroupInfo(upgradeToken.getProtocol()));
        }
        return new UpgradeProcessorExternal(socketWrapperBase, upgradeToken, this.getUpgradeGroupInfo(upgradeToken.getProtocol()));
    }
}

